#ifndef __CAMERA_INTF_H__
#define __CAMERA_INTF_H__

#define PAS6329_DEV             (0xABC00)
#define OV_7670_DEV             (0xABC01) 
#define PAS6375_DEV             (0xABC02) 
#define GC0328C_DEV             (0xABC03) 

#define USE_CAMERA              GC0328C_DEV// PAS6329_DEV  OV_7670_DEV  PAS6375_DEV  GC0328C_DEV

#define PAS6329_DEV_ID          (0x40)
#define OV_7670_DEV_ID          (0x21)
#define PAS6375_DEV_ID          (0x40)
#define GC0328C_DEV_ID          (0x21)

#if (USE_CAMERA == PAS6329_DEV)

#define PAS6329_SET_PAGE0  camera_intf_sccb_write(0xef, 0x00)
#define PAS6329_SET_PAGE1  camera_intf_sccb_write(0xef, 0x01)
#define PAS6329_SET_PAGE2  camera_intf_sccb_write(0xef, 0x02)

const UINT8 pas6329_page0[][2] = {
    {0x04, 0x00},    // 00//01//AE Indoor stage select[0];0:11 ; 1:12 ..
    {0x05, 0x65},    // 3d//66//6f//66//AE_HIST_LLTHd[7:3];AE_HIST_LLBit[2:0]; AE Bias4 parameters
    {0x06, 0x00},    // 1a//00//0c//0c//0C//1A==>JS//AE_HIST_LLUB[5:0]; AE Bias4 parameters
    {0x07, 0x64},    // 64//A0//AE Indoor Y-Thd[7:0]
    {0x08, 0x61},
    {0x09, 0x00},
    {0x0A, 0x64},
    {0x0C, 0x00},
    {0x0D, 0x00},    // AE_HIST_BiasUB[7:0] ; AE Bias1 parameters
    {0x0E, 0x00},    // AE_HIST_BiasThd[7:0] ; AE Bias1 parameters
    {0x0F, 0x9B},    // AWB_Windows_X[7:0]
    {0x11, 0x6E},    // AWB_Windows_Y[7:0]
    {0x13, 0x62},    // For 24MHz. 27M use 0xAE
    {0x14, 0x22},    // For 24MHz. 27M use 0x22
    {0x15, 0x32},    // 00//55//45//32==>JS//AE_HIST_BrightBit[6:4]==>AE Bias 2;AE_HIST_DarkBit[2:0];AE Bias3
    {0x16, 0x57},    // 5f//58//AE_HIST_DarkBin[7:4];AE_HIST_PeakThd[3:0]; AE Bias3 parameters
    {0x17, 0x02},    // AE_HIST_NullThd[3:0] ; AE Bias2 parameters
    {0x19, 0x3E},    // AWB_Digital Gain_Low Bound for R
    {0x1A, 0x67},    // AWB_Digital Gain_Upper Bound for B
    {0x1B, 0x3C},    // 41//3C==>JS//AWB_Digital Gain_Low Bound for B
    {0x1C, 0x6B},    // AWB_Digital Gain_Upper for R
    {0x1D, 0x99},
    {0x1E, 0x98},
    {0x1F, 0x10},    // 10//Denoise_En[4]
    {0x20, 0x16},    // 0x22);//22//DeNoise_Str_G[7:0]
    {0x21, 0x00},    // 0x10);//0x12);//18//12//18//18//18//12==>JS//DeNoise_H_LB_G[7:0]
    {0x22, 0x60},    // DeNoise_H_UB_G[7:0]
    {0x23, 0x16},    // 0x24);//16//24//DeNoise_Str_RB[7:0]
    {0x24, 0x00},    // 0x10);//0x12);//12//1a//1a//1A//12==>JS//DeNoise_H_LB_RB[7:0]
    {0x25, 0x60},    // 60==>JS//DeNoise_H_UB_RB[7:0]
    {0x26, 0x00},    // DeNoise_Gain_Offset_G[7:0]
    {0x27, 0x00},    // DeNoise_Gain_Offset_RB[7:0]
    {0x29, 0x01},    // G_40_ISP_Gamma_EnH[0]
    {0x2A, 0x11},    // 11//0F//12//ISP_Gamma_Y0[7:0]
    {0x2B, 0x20},    // 20//1D//22//ISP_Gamma_Y1[7:0]
    {0x2C, 0x3A},    // 3A//36//3D//ISP_Gamma_Y2[7:0]
    {0x2D, 0x64},    // 64//5D//67//ISP_Gamma_Y3[7:0]
    {0x2E, 0x75},    // 75//6D//77//ISP_Gamma_Y4[7:0]
    {0x2F, 0x84},    // 84//7B//85//ISP_Gamma_Y5[7:0]
    {0x30, 0x92},    // 92//87//91//ISP_Gamma_Y6[7:0]
    {0x31, 0x9F},    // 9F//92//9C//ISP_Gamma_Y7[7:0]
    {0x32, 0xB5},    // B5//A5//AE//ISP_Gamma_Y8[7:0]
    {0x33, 0xC7},    // C7//B4//BD//ISP_Gamma_Y9[7:0]
    {0x34, 0xD5},    // D5//C1//C9//ISP_Gamma_Y10[7:0]
    {0x35, 0xE0},    // E0//CC//D3//ISP_Gamma_Y11[7:0]
    {0x36, 0xEF},    // EF//DE//E2//ISP_Gamma_Y12[7:0]
    {0x37, 0xF8},    // F8//EC//EE//ISP_Gamma_Y13[7:0]
    {0x38, 0xFD},    // FD//F6//F8//ISP_Gamma_Y14[7:0]
    {0x39, 0x01},
    {0x3A, 0x28},
    {0x3B, 0x28},
    {0x3C, 0x24},
    {0x3D, 0x1E},
    {0x3E, 0x00},    // 02//01//02//02//AE_HIST_Backlight[2:0]
    {0x3F, 0x0F},    // 0b//0F//AE_HIST_Step_V[4:0]
    {0x40, 0x0A},    // 58//0A//AE_HIST_HStart[7:0]
    {0x41, 0x19},    // 53//19//AE_HIST_VStart[7:0]
    {0x42, 0x41},
    {0x43, 0x01},
    {0x44, 0x00},
    {0x45, 0x02},
    {0x46, 0x02},
    {0x47, 0x31},    // AWB_ShowActivePix[7];AWB_Speed[1:0]
    {0x48, 0x5A},    // 0x50;//5A//50==>JS//AWB_CThdM[3:0];AWB_CThdStep[7:4] //50
    {0x49, 0x7F},    // 7F//AWB_SumRatio_B[7:0]
    {0x4A, 0x86},    // AWB_SumRatio_R[7:0]
    {0x4B, 0x42},    // AWB_CThdL[7:0]
    {0x4C, 0x14},    // 0x05);//0x05);//05//05//10==>JS//AWB_CThdH[7:0] //10
    {0x4D, 0x64},    // AWB_CbThdL[7:0]
    {0x4E, 0x87},    // AWB_CrThdL[7:0]
    {0x4F, 0x6E},    // AWB_CbCrThdL[7:0]
    {0x50, 0x75},    // AWB_CbThdH[7:0]
    {0x51, 0x96},    // AWBCrThdH[7:0]
    {0x52, 0x86},    // 0x8C);//8C//86//8C==>JS//AWB_CbCrThdH[7:0]	// 20160308 davis for AWB
    {0x53, 0x28},    // 0x14);//R_YLow_NL[7:0]
    {0x54, 0xF5},    // R_YHigh7:0]
    {0x55, 0x53},    // 0x33);//0x53);//53//33//53//33==>JS//AWB_CThdDn[3:0];AWB_CThdUp[7:4] //33	// 20160308 davis for AWB
    {0x56, 0x0D},    // 0x18);	//0x14);//16//18//16//AE_Stage_YLow_LL_Thd[4:0]	// 20160308 davis for AWB
    {0x57, 0x01},    // AWB_LockRange_In[3:0]
    {0x58, 0x05},    // AWB_LockRange_Out[5:0]
    {0x59, 0x03},    // AWB_LockRange_In_LL[5:0]
    {0x5A, 0x08},    // AWB_LockRange_Out_LL[5:0]
    {0x5B, 0x02},    // AWB_MinStep_th[2:0]
    {0x5C, 0x10},    // 0c//10//AE_HIST_Step_H[4:0]
    {0x5D, 0xFF},
    {0x5F, 0x05},    // 06//05==>JS//08//AE_LockRange_Out_LB[7:0]
    {0x60, 0x01},    // 01//00//G_Balance_En[0]
    {0x61, 0x04},    // G_Balance_Thd[3:0]
    {0x62, 0x02},    // G_Balance_ThdLB[7:0]
    {0x63, 0x30},
    {0x64, 0x05},    // 0A//05==>JS//0F/AE_LockRange_Out_UB[7:0]
    {0x65, 0x40},    // 50//40==>JS//40//AE_LockRange_In[7:4]
    {0x66, 0x12},    // 0x13);//12//13//AE_EnH[4] ; Freq_60[0]==>0/1 : 50/60Hz
    {0x67, 0xC7},    // for 24M. 27M use 0x7F
    {0x68, 0x2D},     // for 24M. 27M use 0x33
    {0x6B, 0x06},    // 0x03);//0x06//R_AE_minStage[4:0]
    {0x6C, 0x0F},    // 0x0E);//0x0D);//0x14);//16//19//1A//R_AE_maxStage[4:0]
    {0x6D, 0x58},    // 50//60//58==>JS//AG_Stage_UB[7:0] at Max AE Stage
    {0x6E, 0x13},
    {0x6F, 0x50},    // 0x50);//0x55);// 0x55 //0x4B);//4b//50//50//4B==>JS//55//Ytarget[7:0]
    {0x70, 0x00},
    {0x71, 0x00},
    {0x72, 0x03},    // 0x03 ;//01//AWB_EnH[0] ; AWB_RegionMode[1] //03
    {0x73, 0xC5},    // AWB_Bal_Gain_R[7:0]
    {0x74, 0x9C},    // AWB_Bal_Gain_B[7:0]
    {0x75, 0x0D},    // AWB_Weight_LL[1:0];AWB_Weight_LH[3:2];AWB_Weight_HL[5:4];AWB_Weight_HH[7:6]
    {0x76, 0x96},
    {0x78, 0x01},
    {0x79, 0x16},
    {0x7B, 0x04},
    {0x7C, 0x03},
    {0x7D, 0x00},
    {0x7E, 0x00},
    {0x7F, 0xFF},
    {0x80, 0x86},
    {0x81, 0x00},    // 00//AE_Speed[5:4]==>0:1x ; 1:1/2x ; 2:1/4x ; 3:1/8x ;AE_MinStep_th[1:0]
    {0x84, 0x1C},
    {0x86, 0x09},
    {0x87, 0xEA},
    {0x88, 0x01},
    {0x89, 0x00},
    {0x8A, 0x00},
    {0x8B, 0x00},
    {0x8C, 0x9E},
    {0x8E, 0x00},
    {0x8F, 0x00},
    {0x90, 0x00},
    {0x91, 0x00},
    {0x92, 0x00},
    {0x93, 0x00},
    {0x94, 0x00},
    {0x95, 0x0A},
    {0x97, 0x10},    // Shading_En[4]
    {0x98, 0x00},
    {0x99, 0x46},    // Offset_X_R[6:0]
    {0x9A, 0x52},    // Offset_Y_R[6:0]
    {0x9B, 0x4C},    // Offset_X_G[6:0]
    {0x9C, 0x52},    // Offset_Y_G[6:0]
    {0x9D, 0x4A},    // Offset_X_B[6:0]
    {0x9E, 0x52},    // Offset_Y_B[6:0]
    {0x9F, 0x72},    // LSC_R1[6:0]
    {0xA0, 0x46},    // 46//LSC_G1[6:0]
    {0xA1, 0x34},    // LSC_B1[6:0]
    {0xA2, 0x4C},    // 41//LSC_R2[6:0]
    {0xA3, 0x54},    // 3D//LSC_G2[6:0]
    {0xA4, 0x54},    // LSC_B2[6:0]
    {0xA5, 0x05},    // LSFT_1[6:0]
    {0xA6, 0x01},    // LSFT_2[1:0]
    {0xA7, 0x01},    // LSFT_3[3:0]
    {0xA9, 0x00},    // 0xD0
    {0xAA, 0x00},
    {0xC6, 0xB9},    // 0xA2
    {0xC7, 0x00},
    {0xC8, 0x80},
    {0xC9, 0x00},
    {0xCA, 0xA3},    // 0xB7
    {0xCB, 0x00},
    {0xDF, 0x20},
    {0xE0, 0x80},
    {0xE1, 0x02},
    {0xE2, 0xE0},
    {0xE3, 0x01},
    {0xE6, 0x00},
    {0xE9, 0x87},
    {0xEA, 0x00},
    {0xEB, 0x00},
    {0xED, 0x00},
    {0xEE, 0x3F},
    {0xED, 0x01},
};

const UINT8 pas6329_page1[][2] = {
    {0x02, 0x01},
    {0x03, 0x83},
    {0x04, 0x62},    // 0xFC);//0x78);
    {0x05, 0x02},    // 0x01);//0x04);
    {0x06, 0x10},
    {0x07, 0x0F},	   // 0x13);	// 20160308 davis for AWB
    {0x08, 0x10},
    {0x09, 0x0F},
    {0x0C, 0x03},
    {0x0D, 0x20},    // 0x62);
    {0x0E, 0xE5},    // 0x02);
    {0x0F, 0x01},    // 0x00);
    {0x11, 0x00},
    {0x12, 0x00},
    {0x17, 0x00},
    {0x18, 0x00},
    {0x19, 0x00},
    {0x1A, 0x00},
    {0x1B, 0x8F},
    {0x1C, 0x02},
    {0x1D, 0xEB},
    {0x1E, 0x01},
    {0x20, 0x14},
    {0x21, 0x00},    // 0x00//0x0C//Flip (bit3) & Mirror (bit2)
    {0x22, 0x08},
    {0x23, 0x00},
    {0x24, 0x05},
    {0x27, 0x03},
    {0x28, 0x00},
    {0x2A, 0x00},
    {0x2B, 0x4A},
    {0x2C, 0x7D},
    {0x2D, 0x13},
    {0x2E, 0x49},
    {0x2F, 0x4A},
    {0x30, 0x68},
    {0x31, 0x96},
    {0x32, 0xAB},
    {0x33, 0x31},
    {0x34, 0x81},
    {0x35, 0x00},    // 06//DigDac_offset_Gb1
    {0x36, 0x00},    // 06//DigDac_offset_B1
    {0x37, 0x00},    // 06//DigDac_offset_Gr1
    {0x38, 0x00},    // 06//DigDac_offset_R1
    {0x39, 0x20},
    {0x3B, 0x04},
    {0x3C, 0x04},
    {0x3D, 0x04},
    {0x3E, 0x04},
    {0x40, 0x00},
    {0x41, 0x06},
    {0x42, 0x00},
    {0x43, 0x82},
    {0x44, 0x0E},
    {0x45, 0x23},
    {0x48, 0x21},
    {0x49, 0x11},
    {0x4A, 0x00},
    {0x4B, 0x08},    // 00//08//[3] T_cg_offset_EnL
    {0x50, 0x03},
    {0x51, 0x44},
    {0x52, 0x79},
    {0x53, 0x80},
    {0x54, 0x00},
    {0x56, 0x00},
    {0x57, 0x00},
    {0x5D, 0x00},
    {0x5E, 0x14},
    {0x60, 0x00},
    {0x62, 0x35},
    {0x63, 0x7F},
    {0x64, 0x34},
    {0x66, 0x06},
    {0x67, 0x08},
    {0x68, 0x07},
    {0x6F, 0x00},
    {0x70, 0x00},
    {0x71, 0x00},
    {0x72, 0x00},
    {0x73, 0x00},
    {0x74, 0x00},
    {0x75, 0x00},
    {0x76, 0x00},
    {0x77, 0x20},
    {0x78, 0x07},    // 0x05);
    {0x79, 0x0F},
    {0x7A, 0x0F},
    {0x7B, 0x8A},
    {0x7E, 0x00},
    {0x7F, 0x01},
    {0x80, 0x00},
    {0x82, 0x00},
    {0x87, 0x00},
    {0x88, 0x00},
    {0x89, 0x00},
    {0x8A, 0x00},
    {0x8B, 0x00},
    {0x8C, 0x00},
    {0x8D, 0x00},
    {0x8E, 0x00},
    {0x8F, 0x00},
    {0x90, 0x00},
    {0x91, 0x00},
    {0x9E, 0x02},
    {0x9F, 0x00},
    {0xA1, 0x04},
    {0xA2, 0xC0},
    {0xA4, 0x00},
    {0xA5, 0x00},
    {0xA6, 0x00},
    {0xA7, 0x06},
    {0xA8, 0x0F},
    {0xA9, 0x00},
    {0xAA, 0xAA},
    {0xAB, 0x55},
    {0xAC, 0x66},
    {0xB0, 0x05},
    {0xB1, 0x3F},
    {0xB2, 0xCA},
    {0xB4, 0x02},
    {0xB6, 0x0C},
    {0xBE, 0x4A},
    {0xBF, 0x80},
    {0xC0, 0x13},
    {0xC1, 0x49},
    {0xC2, 0x4A},
    {0xC3, 0x80},
    {0xC4, 0x13},
    {0xC5, 0x49},
    {0xC6, 0x4A},
    {0xC7, 0x80},
    {0xC8, 0x13},
    {0xC9, 0x49},
    {0xCA, 0x00},
    {0xCB, 0x00},
    {0xCC, 0x00},
    {0xCD, 0x00},
    {0xCE, 0x00},
    {0xCF, 0x00},
    {0xD0, 0x00},
    {0xD1, 0x00},
    {0xD2, 0x00},
    {0xD3, 0x00},
    {0xD4, 0x00},
    {0xD5, 0x00},
    {0x11, 0x01},
};

const UINT8 pas6329_page2[][2] = {
    {0x00, 0x00},
    {0x0B, 0x1A},    // 1a//0a//1a//0A//1A==>JS//AUTO_Contrast_EnH[4];AUTO_Contrast_Strength[3:0]
    {0x0C, 0x4B},    // AUTO_Contrast_UB[7:0]
    {0x0D, 0x44},    // 0x40);//44//40//AUTO_Contrast_LB[7:0]
    {0x0E, 0x00},
    {0x0F, 0x96},
    {0x10, 0x32},
    {0x11, 0x0F},    // AE_HIST_Bias_Stage[4:0]
    {0x12, 0x8C},    // AE_HIST_Bright_Thd[7:0]
    {0x13, 0x28},    // AE_HIST_Dark_Thd[7:0]
    {0x14, 0x2D},    // AE_HIST_BCountLmt[7:0]
    {0x15, 0x1E},    // AE_HIST_DCountLmt[7:0]
    {0x17, 0x00},
    {0x18, 0x40},
    {0x19, 0x80},
    {0x1A, 0x61},    // 0x71);//AWB_Skin_Mode[4] ; AWB_Skin_Mask[1] ; AWB_Mask[0]
    {0x1B, 0x86},    // AWB_Weight_SH[7:4] ; AWB_Weight_SL[3:0]
    {0x1C, 0x6E},    // AWB_SCbThdL[7:0]
    {0x1D, 0x7D},    // AWB_SCbThdH[7:0]
    {0x1E, 0x84},    // AWB_SCrThdL[7:0]
    {0x1F, 0x96},    // AWB_SCrThdL[7:0]
    {0x20, 0xF5},    // AWB_SThdY[7:0]
    {0x21, 0x02},    // AWB_SThdR[4:0]
    {0x22, 0x08},    // 08//Defect_En[3]
    {0x26, 0x18},    // DefectThd_NL[4:0]
    {0x27, 0x08},    // DefectThd_LL[4:0]
    {0x2A, 0x80},
    {0x2B, 0x00},    // Edge_Test_Mode[3:0]
    {0x2C, 0x1f},    // 0x14);//0x20);
    {0x2D, 0x1f},    // 0x14);//0x20);
    {0x2E, 0x00},    // 0x10);//10//Edge_Thd_LB[7:0]
    {0x2F, 0x0D},    // 16//19//AE_Stage_LL[4:0]
    {0x30, 0x0D},    // AE_Stage_NL[4:0]
    {0x31, 0x01},
    {0x35, 0x0F},    // Gamma_Strengh_NL[4:0]
    {0x36, 0x04},    // Manual_Gamma_Strengh[5];Gamma_Strengh_Delta[4:0]
    {0x37, 0x08},    // 0A//Gamma_Strengh_LL[3:0]
    {0x38, 0x8D},    // 0x8F);//8e//92//8f//8E//92==>JS//AE_Middle_Gain_En[7];AE_Middle_Stage[4:0]
    {0x39, 0x01},    // 00//01//AE_Middle_Gain[5:0]
    {0x3A, 0x8B},
    {0x3C, 0x00},
    {0x3E, 0x33},    // 33//33//32//33==>JS//32//32//CCM_Sign[5:0]==>Sign Bit
    {0x3F, 0x1F},    // 25//1F//25//1F==>JS//32//CCM_0_0[7:0]
    {0x40, 0x48},    // 4b//48//4b//4F//48==>JS//4B//CCM_0_1[7:0]
    {0x41, 0x19},    // 10//19//10//0C//19==>JS//03//CCM_0_2[7:0]
    {0x42, 0x20},    // 14//14//20//14//20==>JS//20//0B//32//32//CCM_1_0[7:0]==>Cb_CCM
    {0x43, 0xa0},    // 7D//8C//7D==>JS//A0//42//9D//CCM_1_1[7:0]==>Cb_CCM
    {0x44, 0xc0},    // a0//A0//9D//A0//A5//A5//9D==>JS//C0//4D//cF//CF//CCM_1_2[7:0]==>Cb_CCM
    {0x45, 0x90},    // 90//80//78//90==>JS//70//90//46//98//CCM_2_0[7:0]==>Cr_CCM
    {0x46, 0x90},    // 82//80//78//85//91//82==>JS//70//A0//48//A8//CCM_2_1[7:0]==>Cr_CCM
    {0x47, 0x00},    // 06//08//08//00//0E//00//00//0E==>JS//06//10//02//10//CCM_2_2[7:0]==>Cr_CCM
    {0x50, 0x20},    // Y_Thd_H[6:0]
    {0x51, 0x02},    // Y_Thd_L[4:0]
    {0x52, 0x10},    // C_Thd_H[4:0]
    {0x53, 0x03},    // 02//02//03==>JS//C_Thd_L[4:0]
    {0x54, 0x01},    // False_Color_Cancel[0]
    {0x55, 0x00},    // Manual_EdgeRatio[4]
    {0x56, 0x04},    // EdgeRatio_Delta[4:0]
    {0x57, 0x0C},    // 0x04);//10//04//0c//02//04==>JS//EdgeRatio_LL[4:0]
    {0x58, 0x16},    // 0x18);//range -> 0x10~0x1F
    {0x59, 0x00},    // Manual_Edge_th[4]
    {0x5A, 0x02},    // 0e//Edge_th_Delta[4:0]
    {0x5B, 0x0f},    // 0x18);//01//18//14//14//Edge_Th_LL[7:0]
    {0x5C, 0x0C},    // 0x08//0x0a,//0x0C);//0x08);//range -> 0x0A~0x00
    {0x5D, 0x00},    // Manual_Saturation[4];Saturation_2X[1];Saturation_Fast[0]
    {0x5E, 0x06},    // Saturation_Delta[4:0]
    {0x5F, 0x14},    // 0x16);//0d//10//0E//0D==>JS//18//0E//Saturation_LL[4:0]
    {0x60, 0x10},    // 0x16);//0x10);//1f//10//Saturation_NL[4:0]
    {0x61, 0x00},    // Manual_Shading_CP[4];Shading_Fast[0]
    {0x62, 0x05},    // Shading_Delta[4:0]
    {0x63, 0xFF},    // 0x4F);//4f//ff//EF//Shading_CP_LL[7:4] ; Shading_CP_NL[3:0]
    {0x64, 0x03},    // Contrast_Yavg[4] ; Contrast_En[0]
    {0x65, 0x40},    // 0x48);//43//48//46//48==>JS//46//Contrast_Str[7:0]
    {0x66, 0x96},    // 96//FA//96==>JS//Contrast_CP[7:0]
    {0x67, 0x07},
    {0x68, 0x08},
    {0x69, 0x00},    // 10//20//Brightness_LL[7:0]
    {0x6A, 0x00},    // Brightness_NL[7:0]
    {0x6C, 0x32},
    {0x6D, 0x12},
    {0x6E, 0x08},
    {0x6F, 0x0D},
    {0x70, 0x02},
    {0x71, 0x00},
    {0x72, 0x0E},
    {0x73, 0x08},
    {0x74, 0x31},
    {0x75, 0x01},
    {0x76, 0x14},
    {0x77, 0x0A},
    {0x78, 0x14},
    {0x79, 0x03},
    {0x7A, 0x00},
    {0x7B, 0x02},
    {0x7C, 0x15},
    {0x7D, 0x00},
    {0x9B, 0x02},
    {0x9C, 0x80},
    {0x9D, 0x01},
    {0x9E, 0xE0},
    {0x9F, 0x00},
    {0xA0, 0x00},
    {0xA1, 0x00},
    {0xA2, 0x00},
    {0xA4, 0x02},
    {0xAD, 0x00},
    {0xAE, 0x00},
    {0xB2, 0x00},
    {0xBC, 0x13},
    {0xBD, 0x01},
    {0xBE, 0x00},
    {0xBF, 0x00},    // 0x04);
    {0xC0, 0x00},
    {0xC1, 0x03},    // 0x03);//03 //0x0f Hsync/Vsyncͬʱʹ
    {0xC2, 0x00},
    {0xC8, 0x80},
    {0xC9, 0x00},
    {0xCA, 0x00},
    {0xCB, 0x02},
    {0xCC, 0xD0},
    {0xCD, 0x00},
    {0xE0, 0x04},
    {0xE3, 0x00},
    {0xE4, 0x00},
    {0xE5, 0x00},
    {0xE6, 0x00},
    {0xEB, 0x00},
    {0x00, 0x01},
    {0xEF, 0x00},
    {0x3E, 0x00},
    {0x56, 0x0D},
    {0x6B, 0x06},
    {0x6C, 0x0D},
    {0xEF, 0x02},
    {0x2F, 0x1F},
    {0x30, 0x0D},
    {0x38, 0x0D},
    {0x39, 0x01},
};

#elif (USE_CAMERA == OV_7670_DEV) 
const UINT8 ov_7670_init_talbe[][2] = {
    {0x12,0x80},    
    {0x11,0x80},    // 0x02	 // 30fps
    {0x6b,0x0a},    // 0x8a	 // pclk*6
    {0x3a,0x04},    // 0x0c  // modify by jianghumaibg
    {0x3d,0xc2},    
    {0x12,0x00},    
    {0x15,0x00},    
    {0x17,0x13},    
    {0x18,0x01},    
    {0x32,0xbf},    
    {0x19,0x02},    
    {0x1a,0x7a},    
    {0x03,0x0a},    
    {0x0c,0x00},    
    {0x3e,0x00},    
    {0x70,0x3a},    
    {0x71,0x35},    
    {0x72,0x11},    
    {0x73,0xf0},    
    {0xa2,0x02},    
    {0x7a,0x21},    
    {0x7b,0x05},    
    {0x7c,0x13},    
    {0x7d,0x29},    
    {0x7e,0x52},    
    {0x7f,0x63},    
    {0x80,0x71},    
    {0x81,0x7c},    
    {0x82,0x85},    
    {0x83,0x8f},    
    {0x84,0x95},    
    {0x85,0xa3},    
    {0x86,0xae},    
    {0x87,0xc3},    
    {0x88,0xd5},    
    {0x89,0xe7},    
    {0x13,0xe0},    
    {0x01,0x80},    
    {0x02,0x80},    
    {0x00,0x00},    
    {0x10,0x00},    
    {0x0d,0x50},    
    {0x42,0x40},    
    {0x14,0x1a},    
    {0xa5,0x05},    
    {0xab,0x07},    
    {0x24,0x45},    
    {0x25,0x33},    
    {0x26,0xe3},    
    {0x55,0x00},    
    {0x9f,0xa0},    
    {0xa0,0x90},    
    {0xa1,0x0b},    
    {0xa6,0xd8},    
    {0xa7,0xd8},    
    {0xa8,0xf0},    
    {0xa9,0x90},    
    {0xaa,0x94},    
    {0x13,0xe5},    
    {0x0e,0x61},    
    {0x0f,0x4b},    
    {0x16,0x02},    
    {0x1e,0x07},    
    {0x21,0x02},    
    {0x22,0x91},    
    {0x29,0x07},    
    {0x33,0x0b},    
    {0x35,0x0b},    
    {0x37,0x1d},    
    {0x38,0x71},    
    {0x39,0x2a},    
    {0x3c,0x78},    
    {0x4d,0x40},    
    {0x4e,0x20},    
    {0x69,0x00},    
    {0x74,0x19},    
    {0x8d,0x4f},    
    {0x8e,0x00},    
    {0x8f,0x00},    
    {0x90,0x00},    
    {0x91,0x00},    
    {0x92,0x19},    
    {0x96,0x00},    
    {0x9a,0x80},    
    {0xb0,0x84},    
    {0xb1,0x0c},    
    {0xb2,0x0e},    
    {0xb3,0x7c},    
    {0xb8,0x0a},    
    {0x43,0x14},    
    {0x44,0xf0},    
    {0x45,0x34},    
    {0x46,0x58},    
    {0x47,0x28},    
    {0x48,0x3a},    
    {0x59,0x88},    
    {0x5a,0x88},    
    {0x5b,0x44},    
    {0x5c,0x67},    
    {0x5d,0x49},    
    {0x5e,0x0e},    
    {0x64,0x04},    
    {0x65,0x20},    
    {0x66,0x05},    
    {0x94,0x04},    
    {0x95,0x08},    
    {0x6c,0x0a},    
    {0x6d,0x55},    
    {0x6e,0x11},    
    {0x6f,0x9e},    
    {0x6a,0x40},    
    {0x13,0xc7},    
    {0x4f,0x8b},    
    {0x50,0x8b},    
    {0x51,0x00},    
    {0x52,0x22},    
    {0x53,0x5e},    
    {0x54,0x80},    
    {0x58,0x9e},    
    {0x41,0x08},    
    {0x75,0x04},    
    {0x76,0xe1},    
    {0x4c,0x00},    
    {0x77,0x01},    
    {0x3d,0xc8},     // 0xc2. //modify by jianghuaming
    {0x4b,0x09},    
    {0xc9,0x60},    
    {0x41,0x38},    
    {0x56,0x40},    
    {0x34,0x11},    
    {0x3b,0xaa},     // 0x8a
    {0xa4,0x88},    
    {0x96,0x00},    
    {0x97,0x30},    
    {0x98,0x20},    
    {0x99,0x30},    
    {0x9a,0x84},    
    {0x9b,0x29},    
    {0x9c,0x03},    
    {0x9d,0x4b},    
    {0x9e,0x3f},    
    {0x78,0x04},    
    {0x79,0x01},    
    {0xc8,0xf0},    
    {0x79,0x0f},    
    {0xc8,0x00},    
    {0x79,0x10},    
    {0xc8,0x7e},    
    {0x79,0x0a},    
    {0xc8,0x80},    
    {0x79,0x0b},    
    {0xc8,0x01},    
    {0x79,0x0c},    
    {0xc8,0x0f},    
    {0x79,0x0d},    
    {0xc8,0x20},    
    {0x79,0x09},    
    {0xc8,0x80},    
    {0x79,0x02},    
    {0xc8,0xc0},    
    {0x79,0x03},    
    {0xc8,0x40},    
    {0x79,0x05},    
    {0xc8,0x30},    
    {0x79,0x26},    
    {0x2d,0x00},    
    {0x2e,0x00},    
    {0x09,0x03},     // add by jianghuaming
    {0x15,0x12},     // 0x02  //modify by jianghuaming
    {0x13,0xe7},
};
#elif (USE_CAMERA == PAS6375_DEV) 
const UINT8 pas6375_init_talbe[][2] = 
{        
    {0xEF,0x00},  
    {0x04,0x00},  
    {0x05,0x24},  
    {0x06,0x00},  
    {0x07,0x64},  
    {0x08,0x5D},  
    {0x09,0x00},  
    {0x0A,0x3C},  
    {0x0C,0x00},  
    {0x0D,0x50},  
    {0x0E,0x00},  
    {0x0F,0x8C},  
    {0x11,0x64},  
    {0x12,0x30},  
    {0x13,0xE9},  
    {0x14,0x22},  
    {0x15,0x23},  
    {0x16,0x5F},  
    {0x17,0x02},  
    {0x18,0x0F},  
    {0x19,0x40},  
    {0x1A,0x71},  
    {0x1B,0x40},  
    {0x1C,0x64},  
    {0x1D,0xF5},  
    {0x1E,0x90},  
    {0x1F,0x10},  
    {0x20,0x10},  
    {0x21,0x06},  
    {0x22,0x78},  
    {0x23,0x10},  
    {0x24,0x06},  
    {0x25,0x78},  
    {0x26,0x0A},  
    {0x27,0x0A},  
    {0x28,0x3F},  
    {0x29,0x01},  
    {0x2A,0x06},  
    {0x2B,0x0E},  
    {0x2C,0x1E},  
    {0x2D,0x3F},  
    {0x2E,0x4F},  
    {0x2F,0x5F},  
    {0x30,0x6D},  
    {0x31,0x7B},  
    {0x32,0x94},  
    {0x33,0xAA},  
    {0x34,0xBC},  
    {0x35,0xCB},  
    {0x36,0xE1},  
    {0x37,0xF0},  
    {0x38,0xF9},  
    {0x39,0xF1},  
    {0x3A,0x32},  
    {0x3B,0x07},  
    {0x3C,0x19},  
    {0x3D,0x08},  
    {0x3E,0x01},  
    {0x3F,0x0C},  
    {0x40,0x1E},  
    {0x41,0x44},  
    {0x42,0x41},  
    {0x43,0x01},  
    {0x44,0x00},  
    {0x45,0x02},  
    {0x46,0x02},  
    {0x47,0x31},  
    {0x48,0x3C},  
    {0x49,0x7F},  
    {0x4A,0x80},  
    {0x4B,0x42},  
    {0x4C,0x08},  
    {0x4D,0x64},  
    {0x4E,0x87},  
    {0x4F,0x79},  
    {0x50,0x75},  
    {0x51,0x96},  
    {0x52,0x8C},  
    {0x53,0x14},  
    {0x54,0xF5},  
    {0x55,0x43},  
    {0x56,0x18},  
    {0x57,0x01},  
    {0x58,0x03},  
    {0x59,0x03},  
    {0x5A,0x08},  
    {0x5B,0x03},  
    {0x5C,0x0F},  
    {0x5D,0xFF},  
    {0x5E,0x1C},  
    {0x5F,0x05},  
    {0x60,0x01},  
    {0x61,0x16},  
    {0x62,0x0A},  
    {0x63,0x30},  
    {0x64,0x08},  
    {0x65,0x30},  
    {0x66,0x13},  
    {0x67,0xC7},  
    {0x68,0x2D},  
    {0x6B,0x06},  
    {0x6C,0x0F},  
    {0x6D,0x3F},  
    {0x6E,0x03},  
    {0x6F,0x56},  
    {0x70,0x00},  
    {0x71,0x00},  
    {0x72,0x03},  
    {0x73,0xC2},  
    {0x74,0xA4},  
    {0x75,0x83},  
    {0x76,0x60},  
    {0x77,0x88},  
    {0x78,0x01},  
    {0x79,0x19},  
    {0x7B,0x07},  
    {0x7C,0x03},  
    {0x7D,0x08},  
    {0x7E,0x00},  
    {0x7F,0xFF},  
    {0x80,0x87},  
    {0x81,0x12},  
    {0x82,0x00},  
    {0x84,0x16},  
    {0x85,0x00},  
    {0x86,0x08},  
    {0x87,0xEA},  
    {0x88,0x01},  
    {0x89,0x00},  
    {0x8A,0x02},  
    {0x8B,0x00},  
    {0x8C,0xB2},  
    {0x8E,0x00},  
    {0x8F,0x00},  
    {0x90,0x00},  
    {0x91,0x00},  
    {0x93,0x00},  
    {0x94,0x00},  
    {0x95,0x05},  
    {0x97,0x10},  
    {0x98,0x00},  
    {0x99,0x50},  
    {0x9A,0x3C},  
    {0x9B,0x64},  
    {0x9C,0x3C},  
    {0x9D,0x64},  
    {0x9E,0x3C},  
    {0x9F,0x00},  
    {0xA0,0x00},  
    {0xA1,0x00},  
    {0xA2,0x34},  
    {0xA3,0x34},  
    {0xA4,0x34},  
    {0xA5,0x07},  
    {0xA6,0x01},  
    {0xA7,0x03},  
    {0xA8,0x03},  
    {0xDF,0x20},  
    {0xE0,0x80},  
    {0xE1,0x02},  
    {0xE2,0xE0},  
    {0xE3,0x01},  
    {0xE6,0x00},  
    {0xE9,0x07},  
    {0xEA,0x00},  
    {0xEB,0x00},  
    {0xED,0x00},  
    {0xEE,0x3F},  
    {0xED,0x01},  
    {0xEF,0x01},  
    {0x02,0x02},  
    {0x03,0xAC},  
    {0x04,0xF4},  
    {0x05,0x01},  
    {0x06,0x00},  
    {0x07,0x00},  
    {0x08,0x00},  
    {0x0B,0x14},  
    {0x0C,0x00},  
    {0x0D,0x4A},  
    {0x0E,0x02},  
    {0x0F,0x00},  
    {0x10,0x0F},  
    {0x11,0x00},  
    {0x17,0x00},  
    {0x18,0x00},  
    {0x19,0x00},  
    {0x1A,0x00},  
    {0x1B,0x87},  
    {0x1C,0x02},  
    {0x1D,0xE9},  
    {0x1E,0x01},  
    {0x1F,0x01},  
    {0x20,0x14},  
    {0x21,0x00},  
    {0x22,0x08},  
    {0x23,0x01},  
    {0x24,0x0F},  
    {0x25,0x20},  
    {0x26,0x20},  
    {0x27,0x0E},  
    {0x28,0x20},  
    {0x29,0x04},  
    {0x2A,0x00},  
    {0x2B,0x00},  
    {0x2C,0x00},  
    {0x2D,0x01},  
    {0x2E,0xFF},  
    {0x2F,0x65},  
    {0x30,0x6C},  
    {0x31,0x00},  
    {0x32,0x00},  
    {0x33,0x04},  
    {0x34,0xA8},  
    {0x35,0x00},  
    {0x36,0x00},  
    {0x37,0x00},  
    {0x38,0x00},  
    {0x39,0x20},  
    {0x3A,0x10},  
    {0x3B,0x00},  
    {0x3C,0x00},  
    {0x3D,0x00},  
    {0x3E,0x00},  
    {0x40,0x24},  
    {0x41,0x06},  
    {0x42,0x03},  
    {0x43,0x92},  
    {0x44,0x1E},  
    {0x45,0x23},  
    {0x48,0x64},  
    {0x49,0x40},  
    {0x4A,0x00},  
    {0x4B,0x08},  
    {0x4C,0x04},  
    {0x4D,0x38},  
    {0x4E,0x05},  
    {0x50,0x0D},  
    {0x51,0x00},  
    {0x52,0x40},  
    {0x53,0x00},  
    {0x54,0x33},  
    {0x55,0x44},  
    {0x56,0x00},  
    {0x57,0x00},  
    {0x58,0x18},  
    {0x59,0x00},  
    {0x5C,0x00},  
    {0x5D,0x00},  
    {0x5E,0x44},  
    {0x5F,0x40},  
    {0x60,0x10},  
    {0x61,0x04},  
    {0x62,0x01},  
    {0x63,0x78},  
    {0x64,0x10},  
    {0x66,0x08},  
    {0x67,0x40},  
    {0x68,0xC7},  
    {0x69,0x4B},  
    {0x6A,0x01},  
    {0x6B,0x2A},  
    {0x6C,0x00},  
    {0x6D,0x70},  
    {0x6E,0x07},  
    {0x6F,0x00},  
    {0x70,0xBA},  
    {0x71,0x65},  
    {0x72,0x6E},  
    {0x73,0x00},  
    {0x74,0x00},  
    {0x75,0x00},  
    {0x76,0x00},  
    {0x77,0x30},  
    {0x78,0x01},  
    {0x79,0x05},  
    {0x7A,0x0F},  
    {0x7B,0x12},  
    {0x7D,0x04},  
    {0x7F,0x04},  
    {0x80,0x00},  
    {0x81,0x47},  
    {0x82,0x10},  
    {0x84,0x00},  
    {0x85,0x00},  
    {0x86,0x0A},  
    {0x8B,0x00},  
    {0x8C,0x00},  
    {0x8F,0x00},  
    {0x90,0x00},  
    {0x91,0x01},  
    {0x92,0x00},  
    {0x93,0x14},  
    {0x94,0x00},  
    {0x99,0x40},  
    {0x9A,0x00},  
    {0x9B,0x00},  
    {0x9C,0x02},  
    {0x9D,0x43},  
    {0x9E,0x02},  
    {0x9F,0x10},  
    {0xA0,0x89},  
    {0xA1,0x00},  
    {0xA2,0x05},  
    {0xA3,0x00},  
    {0xA4,0x00},  
    {0xA5,0x00},  
    {0xA6,0x00},  
    {0xA7,0x06},  
    {0xA8,0x0F},  
    {0xA9,0x00},  
    {0xAA,0xAA},  
    {0xAB,0x55},  
    {0xAC,0x97},  
    {0xAD,0x71},  
    {0xAE,0x71},  
    {0xAF,0x00},  
    {0xB0,0x05},  
    {0xB1,0x3F},  
    {0xB2,0xCA},  
    {0xB3,0x01},  
    {0xB4,0x00},  
    {0xB5,0x29},  
    {0xB6,0x02},  
    {0xB7,0x00},  
    {0xB8,0xF8},  
    {0xB9,0x00},  
    {0xBA,0x64},  
    {0xBB,0x00},  
    {0xBC,0x19},  
    {0xBF,0x30},  
    {0xC0,0x03},  
    {0xC1,0x18},  
    {0xC2,0x36},  
    {0xC3,0x00},  
    {0xC4,0x00},  
    {0xC5,0x00},  
    {0xC6,0x00},  
    {0xC7,0x08},  
    {0xC8,0x00},  
    {0xC9,0x65},  
    {0xCA,0xA6},  
    {0xCD,0x00},  
    {0xD3,0x80},  
    {0xD4,0x00},  
    {0xD5,0x00},  
    {0xD6,0x03},  
    {0xD7,0x77},  
    {0xD8,0x00},  
    {0xDB,0x00},  
    {0xDE,0x0A},  
    {0xDF,0x00},  
    {0xE0,0x00},  
    {0xE1,0x00},  
    {0xE2,0x17},  
    {0xE4,0x00},  
    {0xE5,0x00},  
    {0xE6,0x00},  
    {0xE7,0x01},  
    {0xE9,0x52},  
    {0xEA,0x90},  
    {0xEB,0x02},  
    {0xEC,0x22},  
    {0xED,0x0D},  
    {0xEE,0x04},  
    {0xF2,0x00},  
    {0xF3,0x50},  
    {0xF6,0x05},  
    {0xF7,0x10},  
    {0xF8,0x03},  
    {0xF9,0x10},  
    {0x11,0x01},  
    {0xEF,0x02},  
    {0x00,0x00},  
    {0x01,0x31},  
    {0x02,0xC7},  
    {0x03,0x00},  
    {0x04,0x3C},  
    {0x05,0xA8},  
    {0x06,0x20},  
    {0x08,0x00},  
    {0x09,0x00},  
    {0x0A,0x00},  
    {0x0B,0x00},  
    {0x0C,0x0A},  
    {0x0E,0x00},  
    {0x0F,0x96},  
    {0x10,0x32},  
    {0x11,0x0E},  
    {0x12,0xB0},  
    {0x13,0x28},  
    {0x14,0xFF},  
    {0x15,0x1E},  
    {0x1A,0xB1},  
    {0x1B,0x86},  
    {0x1C,0x69},  
    {0x1D,0x7D},  
    {0x1E,0x87},  
    {0x1F,0x9B},  
    {0x20,0xB4},  
    {0x21,0x02},  
    {0x22,0x08},  
    {0x23,0x18},  
    {0x2A,0x84},  
    {0x2B,0x00},  
    {0x2C,0x18},  
    {0x2D,0x10},  
    {0x2E,0x1E},  
    {0x2F,0x0E},  
    {0x30,0x0E},  
    {0x31,0x01},  
    {0x32,0x3F},  
    {0x33,0x18},  
    {0x34,0x01},  
    {0x35,0x08},  
    {0x36,0x04},  
    {0x37,0x08},  
    {0x38,0x0E},  
    {0x39,0x20},  
    {0x3A,0x8B},  
    {0x3C,0x04},  
    {0x49,0x0B},  
    {0x4A,0x00},  
    {0x4B,0x00},  
    {0x4C,0x01},  
    {0x4D,0x14},  
    {0x4E,0x02},  
    {0x4F,0x3C},  
    {0x50,0x22},  
    {0x51,0x01},  
    {0x52,0x18},  
    {0x53,0x01},  
    {0x54,0x01},  
    {0x55,0x00},  
    {0x56,0x03},  
    {0x57,0x02},  
    {0x58,0x08},  
    {0x59,0x00},  
    {0x5A,0x08},  
    {0x5B,0x08},  
    {0x5C,0x05},  
    {0x5D,0x02},  
    {0x5E,0x06},  
    {0x5F,0x0F},  
    {0x60,0x14},  
    {0x61,0x00},  
    {0x62,0x04},  
    {0x63,0x4F},  
    {0x64,0x03},  
    {0x65,0x44},  
    {0x66,0x80},  
    {0x68,0x00},  
    {0x69,0x0F},  
    {0x6A,0x00},  
    {0x6B,0x00},  
    {0x6C,0x00},  
    {0x6D,0x00},  
    {0x6E,0x00},  
    {0x6F,0x00},  
    {0x70,0x00},  
    {0x71,0x84},  
    {0x72,0x80},  
    {0x73,0x01},  
    {0x74,0xD4},  
    {0x75,0xC4},  
    {0x8D,0x12},  
    {0x8E,0x10},  
    {0x8F,0x10},  
    {0x90,0x0F},  
    {0x93,0x00},  
    {0x94,0x0C},  
    {0x95,0x04},  
    {0x96,0x00},  
    {0x97,0x08},  
    {0x98,0x04},  
    {0x9B,0x02},  
    {0x9C,0x80},  
    {0x9D,0x01},  
    {0x9E,0xE0},  
    {0x9F,0x00},  
    {0xA0,0x00},  
    {0xA1,0x00},  
    {0xA2,0x00},  
    {0xA4,0x02},  
    {0xA5,0x0A},  
    {0xA6,0x0C},  
    {0xAD,0x00},  
    {0xAE,0x00},  
    {0xB2,0x00},  
    {0xBC,0x10},  
    {0xBD,0x01},  
    {0xBE,0x00},  
    {0xBF,0x00},  
    {0xC0,0x00},  
    {0xC1,0x13},  
    {0xC2,0x10},  
    {0xD7,0x02},  
    {0xD8,0x04},  
    {0xD9,0xC8},  
    {0xDA,0x50},  
    {0xDB,0x0E},  
    {0xDC,0x08},  
    {0xDD,0x14},  
    {0xDE,0x32},  
    {0xDF,0x00},  
    {0xE0,0x04},  
    {0xE1,0x00},  
    {0xE3,0x00},  
    {0xE4,0x00},  
    {0xE5,0x00},  
    {0xE6,0x00},  
    {0xEB,0x00},  
    {0x00,0x01},  
    {0xEF,0x03},  
    {0x01,0x01},  
    {0x02,0x00},  
    {0x03,0x33},  
    {0x04,0x1A},  
    {0x05,0x58},  
    {0x06,0x0E},  
    {0x07,0x0F},  
    {0x08,0x39},  
    {0x09,0x48},  
    {0x0A,0x3D},  
    {0x0B,0x3A},  
    {0x0C,0x03},  
    {0x0D,0x01},  
    {0x0E,0x13},  
    {0x0F,0x0D},  
    {0x10,0x01},  
    {0x11,0x0F},  
    {0x12,0x02},  
    {0x13,0x1A},  
    {0x14,0x19},  
    {0x15,0x0D},  
    {0x16,0x0E},  
    {0x17,0x01},  
    {0x18,0x85},  
    {0x19,0x54},  
    {0x1A,0x10},  
    {0x1B,0x40},  
    {0x1C,0x40},  
    {0x1D,0x21},  
    {0x1E,0x40},  
    {0x1F,0x54},  
    {0x30,0xA0},  
    {0x31,0x01},  
    {0x32,0x50},  
    {0x33,0x00},  
    {0x34,0x60},  
    {0x35,0x00},  
    {0x36,0x00},  
    {0x37,0xFF},  
    {0x38,0x5A},  
    {0x39,0x3C},  
    {0x3A,0x28},  
    {0x3B,0x14},  
    {0x3C,0x02},  
    {0x3D,0x34},  
    {0x3E,0x05},  
    {0x50,0xD0},  
    {0x51,0x50},  
    {0x52,0x40},  
    {0x53,0x18},  
    {0x54,0xA4},  
    {0x55,0x01},  
    {0x56,0x14},  
    {0x57,0x60},  
    {0x58,0x02},  
    {0x59,0x32},  
    {0x5A,0x33},  
    {0x5B,0x24},  
    {0x5C,0x7F},  
    {0x5D,0x0F},  
    {0x5E,0x0F},  
    {0x5F,0x0F},  
    {0x60,0x0F},  
    {0x61,0x1C},  
    {0x62,0x07},  
    {0x63,0x00},  
    {0x64,0x15},  
    {0x65,0x01},  
    {0x66,0x40},  
    {0x68,0x00},  
    {0x69,0xFF},  
    {0x6A,0x00},  
    {0x6B,0xFF},  
    {0x78,0x01},  
    {0x79,0x54},  
    {0x7A,0x40},  
    {0x7B,0x0F},  
    {0x80,0x00},  
    {0x81,0x01},  
    {0x82,0x0F},  
    {0x83,0x18},  
    {0x84,0x02},  
    {0x85,0x0C},  
    {0x86,0x28},  
    {0x87,0x02},  
    {0x8A,0x03},  
    {0x8B,0x96},  
    {0x8C,0x40},  
    {0x8D,0x04},  
    {0x8E,0x00},  
    {0x8F,0x10},  
    {0x90,0x00},  
    {0x9A,0x26},  
    {0x9B,0x00},  
    {0xF1,0x00},  
    {0xF2,0x00},  
    {0xF3,0x00},  
    {0xF4,0x00},  
    {0xF5,0x00},  
    {0xF8,0x48},  
    {0xF9,0x00},  
    {0xFA,0x02},  
    {0xFB,0x00},  
    {0xFC,0x10},  
    {0x00,0x01},  
};

#elif (USE_CAMERA == GC0328C_DEV) 
const UINT8 gc0328c_init_talbe[][2] = {
    {0xFE,0x80},
    {0xFE,0x80},
    {0xFC,0x16},
    {0xFC,0x16},
    {0xFC,0x16},
    {0xFC,0x16},
    {0xF1,0x00},
    {0xF2,0x00},
    {0xFE,0x00},
    {0x4F,0x00},
    {0x03,0x00},
    {0x04,0xC0},
    {0x42,0x00},
    {0x77,0x5A},
    {0x78,0x40},
    {0x79,0x56},
    {0xFE,0x00},
    {0x0D,0x01},
    {0x0E,0xE8},
    {0x0F,0x02},
    {0x10,0x88},
    {0x09,0x00},
    {0x0A,0x00},
    {0x0B,0x00},
    {0x0C,0x00},
    {0x16,0x00},
    {0x17,0x14},
    {0x18,0x0E},
    {0x19,0x06},
    {0x1B,0x48},
    {0x1F,0xC8},
    {0x20,0x01},
    {0x21,0x78},
    {0x22,0xB0},
    {0x23,0x04},
    {0x24,0x16},
    {0x26,0x00},
    {0x50,0x01},
    {0x70,0x45},
    {0x05,0x00},
    {0x06,0xDE},
    {0x07,0x00},
    {0x08,0xA7},
    {0xFE,0x01},
    {0x29,0x00},
    {0x2A,0x83},
    {0x2B,0x02},
    {0x2C,0x8F},
    {0x2D,0x02},
    {0x2E,0x8F},
    {0x2F,0x02},
    {0x30,0x8F},
    {0x31,0x02},
    {0x32,0x8F},
    {0xFE,0x00},
    {0xFE,0x01},
    {0x50,0x00},
    {0x4F,0x00},
    {0x4C,0x01},
    {0x4F,0x00},
    {0x4F,0x00},
    {0x4F,0x00},
    {0x4F,0x00},
    {0x4F,0x00},
    {0x4D,0x30},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4D,0x40},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4D,0x50},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4D,0x60},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4D,0x70},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4F,0x01},
    {0x50,0x88},
    {0xFE,0x00},
    {0xFE,0x00},
    {0x27,0xB7},
    {0x28,0x7F},
    {0x29,0x20},
    {0x33,0x20},
    {0x34,0x20},
    {0x35,0x20},
    {0x36,0x20},
    {0x32,0x08},
    {0x3B,0x00},
    {0x3C,0x00},
    {0x3D,0x00},
    {0x3E,0x00},
    {0x47,0x00},
    {0x48,0x00},
    {0x40,0x7F},
    {0x41,0x26},
    {0x42,0xFB},
    {0x44,0x02},
    {0x45,0x00},
    {0x46,0x03},
    {0x4F,0x01},
    {0x4B,0x01},
    {0x50,0x01},
    {0x7E,0x0A},
    {0x7F,0x03},
    {0x81,0x15},
    {0x82,0x90},
    {0x83,0x02},
    {0x84,0xE5},
    {0x90,0x2C},
    {0x92,0x02},
    {0x94,0x02},
    {0x95,0x35},
    {0xD1,0x24},
    {0xD2,0x24},
    {0xD3,0x40},
    {0xDD,0xD3},
    {0xDE,0x38},
    {0xE4,0x88},
    {0xE5,0x40},
    {0xD7,0x0E},
    {0xFE,0x00},
    {0xBF,0x0E},
    {0xC0,0x1C},
    {0xC1,0x34},
    {0xC2,0x48},
    {0xC3,0x5A},
    {0xC4,0x6E},
    {0xC5,0x80},
    {0xC6,0x9C},
    {0xC7,0xB4},
    {0xC8,0xC7},
    {0xC9,0xD7},
    {0xCA,0xE3},
    {0xCB,0xED},
    {0xCC,0xF2},
    {0xCD,0xF8},
    {0xCE,0xFD},
    {0xCF,0xFF},
    {0xFE,0x00},
    {0x63,0x00},
    {0x64,0x05},
    {0x65,0x0B},
    {0x66,0x19},
    {0x67,0x2E},
    {0x68,0x40},
    {0x69,0x54},
    {0x6A,0x66},
    {0x6B,0x86},
    {0x6C,0xA7},
    {0x6D,0xC6},
    {0x6E,0xE4},
    {0x6F,0xFF},
    {0xFE,0x01},
    {0x18,0x02},
    {0xFE,0x00},
    {0x97,0x30},
    {0x98,0x00},
    {0x9B,0x60},
    {0x9C,0x60},
    {0xA4,0x50},
    {0xA8,0x80},
    {0xAA,0x40},
    {0xA2,0x23},
    {0xAD,0x28},
    {0xFE,0x01},
    {0x9C,0x00},
    {0x9E,0xC0},
    {0x9F,0x40},
    {0xFE,0x01},
    {0x08,0xA0},
    {0x09,0xE8},
    {0x10,0x08},
    {0x11,0x21},
    {0x12,0x11},
    {0x13,0x45},
    {0x15,0xFC},
    {0x18,0x02},
    {0x21,0xF0},
    {0x22,0x60},
    {0x23,0x30},
    {0x25,0x00},
    {0x24,0x14},
    {0x3D,0x80},
    {0x3E,0x40},
    {0xFE,0x01},
    {0x51,0x88},
    {0x52,0x12},
    {0x53,0x80},
    {0x54,0x60},
    {0x55,0x01},
    {0x56,0x02},
    {0x58,0x00},
    {0x5B,0x02},
    {0x5E,0xA4},
    {0x5F,0x8A},
    {0x61,0xDC},
    {0x62,0xDC},
    {0x70,0xFC},
    {0x71,0x10},
    {0x72,0x10},
    {0x73,0x20},
    {0x74,0x20},
    {0x75,0x01},
    {0x76,0x00},
    {0x77,0x40},
    {0x78,0x70},
    {0x79,0x00},
    {0x7B,0x00},
    {0x7C,0x71},
    {0x7D,0x00},
    {0x80,0x70},
    {0x81,0x58},
    {0x82,0x98},
    {0x83,0x60},
    {0x84,0x58},
    {0x85,0x50},
    {0xFE,0x00},
    {0xFE,0x01},
    {0xC0,0x10},
    {0xC1,0x0C},
    {0xC2,0x0A},
    {0xC6,0x0E},
    {0xC7,0x0B},
    {0xC8,0x0A},
    {0xBA,0x26},
    {0xBB,0x1C},
    {0xBC,0x1D},
    {0xB4,0x23},
    {0xB5,0x1C},
    {0xB6,0x1A},
    {0xC3,0x00},
    {0xC4,0x00},
    {0xC5,0x00},
    {0xC9,0x00},
    {0xCA,0x00},
    {0xCB,0x00},
    {0xBD,0x00},
    {0xBE,0x00},
    {0xBF,0x00},
    {0xB7,0x07},
    {0xB8,0x05},
    {0xB9,0x05},
    {0xA8,0x07},
    {0xA9,0x06},
    {0xAA,0x00},
    {0xAB,0x04},
    {0xAC,0x00},
    {0xAD,0x02},
    {0xAE,0x0D},
    {0xAF,0x05},
    {0xB0,0x00},
    {0xB1,0x07},
    {0xB2,0x03},
    {0xB3,0x00},
    {0xA4,0x00},
    {0xA5,0x00},
    {0xA6,0x00},
    {0xA7,0x00},
    {0xA1,0x3C},
    {0xA2,0x50},
    {0xFE,0x00},
    {0xB1,0x12},
    {0xB2,0xF5},
    {0xB3,0xFE},
    {0xB4,0xE0},
    {0xB5,0x15},
    {0xB6,0xC8},
    {0xFE,0x01},
    {0x50,0x00},
    {0xFE,0x01},
    {0x4F,0x00},
    {0x4C,0x01},
    {0x4F,0x00},
    {0x4F,0x00},
    {0x4F,0x00},
    {0x4D,0x34},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x02},
    {0x4E,0x02},
    {0x4D,0x44},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4D,0x53},
    {0x4E,0x08},
    {0x4E,0x08},
    {0x4E,0x04},
    {0x4E,0x04},
    {0x4D,0x65},
    {0x4E,0x04},
    {0x4D,0x73},
    {0x4E,0x20},
    {0x4D,0x83},
    {0x4E,0x20},
    {0x4F,0x01},
    {0x50,0x88},
    {0xFE,0x00},
    {0xF1,0x07},
    {0xF2,0x01},
};
#endif  // USE_CAMERA

#endif
