/**
 * @file tkl_mutex.c
 * @brief this file was auto-generated by tuyaos v&v tools, developer can add implements between BEGIN and END
 * 
 * @warning: changes between user 'BEGIN' and 'END' will be keeped when run tuyaos v&v tools
 *           changes in other place will be overwrited and lost
 *
 * @copyright Copyright 2020-2021 Tuya Inc. All Rights Reserved.
 * 
 */

// --- BEGIN: user defines and implements ---
#include "tkl_mutex.h"
#include "FreeRTOS.h"
#include "task.h"
#include "semphr.h"
#include "tuya_error_code.h"
// --- END: user defines and implements ---

/**
* @brief Create mutex
*
* @param[out] pMutexHandle: mutex handle
*
* @note This API is used to create and init mutex.
*
* @return OPRT_OK on success. Others on error, please refer to tuya_error_code.h
*/
OPERATE_RET tkl_mutex_create_init(TKL_MUTEX_HANDLE *handle)
{
    // --- BEGIN: user implements ---
    if(!handle)
        return OPRT_INVALID_PARM;
    
#if configUSE_RECURSIVE_MUTEXES
	*handle = (TKL_MUTEX_HANDLE)xSemaphoreCreateRecursiveMutex();
#else
	*handle = (TKL_MUTEX_HANDLE)xSemaphoreCreateMutex();
#endif

	if (NULL == *handle) {
		return OPRT_OS_ADAPTER_MUTEX_CREAT_FAILED;
	}
	
    return OPRT_OK;
    // --- END: user implements ---
}

/**
* @brief Lock mutex
*
* @param[in] mutexHandle: mutex handle
*
* @note This API is used to lock mutex.
*
* @return OPRT_OK on success. Others on error, please refer to tuya_error_code.h
*/
OPERATE_RET tkl_mutex_lock(CONST TKL_MUTEX_HANDLE handle)
{
    // --- BEGIN: user implements ---
    if(!handle) {
        return OPRT_INVALID_PARM;
    }
    
    BaseType_t ret;
#if configUSE_RECURSIVE_MUTEXES
    ret = xSemaphoreTakeRecursive(handle, portMAX_DELAY);
#else
    ret = xSemaphoreTake(handle, portMAX_DELAY);
#endif
    if (pdTRUE != ret) {
        return OPRT_OS_ADAPTER_MUTEX_LOCK_FAILED;
    }

    return OPRT_OK;
    // --- END: user implements ---
}

/**
* @brief Try Lock mutex
*
* @param[in] mutexHandle: mutex handle
*
* @note This API is used to try lock mutex.
*
* @return OPRT_OK on success. Others on error, please refer to tuya_error_code.h
*/
OPERATE_RET tkl_mutex_trylock(CONST TKL_MUTEX_HANDLE mutexHandle)
{
    // --- BEGIN: user implements ---
    return OPRT_OK;
    // --- END: user implements ---
}

/**
* @brief Unlock mutex
*
* @param[in] mutexHandle: mutex handle
*
* @note This API is used to unlock mutex.
*
* @return OPRT_OK on success. Others on error, please refer to tuya_error_code.h
*/
OPERATE_RET tkl_mutex_unlock(CONST TKL_MUTEX_HANDLE handle)
{
    // --- BEGIN: user implements ---
    BaseType_t ret;

    if(!handle) {
        return OPRT_INVALID_PARM;
    }
    
#if configUSE_RECURSIVE_MUTEXES
    ret = xSemaphoreGiveRecursive(handle);
#else
    ret = xSemaphoreGive(handle);
#endif
    // ж
    // 
    // extern uint32_t bk_wlan_get_INT_status(void);
    // if (0 == bk_wlan_get_INT_status()) {
    //     ret = xSemaphoreGive(handle);
    // } else {
    //     signed portBASE_TYPE xHigherPriorityTaskWoken = pdFALSE;
    //     ret = xSemaphoreGiveFromISR(handle, &xHigherPriorityTaskWoken);
    //     portEND_SWITCHING_ISR(xHigherPriorityTaskWoken);
    // }
    if (pdTRUE != ret) {
        return OPRT_OS_ADAPTER_MUTEX_UNLOCK_FAILED;
    }

    return OPRT_OK;
    // --- END: user implements ---
}

/**
* @brief Release mutex
*
* @param[in] mutexHandle: mutex handle
*
* @note This API is used to release mutex.
*
* @return OPRT_OK on success. Others on error, please refer to tuya_error_code.h
*/
OPERATE_RET tkl_mutex_release(CONST TKL_MUTEX_HANDLE handle)
{
    // --- BEGIN: user implements ---
    if(!handle) {
        return OPRT_INVALID_PARM;
    }
    
    vSemaphoreDelete(handle);
	
    return OPRT_OK;
    // --- END: user implements ---
}

