/**
 * @file tkl_sleep.c
 * @brief this file was auto-generated by tuyaos v&v tools, developer can add implements between BEGIN and END
 * 
 * @warning: changes between user 'BEGIN' and 'END' will be keeped when run tuyaos v&v tools
 *           changes in other place will be overwrited and lost
 *
 * @copyright Copyright 2020-2021 Tuya Inc. All Rights Reserved.
 * 
 */

// --- BEGIN: user defines and implements ---
#include "tkl_sleep.h"
#include "tuya_error_code.h"
#include "wlan_ui_pub.h"


unsigned char cpu_lp_flag = 0;
// --- END: user defines and implements ---

/**
 * @brief sleep callback register
 * 
 * @param[in] sleep_cb:  sleep callback
 *
 * @return OPRT_OK on success. Others on error, please refer to tuya_error_code.h
 */
OPERATE_RET tkl_cpu_sleep_callback_register(TUYA_SLEEP_CB_T *sleep_cb)
{
    // --- BEGIN: user implements ---
    return OPRT_NOT_SUPPORTED;
    // --- END: user implements ---
}

/**
 * @brief allow to sleep
 * 
 * @param[in] none
 *
 * @return none
 */
VOID_T tkl_cpu_allow_sleep(VOID_T)
{
    // --- BEGIN: user implements ---
    return ;
    // --- END: user implements ---
}

/**
 * @brief force wakeup
 * 
 * @param[in] none
 *
 * @return none
 */
VOID_T tkl_cpu_force_wakeup(VOID_T)
{
    // --- BEGIN: user implements ---
    return ;
    // --- END: user implements ---
}

/**
* @brief Set the low power mode of CPU
*
* @param[in] enable: enable switch
* @param[in] mode:   cpu sleep mode
*
* @note This API is used for setting the low power mode of CPU.
*
* @return OPRT_OK on success. Others on error, please refer to tuya_error_code.h
*/
OPERATE_RET tkl_cpu_sleep_mode_set(BOOL_T enable, TUYA_CPU_SLEEP_MODE_E mode)
{
    // --- BEGIN: user implements ---
    os_printf("*******************************tuya_os_adapt_set_cpu_lp_mode,en = %d, mode = %d\r\n",enable,mode);

    if(mode == TUYA_CPU_SLEEP) {
        if(enable) {
            if(cpu_lp_flag == 0) {
                cpu_lp_flag = 1;                
                os_printf("pmu_release_wakelock(PMU_OS)\r\n");
            }

            bk_wlan_mcu_ps_mode_enable();
            os_printf("bk_wlan_mcu_ps_mode_enable()\r\n");
        }else {
            bk_wlan_mcu_ps_mode_disable();
            os_printf("bk_wlan_mcu_ps_mode_disable()\r\n");
        }
    }else {
        return OPRT_OS_ADAPTER_CPU_LPMODE_SET_FAILED;
    }

    return OPRT_OK;
    // --- END: user implements ---
}

