/**
 * @file tkl_system.c
 * @brief this file was auto-generated by tuyaos v&v tools, developer can add implements between BEGIN and END
 * 
 * @warning: changes between user 'BEGIN' and 'END' will be keeped when run tuyaos v&v tools
 *           changes in other place will be overwrited and lost
 *
 * @copyright Copyright 2020-2021 Tuya Inc. All Rights Reserved.
 * 
 */

// --- BEGIN: user defines and implements ---
#include "tkl_system.h"
#include "tuya_error_code.h"
#include "start_type_pub.h"
#include "FreeRTOS.h"
#include "task.h"
#include "rtos_pub.h"
#include "BkDriverRng.h"
#include "wlan_ui_pub.h"
// --- END: user defines and implements ---

/**
* @brief system reset
*
* @param none
*
* @return none
*/
VOID_T tkl_system_reset(VOID_T)
{
    // --- BEGIN: user implements ---
    bk_reboot();
	return;
    // --- END: user implements ---
}

/**
* @brief Get system tick count
*
* @param none
*
* @return system tick count
*/
SYS_TICK_T tkl_system_get_tick_count(VOID_T)
{
    // --- BEGIN: user implements ---
    return (SYS_TICK_T)xTaskGetTickCount();
    // --- END: user implements ---
}

/**
* @brief Get system millisecond
*
* @param none
*
* @return system millisecond
*/
SYS_TIME_T tkl_system_get_millisecond(VOID_T)
{
    // --- BEGIN: user implements ---
    return (SYS_TIME_T)(tkl_system_get_tick_count() * portTICK_RATE_MS);
    // --- END: user implements ---
}

/**
* @brief Get system random data
*
* @param[in] range: random from 0  to range
*
* @return random value
*/
INT_T tkl_system_get_random(UINT_T range)
{
    // --- BEGIN: user implements ---
    unsigned int trange = range;

    if (range == 0) {
        trange = 0xFF;
    }

    static char exec_flag = FALSE;

    if (!exec_flag) {
        exec_flag = TRUE;
    }

    return (bk_rand() % trange);
    // --- END: user implements ---
}

/**
* @brief Get system reset reason
*
* @param[in] describe: point to reset reason describe
*
* @return reset reason
*/
TUYA_RESET_REASON_E tkl_system_get_reset_reason(CHAR_T** describe)
{
    // --- BEGIN: user implements ---
    unsigned char value = bk_misc_get_start_type() & 0xFF;
    TUYA_RESET_REASON_E bk_value;

    switch (value) {
        case RESET_SOURCE_POWERON:
            bk_value = TUYA_RESET_REASON_POWERON;
            break;

        case RESET_SOURCE_REBOOT:
            bk_value = TUYA_RESET_REASON_SOFTWARE;
            break;

        case RESET_SOURCE_WATCHDOG:
            bk_value = TUYA_RESET_REASON_HW_WDOG;
            break;
        
        case RESET_SOURCE_DEEPPS_GPIO:
        case RESET_SOURCE_DEEPPS_RTC:
            bk_value = TUYA_RESET_REASON_DEEPSLEEP;
            break;
            
        case RESET_SOURCE_CRASH_XAT0:
        case RESET_SOURCE_CRASH_UNDEFINED:
        case RESET_SOURCE_CRASH_PREFETCH_ABORT:
        case RESET_SOURCE_CRASH_DATA_ABORT:
        case RESET_SOURCE_CRASH_UNUSED:
        case RESET_SOURCE_CRASH_PER_XAT0:
            bk_value = TUYA_RESET_REASON_FAULT;
            break;

        default:
            bk_value = TUYA_RESET_REASON_UNKNOWN;
            break;

    }

    return bk_value;
    // --- END: user implements ---
}

/**
* @brief  system sleep
*
* @param[in] describe: num ms
*
* @return none
*/
VOID_T tkl_system_sleep(UINT_T num_ms)
{
    // --- BEGIN: user implements ---
    UINT_T ticks = num_ms / portTICK_RATE_MS;

    if (ticks == 0) {
        ticks = 1;
    }

    vTaskDelay(ticks);
    // --- END: user implements ---
}

/**
* @brief system delay
*
* @param[in] msTime: time in MS
*
* @note This API is used for system sleep.
*
* @return VOID
*/
VOID_T tkl_system_delay(UINT_T num_ms)
{
    // --- BEGIN: user implements ---
    return ;
    // --- END: user implements ---
}

/**
* @brief get system cpu info
*
* @param[in] cpu_ary: info of cpus
* @param[in] cpu_cnt: num of cpu
* @note This API is used for system cpu info get.
*
* @return OPRT_OK on success. Others on error, please refer to tuya_error_code.h
*/

OPERATE_RET tkl_system_get_cpu_info(TUYA_CPU_INFO_T **cpu_ary, INT_T *cpu_cnt)
{
    // --- BEGIN: user implements ---
    return OPRT_NOT_SUPPORTED;
    // --- END: user implements ---
}

