/**
 * @file tkl_timer.c
 * @brief this file was auto-generated by tuyaos v&v tools, developer can add implements between BEGIN and END
 * 
 * @warning: changes between user 'BEGIN' and 'END' will be keeped when run tuyaos v&v tools
 *           changes in other place will be overwrited and lost
 *
 * @copyright Copyright 2020-2021 Tuya Inc. All Rights Reserved.
 * 
 */

// --- BEGIN: user defines and implements ---
#include "tkl_timer.h"
#include "tuya_error_code.h"
#include "tkl_output.h"
#include "BkDriverTimer.h"

/* private macros */
#define TIMER_DEV_NUM       4

/* private variables */
static TUYA_TIMER_BASE_CFG_T timer_map[] = {
    {TUYA_TIMER_MODE_ONCE, NULL, NULL},
    {TUYA_TIMER_MODE_ONCE, NULL, NULL},
    {TUYA_TIMER_MODE_ONCE, NULL, NULL},
    {TUYA_TIMER_MODE_ONCE, NULL, NULL},
    {TUYA_TIMER_MODE_ONCE, NULL, NULL},
    {TUYA_TIMER_MODE_ONCE, NULL, NULL}
};

/* extern function */
extern OSStatus bk_timer_read_cnt(uint8_t timer_id, uint32_t *timer_cnt);
extern OSStatus bk_timer_initialize_us(uint8_t timer_id, uint32_t time_us, void *callback);

/**
 * @brief timer cb
 * 
 * @param[in] args: hw timer id
 *
 * @return none
 */
static void __tkl_hw_timer_cb(void *args)
{
    TUYA_TIMER_NUM_E timer_id = (TUYA_TIMER_NUM_E)args;
    if(timer_map[timer_id].cb){
        timer_map[timer_id].cb(timer_map[timer_id].args);
    }
    return;
}

//test demo
#if 0
TUYA_TIMER_NUM_E time_test_id = 2;

void tkl_hw_test_cb(void *args)
{
    tkl_log_output("timer args = %d\r\n",(int)args);
}


void tkl_hw_test(void)
{
    int timer = 1122;
    TUYA_TIMER_BASE_CFG_T cfg = {
        .mode = TUYA_TIMER_MODE_PERIOD,
        .cb   = tkl_hw_test_cb,
        .args = (void*)timer
    };

    tkl_timer_init(time_test_id, &cfg);
    tkl_timer_start(time_test_id, 1000000);
}


#endif

// --- END: user defines and implements ---

/**
 * @brief timer init
 * 
 * @param[in] timer_id timer id
 * @param[in] cfg timer configure
 *
 * @return OPRT_OK on success. Others on error, please refer to tuya_error_code.h
 */
OPERATE_RET tkl_timer_init(TUYA_TIMER_NUM_E timer_id, TUYA_TIMER_BASE_CFG_T *cfg)
{
    // --- BEGIN: user implements ---
    if (timer_id >= TIMER_DEV_NUM) {
        return OPRT_NOT_SUPPORTED;
    }
    if(cfg == NULL){
        return OPRT_INVALID_PARM;
    }
    if ((2 == timer_id) || (3 == timer_id)) {//bk timer23 ϵͳռʵ bk timerID Ϊ timer4~timer5
        timer_id +=2;
    }
    timer_map[timer_id].mode = cfg->mode;
    timer_map[timer_id].cb = cfg->cb;
    timer_map[timer_id].args = cfg->args;
    return OPRT_OK;
    // --- END: user implements ---
}

/**
 * @brief timer start
 * 
 * @param[in] timer_id timer id
 * @param[in] us when to start
 *
 * @return OPRT_OK on success. Others on error, please refer to tuya_error_code.h
 */
OPERATE_RET tkl_timer_start(TUYA_TIMER_NUM_E timer_id, UINT_T us)
{
    // --- BEGIN: user implements ---
    if (timer_id >= TIMER_DEV_NUM) {
        return OPRT_NOT_SUPPORTED;
    }

    if ((0 == timer_id) || (1 == timer_id)) {
        bk_timer_initialize_us(timer_id, us, __tkl_hw_timer_cb);
    } else {
        if (us < 1000) {
            /* tuya timer2~timer3 can't not set cycle less than 1ms */
            return OPRT_INVALID_PARM;
        }
        bk_timer_initialize((timer_id + 2), us / 1000, __tkl_hw_timer_cb); //bk timer23 ϵͳռʵ bk timerID Ϊ timer4~timer5
        return OPRT_OK;
    }

    return OPRT_OK;
    // --- END: user implements ---
}

/**
 * @brief timer stop
 * 
 * @param[in] timer_id timer id
 *
 * @return OPRT_OK on success. Others on error, please refer to tuya_error_code.h
 */
OPERATE_RET tkl_timer_stop(TUYA_TIMER_NUM_E timer_id)
{
    // --- BEGIN: user implements ---
    if (timer_id >= TIMER_DEV_NUM) {
        return OPRT_NOT_SUPPORTED;
    }

    if ((0 == timer_id) || (1 == timer_id)) {
        bk_timer_stop(timer_id);
    } else {
        bk_timer_stop(timer_id + 2); //bk timer23 ϵͳռʵ bk timerID Ϊ timer4~timer5
        return OPRT_OK;
    }

    return OPRT_OK;
    // --- END: user implements ---
}

/**
 * @brief timer deinit
 * 
 * @param[in] timer_id timer id
 *
 * @return OPRT_OK on success. Others on error, please refer to tuya_error_code.h
 */
OPERATE_RET tkl_timer_deinit(TUYA_TIMER_NUM_E timer_id)
{
    // --- BEGIN: user implements ---
    return OPRT_OK;
    // --- END: user implements ---
}

/**
 * @brief current timer get
 * 
 * @param[in] timer_id timer id
 * @param[out] us timer 
 *
 * @return OPRT_OK on success. Others on error, please refer to tuya_error_code.h
 */
OPERATE_RET tkl_timer_get_current_value(TUYA_TIMER_NUM_E timer_id, UINT_T *us)
{
    // --- BEGIN: user implements ---
    return OPRT_NOT_SUPPORTED;
    // --- END: user implements ---
}

/**
 * @brief timer get
 * 
 * @param[in] timer_id timer id
 * @param[out] us timer interval
 *
 * @return OPRT_OK on success. Others on error, please refer to tuya_error_code.h
 */
OPERATE_RET tkl_timer_get(TUYA_TIMER_NUM_E timer_id, UINT_T *us)
{
    // --- BEGIN: user implements ---
    uint32_t count;

    if ((0 == timer_id) || (1 == timer_id)) {
        bk_timer_read_cnt(timer_id, &count);

        if (us != NULL) {
            *us = count / 26;
        }
    } 
    else {
        return OPRT_NOT_SUPPORTED;
    }

    return OPRT_OK;
    // --- END: user implements ---
}

