#!/bin/bash

# CI系统传入的参数说明:
#
# $1 - SDK项目名称，如: zigbee_sample
# $2 - SDK产物版本，如: 0.0.1-beta.8
# $3 - 开发环境名称，如: efr32_zigbee
# $4 - SDK产物包路径，如: output/dist/zigbee_sample_0.0.1-beta.8_efr32_zigbee_sdk_cfg_0.0.1-beta.9.tar.gz
#
# 例：
#  sh -c "./env_prepare.sh 'zigbee_sample' '0.0.1-beta.8' 'efr32_zigbee' 'output/dist/zigbee_sample_0.0.1-beta.8_efr32_zigbee_sdk_cfg_0.0.1-beta.9.tar.gz'"

CURR_DIR="$( cd "$( dirname "$0" )" && pwd )"

TARGET_NAME=$4
TARGET_PATH=$(dirname $TARGET_NAME)
TUYAOS_PATH=../..
SDK_PATH=sdk
TOOLCHAIN_DIR=toolchain
DRIVERS_DIR=tuyaos/drivers
SDK_BUILD_DIR=$TOOLCHAIN_DIR/cmake

CMD_DIR="commander"
BOOT_DIR="bootloader"
SCRIPTS_DIR="scripts"
TEMPLATES_DIR='templates'

APPS_DIR="apps"
LIBS_DIR="libs"
DOCS_DIR="docs"
TOOLS_DIR="tools"
INCLUDE_DIR="include"
ADAPTER_DIR="adapter"
COMPONENTS_DIR="components"
TUYA_DRIVERS_DIR=$TUYAOS_PATH/$COMPONENTS_DIR/app_tuya_driver/src/non-os

TEMP_DIR="TuyaOS"
OUTPUT_NAME=$TUYAOS_PATH/$TEMP_DIR
OUTPUT_PATH=$TUYAOS_PATH/$TARGET_PATH

# efr32_sdk_6.10.3
SDK_NAME="$( ls "$SDK_PATH")"
IAR_ICF_NAME="iar-cfg.icf"
IAR_ICF_PATH=$SDK_PATH/$SDK_NAME/platform/base/hal/micro/cortexm3/efm32
IAR_ICF_COMMON_NAME="iar-cfg-common.icf"
IAR_ICF_COMMON_PATH=$SDK_PATH/$SDK_NAME/platform/base/hal/micro/cortexm3


echo -e "Build SDK Begin"


cd $SDK_BUILD_DIR

# 1-build 编译 router lib
CHIP_PLATFORM_ID="EFR32MG21A020F1024IM32"
for ((i=0; i<1; i++))
do
    # if [ $i == 1 ]
    # then
    #     CHIP_PLATFORM_ID="EFR32MG21A020F768IM32"
    # fi
    # build router SDK
    python3 tkl_build.py '-make' 'router' $SDK_NAME $CHIP_PLATFORM_ID
    if [ $? -ne 0 ]; then 
    echo -e "kernel router sdk compile error !!!"
    exit 1;
    fi
    # build router TAL
    python3 tal_build.py '-make' 'router' $SDK_NAME $CHIP_PLATFORM_ID
    if [ $? -ne 0 ]; then 
    echo -e "tal router library compile error !!!"
    exit 1;
    fi
done

# 2-build 编译 sleep end device lib
# CHIP_PLATFORM_ID="EFR32MG21A020F1024IM32"
# for ((i=0; i<2; i++))
# do
#     if [ $i == 1 ]
#     then
#         CHIP_PLATFORM_ID="EFR32MG21A020F768IM32"
#     fi
#     # build router SDK
#     python3 tkl_build.py '-make' 'sleep_end_dev' $SDK_NAME $CHIP_PLATFORM_ID
#     if [ $? -ne 0 ]; then 
#     echo -e "kernel sleep_end_dev sdk compile error !!!"
#     exit 1;
#     fi
#     # build sleep_end_dev TAL
#     python3 tal_build.py '-make' 'sleep_end_dev' $SDK_NAME $CHIP_PLATFORM_ID
#     if [ $? -ne 0 ]; then 
#     echo -e "tal sleep_end_dev library compile error !!!"
#     exit 1;
#     fi
# done

cd -

# mkdir output file
if [ -d "$OUTPUT_PATH" ];then
    rm -rf $OUTPUT_NAME
fi
mkdir -p $OUTPUT_PATH

# 3-build 收集 sdk package
VENDOR_EMLIB=vendor/efr32_zigbee/$SDK_PATH/$SDK_NAME/platform/emlib
VENDOR_CMSIS=vendor/efr32_zigbee/$SDK_PATH/$SDK_NAME/platform/CMSIS
DEVICE_INCLUDE=vendor/efr32_zigbee/$SDK_PATH/$SDK_NAME/platform/Device/SiliconLabs/EFR32MG21
INTERRUPT_INCLUDE=vendor/efr32_zigbee/sdk/efr32_sdk_6.10.3/platform/emdrv/gpiointerrupt
TUYAOS_DIR=vendor/efr32_zigbee/tuyaos/drivers

mkdir -p $OUTPUT_NAME/$APPS_DIR
mkdir -p $OUTPUT_NAME/$TOOLS_DIR
mkdir -p $OUTPUT_NAME/$SCRIPTS_DIR
mkdir -p $OUTPUT_NAME/$VENDOR_EMLIB
mkdir -p $OUTPUT_NAME/$VENDOR_CMSIS
mkdir -p $OUTPUT_NAME/$TUYAOS_DIR
mkdir -p $OUTPUT_NAME/$DEVICE_INCLUDE
mkdir -p $OUTPUT_NAME/$INTERRUPT_INCLUDE
mkdir -p $OUTPUT_NAME/$COMPONENTS_DIR/app_tuya_driver/src
cp -a $TUYAOS_PATH/$DOCS_DIR $OUTPUT_NAME/$DOCS_DIR
cp -a $TUYAOS_PATH/$LIBS_DIR $OUTPUT_NAME/$LIBS_DIR
cp -a $TUYAOS_PATH/$INCLUDE_DIR $OUTPUT_NAME/$INCLUDE_DIR
if [ -d "$TUYAOS_PATH/$COMPONENTS_DIR" ];then
    for file in ` ls $TUYAOS_PATH/$COMPONENTS_DIR `
    do
        if [ -d $TUYAOS_PATH/$COMPONENTS_DIR"/"$file ];then
            # echo "$file"
            mkdir -p $OUTPUT_NAME/$INCLUDE_DIR/$COMPONENTS_DIR/$file
            cp -a $TUYAOS_PATH/$COMPONENTS_DIR/$file/$INCLUDE_DIR  $OUTPUT_NAME/$INCLUDE_DIR/$COMPONENTS_DIR/$file
        fi
    done
fi
if [ -d "$TUYAOS_PATH/$ADAPTER_DIR" ];then
    for file in ` ls $TUYAOS_PATH/$ADAPTER_DIR `
    do
        if [ -d $TUYAOS_PATH/$ADAPTER_DIR"/"$file ];then
            # echo "$file"
            mkdir -p $OUTPUT_NAME/$INCLUDE_DIR/$ADAPTER_DIR/$file
            cp -a $TUYAOS_PATH/$ADAPTER_DIR/$file/$INCLUDE_DIR  $OUTPUT_NAME/$INCLUDE_DIR/$ADAPTER_DIR/$file
        fi
    done
fi


# copy vendor header files and tuyaos drivers
cp -a $TUYAOS_PATH/$VENDOR_EMLIB/inc $OUTPUT_NAME/$VENDOR_EMLIB
cp -a $TUYAOS_PATH/$VENDOR_EMLIB/src $OUTPUT_NAME/$VENDOR_EMLIB
cp -a $TUYAOS_PATH/$INTERRUPT_INCLUDE/inc $OUTPUT_NAME/$INTERRUPT_INCLUDE
cp -a $TUYAOS_PATH/$INTERRUPT_INCLUDE/src $OUTPUT_NAME/$INTERRUPT_INCLUDE
cp -a $TUYAOS_PATH/$VENDOR_CMSIS/Include $OUTPUT_NAME/$VENDOR_CMSIS
cp -a $TUYAOS_PATH/$DEVICE_INCLUDE/Include $OUTPUT_NAME/$DEVICE_INCLUDE
cp -a $DRIVERS_DIR/tkl_adc.c $OUTPUT_NAME/$TUYAOS_DIR
cp -a $DRIVERS_DIR/tkl_pwm.c $OUTPUT_NAME/$TUYAOS_DIR
cp -a $DRIVERS_DIR/tkl_gpio.c $OUTPUT_NAME/$TUYAOS_DIR
if [ -d "$TUYA_DRIVERS_DIR" ];then
    for file in ` ls $TUYA_DRIVERS_DIR `
    do
        if [ -f $TUYA_DRIVERS_DIR"/"$file ];then
            # echo "$file"
            cp -a $TUYA_DRIVERS_DIR/$file $OUTPUT_NAME/$COMPONENTS_DIR/app_tuya_driver/src
        fi
    done
fi

# copy necessary document
cp -a $TUYAOS_PATH/CHANGELOG.md $OUTPUT_NAME
cp -a $TUYAOS_PATH/RELEASE.md $OUTPUT_NAME
cp -a $TUYAOS_PATH/LICENSE $OUTPUT_NAME

# copy build_app.bat and build_app.py
cp -a $SDK_BUILD_DIR/build_app.*  $OUTPUT_NAME
cp -a $TUYAOS_PATH/$SCRIPTS_DIR/kconfiglib  $OUTPUT_NAME/$SCRIPTS_DIR

# copy ld file to tools
LD_FILE="ld"
LD_ICF_FILE="icf"
mkdir -p $OUTPUT_NAME/$LD_FILE/$LD_ICF_FILE
cp -a $IAR_ICF_PATH/$IAR_ICF_NAME $OUTPUT_NAME/$LD_FILE/$LD_ICF_FILE
cp -a $IAR_ICF_COMMON_PATH/$IAR_ICF_COMMON_NAME $OUTPUT_NAME/$LD_FILE
mv -f $OUTPUT_NAME/$LD_FILE $OUTPUT_NAME/$TOOLS_DIR

# copy tools to output directory
cp -a $TOOLCHAIN_DIR/$CMD_DIR  $OUTPUT_NAME/$TOOLS_DIR
cp -a $TOOLCHAIN_DIR/$BOOT_DIR  $OUTPUT_NAME/$TOOLS_DIR
cp -a $TOOLCHAIN_DIR/$SCRIPTS_DIR  $OUTPUT_NAME/$TOOLS_DIR
cp -a $TOOLCHAIN_DIR/$TEMPLATES_DIR  $OUTPUT_NAME/$TOOLS_DIR


#4-build 打包压缩生成产物
tar -zcPf $TUYAOS_PATH/$TARGET_NAME -C $TUYAOS_PATH $TEMP_DIR
rm -rf $OUTPUT_NAME

echo -e "Build Finish"


