# coding:utf-8
import os
import sys
import shutil
import xml.etree.ElementTree as ET

# 'router' of 'sleep_end_device'
DEVICE_TYPE = sys.argv[1]
#'-make' or '-clean'
BUILD_OPT = sys.argv[2]
# chip id efr32mg21a020f768im32 /efr32mg21a020f1024im32
CHIP_PLATFORM_ID = sys.argv[3].lower()

MAKE_EWP_FILE = 'efr32_sdk.ewp'
MAKE_DEP_FILE = 'efr32_sdk.dep'
BUILD_OUTPUT_DIR = '..\..\..\..\..\..\libs'
IAR_PATH_PREFEX = os.path.join('$PROJ_DIR$', '')

sdk_libs_list = []
tkl_libs_list = []


def tkl_libs_file_copy_to_target_dir(libs_list, output_path):

    for item in libs_list:
        file_name = os.path.split(item)[1]
        new_file = os.path.join(output_path, file_name)
        old_file = item.replace(IAR_PATH_PREFEX, '')
        # print(new_file)
        # print(old_file)
        shutil.copyfile(old_file, new_file)


def sdk_libs_file_copy_to_target_dir(libs_list, output_path):

    lib_name = os.listdir(output_path)
    for item in libs_list:
        file_name = os.path.split(item)[1]
        if file_name not in lib_name:
            new_file = os.path.join(output_path, file_name)
            old_file = item.replace(IAR_PATH_PREFEX, '')
            # print(new_file)
            # print(old_file)
            shutil.copyfile(old_file, new_file)


def iar_xml_sdk_libs_path_collect(xml_root, libs_path):

    setting = xml_root.findall('group')
    for obs in setting:
        name = obs.find('name')
        # print(name.text)
        if name.text == 'Libraries':
            item = obs.findall('file')
            for opt in item:
                f_name = opt.find('name')
                # print(f_name.text)
                libs_path.append(f_name.text)
            # print("find sucessfully")


def iar_xml_tkl_libs_path_collect(xml_root, libs_path):
    
    cfg_obs = xml_root.findall('configuration')
    for obs in cfg_obs:
        name = obs.find('name')
        if name.text == DEVICE_TYPE:
            # print(name.text)
            setting = obs.findall('settings')
            for obs in setting:
                obs_name = obs.find('name')
                if obs_name.text == 'IARCHIVE':
                    option = obs.find('data').findall('option')
                    for item in option:
                        item_name = item.find('name')
                        if item_name.text == 'IarchiveOutput':
                            state = item.find('state')
                            # print(state.text)
                            libs_path.append(state.text)
                            tkl_libs_list.append(state.text)
                            # print("find sucessfully")


def iar_xml_resolution_libs_path():

    ewp_tree = ET.parse(MAKE_EWP_FILE)
    ewp_root = ewp_tree.getroot()
    iar_xml_tkl_libs_path_collect(ewp_root, tkl_libs_list)
    iar_xml_sdk_libs_path_collect(ewp_root, sdk_libs_list)


def tkl_lib_copy_to_target_dir():
    
    output_path = os.path.join(BUILD_OUTPUT_DIR, '')
    if os.path.exists(output_path) == False:
        os.mkdir(output_path)
    iar_xml_resolution_libs_path()
    tkl_libs_file_copy_to_target_dir(tkl_libs_list, output_path)
    sdk_libs_file_copy_to_target_dir(sdk_libs_list, output_path)


def tkl_clean_build_dir():
    build_path = DEVICE_TYPE
    if os.path.exists(build_path):
        os.remove(MAKE_DEP_FILE)
        os.rmtree(build_path)

if __name__ == "__main__":

    print('< SDK BUILD-POST START >')
    if BUILD_OPT == '-make':
        tkl_lib_copy_to_target_dir()
    elif BUILD_OPT == '-clean':
        tkl_clean_build_dir()

