/**************************************************************************//**
 * @file
 * @brief EFR32MG24 MPAHBRAM register and bit field definitions
 ******************************************************************************
 * # License
 * <b>Copyright 2021 Silicon Laboratories, Inc. www.silabs.com</b>
 ******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 *****************************************************************************/
#ifndef EFR32MG24_MPAHBRAM_H
#define EFR32MG24_MPAHBRAM_H
#define MPAHBRAM_HAS_SET_CLEAR

/**************************************************************************//**
* @addtogroup Parts
* @{
******************************************************************************/
/**************************************************************************//**
 * @defgroup EFR32MG24_MPAHBRAM MPAHBRAM
 * @{
 * @brief EFR32MG24 MPAHBRAM Register Declaration.
 *****************************************************************************/

/** MPAHBRAM Register Declaration. */
typedef struct {
  __IM uint32_t  IPVERSION;                     /**< IP version ID                                      */
  __IOM uint32_t CMD;                           /**< Command register                                   */
  __IOM uint32_t CTRL;                          /**< Control register                                   */
  __IM uint32_t  ECCERRADDR0;                   /**< ECC Error Address 0                                */
  __IM uint32_t  ECCERRADDR1;                   /**< ECC Error Address 1                                */
  __IM uint32_t  ECCERRADDR2;                   /**< ECC Error Address 2                                */
  __IM uint32_t  ECCERRADDR3;                   /**< ECC Error Address 3                                */
  __IM uint32_t  ECCMERRIND;                    /**< Multiple ECC error indication                      */
  __IOM uint32_t IF;                            /**< Interrupt Flags                                    */
  __IOM uint32_t IEN;                           /**< Interrupt Enable                                   */
  __IOM uint32_t RAMBANKSVALID;                 /**< New Register                                       */
  __IOM uint32_t CFGSRTOP;                      /**< Sequential Region on Top                           */
  __IOM uint32_t CFGSRMAP;                      /**< Sequential Region Map                              */
  __IOM uint32_t CFGIU0MAP;                     /**< Interleaving Unit 0 Map                            */
  __IOM uint32_t CFGIU1MAP;                     /**< Interleaving Unit 1 Map                            */
  __IOM uint32_t CFGIU2MAP;                     /**< Interleaving Unit 2 Map                            */
  __IOM uint32_t CFGIU3MAP;                     /**< Interleaving Unit 3 Map                            */
  __IOM uint32_t RPURATD0;                      /**< Root Access Type Descriptor Register               */
  uint32_t       RESERVED0[1006U];              /**< Reserved for future use                            */
  __IM uint32_t  IPVERSION_SET;                 /**< IP version ID                                      */
  __IOM uint32_t CMD_SET;                       /**< Command register                                   */
  __IOM uint32_t CTRL_SET;                      /**< Control register                                   */
  __IM uint32_t  ECCERRADDR0_SET;               /**< ECC Error Address 0                                */
  __IM uint32_t  ECCERRADDR1_SET;               /**< ECC Error Address 1                                */
  __IM uint32_t  ECCERRADDR2_SET;               /**< ECC Error Address 2                                */
  __IM uint32_t  ECCERRADDR3_SET;               /**< ECC Error Address 3                                */
  __IM uint32_t  ECCMERRIND_SET;                /**< Multiple ECC error indication                      */
  __IOM uint32_t IF_SET;                        /**< Interrupt Flags                                    */
  __IOM uint32_t IEN_SET;                       /**< Interrupt Enable                                   */
  __IOM uint32_t RAMBANKSVALID_SET;             /**< New Register                                       */
  __IOM uint32_t CFGSRTOP_SET;                  /**< Sequential Region on Top                           */
  __IOM uint32_t CFGSRMAP_SET;                  /**< Sequential Region Map                              */
  __IOM uint32_t CFGIU0MAP_SET;                 /**< Interleaving Unit 0 Map                            */
  __IOM uint32_t CFGIU1MAP_SET;                 /**< Interleaving Unit 1 Map                            */
  __IOM uint32_t CFGIU2MAP_SET;                 /**< Interleaving Unit 2 Map                            */
  __IOM uint32_t CFGIU3MAP_SET;                 /**< Interleaving Unit 3 Map                            */
  __IOM uint32_t RPURATD0_SET;                  /**< Root Access Type Descriptor Register               */
  uint32_t       RESERVED1[1006U];              /**< Reserved for future use                            */
  __IM uint32_t  IPVERSION_CLR;                 /**< IP version ID                                      */
  __IOM uint32_t CMD_CLR;                       /**< Command register                                   */
  __IOM uint32_t CTRL_CLR;                      /**< Control register                                   */
  __IM uint32_t  ECCERRADDR0_CLR;               /**< ECC Error Address 0                                */
  __IM uint32_t  ECCERRADDR1_CLR;               /**< ECC Error Address 1                                */
  __IM uint32_t  ECCERRADDR2_CLR;               /**< ECC Error Address 2                                */
  __IM uint32_t  ECCERRADDR3_CLR;               /**< ECC Error Address 3                                */
  __IM uint32_t  ECCMERRIND_CLR;                /**< Multiple ECC error indication                      */
  __IOM uint32_t IF_CLR;                        /**< Interrupt Flags                                    */
  __IOM uint32_t IEN_CLR;                       /**< Interrupt Enable                                   */
  __IOM uint32_t RAMBANKSVALID_CLR;             /**< New Register                                       */
  __IOM uint32_t CFGSRTOP_CLR;                  /**< Sequential Region on Top                           */
  __IOM uint32_t CFGSRMAP_CLR;                  /**< Sequential Region Map                              */
  __IOM uint32_t CFGIU0MAP_CLR;                 /**< Interleaving Unit 0 Map                            */
  __IOM uint32_t CFGIU1MAP_CLR;                 /**< Interleaving Unit 1 Map                            */
  __IOM uint32_t CFGIU2MAP_CLR;                 /**< Interleaving Unit 2 Map                            */
  __IOM uint32_t CFGIU3MAP_CLR;                 /**< Interleaving Unit 3 Map                            */
  __IOM uint32_t RPURATD0_CLR;                  /**< Root Access Type Descriptor Register               */
  uint32_t       RESERVED2[1006U];              /**< Reserved for future use                            */
  __IM uint32_t  IPVERSION_TGL;                 /**< IP version ID                                      */
  __IOM uint32_t CMD_TGL;                       /**< Command register                                   */
  __IOM uint32_t CTRL_TGL;                      /**< Control register                                   */
  __IM uint32_t  ECCERRADDR0_TGL;               /**< ECC Error Address 0                                */
  __IM uint32_t  ECCERRADDR1_TGL;               /**< ECC Error Address 1                                */
  __IM uint32_t  ECCERRADDR2_TGL;               /**< ECC Error Address 2                                */
  __IM uint32_t  ECCERRADDR3_TGL;               /**< ECC Error Address 3                                */
  __IM uint32_t  ECCMERRIND_TGL;                /**< Multiple ECC error indication                      */
  __IOM uint32_t IF_TGL;                        /**< Interrupt Flags                                    */
  __IOM uint32_t IEN_TGL;                       /**< Interrupt Enable                                   */
  __IOM uint32_t RAMBANKSVALID_TGL;             /**< New Register                                       */
  __IOM uint32_t CFGSRTOP_TGL;                  /**< Sequential Region on Top                           */
  __IOM uint32_t CFGSRMAP_TGL;                  /**< Sequential Region Map                              */
  __IOM uint32_t CFGIU0MAP_TGL;                 /**< Interleaving Unit 0 Map                            */
  __IOM uint32_t CFGIU1MAP_TGL;                 /**< Interleaving Unit 1 Map                            */
  __IOM uint32_t CFGIU2MAP_TGL;                 /**< Interleaving Unit 2 Map                            */
  __IOM uint32_t CFGIU3MAP_TGL;                 /**< Interleaving Unit 3 Map                            */
  __IOM uint32_t RPURATD0_TGL;                  /**< Root Access Type Descriptor Register               */
} MPAHBRAM_TypeDef;
/** @} End of group EFR32MG24_MPAHBRAM */

/**************************************************************************//**
 * @addtogroup EFR32MG24_MPAHBRAM
 * @{
 * @defgroup EFR32MG24_MPAHBRAM_BitFields MPAHBRAM Bit Fields
 * @{
 *****************************************************************************/

/* Bit fields for MPAHBRAM IPVERSION */
#define _MPAHBRAM_IPVERSION_RESETVALUE                    0x00000002UL                                 /**< Default value for MPAHBRAM_IPVERSION        */
#define _MPAHBRAM_IPVERSION_MASK                          0x00000003UL                                 /**< Mask for MPAHBRAM_IPVERSION                 */
#define _MPAHBRAM_IPVERSION_IPVERSION_SHIFT               0                                            /**< Shift value for MPAHBRAM_IPVERSION          */
#define _MPAHBRAM_IPVERSION_IPVERSION_MASK                0x3UL                                        /**< Bit mask for MPAHBRAM_IPVERSION             */
#define _MPAHBRAM_IPVERSION_IPVERSION_DEFAULT             0x00000002UL                                 /**< Mode DEFAULT for MPAHBRAM_IPVERSION         */
#define MPAHBRAM_IPVERSION_IPVERSION_DEFAULT              (_MPAHBRAM_IPVERSION_IPVERSION_DEFAULT << 0) /**< Shifted mode DEFAULT for MPAHBRAM_IPVERSION */

/* Bit fields for MPAHBRAM CMD */
#define _MPAHBRAM_CMD_RESETVALUE                          0x00000000UL                               /**< Default value for MPAHBRAM_CMD              */
#define _MPAHBRAM_CMD_MASK                                0x0000000FUL                               /**< Mask for MPAHBRAM_CMD                       */
#define MPAHBRAM_CMD_CLEARECCADDR0                        (0x1UL << 0)                               /**< Clear ECCERRADDR0                           */
#define _MPAHBRAM_CMD_CLEARECCADDR0_SHIFT                 0                                          /**< Shift value for MPAHBRAM_CLEARECCADDR0      */
#define _MPAHBRAM_CMD_CLEARECCADDR0_MASK                  0x1UL                                      /**< Bit mask for MPAHBRAM_CLEARECCADDR0         */
#define _MPAHBRAM_CMD_CLEARECCADDR0_DEFAULT               0x00000000UL                               /**< Mode DEFAULT for MPAHBRAM_CMD               */
#define MPAHBRAM_CMD_CLEARECCADDR0_DEFAULT                (_MPAHBRAM_CMD_CLEARECCADDR0_DEFAULT << 0) /**< Shifted mode DEFAULT for MPAHBRAM_CMD       */
#define MPAHBRAM_CMD_CLEARECCADDR1                        (0x1UL << 1)                               /**< Clear ECCERRADDR1                           */
#define _MPAHBRAM_CMD_CLEARECCADDR1_SHIFT                 1                                          /**< Shift value for MPAHBRAM_CLEARECCADDR1      */
#define _MPAHBRAM_CMD_CLEARECCADDR1_MASK                  0x2UL                                      /**< Bit mask for MPAHBRAM_CLEARECCADDR1         */
#define _MPAHBRAM_CMD_CLEARECCADDR1_DEFAULT               0x00000000UL                               /**< Mode DEFAULT for MPAHBRAM_CMD               */
#define MPAHBRAM_CMD_CLEARECCADDR1_DEFAULT                (_MPAHBRAM_CMD_CLEARECCADDR1_DEFAULT << 1) /**< Shifted mode DEFAULT for MPAHBRAM_CMD       */
#define MPAHBRAM_CMD_CLEARECCADDR2                        (0x1UL << 2)                               /**< Clear ECCERRADDR2                           */
#define _MPAHBRAM_CMD_CLEARECCADDR2_SHIFT                 2                                          /**< Shift value for MPAHBRAM_CLEARECCADDR2      */
#define _MPAHBRAM_CMD_CLEARECCADDR2_MASK                  0x4UL                                      /**< Bit mask for MPAHBRAM_CLEARECCADDR2         */
#define _MPAHBRAM_CMD_CLEARECCADDR2_DEFAULT               0x00000000UL                               /**< Mode DEFAULT for MPAHBRAM_CMD               */
#define MPAHBRAM_CMD_CLEARECCADDR2_DEFAULT                (_MPAHBRAM_CMD_CLEARECCADDR2_DEFAULT << 2) /**< Shifted mode DEFAULT for MPAHBRAM_CMD       */
#define MPAHBRAM_CMD_CLEARECCADDR3                        (0x1UL << 3)                               /**< Clear ECCERRADDR3                           */
#define _MPAHBRAM_CMD_CLEARECCADDR3_SHIFT                 3                                          /**< Shift value for MPAHBRAM_CLEARECCADDR3      */
#define _MPAHBRAM_CMD_CLEARECCADDR3_MASK                  0x8UL                                      /**< Bit mask for MPAHBRAM_CLEARECCADDR3         */
#define _MPAHBRAM_CMD_CLEARECCADDR3_DEFAULT               0x00000000UL                               /**< Mode DEFAULT for MPAHBRAM_CMD               */
#define MPAHBRAM_CMD_CLEARECCADDR3_DEFAULT                (_MPAHBRAM_CMD_CLEARECCADDR3_DEFAULT << 3) /**< Shifted mode DEFAULT for MPAHBRAM_CMD       */

/* Bit fields for MPAHBRAM CTRL */
#define _MPAHBRAM_CTRL_RESETVALUE                         0x00000040UL                                  /**< Default value for MPAHBRAM_CTRL             */
#define _MPAHBRAM_CTRL_MASK                               0x000000FFUL                                  /**< Mask for MPAHBRAM_CTRL                      */
#define MPAHBRAM_CTRL_ECCEN                               (0x1UL << 0)                                  /**< Enable ECC functionality                    */
#define _MPAHBRAM_CTRL_ECCEN_SHIFT                        0                                             /**< Shift value for MPAHBRAM_ECCEN              */
#define _MPAHBRAM_CTRL_ECCEN_MASK                         0x1UL                                         /**< Bit mask for MPAHBRAM_ECCEN                 */
#define _MPAHBRAM_CTRL_ECCEN_DEFAULT                      0x00000000UL                                  /**< Mode DEFAULT for MPAHBRAM_CTRL              */
#define MPAHBRAM_CTRL_ECCEN_DEFAULT                       (_MPAHBRAM_CTRL_ECCEN_DEFAULT << 0)           /**< Shifted mode DEFAULT for MPAHBRAM_CTRL      */
#define MPAHBRAM_CTRL_ECCWEN                              (0x1UL << 1)                                  /**< Enable ECC syndrome writes                  */
#define _MPAHBRAM_CTRL_ECCWEN_SHIFT                       1                                             /**< Shift value for MPAHBRAM_ECCWEN             */
#define _MPAHBRAM_CTRL_ECCWEN_MASK                        0x2UL                                         /**< Bit mask for MPAHBRAM_ECCWEN                */
#define _MPAHBRAM_CTRL_ECCWEN_DEFAULT                     0x00000000UL                                  /**< Mode DEFAULT for MPAHBRAM_CTRL              */
#define MPAHBRAM_CTRL_ECCWEN_DEFAULT                      (_MPAHBRAM_CTRL_ECCWEN_DEFAULT << 1)          /**< Shifted mode DEFAULT for MPAHBRAM_CTRL      */
#define MPAHBRAM_CTRL_ECCERRFAULTEN                       (0x1UL << 2)                                  /**< ECC Error bus fault enable                  */
#define _MPAHBRAM_CTRL_ECCERRFAULTEN_SHIFT                2                                             /**< Shift value for MPAHBRAM_ECCERRFAULTEN      */
#define _MPAHBRAM_CTRL_ECCERRFAULTEN_MASK                 0x4UL                                         /**< Bit mask for MPAHBRAM_ECCERRFAULTEN         */
#define _MPAHBRAM_CTRL_ECCERRFAULTEN_DEFAULT              0x00000000UL                                  /**< Mode DEFAULT for MPAHBRAM_CTRL              */
#define MPAHBRAM_CTRL_ECCERRFAULTEN_DEFAULT               (_MPAHBRAM_CTRL_ECCERRFAULTEN_DEFAULT << 2)   /**< Shifted mode DEFAULT for MPAHBRAM_CTRL      */
#define _MPAHBRAM_CTRL_AHBPORTPRIORITY_SHIFT              3                                             /**< Shift value for MPAHBRAM_AHBPORTPRIORITY    */
#define _MPAHBRAM_CTRL_AHBPORTPRIORITY_MASK               0x38UL                                        /**< Bit mask for MPAHBRAM_AHBPORTPRIORITY       */
#define _MPAHBRAM_CTRL_AHBPORTPRIORITY_DEFAULT            0x00000000UL                                  /**< Mode DEFAULT for MPAHBRAM_CTRL              */
#define _MPAHBRAM_CTRL_AHBPORTPRIORITY_NONE               0x00000000UL                                  /**< Mode NONE for MPAHBRAM_CTRL                 */
#define _MPAHBRAM_CTRL_AHBPORTPRIORITY_PORT0              0x00000001UL                                  /**< Mode PORT0 for MPAHBRAM_CTRL                */
#define _MPAHBRAM_CTRL_AHBPORTPRIORITY_PORT1              0x00000002UL                                  /**< Mode PORT1 for MPAHBRAM_CTRL                */
#define _MPAHBRAM_CTRL_AHBPORTPRIORITY_PORT2              0x00000003UL                                  /**< Mode PORT2 for MPAHBRAM_CTRL                */
#define _MPAHBRAM_CTRL_AHBPORTPRIORITY_PORT3              0x00000004UL                                  /**< Mode PORT3 for MPAHBRAM_CTRL                */
#define MPAHBRAM_CTRL_AHBPORTPRIORITY_DEFAULT             (_MPAHBRAM_CTRL_AHBPORTPRIORITY_DEFAULT << 3) /**< Shifted mode DEFAULT for MPAHBRAM_CTRL      */
#define MPAHBRAM_CTRL_AHBPORTPRIORITY_NONE                (_MPAHBRAM_CTRL_AHBPORTPRIORITY_NONE << 3)    /**< Shifted mode NONE for MPAHBRAM_CTRL         */
#define MPAHBRAM_CTRL_AHBPORTPRIORITY_PORT0               (_MPAHBRAM_CTRL_AHBPORTPRIORITY_PORT0 << 3)   /**< Shifted mode PORT0 for MPAHBRAM_CTRL        */
#define MPAHBRAM_CTRL_AHBPORTPRIORITY_PORT1               (_MPAHBRAM_CTRL_AHBPORTPRIORITY_PORT1 << 3)   /**< Shifted mode PORT1 for MPAHBRAM_CTRL        */
#define MPAHBRAM_CTRL_AHBPORTPRIORITY_PORT2               (_MPAHBRAM_CTRL_AHBPORTPRIORITY_PORT2 << 3)   /**< Shifted mode PORT2 for MPAHBRAM_CTRL        */
#define MPAHBRAM_CTRL_AHBPORTPRIORITY_PORT3               (_MPAHBRAM_CTRL_AHBPORTPRIORITY_PORT3 << 3)   /**< Shifted mode PORT3 for MPAHBRAM_CTRL        */
#define MPAHBRAM_CTRL_ADDRFAULTEN                         (0x1UL << 6)                                  /**< Address fault bus fault enable              */
#define _MPAHBRAM_CTRL_ADDRFAULTEN_SHIFT                  6                                             /**< Shift value for MPAHBRAM_ADDRFAULTEN        */
#define _MPAHBRAM_CTRL_ADDRFAULTEN_MASK                   0x40UL                                        /**< Bit mask for MPAHBRAM_ADDRFAULTEN           */
#define _MPAHBRAM_CTRL_ADDRFAULTEN_DEFAULT                0x00000001UL                                  /**< Mode DEFAULT for MPAHBRAM_CTRL              */
#define MPAHBRAM_CTRL_ADDRFAULTEN_DEFAULT                 (_MPAHBRAM_CTRL_ADDRFAULTEN_DEFAULT << 6)     /**< Shifted mode DEFAULT for MPAHBRAM_CTRL      */
#define MPAHBRAM_CTRL_WAITSTATES                          (0x1UL << 7)                                  /**< RAM read wait states                        */
#define _MPAHBRAM_CTRL_WAITSTATES_SHIFT                   7                                             /**< Shift value for MPAHBRAM_WAITSTATES         */
#define _MPAHBRAM_CTRL_WAITSTATES_MASK                    0x80UL                                        /**< Bit mask for MPAHBRAM_WAITSTATES            */
#define _MPAHBRAM_CTRL_WAITSTATES_DEFAULT                 0x00000000UL                                  /**< Mode DEFAULT for MPAHBRAM_CTRL              */
#define MPAHBRAM_CTRL_WAITSTATES_DEFAULT                  (_MPAHBRAM_CTRL_WAITSTATES_DEFAULT << 7)      /**< Shifted mode DEFAULT for MPAHBRAM_CTRL      */

/* Bit fields for MPAHBRAM ECCERRADDR0 */
#define _MPAHBRAM_ECCERRADDR0_RESETVALUE                  0x00000000UL                              /**< Default value for MPAHBRAM_ECCERRADDR0      */
#define _MPAHBRAM_ECCERRADDR0_MASK                        0xFFFFFFFFUL                              /**< Mask for MPAHBRAM_ECCERRADDR0               */
#define _MPAHBRAM_ECCERRADDR0_ADDR_SHIFT                  0                                         /**< Shift value for MPAHBRAM_ADDR               */
#define _MPAHBRAM_ECCERRADDR0_ADDR_MASK                   0xFFFFFFFFUL                              /**< Bit mask for MPAHBRAM_ADDR                  */
#define _MPAHBRAM_ECCERRADDR0_ADDR_DEFAULT                0x00000000UL                              /**< Mode DEFAULT for MPAHBRAM_ECCERRADDR0       */
#define MPAHBRAM_ECCERRADDR0_ADDR_DEFAULT                 (_MPAHBRAM_ECCERRADDR0_ADDR_DEFAULT << 0) /**< Shifted mode DEFAULT for MPAHBRAM_ECCERRADDR0*/

/* Bit fields for MPAHBRAM ECCERRADDR1 */
#define _MPAHBRAM_ECCERRADDR1_RESETVALUE                  0x00000000UL                              /**< Default value for MPAHBRAM_ECCERRADDR1      */
#define _MPAHBRAM_ECCERRADDR1_MASK                        0xFFFFFFFFUL                              /**< Mask for MPAHBRAM_ECCERRADDR1               */
#define _MPAHBRAM_ECCERRADDR1_ADDR_SHIFT                  0                                         /**< Shift value for MPAHBRAM_ADDR               */
#define _MPAHBRAM_ECCERRADDR1_ADDR_MASK                   0xFFFFFFFFUL                              /**< Bit mask for MPAHBRAM_ADDR                  */
#define _MPAHBRAM_ECCERRADDR1_ADDR_DEFAULT                0x00000000UL                              /**< Mode DEFAULT for MPAHBRAM_ECCERRADDR1       */
#define MPAHBRAM_ECCERRADDR1_ADDR_DEFAULT                 (_MPAHBRAM_ECCERRADDR1_ADDR_DEFAULT << 0) /**< Shifted mode DEFAULT for MPAHBRAM_ECCERRADDR1*/

/* Bit fields for MPAHBRAM ECCERRADDR2 */
#define _MPAHBRAM_ECCERRADDR2_RESETVALUE                  0x00000000UL                              /**< Default value for MPAHBRAM_ECCERRADDR2      */
#define _MPAHBRAM_ECCERRADDR2_MASK                        0xFFFFFFFFUL                              /**< Mask for MPAHBRAM_ECCERRADDR2               */
#define _MPAHBRAM_ECCERRADDR2_ADDR_SHIFT                  0                                         /**< Shift value for MPAHBRAM_ADDR               */
#define _MPAHBRAM_ECCERRADDR2_ADDR_MASK                   0xFFFFFFFFUL                              /**< Bit mask for MPAHBRAM_ADDR                  */
#define _MPAHBRAM_ECCERRADDR2_ADDR_DEFAULT                0x00000000UL                              /**< Mode DEFAULT for MPAHBRAM_ECCERRADDR2       */
#define MPAHBRAM_ECCERRADDR2_ADDR_DEFAULT                 (_MPAHBRAM_ECCERRADDR2_ADDR_DEFAULT << 0) /**< Shifted mode DEFAULT for MPAHBRAM_ECCERRADDR2*/

/* Bit fields for MPAHBRAM ECCERRADDR3 */
#define _MPAHBRAM_ECCERRADDR3_RESETVALUE                  0x00000000UL                              /**< Default value for MPAHBRAM_ECCERRADDR3      */
#define _MPAHBRAM_ECCERRADDR3_MASK                        0xFFFFFFFFUL                              /**< Mask for MPAHBRAM_ECCERRADDR3               */
#define _MPAHBRAM_ECCERRADDR3_ADDR_SHIFT                  0                                         /**< Shift value for MPAHBRAM_ADDR               */
#define _MPAHBRAM_ECCERRADDR3_ADDR_MASK                   0xFFFFFFFFUL                              /**< Bit mask for MPAHBRAM_ADDR                  */
#define _MPAHBRAM_ECCERRADDR3_ADDR_DEFAULT                0x00000000UL                              /**< Mode DEFAULT for MPAHBRAM_ECCERRADDR3       */
#define MPAHBRAM_ECCERRADDR3_ADDR_DEFAULT                 (_MPAHBRAM_ECCERRADDR3_ADDR_DEFAULT << 0) /**< Shifted mode DEFAULT for MPAHBRAM_ECCERRADDR3*/

/* Bit fields for MPAHBRAM ECCMERRIND */
#define _MPAHBRAM_ECCMERRIND_RESETVALUE                   0x00000000UL                           /**< Default value for MPAHBRAM_ECCMERRIND       */
#define _MPAHBRAM_ECCMERRIND_MASK                         0x0000000FUL                           /**< Mask for MPAHBRAM_ECCMERRIND                */
#define MPAHBRAM_ECCMERRIND_P0                            (0x1UL << 0)                           /**< Multiple ECC errors on AHB port 0           */
#define _MPAHBRAM_ECCMERRIND_P0_SHIFT                     0                                      /**< Shift value for MPAHBRAM_P0                 */
#define _MPAHBRAM_ECCMERRIND_P0_MASK                      0x1UL                                  /**< Bit mask for MPAHBRAM_P0                    */
#define _MPAHBRAM_ECCMERRIND_P0_DEFAULT                   0x00000000UL                           /**< Mode DEFAULT for MPAHBRAM_ECCMERRIND        */
#define MPAHBRAM_ECCMERRIND_P0_DEFAULT                    (_MPAHBRAM_ECCMERRIND_P0_DEFAULT << 0) /**< Shifted mode DEFAULT for MPAHBRAM_ECCMERRIND*/
#define MPAHBRAM_ECCMERRIND_P1                            (0x1UL << 1)                           /**< Multiple ECC errors on AHB port 1           */
#define _MPAHBRAM_ECCMERRIND_P1_SHIFT                     1                                      /**< Shift value for MPAHBRAM_P1                 */
#define _MPAHBRAM_ECCMERRIND_P1_MASK                      0x2UL                                  /**< Bit mask for MPAHBRAM_P1                    */
#define _MPAHBRAM_ECCMERRIND_P1_DEFAULT                   0x00000000UL                           /**< Mode DEFAULT for MPAHBRAM_ECCMERRIND        */
#define MPAHBRAM_ECCMERRIND_P1_DEFAULT                    (_MPAHBRAM_ECCMERRIND_P1_DEFAULT << 1) /**< Shifted mode DEFAULT for MPAHBRAM_ECCMERRIND*/
#define MPAHBRAM_ECCMERRIND_P2                            (0x1UL << 2)                           /**< Multiple ECC errors on AHB port 2           */
#define _MPAHBRAM_ECCMERRIND_P2_SHIFT                     2                                      /**< Shift value for MPAHBRAM_P2                 */
#define _MPAHBRAM_ECCMERRIND_P2_MASK                      0x4UL                                  /**< Bit mask for MPAHBRAM_P2                    */
#define _MPAHBRAM_ECCMERRIND_P2_DEFAULT                   0x00000000UL                           /**< Mode DEFAULT for MPAHBRAM_ECCMERRIND        */
#define MPAHBRAM_ECCMERRIND_P2_DEFAULT                    (_MPAHBRAM_ECCMERRIND_P2_DEFAULT << 2) /**< Shifted mode DEFAULT for MPAHBRAM_ECCMERRIND*/
#define MPAHBRAM_ECCMERRIND_P3                            (0x1UL << 3)                           /**< Multiple ECC errors on AHB port 2           */
#define _MPAHBRAM_ECCMERRIND_P3_SHIFT                     3                                      /**< Shift value for MPAHBRAM_P3                 */
#define _MPAHBRAM_ECCMERRIND_P3_MASK                      0x8UL                                  /**< Bit mask for MPAHBRAM_P3                    */
#define _MPAHBRAM_ECCMERRIND_P3_DEFAULT                   0x00000000UL                           /**< Mode DEFAULT for MPAHBRAM_ECCMERRIND        */
#define MPAHBRAM_ECCMERRIND_P3_DEFAULT                    (_MPAHBRAM_ECCMERRIND_P3_DEFAULT << 3) /**< Shifted mode DEFAULT for MPAHBRAM_ECCMERRIND*/

/* Bit fields for MPAHBRAM IF */
#define _MPAHBRAM_IF_RESETVALUE                           0x00000000UL                          /**< Default value for MPAHBRAM_IF               */
#define _MPAHBRAM_IF_MASK                                 0x000000FFUL                          /**< Mask for MPAHBRAM_IF                        */
#define MPAHBRAM_IF_AHB0ERR1B                             (0x1UL << 0)                          /**< AHB0 1-bit ECC Error Interrupt Flag         */
#define _MPAHBRAM_IF_AHB0ERR1B_SHIFT                      0                                     /**< Shift value for MPAHBRAM_AHB0ERR1B          */
#define _MPAHBRAM_IF_AHB0ERR1B_MASK                       0x1UL                                 /**< Bit mask for MPAHBRAM_AHB0ERR1B             */
#define _MPAHBRAM_IF_AHB0ERR1B_DEFAULT                    0x00000000UL                          /**< Mode DEFAULT for MPAHBRAM_IF                */
#define MPAHBRAM_IF_AHB0ERR1B_DEFAULT                     (_MPAHBRAM_IF_AHB0ERR1B_DEFAULT << 0) /**< Shifted mode DEFAULT for MPAHBRAM_IF        */
#define MPAHBRAM_IF_AHB1ERR1B                             (0x1UL << 1)                          /**< AHB1 1-bit ECC Error Interrupt Flag         */
#define _MPAHBRAM_IF_AHB1ERR1B_SHIFT                      1                                     /**< Shift value for MPAHBRAM_AHB1ERR1B          */
#define _MPAHBRAM_IF_AHB1ERR1B_MASK                       0x2UL                                 /**< Bit mask for MPAHBRAM_AHB1ERR1B             */
#define _MPAHBRAM_IF_AHB1ERR1B_DEFAULT                    0x00000000UL                          /**< Mode DEFAULT for MPAHBRAM_IF                */
#define MPAHBRAM_IF_AHB1ERR1B_DEFAULT                     (_MPAHBRAM_IF_AHB1ERR1B_DEFAULT << 1) /**< Shifted mode DEFAULT for MPAHBRAM_IF        */
#define MPAHBRAM_IF_AHB2ERR1B                             (0x1UL << 2)                          /**< AHB2 1-bit ECC Error Interrupt Flag         */
#define _MPAHBRAM_IF_AHB2ERR1B_SHIFT                      2                                     /**< Shift value for MPAHBRAM_AHB2ERR1B          */
#define _MPAHBRAM_IF_AHB2ERR1B_MASK                       0x4UL                                 /**< Bit mask for MPAHBRAM_AHB2ERR1B             */
#define _MPAHBRAM_IF_AHB2ERR1B_DEFAULT                    0x00000000UL                          /**< Mode DEFAULT for MPAHBRAM_IF                */
#define MPAHBRAM_IF_AHB2ERR1B_DEFAULT                     (_MPAHBRAM_IF_AHB2ERR1B_DEFAULT << 2) /**< Shifted mode DEFAULT for MPAHBRAM_IF        */
#define MPAHBRAM_IF_AHB3ERR1B                             (0x1UL << 3)                          /**< AHB3 1-bit ECC Error Interrupt Flag         */
#define _MPAHBRAM_IF_AHB3ERR1B_SHIFT                      3                                     /**< Shift value for MPAHBRAM_AHB3ERR1B          */
#define _MPAHBRAM_IF_AHB3ERR1B_MASK                       0x8UL                                 /**< Bit mask for MPAHBRAM_AHB3ERR1B             */
#define _MPAHBRAM_IF_AHB3ERR1B_DEFAULT                    0x00000000UL                          /**< Mode DEFAULT for MPAHBRAM_IF                */
#define MPAHBRAM_IF_AHB3ERR1B_DEFAULT                     (_MPAHBRAM_IF_AHB3ERR1B_DEFAULT << 3) /**< Shifted mode DEFAULT for MPAHBRAM_IF        */
#define MPAHBRAM_IF_AHB0ERR2B                             (0x1UL << 4)                          /**< AHB0 2-bit ECC Error Interrupt Flag         */
#define _MPAHBRAM_IF_AHB0ERR2B_SHIFT                      4                                     /**< Shift value for MPAHBRAM_AHB0ERR2B          */
#define _MPAHBRAM_IF_AHB0ERR2B_MASK                       0x10UL                                /**< Bit mask for MPAHBRAM_AHB0ERR2B             */
#define _MPAHBRAM_IF_AHB0ERR2B_DEFAULT                    0x00000000UL                          /**< Mode DEFAULT for MPAHBRAM_IF                */
#define MPAHBRAM_IF_AHB0ERR2B_DEFAULT                     (_MPAHBRAM_IF_AHB0ERR2B_DEFAULT << 4) /**< Shifted mode DEFAULT for MPAHBRAM_IF        */
#define MPAHBRAM_IF_AHB1ERR2B                             (0x1UL << 5)                          /**< AHB1 2-bit ECC Error Interrupt Flag         */
#define _MPAHBRAM_IF_AHB1ERR2B_SHIFT                      5                                     /**< Shift value for MPAHBRAM_AHB1ERR2B          */
#define _MPAHBRAM_IF_AHB1ERR2B_MASK                       0x20UL                                /**< Bit mask for MPAHBRAM_AHB1ERR2B             */
#define _MPAHBRAM_IF_AHB1ERR2B_DEFAULT                    0x00000000UL                          /**< Mode DEFAULT for MPAHBRAM_IF                */
#define MPAHBRAM_IF_AHB1ERR2B_DEFAULT                     (_MPAHBRAM_IF_AHB1ERR2B_DEFAULT << 5) /**< Shifted mode DEFAULT for MPAHBRAM_IF        */
#define MPAHBRAM_IF_AHB2ERR2B                             (0x1UL << 6)                          /**< AHB2 2-bit ECC Error Interrupt Flag         */
#define _MPAHBRAM_IF_AHB2ERR2B_SHIFT                      6                                     /**< Shift value for MPAHBRAM_AHB2ERR2B          */
#define _MPAHBRAM_IF_AHB2ERR2B_MASK                       0x40UL                                /**< Bit mask for MPAHBRAM_AHB2ERR2B             */
#define _MPAHBRAM_IF_AHB2ERR2B_DEFAULT                    0x00000000UL                          /**< Mode DEFAULT for MPAHBRAM_IF                */
#define MPAHBRAM_IF_AHB2ERR2B_DEFAULT                     (_MPAHBRAM_IF_AHB2ERR2B_DEFAULT << 6) /**< Shifted mode DEFAULT for MPAHBRAM_IF        */
#define MPAHBRAM_IF_AHB3ERR2B                             (0x1UL << 7)                          /**< AHB3 2-bit ECC Error Interrupt Flag         */
#define _MPAHBRAM_IF_AHB3ERR2B_SHIFT                      7                                     /**< Shift value for MPAHBRAM_AHB3ERR2B          */
#define _MPAHBRAM_IF_AHB3ERR2B_MASK                       0x80UL                                /**< Bit mask for MPAHBRAM_AHB3ERR2B             */
#define _MPAHBRAM_IF_AHB3ERR2B_DEFAULT                    0x00000000UL                          /**< Mode DEFAULT for MPAHBRAM_IF                */
#define MPAHBRAM_IF_AHB3ERR2B_DEFAULT                     (_MPAHBRAM_IF_AHB3ERR2B_DEFAULT << 7) /**< Shifted mode DEFAULT for MPAHBRAM_IF        */

/* Bit fields for MPAHBRAM IEN */
#define _MPAHBRAM_IEN_RESETVALUE                          0x00000000UL                           /**< Default value for MPAHBRAM_IEN              */
#define _MPAHBRAM_IEN_MASK                                0x000000FFUL                           /**< Mask for MPAHBRAM_IEN                       */
#define MPAHBRAM_IEN_AHB0ERR1B                            (0x1UL << 0)                           /**< AHB0 1-bit ECC Error Interrupt Enable       */
#define _MPAHBRAM_IEN_AHB0ERR1B_SHIFT                     0                                      /**< Shift value for MPAHBRAM_AHB0ERR1B          */
#define _MPAHBRAM_IEN_AHB0ERR1B_MASK                      0x1UL                                  /**< Bit mask for MPAHBRAM_AHB0ERR1B             */
#define _MPAHBRAM_IEN_AHB0ERR1B_DEFAULT                   0x00000000UL                           /**< Mode DEFAULT for MPAHBRAM_IEN               */
#define MPAHBRAM_IEN_AHB0ERR1B_DEFAULT                    (_MPAHBRAM_IEN_AHB0ERR1B_DEFAULT << 0) /**< Shifted mode DEFAULT for MPAHBRAM_IEN       */
#define MPAHBRAM_IEN_AHB1ERR1B                            (0x1UL << 1)                           /**< AHB1 1-bit ECC Error Interrupt Enable       */
#define _MPAHBRAM_IEN_AHB1ERR1B_SHIFT                     1                                      /**< Shift value for MPAHBRAM_AHB1ERR1B          */
#define _MPAHBRAM_IEN_AHB1ERR1B_MASK                      0x2UL                                  /**< Bit mask for MPAHBRAM_AHB1ERR1B             */
#define _MPAHBRAM_IEN_AHB1ERR1B_DEFAULT                   0x00000000UL                           /**< Mode DEFAULT for MPAHBRAM_IEN               */
#define MPAHBRAM_IEN_AHB1ERR1B_DEFAULT                    (_MPAHBRAM_IEN_AHB1ERR1B_DEFAULT << 1) /**< Shifted mode DEFAULT for MPAHBRAM_IEN       */
#define MPAHBRAM_IEN_AHB2ERR1B                            (0x1UL << 2)                           /**< AHB2 1-bit ECC Error Interrupt Enable       */
#define _MPAHBRAM_IEN_AHB2ERR1B_SHIFT                     2                                      /**< Shift value for MPAHBRAM_AHB2ERR1B          */
#define _MPAHBRAM_IEN_AHB2ERR1B_MASK                      0x4UL                                  /**< Bit mask for MPAHBRAM_AHB2ERR1B             */
#define _MPAHBRAM_IEN_AHB2ERR1B_DEFAULT                   0x00000000UL                           /**< Mode DEFAULT for MPAHBRAM_IEN               */
#define MPAHBRAM_IEN_AHB2ERR1B_DEFAULT                    (_MPAHBRAM_IEN_AHB2ERR1B_DEFAULT << 2) /**< Shifted mode DEFAULT for MPAHBRAM_IEN       */
#define MPAHBRAM_IEN_AHB3ERR1B                            (0x1UL << 3)                           /**< AHB3 1-bit ECC Error Interrupt Enable       */
#define _MPAHBRAM_IEN_AHB3ERR1B_SHIFT                     3                                      /**< Shift value for MPAHBRAM_AHB3ERR1B          */
#define _MPAHBRAM_IEN_AHB3ERR1B_MASK                      0x8UL                                  /**< Bit mask for MPAHBRAM_AHB3ERR1B             */
#define _MPAHBRAM_IEN_AHB3ERR1B_DEFAULT                   0x00000000UL                           /**< Mode DEFAULT for MPAHBRAM_IEN               */
#define MPAHBRAM_IEN_AHB3ERR1B_DEFAULT                    (_MPAHBRAM_IEN_AHB3ERR1B_DEFAULT << 3) /**< Shifted mode DEFAULT for MPAHBRAM_IEN       */
#define MPAHBRAM_IEN_AHB0ERR2B                            (0x1UL << 4)                           /**< AHB0 2-bit ECC Error Interrupt Enable       */
#define _MPAHBRAM_IEN_AHB0ERR2B_SHIFT                     4                                      /**< Shift value for MPAHBRAM_AHB0ERR2B          */
#define _MPAHBRAM_IEN_AHB0ERR2B_MASK                      0x10UL                                 /**< Bit mask for MPAHBRAM_AHB0ERR2B             */
#define _MPAHBRAM_IEN_AHB0ERR2B_DEFAULT                   0x00000000UL                           /**< Mode DEFAULT for MPAHBRAM_IEN               */
#define MPAHBRAM_IEN_AHB0ERR2B_DEFAULT                    (_MPAHBRAM_IEN_AHB0ERR2B_DEFAULT << 4) /**< Shifted mode DEFAULT for MPAHBRAM_IEN       */
#define MPAHBRAM_IEN_AHB1ERR2B                            (0x1UL << 5)                           /**< AHB1 2-bit ECC Error Interrupt Enable       */
#define _MPAHBRAM_IEN_AHB1ERR2B_SHIFT                     5                                      /**< Shift value for MPAHBRAM_AHB1ERR2B          */
#define _MPAHBRAM_IEN_AHB1ERR2B_MASK                      0x20UL                                 /**< Bit mask for MPAHBRAM_AHB1ERR2B             */
#define _MPAHBRAM_IEN_AHB1ERR2B_DEFAULT                   0x00000000UL                           /**< Mode DEFAULT for MPAHBRAM_IEN               */
#define MPAHBRAM_IEN_AHB1ERR2B_DEFAULT                    (_MPAHBRAM_IEN_AHB1ERR2B_DEFAULT << 5) /**< Shifted mode DEFAULT for MPAHBRAM_IEN       */
#define MPAHBRAM_IEN_AHB2ERR2B                            (0x1UL << 6)                           /**< AHB2 2-bit ECC Error Interrupt Enable       */
#define _MPAHBRAM_IEN_AHB2ERR2B_SHIFT                     6                                      /**< Shift value for MPAHBRAM_AHB2ERR2B          */
#define _MPAHBRAM_IEN_AHB2ERR2B_MASK                      0x40UL                                 /**< Bit mask for MPAHBRAM_AHB2ERR2B             */
#define _MPAHBRAM_IEN_AHB2ERR2B_DEFAULT                   0x00000000UL                           /**< Mode DEFAULT for MPAHBRAM_IEN               */
#define MPAHBRAM_IEN_AHB2ERR2B_DEFAULT                    (_MPAHBRAM_IEN_AHB2ERR2B_DEFAULT << 6) /**< Shifted mode DEFAULT for MPAHBRAM_IEN       */
#define MPAHBRAM_IEN_AHB3ERR2B                            (0x1UL << 7)                           /**< AHB3 2-bit ECC Error Interrupt Enable       */
#define _MPAHBRAM_IEN_AHB3ERR2B_SHIFT                     7                                      /**< Shift value for MPAHBRAM_AHB3ERR2B          */
#define _MPAHBRAM_IEN_AHB3ERR2B_MASK                      0x80UL                                 /**< Bit mask for MPAHBRAM_AHB3ERR2B             */
#define _MPAHBRAM_IEN_AHB3ERR2B_DEFAULT                   0x00000000UL                           /**< Mode DEFAULT for MPAHBRAM_IEN               */
#define MPAHBRAM_IEN_AHB3ERR2B_DEFAULT                    (_MPAHBRAM_IEN_AHB3ERR2B_DEFAULT << 7) /**< Shifted mode DEFAULT for MPAHBRAM_IEN       */

/* Bit fields for MPAHBRAM RAMBANKSVALID */
#define _MPAHBRAM_RAMBANKSVALID_RESETVALUE                0xFFFFFFFFUL                                          /**< Default value for MPAHBRAM_RAMBANKSVALID    */
#define _MPAHBRAM_RAMBANKSVALID_MASK                      0x0000FFFFUL                                          /**< Mask for MPAHBRAM_RAMBANKSVALID             */
#define _MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_SHIFT       0                                                     /**< Shift value for MPAHBRAM_RAMBANKSVALID      */
#define _MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_MASK        0xFFFFUL                                              /**< Bit mask for MPAHBRAM_RAMBANKSVALID         */
#define _MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_DEFAULT     0xFFFFFFFFUL                                          /**< Mode DEFAULT for MPAHBRAM_RAMBANKSVALID     */
#define _MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0        0x00000001UL                                          /**< Mode BLK0 for MPAHBRAM_RAMBANKSVALID        */
#define _MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO1     0x00000003UL                                          /**< Mode BLK0TO1 for MPAHBRAM_RAMBANKSVALID     */
#define _MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO2     0x00000007UL                                          /**< Mode BLK0TO2 for MPAHBRAM_RAMBANKSVALID     */
#define _MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO3     0x0000000FUL                                          /**< Mode BLK0TO3 for MPAHBRAM_RAMBANKSVALID     */
#define _MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO4     0x0000001FUL                                          /**< Mode BLK0TO4 for MPAHBRAM_RAMBANKSVALID     */
#define _MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO5     0x0000003FUL                                          /**< Mode BLK0TO5 for MPAHBRAM_RAMBANKSVALID     */
#define _MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO6     0x0000007FUL                                          /**< Mode BLK0TO6 for MPAHBRAM_RAMBANKSVALID     */
#define _MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO7     0x000000FFUL                                          /**< Mode BLK0TO7 for MPAHBRAM_RAMBANKSVALID     */
#define _MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO8     0x000001FFUL                                          /**< Mode BLK0TO8 for MPAHBRAM_RAMBANKSVALID     */
#define _MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO9     0x000003FFUL                                          /**< Mode BLK0TO9 for MPAHBRAM_RAMBANKSVALID     */
#define _MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO10    0x000007FFUL                                          /**< Mode BLK0TO10 for MPAHBRAM_RAMBANKSVALID    */
#define _MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO11    0x00000FFFUL                                          /**< Mode BLK0TO11 for MPAHBRAM_RAMBANKSVALID    */
#define _MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO12    0x00001FFFUL                                          /**< Mode BLK0TO12 for MPAHBRAM_RAMBANKSVALID    */
#define _MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO13    0x00003FFFUL                                          /**< Mode BLK0TO13 for MPAHBRAM_RAMBANKSVALID    */
#define _MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO14    0x00007FFFUL                                          /**< Mode BLK0TO14 for MPAHBRAM_RAMBANKSVALID    */
#define _MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO15    0x0000FFFFUL                                          /**< Mode BLK0TO15 for MPAHBRAM_RAMBANKSVALID    */
#define MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_DEFAULT      (_MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_DEFAULT << 0)  /**< Shifted mode DEFAULT for MPAHBRAM_RAMBANKSVALID*/
#define MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0         (_MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0 << 0)     /**< Shifted mode BLK0 for MPAHBRAM_RAMBANKSVALID*/
#define MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO1      (_MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO1 << 0)  /**< Shifted mode BLK0TO1 for MPAHBRAM_RAMBANKSVALID*/
#define MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO2      (_MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO2 << 0)  /**< Shifted mode BLK0TO2 for MPAHBRAM_RAMBANKSVALID*/
#define MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO3      (_MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO3 << 0)  /**< Shifted mode BLK0TO3 for MPAHBRAM_RAMBANKSVALID*/
#define MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO4      (_MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO4 << 0)  /**< Shifted mode BLK0TO4 for MPAHBRAM_RAMBANKSVALID*/
#define MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO5      (_MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO5 << 0)  /**< Shifted mode BLK0TO5 for MPAHBRAM_RAMBANKSVALID*/
#define MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO6      (_MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO6 << 0)  /**< Shifted mode BLK0TO6 for MPAHBRAM_RAMBANKSVALID*/
#define MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO7      (_MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO7 << 0)  /**< Shifted mode BLK0TO7 for MPAHBRAM_RAMBANKSVALID*/
#define MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO8      (_MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO8 << 0)  /**< Shifted mode BLK0TO8 for MPAHBRAM_RAMBANKSVALID*/
#define MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO9      (_MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO9 << 0)  /**< Shifted mode BLK0TO9 for MPAHBRAM_RAMBANKSVALID*/
#define MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO10     (_MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO10 << 0) /**< Shifted mode BLK0TO10 for MPAHBRAM_RAMBANKSVALID*/
#define MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO11     (_MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO11 << 0) /**< Shifted mode BLK0TO11 for MPAHBRAM_RAMBANKSVALID*/
#define MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO12     (_MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO12 << 0) /**< Shifted mode BLK0TO12 for MPAHBRAM_RAMBANKSVALID*/
#define MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO13     (_MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO13 << 0) /**< Shifted mode BLK0TO13 for MPAHBRAM_RAMBANKSVALID*/
#define MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO14     (_MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO14 << 0) /**< Shifted mode BLK0TO14 for MPAHBRAM_RAMBANKSVALID*/
#define MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO15     (_MPAHBRAM_RAMBANKSVALID_RAMBANKSVALID_BLK0TO15 << 0) /**< Shifted mode BLK0TO15 for MPAHBRAM_RAMBANKSVALID*/

/* Bit fields for MPAHBRAM CFGSRTOP */
#define _MPAHBRAM_CFGSRTOP_RESETVALUE                     0x00000000UL                            /**< Default value for MPAHBRAM_CFGSRTOP         */
#define _MPAHBRAM_CFGSRTOP_MASK                           0x00000001UL                            /**< Mask for MPAHBRAM_CFGSRTOP                  */
#define MPAHBRAM_CFGSRTOP_SRTOP                           (0x1UL << 0)                            /**< Sequential region on top                    */
#define _MPAHBRAM_CFGSRTOP_SRTOP_SHIFT                    0                                       /**< Shift value for MPAHBRAM_SRTOP              */
#define _MPAHBRAM_CFGSRTOP_SRTOP_MASK                     0x1UL                                   /**< Bit mask for MPAHBRAM_SRTOP                 */
#define _MPAHBRAM_CFGSRTOP_SRTOP_DEFAULT                  0x00000000UL                            /**< Mode DEFAULT for MPAHBRAM_CFGSRTOP          */
#define MPAHBRAM_CFGSRTOP_SRTOP_DEFAULT                   (_MPAHBRAM_CFGSRTOP_SRTOP_DEFAULT << 0) /**< Shifted mode DEFAULT for MPAHBRAM_CFGSRTOP  */

/* Bit fields for MPAHBRAM CFGSRMAP */
#define _MPAHBRAM_CFGSRMAP_RESETVALUE                     0xFFFFFFFFUL                          /**< Default value for MPAHBRAM_CFGSRMAP         */
#define _MPAHBRAM_CFGSRMAP_MASK                           0x0000FFFFUL                          /**< Mask for MPAHBRAM_CFGSRMAP                  */
#define _MPAHBRAM_CFGSRMAP_MAP_SHIFT                      0                                     /**< Shift value for MPAHBRAM_MAP                */
#define _MPAHBRAM_CFGSRMAP_MAP_MASK                       0xFFFFUL                              /**< Bit mask for MPAHBRAM_MAP                   */
#define _MPAHBRAM_CFGSRMAP_MAP_DEFAULT                    0xFFFFFFFFUL                          /**< Mode DEFAULT for MPAHBRAM_CFGSRMAP          */
#define MPAHBRAM_CFGSRMAP_MAP_DEFAULT                     (_MPAHBRAM_CFGSRMAP_MAP_DEFAULT << 0) /**< Shifted mode DEFAULT for MPAHBRAM_CFGSRMAP  */

/* Bit fields for MPAHBRAM CFGIU0MAP */
#define _MPAHBRAM_CFGIU0MAP_RESETVALUE                    0x00000000UL                           /**< Default value for MPAHBRAM_CFGIU0MAP        */
#define _MPAHBRAM_CFGIU0MAP_MASK                          0x0000FFFFUL                           /**< Mask for MPAHBRAM_CFGIU0MAP                 */
#define _MPAHBRAM_CFGIU0MAP_MAP_SHIFT                     0                                      /**< Shift value for MPAHBRAM_MAP                */
#define _MPAHBRAM_CFGIU0MAP_MAP_MASK                      0xFFFFUL                               /**< Bit mask for MPAHBRAM_MAP                   */
#define _MPAHBRAM_CFGIU0MAP_MAP_DEFAULT                   0x00000000UL                           /**< Mode DEFAULT for MPAHBRAM_CFGIU0MAP         */
#define MPAHBRAM_CFGIU0MAP_MAP_DEFAULT                    (_MPAHBRAM_CFGIU0MAP_MAP_DEFAULT << 0) /**< Shifted mode DEFAULT for MPAHBRAM_CFGIU0MAP */

/* Bit fields for MPAHBRAM CFGIU1MAP */
#define _MPAHBRAM_CFGIU1MAP_RESETVALUE                    0x00000000UL                           /**< Default value for MPAHBRAM_CFGIU1MAP        */
#define _MPAHBRAM_CFGIU1MAP_MASK                          0x0000FFFFUL                           /**< Mask for MPAHBRAM_CFGIU1MAP                 */
#define _MPAHBRAM_CFGIU1MAP_MAP_SHIFT                     0                                      /**< Shift value for MPAHBRAM_MAP                */
#define _MPAHBRAM_CFGIU1MAP_MAP_MASK                      0xFFFFUL                               /**< Bit mask for MPAHBRAM_MAP                   */
#define _MPAHBRAM_CFGIU1MAP_MAP_DEFAULT                   0x00000000UL                           /**< Mode DEFAULT for MPAHBRAM_CFGIU1MAP         */
#define MPAHBRAM_CFGIU1MAP_MAP_DEFAULT                    (_MPAHBRAM_CFGIU1MAP_MAP_DEFAULT << 0) /**< Shifted mode DEFAULT for MPAHBRAM_CFGIU1MAP */

/* Bit fields for MPAHBRAM CFGIU2MAP */
#define _MPAHBRAM_CFGIU2MAP_RESETVALUE                    0x00000000UL                           /**< Default value for MPAHBRAM_CFGIU2MAP        */
#define _MPAHBRAM_CFGIU2MAP_MASK                          0x0000FFFFUL                           /**< Mask for MPAHBRAM_CFGIU2MAP                 */
#define _MPAHBRAM_CFGIU2MAP_MAP_SHIFT                     0                                      /**< Shift value for MPAHBRAM_MAP                */
#define _MPAHBRAM_CFGIU2MAP_MAP_MASK                      0xFFFFUL                               /**< Bit mask for MPAHBRAM_MAP                   */
#define _MPAHBRAM_CFGIU2MAP_MAP_DEFAULT                   0x00000000UL                           /**< Mode DEFAULT for MPAHBRAM_CFGIU2MAP         */
#define MPAHBRAM_CFGIU2MAP_MAP_DEFAULT                    (_MPAHBRAM_CFGIU2MAP_MAP_DEFAULT << 0) /**< Shifted mode DEFAULT for MPAHBRAM_CFGIU2MAP */

/* Bit fields for MPAHBRAM CFGIU3MAP */
#define _MPAHBRAM_CFGIU3MAP_RESETVALUE                    0x00000000UL                           /**< Default value for MPAHBRAM_CFGIU3MAP        */
#define _MPAHBRAM_CFGIU3MAP_MASK                          0x0000FFFFUL                           /**< Mask for MPAHBRAM_CFGIU3MAP                 */
#define _MPAHBRAM_CFGIU3MAP_MAP_SHIFT                     0                                      /**< Shift value for MPAHBRAM_MAP                */
#define _MPAHBRAM_CFGIU3MAP_MAP_MASK                      0xFFFFUL                               /**< Bit mask for MPAHBRAM_MAP                   */
#define _MPAHBRAM_CFGIU3MAP_MAP_DEFAULT                   0x00000000UL                           /**< Mode DEFAULT for MPAHBRAM_CFGIU3MAP         */
#define MPAHBRAM_CFGIU3MAP_MAP_DEFAULT                    (_MPAHBRAM_CFGIU3MAP_MAP_DEFAULT << 0) /**< Shifted mode DEFAULT for MPAHBRAM_CFGIU3MAP */

/* Bit fields for MPAHBRAM RPURATD0 */
#define _MPAHBRAM_RPURATD0_RESETVALUE                     0x00000000UL                                         /**< Default value for MPAHBRAM_RPURATD0         */
#define _MPAHBRAM_RPURATD0_MASK                           0x0001FF06UL                                         /**< Mask for MPAHBRAM_RPURATD0                  */
#define MPAHBRAM_RPURATD0_RATDCMD                         (0x1UL << 1)                                         /**< CMD Protection Bit                          */
#define _MPAHBRAM_RPURATD0_RATDCMD_SHIFT                  1                                                    /**< Shift value for MPAHBRAM_RATDCMD            */
#define _MPAHBRAM_RPURATD0_RATDCMD_MASK                   0x2UL                                                /**< Bit mask for MPAHBRAM_RATDCMD               */
#define _MPAHBRAM_RPURATD0_RATDCMD_DEFAULT                0x00000000UL                                         /**< Mode DEFAULT for MPAHBRAM_RPURATD0          */
#define MPAHBRAM_RPURATD0_RATDCMD_DEFAULT                 (_MPAHBRAM_RPURATD0_RATDCMD_DEFAULT << 1)            /**< Shifted mode DEFAULT for MPAHBRAM_RPURATD0  */
#define MPAHBRAM_RPURATD0_RATDCTRL                        (0x1UL << 2)                                         /**< CTRL Protection Bit                         */
#define _MPAHBRAM_RPURATD0_RATDCTRL_SHIFT                 2                                                    /**< Shift value for MPAHBRAM_RATDCTRL           */
#define _MPAHBRAM_RPURATD0_RATDCTRL_MASK                  0x4UL                                                /**< Bit mask for MPAHBRAM_RATDCTRL              */
#define _MPAHBRAM_RPURATD0_RATDCTRL_DEFAULT               0x00000000UL                                         /**< Mode DEFAULT for MPAHBRAM_RPURATD0          */
#define MPAHBRAM_RPURATD0_RATDCTRL_DEFAULT                (_MPAHBRAM_RPURATD0_RATDCTRL_DEFAULT << 2)           /**< Shifted mode DEFAULT for MPAHBRAM_RPURATD0  */
#define MPAHBRAM_RPURATD0_RATDIF                          (0x1UL << 8)                                         /**< IF Protection Bit                           */
#define _MPAHBRAM_RPURATD0_RATDIF_SHIFT                   8                                                    /**< Shift value for MPAHBRAM_RATDIF             */
#define _MPAHBRAM_RPURATD0_RATDIF_MASK                    0x100UL                                              /**< Bit mask for MPAHBRAM_RATDIF                */
#define _MPAHBRAM_RPURATD0_RATDIF_DEFAULT                 0x00000000UL                                         /**< Mode DEFAULT for MPAHBRAM_RPURATD0          */
#define MPAHBRAM_RPURATD0_RATDIF_DEFAULT                  (_MPAHBRAM_RPURATD0_RATDIF_DEFAULT << 8)             /**< Shifted mode DEFAULT for MPAHBRAM_RPURATD0  */
#define MPAHBRAM_RPURATD0_RATDIEN                         (0x1UL << 9)                                         /**< IEN Protection Bit                          */
#define _MPAHBRAM_RPURATD0_RATDIEN_SHIFT                  9                                                    /**< Shift value for MPAHBRAM_RATDIEN            */
#define _MPAHBRAM_RPURATD0_RATDIEN_MASK                   0x200UL                                              /**< Bit mask for MPAHBRAM_RATDIEN               */
#define _MPAHBRAM_RPURATD0_RATDIEN_DEFAULT                0x00000000UL                                         /**< Mode DEFAULT for MPAHBRAM_RPURATD0          */
#define MPAHBRAM_RPURATD0_RATDIEN_DEFAULT                 (_MPAHBRAM_RPURATD0_RATDIEN_DEFAULT << 9)            /**< Shifted mode DEFAULT for MPAHBRAM_RPURATD0  */
#define MPAHBRAM_RPURATD0_RATDRAMBANKSVALID               (0x1UL << 10)                                        /**< RAMBANKSVALID Protection Bit                */
#define _MPAHBRAM_RPURATD0_RATDRAMBANKSVALID_SHIFT        10                                                   /**< Shift value for MPAHBRAM_RATDRAMBANKSVALID  */
#define _MPAHBRAM_RPURATD0_RATDRAMBANKSVALID_MASK         0x400UL                                              /**< Bit mask for MPAHBRAM_RATDRAMBANKSVALID     */
#define _MPAHBRAM_RPURATD0_RATDRAMBANKSVALID_DEFAULT      0x00000000UL                                         /**< Mode DEFAULT for MPAHBRAM_RPURATD0          */
#define MPAHBRAM_RPURATD0_RATDRAMBANKSVALID_DEFAULT       (_MPAHBRAM_RPURATD0_RATDRAMBANKSVALID_DEFAULT << 10) /**< Shifted mode DEFAULT for MPAHBRAM_RPURATD0  */
#define MPAHBRAM_RPURATD0_RATDCFGSRTOP                    (0x1UL << 11)                                        /**< CFGSRTOP Protection Bit                     */
#define _MPAHBRAM_RPURATD0_RATDCFGSRTOP_SHIFT             11                                                   /**< Shift value for MPAHBRAM_RATDCFGSRTOP       */
#define _MPAHBRAM_RPURATD0_RATDCFGSRTOP_MASK              0x800UL                                              /**< Bit mask for MPAHBRAM_RATDCFGSRTOP          */
#define _MPAHBRAM_RPURATD0_RATDCFGSRTOP_DEFAULT           0x00000000UL                                         /**< Mode DEFAULT for MPAHBRAM_RPURATD0          */
#define MPAHBRAM_RPURATD0_RATDCFGSRTOP_DEFAULT            (_MPAHBRAM_RPURATD0_RATDCFGSRTOP_DEFAULT << 11)      /**< Shifted mode DEFAULT for MPAHBRAM_RPURATD0  */
#define MPAHBRAM_RPURATD0_RATDCFGSRMAP                    (0x1UL << 12)                                        /**< CFGSRMAP Protection Bit                     */
#define _MPAHBRAM_RPURATD0_RATDCFGSRMAP_SHIFT             12                                                   /**< Shift value for MPAHBRAM_RATDCFGSRMAP       */
#define _MPAHBRAM_RPURATD0_RATDCFGSRMAP_MASK              0x1000UL                                             /**< Bit mask for MPAHBRAM_RATDCFGSRMAP          */
#define _MPAHBRAM_RPURATD0_RATDCFGSRMAP_DEFAULT           0x00000000UL                                         /**< Mode DEFAULT for MPAHBRAM_RPURATD0          */
#define MPAHBRAM_RPURATD0_RATDCFGSRMAP_DEFAULT            (_MPAHBRAM_RPURATD0_RATDCFGSRMAP_DEFAULT << 12)      /**< Shifted mode DEFAULT for MPAHBRAM_RPURATD0  */
#define MPAHBRAM_RPURATD0_RATDCFGIU0MAP                   (0x1UL << 13)                                        /**< CFGIU0MAP Protection Bit                    */
#define _MPAHBRAM_RPURATD0_RATDCFGIU0MAP_SHIFT            13                                                   /**< Shift value for MPAHBRAM_RATDCFGIU0MAP      */
#define _MPAHBRAM_RPURATD0_RATDCFGIU0MAP_MASK             0x2000UL                                             /**< Bit mask for MPAHBRAM_RATDCFGIU0MAP         */
#define _MPAHBRAM_RPURATD0_RATDCFGIU0MAP_DEFAULT          0x00000000UL                                         /**< Mode DEFAULT for MPAHBRAM_RPURATD0          */
#define MPAHBRAM_RPURATD0_RATDCFGIU0MAP_DEFAULT           (_MPAHBRAM_RPURATD0_RATDCFGIU0MAP_DEFAULT << 13)     /**< Shifted mode DEFAULT for MPAHBRAM_RPURATD0  */
#define MPAHBRAM_RPURATD0_RATDCFGIU1MAP                   (0x1UL << 14)                                        /**< CFGIU1MAP Protection Bit                    */
#define _MPAHBRAM_RPURATD0_RATDCFGIU1MAP_SHIFT            14                                                   /**< Shift value for MPAHBRAM_RATDCFGIU1MAP      */
#define _MPAHBRAM_RPURATD0_RATDCFGIU1MAP_MASK             0x4000UL                                             /**< Bit mask for MPAHBRAM_RATDCFGIU1MAP         */
#define _MPAHBRAM_RPURATD0_RATDCFGIU1MAP_DEFAULT          0x00000000UL                                         /**< Mode DEFAULT for MPAHBRAM_RPURATD0          */
#define MPAHBRAM_RPURATD0_RATDCFGIU1MAP_DEFAULT           (_MPAHBRAM_RPURATD0_RATDCFGIU1MAP_DEFAULT << 14)     /**< Shifted mode DEFAULT for MPAHBRAM_RPURATD0  */
#define MPAHBRAM_RPURATD0_RATDCFGIU2MAP                   (0x1UL << 15)                                        /**< CFGIU2MAP Protection Bit                    */
#define _MPAHBRAM_RPURATD0_RATDCFGIU2MAP_SHIFT            15                                                   /**< Shift value for MPAHBRAM_RATDCFGIU2MAP      */
#define _MPAHBRAM_RPURATD0_RATDCFGIU2MAP_MASK             0x8000UL                                             /**< Bit mask for MPAHBRAM_RATDCFGIU2MAP         */
#define _MPAHBRAM_RPURATD0_RATDCFGIU2MAP_DEFAULT          0x00000000UL                                         /**< Mode DEFAULT for MPAHBRAM_RPURATD0          */
#define MPAHBRAM_RPURATD0_RATDCFGIU2MAP_DEFAULT           (_MPAHBRAM_RPURATD0_RATDCFGIU2MAP_DEFAULT << 15)     /**< Shifted mode DEFAULT for MPAHBRAM_RPURATD0  */
#define MPAHBRAM_RPURATD0_RATDCFGIU3MAP                   (0x1UL << 16)                                        /**< CFGIU3MAP Protection Bit                    */
#define _MPAHBRAM_RPURATD0_RATDCFGIU3MAP_SHIFT            16                                                   /**< Shift value for MPAHBRAM_RATDCFGIU3MAP      */
#define _MPAHBRAM_RPURATD0_RATDCFGIU3MAP_MASK             0x10000UL                                            /**< Bit mask for MPAHBRAM_RATDCFGIU3MAP         */
#define _MPAHBRAM_RPURATD0_RATDCFGIU3MAP_DEFAULT          0x00000000UL                                         /**< Mode DEFAULT for MPAHBRAM_RPURATD0          */
#define MPAHBRAM_RPURATD0_RATDCFGIU3MAP_DEFAULT           (_MPAHBRAM_RPURATD0_RATDCFGIU3MAP_DEFAULT << 16)     /**< Shifted mode DEFAULT for MPAHBRAM_RPURATD0  */

/** @} End of group EFR32MG24_MPAHBRAM_BitFields */
/** @} End of group EFR32MG24_MPAHBRAM */
/** @} End of group Parts */

#endif /* EFR32MG24_MPAHBRAM_H */
