/***************************************************************************//**
 * @file sl_status_string_config.h
 * @brief Status String Functions Configuration - Configuration Template File
 *******************************************************************************
 * # License
 * <b>Copyright 2019 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc.  Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement.  This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/

// <<< Use Configuration Wizard in Context Menu >>>

/*********************************************************************************************************
 *********************************************************************************************************
 *                                               MODULE
 ********************************************************************************************************
 *******************************************************************************************************/

#ifndef  SL_STATUS_STRING_CONFIG_H
#define  SL_STATUS_STRING_CONFIG_H

// <h> SL_STATUS string components Configuration

/********************************************************************************************************
 ********************************************************************************************************
 *                                             STRING COMPONENTS
 *********************************************************************************************************
 ********************************************************************************************************/
// <q STATUS_STRING_ENABLE_GENERIC> Enable generic string
// <i> Enable (1) or disable (0) generic string components.
// <i> Default: 1
#define  SL_STATUS_STRING_ENABLE_GENERIC                             1

// <q STATUS_STRING_ENABLE_BLUETOOTH> Enable Bluetooth string components
// <i> Enable (1) or disable (0) Bluetooth string components.
// <i> Default: 1
#define  SL_STATUS_STRING_ENABLE_BLUETOOTH                           1

// <q STATUS_STRING_ENABLE_WIFI> Enable WiFi string components
// <i> Enable (1) or disable (0) Wifi string components.
// <i> Default: 1
#define  SL_STATUS_STRING_ENABLE_WIFI                                1

// </h>

#endif // End of status_string_config module include.

// <<< end of configuration section >>>
