#ifndef SL_BT_POWER_CONTROL_CONFIG_H
#define SL_BT_POWER_CONTROL_CONFIG_H

// <<< Use Configuration Wizard in Context Menu >>>

// <h> Bluetooth LE Power Control Configuration

// <o SL_BT_GOLDEN_RSSI_MIN_1M> The lower bound of RSSI golden range on 1M PHY
// <i> Default: -60
// <i> Define the lower bound of RSSI golden range which the RSSI on 1M PHY of a
// <i> Bluetooth connection is preferred to remain in. Unit: dBm
#define SL_BT_GOLDEN_RSSI_MIN_1M     (-60)

// <o SL_BT_GOLDEN_RSSI_MAX_1M> The upper bound of RSSI golden range on 1M PHY
// <i> Default: -40
// <i> Define the upper bound of RSSI golden range which the RSSI on 1M PHY of a
// <i> Bluetooth connection is preferred to remain in. Unit: dBm
#define SL_BT_GOLDEN_RSSI_MAX_1M     (-40)

// <o SL_BT_GOLDEN_RSSI_MIN_2M> The lower bound of RSSI golden range on 2M PHY
// <i> Default: -60
// <i> Define the lower bound of RSSI golden range which the RSSI on 2M PHY of a
// <i> Bluetooth connection is preferred to remain in. Unit: dBm
#define SL_BT_GOLDEN_RSSI_MIN_2M     (-60)

// <o SL_BT_GOLDEN_RSSI_MAX_2M> The upper bound of RSSI golden range on 2M PHY
// <i> Default: -40
// <i> Define the upper bound of RSSI golden range which the RSSI on 2M PHY of a
// <i> Bluetooth connection is preferred to remain in. Unit: dBm
#define SL_BT_GOLDEN_RSSI_MAX_2M     (-40)

// <o SL_BT_GOLDEN_RSSI_MIN_CODED_S8> The lower bound of RSSI golden range on Coded PHY with coding scheme S=8
// <i> Default: -60
// <i> Define the lower bound of RSSI golden range which the RSSI on Coded PHY (S=8) of a
// <i> Bluetooth connection is preferred to remain in. Unit: dBm
#define SL_BT_GOLDEN_RSSI_MIN_CODED_S8     (-60)

// <o SL_BT_GOLDEN_RSSI_MAX_CODED_S8> The upper bound of RSSI golden range on Coded PHY with coding scheme S=8
// <i> Default: -40
// <i> Define the upper bound of RSSI golden range which the RSSI on Coded PHY (S=8) of a
// <i> Bluetooth connection is preferred to remain in. Unit: dBm
#define SL_BT_GOLDEN_RSSI_MAX_CODED_S8     (-40)

// <o SL_BT_GOLDEN_RSSI_MIN_CODED_S2> The lower bound of RSSI golden range on Coded PHY with coding scheme S=2
// <i> Default: -60
// <i> Define the lower bound of RSSI golden range which the RSSI on Coded PHY (S=2) of a
// <i> Bluetooth connection is preferred to remain in. Unit: dBm
#define SL_BT_GOLDEN_RSSI_MIN_CODED_S2     (-60)

// <o SL_BT_GOLDEN_RSSI_MAX_CODED_S2> The upper bound of RSSI golden range on Coded PHY with coding scheme S=2
// <i> Default: -40
// <i> Define the upper bound of RSSI golden range which the RSSI on Coded PHY (S=2) of a
// <i> Bluetooth connection is preferred to remain in. Unit: dBm
#define SL_BT_GOLDEN_RSSI_MAX_CODED_S2     (-40)

// </h> End Bluetooth LE Power Control Configuration

// <<< end of configuration section >>>

/**
 * @brief Initialize Bluetooth LE Power Control feature.
 *
 * This function is automatically called by code generated by the Universal
 * Configurator if the feature is included in the project. The application is
 * not expected to call this function directly.
 */
sl_status_t sl_bt_init_power_control();

#endif // SL_BT_POWER_CONTROL_CONFIG_H
