/***************************************************************************//**
 * @file
 * @brief
 *******************************************************************************
 * # License
 * <b>Copyright 2018 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc. Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement.
 * The software is governed by the sections of the MSLA applicable to Micrium
 * Software.
 *
 ******************************************************************************/

/*
 *********************************************************************************************************
 *
 *                                  KERNEL TRACE RECORDER CONFIGURATION
 *
 *                                      CONFIGURATION TEMPLATE FILE
 *
 * Filename      : os_cfg_trace.h
 * Programmer(s) : Micrium
 *********************************************************************************************************
 */

/*
 *********************************************************************************************************
 *********************************************************************************************************
 *                                               MODULE
 *********************************************************************************************************
 *********************************************************************************************************
 */

#ifndef SILABS_OS_CFG_TRACE_H
#define SILABS_OS_CFG_TRACE_H

/*
 *********************************************************************************************************
 *********************************************************************************************************
 *                                             INCLUDE FILES
 *********************************************************************************************************
 *********************************************************************************************************
 */

#include  <common/include/lib_def.h>

/*
 *********************************************************************************************************
 *********************************************************************************************************
 *                                       TRACE RECORDER RESOURCES
 *********************************************************************************************************
 *********************************************************************************************************
 */

#define  OS_CFG_TRACE_MAX_TASK                              32

#define  OS_CFG_TRACE_MAX_RESOURCES                         256
#ifndef OS_CFG_TRACE_API_ENTER_EN
#define  OS_CFG_TRACE_API_ENTER_EN                          DEF_DISABLED
#endif
#ifndef OS_CFG_TRACE_API_EXIT_EN
#define  OS_CFG_TRACE_API_EXIT_EN                           DEF_DISABLED
#endif
/*
 *********************************************************************************************************
 *********************************************************************************************************
 *                                             MODULE END
 *********************************************************************************************************
 *********************************************************************************************************
 */

#endif /* End of os_cfg_trace.h module include.                */
