/***************************************************************************/ /**
 * @brief Kernel Trace recorder config
 *******************************************************************************
 * # License
 * <b>Copyright 2018 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc.  Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement.  This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/

/*
*********************************************************************************************************
*
*                                  KERNEL TRACE RECORDER CONFIGURATION
*
*                                      CONFIGURATION TEMPLATE FILE
*
* File : os_cfg_trace.h
*********************************************************************************************************
*/

/*
*********************************************************************************************************
*********************************************************************************************************
*                                               MODULE
*********************************************************************************************************
*********************************************************************************************************
*/

#ifndef  OS_CFG_TRACE_H
#define  OS_CFG_TRACE_H


/*
*********************************************************************************************************
*********************************************************************************************************
*                                             INCLUDE FILES
*********************************************************************************************************
*********************************************************************************************************
*/

#include  <common/include/lib_def.h>
#include  <os_cfg.h>


/*
*********************************************************************************************************
*********************************************************************************************************
*                                       TRACE RECORDER RESOURCES
*********************************************************************************************************
*********************************************************************************************************
*/

#define  OS_CFG_TRACE_MAX_TASK                              OS_CFG_PRIO_MAX

#define  OS_CFG_TRACE_MAX_RESOURCES                         256

#define  OS_CFG_TRACE_API_ENTER_EN                          DEF_DISABLED

#define  OS_CFG_TRACE_API_EXIT_EN                           DEF_DISABLED


/*
*********************************************************************************************************
*********************************************************************************************************
*                                             MODULE END
*********************************************************************************************************
*********************************************************************************************************
*/

#endif

