# coding:utf-8
import os
import sys
import subprocess

# Parameter description:
# $1 - Application project path: apps\tuyaos_zigbee_light_sample
# $2 - Application project name: tuyaos_zigbee_light_sample
# $3 - Application project version: 1.0.0
# $4 - Application project command: build/clean
# python build_app.py apps\tuyaos_zigbee_light_sample tuyaos_zigbee_light_sample 1.0.0 clean

# Get the path to the current python interpreter
PYTHON_PATH = sys.executable

APP_PATH = sys.argv[1]
APP_NAME = sys.argv[2]
APP_VERSION = sys.argv[3]
BUILD_COMMAND = 'build'

print(len(sys.argv))
if len(sys.argv) == 5:
    BUILD_COMMAND = sys.argv[4]

# app project product name and path
CURR_PATH = os.getcwd()
SCRIPT_PATH = 'tools\scripts'
APP_BUILD_PATH = os.path.join(APP_PATH, '_build')

print(APP_PATH)
print(APP_NAME)
print(APP_VERSION)
print(BUILD_COMMAND)
print(SCRIPT_PATH)

# check 
if len(sys.argv) < 3 or APP_PATH=='' or APP_NAME=='' or APP_VERSION=='':
    print("Script parameter error !!!")


if BUILD_COMMAND == "build":
    os.chdir(SCRIPT_PATH)
    python_path = PYTHON_PATH + ' app_prepare.py'
    para = "%s \"%s\" \"%s\" \"%s\" \"%s\""%(python_path, APP_PATH, APP_NAME, APP_VERSION, BUILD_COMMAND)
    ret = subprocess.call(para)
    if ret != 0:
        print("app_prepare.py execution failed !!!")
        sys.exit(1)
    os.chdir(CURR_PATH)


os.chdir(APP_BUILD_PATH)
python_path = PYTHON_PATH + ' build.py'
para = "%s \"%s\" \"%s\" \"%s\" \"%s\""%(python_path, APP_PATH, APP_NAME, APP_VERSION, BUILD_COMMAND)
ret = subprocess.call(para)
if ret != 0:
    print("build.py execution failed !!!")
    sys.exit(1)
os.chdir(CURR_PATH)

