# coding:utf-8
from hashlib import new
import os
import sys
import subprocess
import xml.etree.ElementTree as ET
from winreg import ConnectRegistry, HKEY_LOCAL_MACHINE, OpenKey, QueryValueEx, KEY_READ

#'-make' or '-clean'
BUILD_OPT = sys.argv[1]
# 'router' of 'sleep_end_dev'
DEVICE_TYPE = sys.argv[2]
# efr32_sdk_6.10.3
VENDOR_NAME = sys.argv[3]
# efr32mg21a020f768im32 /efr32mg21a020f1024im32
CHIP_PLATFORM_ID = sys.argv[4]


# find IAR compilation tools
ICCARM_BIN = 'IarBuild.exe'
ICCARM_BIN_PATH = 'common\\bin'
ICCARM_TOOLCHA = ''

IAR_EWP_NAME = 'tal_zigbee_library.ewp'
TAL_BUILD_PATH = '..\\tal_project'
TAL_IAR_BUILD_EWP = os.path.join(TAL_BUILD_PATH, IAR_EWP_NAME)

# IAR install path check
def iar_compiler_install_check():
    global ICCARM_TOOLCHA
    root = ConnectRegistry(None, HKEY_LOCAL_MACHINE)
    try:
        root_key = OpenKey(HKEY_LOCAL_MACHINE, r'SOFTWARE\\WOW6432Node\\IAR Systems\\Embedded Workbench\\5.0', 0, KEY_READ)
        Pathname = QueryValueEx(root_key, "LastInstallPath")[0]
        ICCARM_TOOLCHA = os.path.join(Pathname, ICCARM_BIN_PATH, ICCARM_BIN)
        # print(ICCARM_TOOLCHA)
    except:
        print(' ')
        print('IAR compilation environment is not installed !!!')
        print(' ')
        sys.exit(1)

# IAR compile environment chip config
def iar_compilation_env_chip_config(ewp_tree, ewp_root, ewp_file):

    cfg_obs = ewp_root.findall('configuration')
    for sub_obs in cfg_obs:
        obs_name = sub_obs.find('name')
        # print(obs_name.text)
        if obs_name.text == DEVICE_TYPE:
            settings = sub_obs.findall('settings')
            for obs in settings:
                obs_name = obs.find('name')
                if obs_name.text == 'General':
                    option = obs.find('data').findall('option')
                    for item in option:
                        item_name = item.find('name')
                        if item_name.text == 'OGChipSelectEditMenu' or item_name.text == 'GFPUDeviceSlave':
                            content = item.find('state')
                            # print(content.text)
                            content.text = CHIP_PLATFORM_ID.upper() + '\tSiliconLaboratories ' + CHIP_PLATFORM_ID.upper()
                            ewp_tree.write(ewp_file)
                elif obs_name.text == 'ICCARM':
                    option = obs.find('data').findall('option')
                    for item in option:
                        item_name = item.find('name')
                        if item_name.text == 'CCDefines':
                            content = item.findall('state')
                            for state_obs in content:
                                if state_obs.text != None:
                                    target_str = state_obs.text.find('EFR32MG21A020F') # find "EFR32MG21A020F1024IM32" string
                                    if target_str != -1:
                                        # print(state_obs.text)
                                        state_obs.text = CHIP_PLATFORM_ID.upper()
                                        ewp_tree.write(ewp_file)
                elif obs_name.text == 'AARM':
                    option = obs.find('data').findall('option')
                    for item in option:
                        item_name = item.find('name')
                        if item_name.text == 'ADefines':
                            content = item.findall('state')
                            for state_obs in content:
                                if state_obs.text != None:
                                    target_str = state_obs.text.find('EFR32MG21A020F') # find "EFR32MG21A020F1024IM32" string
                                    if target_str != -1:
                                        # print(state_obs.text)
                                        state_obs.text = CHIP_PLATFORM_ID.upper()
                                        ewp_tree.write(ewp_file)
                elif obs_name.text == 'ILINK':
                    option = obs.find('data').findall('option')
                    for item in option:
                        item_name = item.find('name')
                        if item_name.text == 'IlinkConfigDefines':
                            content = item.findall('state')
                            for state_obs in content:
                                sub_string = state_obs.text.split('=')[0]
                                if sub_string == 'FLASH_SIZE':
                                    # print(sub_string)
                                    if CHIP_PLATFORM_ID.upper() == 'EFR32MG21A020F1024IM32':
                                        state_obs.text = 'FLASH_SIZE=1048576'
                                    elif CHIP_PLATFORM_ID.upper() == 'EFR32MG21A020F768IM32':
                                        state_obs.text = 'FLASH_SIZE=786432'
                                    ewp_tree.write(ewp_file)
                                elif sub_string == 'RAM_SIZE':
                                    # print(state_obs.text)
                                    if CHIP_PLATFORM_ID.upper() == 'EFR32MG21A020F1024IM32':
                                        state_obs.text = 'RAM_SIZE=98304'
                                    elif CHIP_PLATFORM_ID.upper() == 'EFR32MG21A020F768IM32':
                                        state_obs.text = 'RAM_SIZE=65536'
                                    ewp_tree.write(ewp_file)

# IAR compile environment target output rename
def iar_compilation_env_target_libs_rename(ewp_tree, ewp_root, ewp_file):
    cfg_obs = ewp_root.findall('configuration')
    for obs in cfg_obs:
        name = obs.find('name')
        if name.text == DEVICE_TYPE:
            # print(name.text)
            setting = obs.findall('settings')
            for obs in setting:
                obs_name = obs.find('name')
                if obs_name.text == 'IARCHIVE':
                    option = obs.find('data').findall('option')
                    for item in option:
                        item_name = item.find('name')
                        if item_name.text == 'IarchiveOutput':
                            target = item.find('state')
                            # print(target.text)
                            target_path = os.path.split(target.text)[0]
                            new_name = 'tal'+'_'+DEVICE_TYPE+'_'+CHIP_PLATFORM_ID.lower()+'.a'
                            target.text = os.path.join(target_path, new_name)
                            ewp_tree.write(ewp_file)

# IAR compile environment prepare
def iar_compilation_env_prepare():
    ewp_tree = ET.parse(TAL_IAR_BUILD_EWP)
    ewp_root = ewp_tree.getroot()
    iar_compilation_env_chip_config(ewp_tree, ewp_root, TAL_IAR_BUILD_EWP)
    iar_compilation_env_target_libs_rename(ewp_tree, ewp_root, TAL_IAR_BUILD_EWP)
    ewp_tree.write(TAL_IAR_BUILD_EWP, encoding="UTF-8", xml_declaration=True)


# call the IAR compiler to compile
def iar_build_start():
    p0 = ICCARM_TOOLCHA     # IarBuild.exe path
    p1 = TAL_IAR_BUILD_EWP  # Iar project ewp file path
    p2 = BUILD_OPT          # Iar build options
    p3 = DEVICE_TYPE        # Iar config options
    p4 = '-log'             # print log
    p5 = 'info'             # log type
    print('< ================='+DEVICE_TYPE+' '+CHIP_PLATFORM_ID+' tal build start=================== >')
    sys.stdout.flush()
    para = "%s \"%s\" \"%s\" \"%s\" \"%s\" \"%s\""%(p0, p1, p2, p3, p4, p5)
    # print(para)
    ret = subprocess.call(para)
    if ret == 0:
        os.chdir(TAL_BUILD_PATH)
        # print(os.getcwd())
        subprocess.call('python3 build_post.py'+' '+DEVICE_TYPE+' '+BUILD_OPT+' '+CHIP_PLATFORM_ID)
    else:
        print("tal build error!!!")
        sys.exit(1)
    print('< =================='+DEVICE_TYPE+' '+CHIP_PLATFORM_ID+' tal build end==================== >')


if __name__ == "__main__":
    iar_compiler_install_check()
    iar_compilation_env_prepare()
    iar_build_start()
    




