#!/usr/bin/env python
# coding=UTF-8
'''
@Author: Deven
@email: liming@tuya.com
@Date: 2020-01-21 10:31:37
LastEditors: Please set LastEditors
LastEditTime: 2021-03-09 11:21:06
@file name: 
@Description: 
@Copyright: HANGZHOU TUYA INFORMATION TECHNOLOGY CO.,LTD
@Company: http://www.tuya.com
'''

import sys
import os
import string

log_file = "a.log"
install_code_file = "inst_001.txt"
target_file = "install_code.txt"
target_str = "InstallCode:"



def read_install_code():
    
    print("******************read install code*********************")
    os.system("commander.exe tokendump --tokengroup znet --token MFG_INSTALLATION_CODE -d efr32 > "+target_file)
    
    with open(target_file, "r") as fp:
        try:
            for line in fp:
                line = line.replace(" ", "")
                if line.startswith(target_str):
                    line = line.rstrip("\r\n")
                    str_len = len(target_str)
                    
                    fp.close()
                    os.remove(target_file)
                    
                    return line[str_len:]
        except:
            fp.close()
            return 0


def write_install_code(code_str):

    print("******************write install code*********************")
    with open(install_code_file, "w+") as fp:
        try:
            fp.write("Install Code: "+code_str)
            fp.close()
        except:
            fp.close()
            return 0
    os.system("commander.exe  flash --tokengroup znet --tokenfile "+install_code_file+" -d efr32"+" > "+log_file)

    os.remove(log_file)
    os.remove(install_code_file)
    return 1


# python install_code.py  [read/write]  [install code file]
if __name__ == '__main__':

    if sys.argv[1] == "write" and len(sys.argv) != 3:
        
        print("usage: python install_code.py  [write]  [install code]")
        exit(-1)
    elif sys.argv[1] == "read" and len(sys.argv) != 2:
        print("usage: python install_code.py  [read]")
        exit(-1)


    if sys.argv[1] == "read":

        data = read_install_code()
        print(data)
    elif sys.argv[1] == "write":
        
        data = write_install_code(sys.argv[2])
        print(data)

