# coding:utf-8
import os
import sys
import json
import shutil
import xml.etree.ElementTree as ET

#*****************************************************************#
# NOTE: This script is a compiled script. Please do not modify it #
#*****************************************************************#

# Parameter description：
# $1 - Application project path: apps\tuyaos_zigbee_light_sample
# $2 - Application project name: tuyaos_zigbee_light_sample
# $3 - Application project version: 1.0.0
# $4 - Application project command： build/clean
# app_prepare.py apps\tuyaos_zigbee_light_sample tuyaos_zigbee_light_sample 1.0.0 clean


APP_PATH = sys.argv[1]
APP_NAME = sys.argv[2]
APP_VERSION = sys.argv[3]
BUILD_COMMAND = sys.argv[4]

DEVICE_ROLE =''
CHIP_PLATFORM_ID =''
SCRIPTS_TUYAOS_SDK_PATH = '..\..'

APP_PATH_DIR = os.path.join(SCRIPTS_TUYAOS_SDK_PATH, APP_PATH)
APP_BUILD_PATH = os.path.join(APP_PATH_DIR, '_build')
PROJ_TEMP_PATH = os.path.join(SCRIPTS_TUYAOS_SDK_PATH, 'tools', 'templates')


PROJ_TUYAOS_SDK_PATH = '..\..\..'
APP_RELATIVE_PROJ_PATH = '..'
IAR_PATH_PREFIX = '$PROJ_DIR$'
LIBS_RELATIVE_PROJ_PATH = os.path.join(PROJ_TUYAOS_SDK_PATH, 'libs')
INCLUDE_RELATIVE_PROJ_PATH = os.path.join(PROJ_TUYAOS_SDK_PATH, 'include')
ICF_RELATIVE_PROJ_PATH = os.path.join(PROJ_TUYAOS_SDK_PATH, 'tools\ld\icf')
COMP_RELATIVE_PROJ_PATH = os.path.join(PROJ_TUYAOS_SDK_PATH, 'components')
APP_CONFIG_SRC = os.path.join(IAR_PATH_PREFIX, APP_RELATIVE_PROJ_PATH, 'src', 'app_config.c')


# only in .ewp
INC_PATH = []
ICF_FILE = []
# in .ewp .ewt
COMP_SRC_FILES = []
APP_SRC_FILES = [APP_CONFIG_SRC]
# in .ewp .ewt
LIB_FILES =[]

make_ewt_file = APP_NAME + '.ewt'
make_ewp_file = APP_NAME + '.ewp'
make_eww_file = APP_NAME + '.eww'

def pretty_xml(element, indent, newline, level=0):
    if len(element): #check have subElement
        if (element.text is None) or element.text.isspace():
            element.text = newline + indent * (level + 1)
        else:
            element.text = newline + indent * (level + 1) + element.text.strip() + newline + indent * (level + 1)
    temp = list(element)
    for subelement in temp:
        if temp.index(subelement) < (len(temp) - 1):
            subelement.tail = newline + indent * (level + 1)
        else:    
            subelement.tail = newline + indent * level
        pretty_xml(subelement, indent, newline, level=level + 1)


def appconfig_json_parser():
    global DEVICE_ROLE
    global CHIP_PLATFORM_ID
    print('Json config parser...')
    config_js = os.path.join(APP_PATH_DIR, 'appconfig.json')
    with open(config_js, 'r') as js_file:
        json_str = json.load(js_file)
        role_str = json_str['firmwareInfo']['dev_role']
        DEVICE_ROLE = role_str.lower()
        role_str = json_str['firmwareInfo']['chip_id']
        CHIP_PLATFORM_ID = role_str.upper()
        js_file.close()


def app_project_env_prepare():
    
    print('Copy IAR templates...')
    # print(APP_BUILD_PATH)
    if os.path.exists(APP_BUILD_PATH):
        shutil.rmtree(APP_BUILD_PATH, ignore_errors=True)

    os.mkdir(APP_BUILD_PATH)
    # copy templates to app dirs
    files = os.listdir(PROJ_TEMP_PATH)
    for f in files:
        # print(f)
        old_file = os.path.join(PROJ_TEMP_PATH, f)
        suffix = os.path.splitext(old_file)[1]
        if suffix == '.json':
            new_file = os.path.join(APP_PATH_DIR, f)
            if os.path.exists(new_file):
                print(f+' already exists.')
            else:
                shutil.copyfile(old_file, new_file)    
        else:
            new_file = os.path.join(APP_BUILD_PATH, f)
            shutil.copyfile(old_file, new_file)
        
        # rename file name
        suffix = os.path.splitext(new_file)[1]
        if suffix != '.py' and suffix != '.json':
            old_name = new_file
            new_name = os.path.join(APP_BUILD_PATH, APP_NAME+suffix)
            # print(old_name)
            # print(new_name)
            os.rename(old_name, new_name)
    appconfig_json_parser()


def write_src_file(option, list):
    for c_file in list:
        new_file = ET.Element('file')
        new_name = ET.SubElement(new_file,'name')
        new_name.text = c_file
        option.append(new_file)

def write_head_file(option):
    for inc_file in INC_PATH:
        new_inc = ET.Element('state')
        new_inc.text = inc_file
        option.append(new_inc)


def write_libs_file(option):
    for lib_file in LIB_FILES:
        new_file = ET.Element('file')
        new_name = ET.SubElement(new_file,'name')
        new_name.text = lib_file
        option.append(new_file)


# IAR compile environment prepare
def compile_chip_id_set(xml_root, xml_tree, xml_file, chip_id):
    cfg_obs = xml_root.findall('configuration')
    for sub_obs in cfg_obs:
        obs_name = sub_obs.find('name')
        # print(obs_name.text)
        settings = sub_obs.findall('settings')
        for obs in settings:
            obs_name = obs.find('name')
            if obs_name.text == 'General':
                option = obs.find('data').findall('option')
                for item in option:
                    item_name = item.find('name')
                    if item_name.text == 'OGChipSelectEditMenu' or item_name.text == 'GFPUDeviceSlave':
                        content = item.find('state')
                        # print(content.text)
                        content.text = chip_id + '\tSiliconLaboratories ' + chip_id
                        xml_tree.write(xml_file)
            elif obs_name.text == 'ICCARM':
                option = obs.find('data').findall('option')
                for item in option:
                    item_name = item.find('name')
                    if item_name.text == 'CCDefines':
                        content = item.findall('state')
                        for state_obs in content:
                            if state_obs.text != None:
                                target_str = state_obs.text.find('EFR32MG21A020F') # find "EFR32MG21A020F1024IM32" string
                                if target_str != -1:
                                    # print(state_obs.text)
                                    state_obs.text = chip_id
                                    xml_tree.write(xml_file)
            elif obs_name.text == 'AARM':
                option = obs.find('data').findall('option')
                for item in option:
                    item_name = item.find('name')
                    if item_name.text == 'ADefines':
                        content = item.findall('state')
                        for state_obs in content:
                            if state_obs.text != None:
                                target_str = state_obs.text.find('EFR32MG21A020F') # find "EFR32MG21A020F1024IM32" string
                                if target_str != -1:
                                    # print(state_obs.text)
                                    state_obs.text = chip_id
                                    xml_tree.write(xml_file)
            elif obs_name.text == 'ILINK':
                option = obs.find('data').findall('option')
                for item in option:
                    item_name = item.find('name')
                    if item_name.text == 'IlinkConfigDefines':
                        content = item.findall('state')
                        for state_obs in content:
                            sub_string = state_obs.text.split('=')[0]
                            if sub_string == 'FLASH_SIZE':
                                # print(sub_string)
                                if chip_id == 'EFR32MG21A020F1024IM32':
                                    state_obs.text = 'FLASH_SIZE=1048576'
                                elif chip_id == 'EFR32MG21A020F768IM32':
                                    state_obs.text = 'FLASH_SIZE=786432'
                                xml_tree.write(xml_file)
                            elif sub_string == 'RAM_SIZE':
                                # print(state_obs.text)
                                if chip_id == 'EFR32MG21A020F1024IM32':
                                    state_obs.text = 'RAM_SIZE=98304'
                                elif chip_id == 'EFR32MG21A020F768IM32':
                                    state_obs.text = 'RAM_SIZE=65536'
                                xml_tree.write(xml_file)


def compile_insert_src_file(xml_root, xml_tree, xml_file):
    setting = xml_root.findall('group')
    for obs in setting:
        name = obs.find('name')
        # print(name)
        if name.text == 'app':
            # print("find sucessfully")
            write_src_file(obs, APP_SRC_FILES)
            xml_tree.write(xml_file)
        if name.text == 'plugins':
            # print("find sucessfully")
            write_src_file(obs, COMP_SRC_FILES)
            xml_tree.write(xml_file)


def compile_insert_lib_file(xml_root, xml_tree, xml_file):
    setting = xml_root.findall('group')
    for obs in setting:
        name = obs.find('name')
        # print(name)
        if name.text == 'vendor':
            # print("find sucessfully")
            write_libs_file(obs)
            xml_tree.write(xml_file)

def compile_insert_head_file(xml_root, xml_tree, xml_file):
    setting = xml_root.find('configuration').findall('settings')
    for obs in setting:
        obs_name = obs.find('name')
        if obs_name.text == 'ICCARM':
            option = obs.find('data').findall('option')
            for item in option:
                item_name = item.find('name')
                if item_name.text == 'CCIncludePath2':
                    # print("find sucessfully")
                    write_head_file(item)
                    xml_tree.write(xml_file)

def compile_modify_ilink_element(xml_root, xml_tree, xml_file):
    setting = xml_root.find('configuration').findall('settings')
    for obs in setting:
        obs_name = obs.find('name')
        if obs_name.text == 'ILINK':
            option = obs.find('data').findall('option')
            for item in option:
                item_name = item.find('name')
                if item_name.text == 'IlinkIcfFile':
                    name = item.find('state')
                    # print(name.text)
                    name.text = ICF_FILE[0]
                    xml_tree.write(xml_file)
                if item_name.text == 'IlinkOutputFile':
                    name = item.find('state')
                    # print(name.text)
                    name.text = APP_NAME + '.out'
                    xml_tree.write(xml_file)
                if item_name.text == 'IlinkTrustzoneImportLibraryOut':
                    name = item.find('state')
                    # print(name.text)
                    name.text = APP_NAME + 'lib.o'
                    xml_tree.write(xml_file)

def compile_modify_objcopy_element(xml_root, xml_tree, xml_file):
    setting = xml_root.find('configuration').findall('settings')
    for obs in setting:
        obs_name = obs.find('name')
        if obs_name.text == 'OBJCOPY':
            option = obs.find('data').findall('option')
            for item in option:
                item_name = item.find('name')
                if item_name.text == 'OOCOutputFile':
                    name = item.find('state')
                    # print(name.text)
                    name.text = APP_NAME + '.s37'
                    xml_tree.write(xml_file)

def get_files(dir, suffix, f_list):
    for root, dirs, files in os.walk(dir):
        for name in files:
            suf = os.path.splitext(name)[1]
            if suf == suffix:
                # print(name)
                # print(os.path.join(root, name))
                file_path = os.path.join(IAR_PATH_PREFIX, root, name)
                # print(file_path)
                f_list.append(file_path)

def lib_file_filter(name):
    txt = os.path.splitext(name)[0]
    # print(name)
    if DEVICE_ROLE == 'router':
        if name == 'zigbee-pro-leaf-stack.a' or txt.find('sleep_end_dev') != -1:
            return 0
        if CHIP_PLATFORM_ID == 'EFR32MG21A020F1024IM32':
            if txt.find('efr32mg21a020f768im32') != -1:
                return 0
        elif CHIP_PLATFORM_ID == 'EFR32MG21A020F768IM32':
            if txt.find('efr32mg21a020f1024im32') != -1:
                return 0
    elif DEVICE_ROLE == 'sleep_end_dev':
        if name == 'zigbee-pro-stack.a' or txt.find('router') != -1:
            return 0
        if CHIP_PLATFORM_ID == 'EFR32MG21A020F1024IM32':
            if txt.find('efr32mg21a020f768im32') != -1:
                return 0
        elif CHIP_PLATFORM_ID == 'EFR32MG21A020F768IM32':
            if txt.find('efr32mg21a020f1024im32') != -1:
                return 0
    return 1

def get_libs_files(dir, suffix, f_list):

    for root, dirs, files in os.walk(dir):
        for name in files:
            suf = os.path.splitext(name)[1]
            if suf == suffix:
                status = lib_file_filter(name)
                if status == 0:
                    continue
                # print(os.path.join(root, name))
                file_path = os.path.join(IAR_PATH_PREFIX, root, name)
                # print(file_path)
                f_list.append(file_path)


def get_include_path(dir, suffix, f_list):
    for root, dirs, files in os.walk(dir):
        for name in files:
            suf = os.path.splitext(name)[1]
            if suf == suffix:
                # print(root)
                # print(os.path.join(root, name))
                inc_path = os.path.join(IAR_PATH_PREFIX, root)
                # print(inc_path)
                f_list.append(inc_path)
                break

def iar_compile_info_collect():
    print('Compile dependents get...')
    get_files(APP_RELATIVE_PROJ_PATH, '.c', APP_SRC_FILES)
    get_files(COMP_RELATIVE_PROJ_PATH, '.c', COMP_SRC_FILES)
    get_files(ICF_RELATIVE_PROJ_PATH, '.icf', ICF_FILE)
    get_libs_files(LIBS_RELATIVE_PROJ_PATH, '.a', LIB_FILES)
    get_include_path(APP_RELATIVE_PROJ_PATH, '.h', INC_PATH)
    get_include_path(INCLUDE_RELATIVE_PROJ_PATH, '.h', INC_PATH)
    get_include_path(COMP_RELATIVE_PROJ_PATH, '.h', INC_PATH)


def ewt_xml_itme_insert():
    print('IAR ewt file generate...')
    ewt_tree = ET.parse(make_ewt_file)
    ewt_root = ewt_tree.getroot()

    compile_insert_src_file(ewt_root, ewt_tree, make_ewt_file)
    compile_insert_lib_file(ewt_root, ewt_tree, make_ewt_file)
    pretty_xml(ewt_root, '    ', '\n')
    ewt_tree.write(make_ewt_file, encoding="utf-8", xml_declaration=True)

def ewp_xml_itme_insert():
    print('IAR ewp file generate...')
    ewp_tree = ET.parse(make_ewp_file)
    ewp_root = ewp_tree.getroot()
    compile_insert_src_file(ewp_root, ewp_tree, make_ewp_file)
    compile_insert_lib_file(ewp_root, ewp_tree, make_ewp_file)
    compile_insert_head_file(ewp_root, ewp_tree, make_ewp_file)
    compile_modify_ilink_element(ewp_root, ewp_tree, make_ewp_file)
    compile_modify_objcopy_element(ewp_root, ewp_tree, make_ewp_file)
    compile_chip_id_set(ewp_root, ewp_tree, make_ewp_file, CHIP_PLATFORM_ID)
    pretty_xml(ewp_root, '    ', '\n')
    ewp_tree.write(make_ewp_file, encoding="utf-8", xml_declaration=True)

def eww_xml_itme_insert():
    print('IAR ewp file generate...')
    eww_tree = ET.parse(make_eww_file)
    eww_root = eww_tree.getroot()

    setting = eww_root.findall('project')
    for obs in setting:
        name = obs.find('path')
        # print(name.text)
        if name.text == '$WS_DIR$\\tuya_kernel_sample.ewp':
            # print("find sucessfully")
            name.text = os.path.join('$WS_DIR$', APP_NAME+'.ewp')
            eww_tree.write(make_eww_file, encoding="utf-8", xml_declaration=True)

if __name__ == "__main__":
    
    print('< START BUILDING THE COMPILATION ENVIRONMENT >')
    app_project_env_prepare()

    if CHIP_PLATFORM_ID == "" or CHIP_PLATFORM_ID != "EFR32MG21A020F1024IM32":
        print("Fatal:device platform not supported!!!")
        sys.exit(1)
    if DEVICE_ROLE == "" or DEVICE_ROLE != "router":
        print("Fatal:device role not supported!!!")
        sys.exit(1)

    # change dirct
    os.chdir(APP_BUILD_PATH)
    # print(os.getcwd())
    iar_compile_info_collect()
    ewt_xml_itme_insert()
    ewp_xml_itme_insert()
    eww_xml_itme_insert()

