# coding:utf-8
import os
import sys
import shutil

# 'router' of 'sleep_end_dev'
DEVICE_TYPE = sys.argv[1]
#'-make' or '-clean'
BUILD_OPT = sys.argv[2]
# chip id efr32mg21a020f768im32 /efr32mg21a020f1024im32
CHIP_PLATFORM_ID = sys.argv[3].lower()

TAL_LIB_OUTPUT_DIR = '..\..\..\..\libs'
TAL_LIB_SRC_DIR = os.path.join(DEVICE_TYPE, 'exe')


TAL_LIB_TARGET = 'tal'+'_'+DEVICE_TYPE+'_'+CHIP_PLATFORM_ID+'.a'


def tal_lib_copy_to_target_dir():

    if os.path.exists(TAL_LIB_OUTPUT_DIR):
        new_file = os.path.join(TAL_LIB_OUTPUT_DIR, TAL_LIB_TARGET)
        old_file = os.path.join(TAL_LIB_SRC_DIR, TAL_LIB_TARGET)
        # print(new_file)
        # print(old_file)
        shutil.copyfile(old_file, new_file)


def tal_clean_build_dir():
    build_path = DEVICE_TYPE
    build_dep = 'tal_zigbee_library.dep'
    if os.path.exists(build_path):
        os.remove(build_dep)
        shutil.rmtree(build_path, ignore_errors=True)


if __name__ == "__main__":

    print('< TAL BUILD-POST START >')
    if BUILD_OPT == '-make':
        tal_lib_copy_to_target_dir()
    elif BUILD_OPT == '-clean':
        tal_clean_build_dir()