# coding:utf-8
import os
import sys
import shutil
import subprocess
from winreg import ConnectRegistry, HKEY_LOCAL_MACHINE, OpenKey, QueryValueEx, KEY_READ


#*****************************************************************#
# NOTE: This script is a compiled script. Please do not modify it #
#*****************************************************************#

# Parameter description:
# $1 - Application project path: apps\tuyaos_zigbee_light_sample
# $2 - Application project name: tuyaos_zigbee_light_sample
# $3 - Application project version: 1.0.0
# $4 - Application project command: build/clean
# build.py apps\tuyaos_zigbee_light_sample tuyaos_zigbee_light_sample 1.0.0 clean


#app name
APP_PATH = sys.argv[1]
#app name
APP_NAME = sys.argv[2]
#app version
APP_VERS = sys.argv[3]
#iar compile parameter
if sys.argv[4] == 'clean':
    IAR_MAKE_OPT = '-clean'
elif sys.argv[4] == 'bulid':
    IAR_MAKE_OPT = '-make'
else:
    IAR_MAKE_OPT = '-make'


# IAR compilation dependent file
TAL_IAR_BUILD_EWP = APP_NAME+'.ewp'
TAL_IAR_BUILD_DEP = APP_NAME+'.dep'

# find IAR compilation tools
ICCARM_BIN = 'IarBuild.exe'
ICCARM_BIN_PATH = 'common\\bin'
ICCARM_TOOLCHA = ''

# app project product name and path
CURR_PATH = os.getcwd()
BIN_NAME = APP_NAME+'.s37'
BUILD_PATH = os.path.join(CURR_PATH, 'build')
OUTPUT_PATH = os.path.join('..\\', 'output')

# Get the path to the current Python interpreter
PYTHON_PATH = sys.executable

# IAR install path check
root = ConnectRegistry(None, HKEY_LOCAL_MACHINE)
try:
    root_key = OpenKey(HKEY_LOCAL_MACHINE, r'SOFTWARE\\WOW6432Node\\IAR Systems\\Embedded Workbench\\5.0', 0, KEY_READ)
    Pathname = QueryValueEx(root_key, "LastInstallPath")[0]
    ICCARM_TOOLCHA = os.path.join(Pathname, ICCARM_BIN_PATH, ICCARM_BIN)
    # print(ICCARM_TOOLCHA)
except:
    print(' ')
    print('IAR compilation environment is not installed !!!')
    print(' ')
    sys.exit(1)


p0 = ICCARM_TOOLCHA
p1 = TAL_IAR_BUILD_EWP
p2 = IAR_MAKE_OPT
p3 = 'Normal'
p4 = '-log'
p5 = 'all'

print('< ====================app build start====================== >')
sys.stdout.flush()

if IAR_MAKE_OPT == '-make':
    python_path = PYTHON_PATH + ' prebuild.py'
    para = "%s \"%s\" \"%s\""%(python_path, APP_NAME, APP_VERS)
    ret = subprocess.call(para)
    if ret != 0:
        print("prebuild execution failed !!!")
        sys.exit(1)

para = "%s \"%s\" \"%s\" \"%s\" \"%s\" \"%s\""%(p0, p1, p2, p3, p4, p5)
# print(para)
ret = subprocess.call(para)
if ret == 0:
    if IAR_MAKE_OPT == '-clean':
        if os.path.exists(OUTPUT_PATH):
            shutil.rmtree(OUTPUT_PATH, ignore_errors=True)
        if os.path.exists(BUILD_PATH):
            os.remove(TAL_IAR_BUILD_DEP)
            shutil.rmtree(BUILD_PATH, ignore_errors=True)
    else:
        if os.path.exists(OUTPUT_PATH):
            shutil.rmtree(OUTPUT_PATH, ignore_errors=True)
        os.mkdir(OUTPUT_PATH)

        # combine bootloader with app .s37
        python_path = PYTHON_PATH + ' postbuild.py'
        para = "%s \"%s\" \"%s\""%(python_path, APP_NAME, APP_VERS)
        status = subprocess.call(para)
        if status != 0:
            print("File format conversion error!!!")
            sys.exit(1)            
else:
    print("app build error!!!")
    sys.exit(1)

print('< +====================app build end======================= >')


