'''
Author: Deven
Email: liming@tuya.com
LastEditors: Please set LastEditors
FileName: &file name&
Description: 
Copyright: HANGZHOU TUYA INFORMATION TECHNOLOGY CO.,LTD
Company: http://www.tuya.com
Date: 2021-10-22 14:53:35
LastEditTime: 2021-12-26 17:28:08
'''
# coding:utf-8
import os
import sys
import json
import struct
import collections
import subprocess
from binascii import crc32

#*****************************************************************#
# NOTE: This script is a compiled script. Please do not modify it #
#*****************************************************************#
# Post Build processing.


CHIP_ID = ''
IMAGE_TYPE = ''
MANUFACTURE_ID = ''

APP_PROJ_PATH = '..'
JSON_CONFIG_NAME = 'appconfig.json'
JSON_CONFIG_PATH = os.path.join(APP_PROJ_PATH, JSON_CONFIG_NAME)

COMMANDER_NAME = 'commander.exe'
IMAGE_BUILD = 'image-builder-windows.exe'

APP_PATH = 'build\exe'
OUTPUT_PATH = os.path.join('..\\', 'output')

TOOLS_PATH = '..\..\..\\tools'
BOOTLOADER_PATH = os.path.join(TOOLS_PATH, 'bootloader')
COMMANDER_PATH = os.path.join(TOOLS_PATH, 'commander', COMMANDER_NAME)
IMAGE_BUILD_PATH = os.path.join(TOOLS_PATH, 'commander\image-builder', IMAGE_BUILD)

APP_NAME = sys.argv[1]
APP_VERSION = sys.argv[2]

# version info convert
def version_string_to_hex(version):
    str = version.replace('.', '')
    strlen = len(str)
    version_hex = ((int(str[0:1]) << 6) & 0xc0) + ((int(str[1:2]) << 4) & 0x30)
    if (strlen > 3):
        version_hex = version_hex + (int(str[2:4]) & 0x0f)
    else:
        version_hex = version_hex + (int(str[2:3]) & 0x0f)
    # print(hex(version_hex))
    return version_hex


def convert_bin_file_to_specified_size(src_file, out_file, size):
    
    bin_size = os.path.getsize(src_file)
    target_size = int(size)

    if target_size > bin_size:
        fill_size = target_size - bin_size
        read_size = bin_size
    else:
        fill_size = bin_size - target_size
        read_size = target_size

    with open(src_file, 'rb') as f:
        bin = f.read(read_size)
        f.close()
    
    with open(out_file, 'wb') as f:
        f.write(bin)
        if target_size > bin_size:
            for i in range(fill_size):
                fill_bin = struct.pack('B',0xFF)
                f.write(fill_bin)
        f.close()


def insert_diff_ota_head(src_data, flash_size, buf_size, part_num, block_size):
    patch_header = struct.pack(">10I2HI16x",    #>3I4b2I
                               0x74757961,  # magic number
                               0xFFFFFFFF,  # crc
                               flash_size,  # flash_size = app_size+backup_size+ota_size+manage_size
                               1,           # 1–单区差分ota  2-压缩升级
                               buf_size,    # diff buff size(4k,8k,12k,16k,20k)
                               part_num,    # 分区数量，默认单分区0
                               block_size,  # flash block size
                               len(src_data),   # 升级文件长度
                               crc32(src_data), # 升级文件crc
                               1,           # ability
                               0x1002,      # manufacture_id
                               0x1602,      # image_type
                               0)           # reserved
    return (src_data + patch_header)


def patch_bin_tail_add(src_file, output_file):

    block_size = 0x2000  # block size
    buf_size = 0x4000    # buff size
    part_num = 0         # 分区数量
    if CHIP_ID.upper() == "EFR32MG21A020F1024IM32":
        flash_size = 0xDC000 # flash size
    elif CHIP_ID.upper() == "EFR32MG21A020F768IM32":
        flash_size = 0x9C000 # flash size

    if (buf_size % block_size != 0):
        print("buf_size error!!!")
        return -1
    
    with open(src_file, 'rb') as f:
        src_data = f.read()
        f.close()
   
    patch_io = open(output_file, "wb")
    patch_io.write(insert_diff_ota_head(src_data, flash_size, buf_size, part_num, block_size))
    patch_io.close()



# firmware info parser
def app_firmware_info_collect():
    global CHIP_ID
    global IMAGE_TYPE
    global MANUFACTURE_ID
    print("firmware information parse start...")
    file = open(JSON_CONFIG_PATH, 'rb')
    fileJson = json.load(file, object_pairs_hook=collections.OrderedDict)
    IMAGE_TYPE = fileJson['firmwareInfo']['image_type']
    MANUFACTURE_ID = fileJson['firmwareInfo']['manufacture_id']
    CHIP_ID = fileJson['firmwareInfo']['chip_id']
    file.close()
    print("firmware information parse success")


def combine_bootloader_with_bin(src_file, output_file):
    print (" ")
    print ("Start combine bootloader with app .bin file.")
    print (" ")
    sys.stdout.flush()
    btl_bin_path = ''
    btl_list = os.listdir(BOOTLOADER_PATH)
    for file in btl_list:
        if CHIP_ID.upper() == "EFR32MG21A020F1024IM32":
            if file.find('MG21-1M') != -1:
                btl_bin_path = os.path.join(BOOTLOADER_PATH, file)
                break
        elif CHIP_ID.upper() == "EFR32MG21A020F768IM32":
            if file.find('MG21-768K') != -1:
                btl_bin_path = os.path.join(BOOTLOADER_PATH, file)
                break
    input1 = open(btl_bin_path, 'rb').read()
    input2 = open(src_file, 'rb').read()

    input1 += input2 
    with open(output_file, 'wb') as fp:
        fp.write(input1)
        fp.close()


# commander.exe convert tuyaos_demo_light2.s37 --outfile  tuyaos_demo_light2.bin
def convert_s37_to_bin_file(src_file, output_file):
    print (" ")
    print ("Start convert s37 to bin file.")
    print (" ")
    sys.stdout.flush()

    p0 = COMMANDER_PATH
    p1 = 'convert'
    p2 = src_file
    p3 = '--outfile'
    p4 = output_file
    para = "%s \"%s\" \"%s\" \"%s\" \"%s\""%(p0, p1, p2, p3, p4)
    # print(para)
    ret = subprocess.call(para)
    if ret != 0:
        print("convert s37 to bin error!!!")
        sys.exit(1)

# commander.exe convert tuyaos_demo_light2.bin --outfile  tuyaos_demo_light2.s37
def convert_bin_to_s37_file(src_file, output_file):
    print (" ")
    print ("Start convert bin to s37 file.")
    print (" ")
    sys.stdout.flush()

    p0 = COMMANDER_PATH
    p1 = 'convert'
    p2 = src_file
    p3 = '--outfile'
    p4 = output_file
    para = "%s \"%s\" \"%s\" \"%s\" \"%s\""%(p0, p1, p2, p3, p4)
    # print(para)
    ret = subprocess.call(para)
    if ret != 0:
        print("convert bin to s37 error!!!")
        sys.exit(1)

# commander.exe gbl create gbl_app_name.gbl '--app' s37_app_name.s37 --device EFR32MG21A020F1024
def convert_s37_to_gbl_file(src_file, output_file):
    print (" ")
    print ("Start generate .gbl file.")
    print (" ")
    sys.stdout.flush()

    p0 = COMMANDER_PATH
    p1 = 'gbl'
    p2 = 'create'
    p3 = output_file
    p4 = '--app'
    p5 = src_file
    p6 = '--device'
    p7 = CHIP_ID
    para = "%s \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\""%(p0, p1, p2, p3, p4, p5, p6, p7)
    # print(para)
    ret = subprocess.call(para)
    if ret != 0:
        print("GBL generate error!!!")
        sys.exit(1)

# IMAGE_BUILD_PATH --create "app_name_OTA_1.0.0.bin" --version 0x40 --manuf-id $(MANUF_ID) --image-type $(OTA_IMAGE_TYPE) --tag-id 0x0000 --tag-file "$(OUTPUT_DIR)/$(TARGET).gbl" --string "$(TARGET)"
def convert_gbl_to_ota_file(src_file, output_file, app_name, version):
    print (" ")
    print ("Start generate OTA file.")
    print (" ")
    sys.stdout.flush()

    p0 = IMAGE_BUILD_PATH
    p1 = '--create'
    p2 = output_file
    p3 = '--version'
    p4 = version_string_to_hex(version)
    p5 = '--manuf-id'
    p6 = MANUFACTURE_ID
    p7 = '--image-type'
    p8 = IMAGE_TYPE
    p9 = '--tag-id'
    p10 = 0x0000
    p11 = '--tag-file'
    p12 = src_file
    p13 = '--string'
    p14 = app_name
    para = "%s \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\""%(p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14)
    ret = subprocess.call(para)
    if ret != 0:
        print("OTA generate error!!!")
        sys.exit(1)

# EFR32MG21A020F1024IM32
# |**** 0x00008000 ****|**** 496K ****|**** 0x00084000 *****|***** app code********|
# |**** 0x00084000 ****|**** 16K *****|**** 0x00088000 *****|*** diff backup*******|
# |**** 0x00088000 ****|**** 352K ****|**** 0x000E0000 *****|***** ota*************|
# |**** 0x000E0000 ****|**** 16K *****|**** 0x000E4000 *****|**** diff mange*******|
# EFR32MG21A020F768IM32
# |**** 0x00008000 ****|**** 344K ****|**** 0x0005E000 *****|***** app code********|
# |**** 0x0005E000 ****|**** 16K *****|**** 0x00062000 *****|*** diff backup*******|
# |**** 0x00062000 ****|**** 248K ****|**** 0x000A0000 *****|***** ota*************|
# |**** 0x000A0000 ****|**** 16K *****|**** 0x000A4000 *****|**** diff mange*******|
def check_upgrade_firmware_size(qio_s37, qio_bin, ug_bin, diff_bin):

    ug_bin_size = os.path.getsize(ug_bin)
    qio_bin_size = os.path.getsize(qio_bin)
    if CHIP_ID.upper() == "EFR32MG21A020F1024IM32":
        qio_bin_max_size = 496*1024         # app code
        ug_bin_max_size = (352+16)*1024     # ota + diff mange
    elif CHIP_ID.upper() == "EFR32MG21A020F768IM32":
        qio_bin_max_size = 344*1024         # app code
        ug_bin_max_size = (248+16)*1024     # ota + diff mange
    
    if qio_bin_size >= qio_bin_max_size:
        print("")
        print("ERROR: QIO-s37 FIRMWARE SIZE OVERFLOW !!!")
        print("")
        sys.stdout.flush()
        os.remove(qio_s37)
        os.remove(ug_bin)
        os.remove(diff_bin)
        exit(1)

    if ug_bin_size >= ug_bin_max_size:
        print("")
        print("WARNING: UPGRADE FIRMWARE SIZE OVERFLOW !!!")
        print("")
        sys.stdout.flush()
        # os.remove(ug_bin)

    os.remove(qio_bin)


if __name__ == "__main__":
    app_firmware_info_collect()
    
    # convert app s37 to app bin and add path tail to target file
    src_file = os.path.join(APP_PATH, APP_NAME+'.s37')
    output_file = os.path.join(APP_PATH, APP_NAME+'.bin')
    convert_s37_to_bin_file(src_file, output_file)
    src_file = os.path.join(APP_PATH, APP_NAME+'.bin')
    diff_file_bin = os.path.join(OUTPUT_PATH, APP_NAME+'_DIFF_'+APP_VERSION+'.bin')
    patch_bin_tail_add(src_file, diff_file_bin)

    # combine bootloader bin with app bin to QIO bin and convert to s37
    src_file = os.path.join(APP_PATH, APP_NAME+'.bin')
    qio_file_bin = os.path.join(OUTPUT_PATH, APP_NAME+'_QIO_'+APP_VERSION+'.bin')
    combine_bootloader_with_bin(src_file, qio_file_bin)
    qio_file_s37 = os.path.join(OUTPUT_PATH, APP_NAME+'_QIO_'+APP_VERSION+'.s37')
    convert_bin_to_s37_file(qio_file_bin, qio_file_s37)
    
    # convert app s37 to app gbl and use app gbl to OTA bin
    src_file = os.path.join(APP_PATH, APP_NAME+'.s37')
    gbl_file = os.path.join(APP_PATH, APP_NAME+'.gbl')
    convert_s37_to_gbl_file(src_file, gbl_file)
    ug_file_bin = os.path.join(OUTPUT_PATH, APP_NAME+'_UG_'+APP_VERSION+'.bin')
    convert_gbl_to_ota_file(gbl_file, ug_file_bin, APP_NAME, APP_VERSION)
    
    # firmware size check
    check_upgrade_firmware_size(qio_file_s37, qio_file_bin, ug_file_bin, diff_file_bin)
