/**
 * @file tkl_rtc.c
 * @brief This is tuya tkl rtc src file
 * @version 1.0
 * @date 2021-09-10
 *
 * @copyright Copyright 2021-2022 Tuya Inc. All Rights Reserved.
 *
 */
#include "tkl_rtc.h"
#include "tkl_system.h"

UINT32_T g_rtc_sec = 0;



OPERATE_RET tkl_rtc_init(VOID_T)
{
    return OPRT_OK;
}

OPERATE_RET tkl_rtc_deinit(VOID_T)
{
    g_rtc_sec = 0;
    return OPRT_OK;
}

OPERATE_RET tkl_rtc_time_set(TIME_T time_sec)
{
    g_rtc_sec = time_sec;
    return OPRT_OK;
}

OPERATE_RET tkl_rtc_time_get(TIME_T *time_sec)
{
    *time_sec = g_rtc_sec;
    return OPRT_OK;
}

VOID_T tkl_rtc_time_loop_handler(VOID_T)
{
    UINT32_T diff_tick;
    UINT32_T curr_tick = 0;
    STATIC UINT32_T last_tick = 0;
    STATIC UINT32_T remain_tick = 0;

    curr_tick = tkl_system_get_millisecond();
    if(last_tick == 0) {
        last_tick = curr_tick;
        return;
    }

    if(curr_tick >= last_tick) {
        diff_tick  = curr_tick - last_tick;
    }
    else {
        diff_tick = curr_tick + (0xFFFFFFFF - last_tick);
    }
    
    diff_tick += remain_tick;
    if((diff_tick / 1000) < 1) {
        return;
    }

    remain_tick = diff_tick % 1000;
    last_tick = curr_tick;

    g_rtc_sec += (diff_tick / 1000);
}


