/**
* @file tkl_platform_types.h
* @brief This is tuya tkl platform types file
* @version 0.1
* @date 2021-04-06
*
* @copyright Copyright 2021-2022 Tuya Inc. All Rights Reserved.
*
*/

#ifndef __TKL_PLATFORM_TYPES_H__
#define __TKL_PLATFORM_TYPES_H__

#include <stdio.h>
#include <stdlib.h>


#include PLATFORM_HEADER
#include "stack/include/ember-types.h"
#include "app/framework/include/af.h"
#include "app/framework/util/attribute-storage.h"
#include "app/util/serial/command-interpreter2.h"

#include "em_wdog.h"
// #include "em_msc.h"
// #include "em_se.h"
// #include "em_adc.h"
// #include "em_iadc.h"
// #include "em_cmu.h"
// #include "em_gpio.h"
// #include "em_usart.h"
// #include "em_timer.h"
// #include "gpiointerrupt.h"
#include "hal/hal.h"
#include "hal/micro/random.h"

#include "mbedtls/sha256.h"
// ZDO
#include "app/util/zigbee-framework/zigbee-device-common.h"
#include "app/util/zigbee-framework/zigbee-device-library.h"

#include "app/util/security/security.h"
#include "app/util/common/form-and-join.h"

#include "app/framework/util/service-discovery.h"
#include "app/framework/util/af-main.h"
#include "app/framework/util/util.h"

#include "app/framework/security/af-security.h"
#include "app/framework/security/crypto-state.h"

#include "app/framework/plugin/partner-link-key-exchange/partner-link-key-exchange.h"
#include "app/framework/plugin/find-and-bind-initiator/find-and-bind-initiator.h"
#include "app/framework/plugin-soc/idle-sleep/idle-sleep.h"
#include "app/framework/plugin/reporting/reporting.h"
#include "app/framework/plugin/scenes/scenes.h"
#include "app/framework/plugin/zll-commissioning-common/zll-commissioning-common.h"
#include "app/framework/plugin/zll-commissioning-client/zll-commissioning-client.h"
#include "app/framework/plugin/zll-commissioning-server/zll-commissioning-server.h"
#include "znet-bookkeeping.h"

#include "stack/include/source-route.h"
#include "stack/include/aes-mmo.h"
#include "stack/include/mfglib.h"


// TuyaOS types
#include "tuya_zigbee_stack.h"

#ifdef __cplusplus
extern "C" {
#endif




#ifdef __cplusplus
}
#endif

#endif