 /**
 * @file tkl_zigbee_inner.h
 * @brief Common process - instert to native SDK API
 * @version 1.0.0
 * @date 2021-04-21
 *
 * @copyright Copyright 2021-2022 Tuya Inc. All Rights Reserved.
 *
 */

#ifndef __TKL_ZIGBEE_INNER_H__
#define __TKL_ZIGBEE_INNER_H__

#include "tkl_data_transceiver.h"
#include "tkl_network_manager.h"
#include "tkl_zcl_group.h"
#include "tkl_zcl_scene.h"
#include "tkl_zcl_ota.h"


#ifdef __cplusplus
    extern "C" {
#endif


typedef EmberAfStatus (*command_parse_cb)(EmberAfClusterCommand *cmd);
typedef struct {
    command_parse_cb client_parse_cb; 
    command_parse_cb server_parse_cb; 
} SDK_COMMAND_CB_T;

/* indentify callback */
extern SDK_COMMAND_CB_T g_identify_cb;

/* zll Commissioning callback */
extern SDK_COMMAND_CB_T g_zll_cb;

/* group callback */
extern TKL_GROUP_CB_T g_group_cb;

/* scene callback */
extern TKL_SCENE_CB_T g_scene_cb;

/* data transceiver callback */
extern TKL_ZG_RECV_CB g_zcl_recv_cb;
extern TKL_ZG_SEND_CB g_zcl_send_cb;

/* zigbee zcl ota callback */
extern TKL_ZG_OTA_CB g_zcl_ota_cb;

/**
 * @brief start identify when received identify command
 * this API will insert to native SDK
 * start identify countdown at up layer.
 *
 * @param[in]   ep_id: endpoint
 * @param[in]   time:  identify time (second)
 * @return  TRUE/ FALSE
 */
BOOL_T tkl_zg_inner_identify_start(UINT8_T ep_id, UINT16_T time);

/**
 * @brief all cluster init callback.
 * this API will insert to native SDK
 *
 * @param[in] ep_id:      endpoint id
 * @param[in] sl_cluster: point to native cluster structure
 * @return  none
 */
VOID_T tkl_zg_inner_cluster_init_callback(UINT8_T ep_id,
                                        EmberAfCluster *sl_cluster);

/**
 * @brief position the location of the attribute in the global array.
 * only be called once in the initialization process.
 *
 * @param[in] ep_id:      endpoint id
 * @param[in] cluster_id: cluster id
 * @param[in] is_server:  is server of client cluster
 * @param[in] attr_id:    attribute id
 * @return  position of the attribute in the global array
 */
UINT8_T* tkl_zg_inner_attr_location(UINT8_T ep_id, EmberAfClusterId cluster_id, 
                                    UINT8_T is_server, EmberAfAttributeId attr_id);

/**
 * @brief zigbee scan duration get
 * this API will insert to native SDK
 * @param[in]   none
 * @return  0: success  Other: fail
 */
ZG_SCAN_DURATION_E tkl_zg_inner_scan_duration_get(VOID_T);


/**
* @brief ota init
 * this API will insert to native SDK
 * 
 * @param[in] app_ver:  app current version
 * @param[in] manuf_id:  manufacturer id
 * @param[in] image_type:  ota image type
 *
 * @note This API is used for ota init
 *
 * @return none
 */
VOID_T tkl_inner_ota_init(UINT_T app_ver, UINT16_T manuf_id, UINT16_T image_type);

/**
 * @brief zigbee poll send management function
 * this API will insert to native SDK
 * @param[in]   none
 * @return  0: success  Other: fail
 */
VOID_T tkl_zg_inner_poll_mamager_callback(VOID_T);

/**
 * @brief after joined network is broadcast permit join
 * this API will insert to native SDK
 * @param[in]   none
 * @return  0: enabele broadcast permit join
 */
BOOL_T tkl_zg_inner_is_permit_join_after_joined(VOID_T);

#ifdef __cplusplus
}
#endif

#endif
