/**
 * @file tal_mutex.c
 * @brief This is tuya tal_mutex file
 * @version 1.0
 * @date 2021-09-10
 *
 * @copyright Copyright 2021-2022 Tuya Inc. All Rights Reserved.
 *
 */


/***********************************************************************
 ** INCLUDE                                                           **
 **********************************************************************/
#include "tkl_system.h"
#include "tkl_memory.h"
#include "tkl_mutex.h"

/***********************************************************************
 ** CONSTANT ( MACRO AND ENUM )                                       **
 **********************************************************************/


/***********************************************************************
 ** STRUCT                                                            **
 **********************************************************************/


/***********************************************************************
 ** VARIABLE                                                          **
 **********************************************************************/


/***********************************************************************
 ** FUNCTON                                                           **
 **********************************************************************/




OPERATE_RET tkl_mutex_create_init(TKL_MUTEX_HANDLE *pMutexHandle)
{
    *pMutexHandle = tkl_system_malloc(SIZEOF(UINT32_T));
    return OPRT_OK;
}

OPERATE_RET tkl_mutex_lock(CONST TKL_MUTEX_HANDLE mutexHandle)
{
    UINT32_T *p_irq_mask = mutexHandle;
    *p_irq_mask = tkl_system_enter_critical();
    return OPRT_OK;
}

OPERATE_RET tkl_mutex_unlock(CONST TKL_MUTEX_HANDLE mutexHandle)
{
    UINT32_T *p_irq_mask = mutexHandle;
    tkl_system_exit_critical(*p_irq_mask);
    return OPRT_OK;
}

OPERATE_RET tkl_mutex_release(CONST TKL_MUTEX_HANDLE mutexHandle)
{
    tkl_system_free(mutexHandle);
    return OPRT_OK;
}

