/**
* @file tkl_sleep.c
* @brief This is tuya tkl sleep src file
* @version 0.1
* @date 2021-04-06
*
* @copyright Copyright 2021-2022 Tuya Inc. All Rights Reserved.
*
*/

#include "tkl_platform_types.h"
#include "tkl_sleep.h"


TUYA_SLEEP_CB_T g_sleep_cb;



OPERATE_RET tkl_cpu_sleep_callback_register(TUYA_SLEEP_CB_T *sleep_cb)
{
#if defined (TUYA_ZG_S_END_DEV)
    if(sleep_cb != NULL) {
        g_sleep_cb.pre_sleep_cb = sleep_cb->pre_sleep_cb;
        g_sleep_cb.post_wakeup_cb = sleep_cb->post_wakeup_cb;
        return OPRT_OK;
    }

    return OPRT_INVALID_PARM;
#else
    return OPRT_NOT_SUPPORTED;
#endif
}


VOID_T tkl_cpu_allow_sleep(VOID_T)
{
#if defined (TUYA_ZG_S_END_DEV)
    emberAfForceEndDeviceToStayAwake(0);
#endif
}

VOID_T tkl_cpu_force_wakeup(VOID_T)
{
#if defined (TUYA_ZG_S_END_DEV)
    emberAfForceEndDeviceToStayAwake(1);
#endif
}


OPERATE_RET tkl_cpu_sleep_mode_set(CONST BOOL_T enable, CONST TUYA_CPU_SLEEP_MODE_E mode)
{
    return OPRT_NOT_SUPPORTED;
}



