/*
 * @Author: Deven
 * @Email: liming@tuya.com
 * @LastEditors: Please set LastEditors
 * @FileName: &file name&
 * @Description: 
 * @Copyright: HANGZHOU TUYA INFORMATION TECHNOLOGY CO.,LTD
 * @Company: http://www.tuya.com
 * @Date: 2021-04-26 17:00:01
 * @LastEditTime: 2021-09-02 15:56:56
 */
#include "tkl_platform_types.h"
#include "tkl_attribute_rw.h"
#include "tkl_data_transceiver.h"
#include "tkl_memory.h"

#if defined (TUYA_RUNTIME_DBG)
#include "tkl_uart.h"
#define tuya_attr_debug(...)    tkl_dbg_printf(__VA_ARGS__)
#else
#define tuya_attr_debug(...)
#endif

extern TKL_ZG_RECV_CB *tkl_zg_register_recv_cb_get(VOID_T);


OPERATE_RET tkl_zg_write_attribute(TKL_CLUSTER_TRIPLET_T *triplet,
                                    UINT16_T attr_id,
                                    VOID_T *data,
                                    ZG_ATTR_TYPE_E type)
{
    EmberAfStatus status;
    TKL_ZG_RECV_CB cb;
    TKL_ZG_RECV_CB cb_zero;
    TKL_ZG_RECV_CB *inner_cb = tkl_zg_register_recv_cb_get();

	// Get the previously registered callback function and override it to null to prohibit callback notification
    tkl_system_memcpy(&cb, inner_cb, sizeof(TKL_ZG_RECV_CB));
    tkl_system_memset(&cb_zero, 0, sizeof(TKL_ZG_RECV_CB));
    tkl_zg_register_recv_cb(&cb_zero);
    
    status = emberAfWriteAttribute(triplet->ep_id,
                                    triplet->cluster_id,
                                    attr_id,
                                    triplet->is_server == 1 ? CLUSTER_MASK_SERVER:CLUSTER_MASK_CLIENT,
                                    (UINT8_T *)data,
                                    (EmberAfAttributeType)type);
    tkl_zg_register_recv_cb(&cb);
    
    // tuya_attr_debug("write status %d\r\n",status);
    return (status == EMBER_ZCL_STATUS_SUCCESS)? OPRT_OK: OPRT_OS_ADAPTER_ZG_ATTR_WRITE_FAILED;
}


OPERATE_RET tkl_zg_read_attribute(TKL_CLUSTER_TRIPLET_T *triplet,
                                    UINT16_T attr_id,
                                    VOID_T *data,
                                    UINT8_T len)
{
    EmberAfStatus status;

    status = emberAfReadAttribute(triplet->ep_id,
                                    triplet->cluster_id,
                                    attr_id,
                                    triplet->is_server == 1 ? CLUSTER_MASK_SERVER:CLUSTER_MASK_CLIENT,
                                    (UINT8_T *)data,
                                    len, 
                                    NULL);
    // tuya_attr_debug("read status %d\r\n",status);
    return (status == EMBER_ZCL_STATUS_SUCCESS)? OPRT_OK: OPRT_OS_ADAPTER_ZG_ATTR_READ_FAILED;
}



