/*
 * @Author: Deven
 * @Email: liming@tuya.com
 * @LastEditors: Please set LastEditors
 * @FileName: &file name&
 * @Description: 
 * @Copyright: HANGZHOU TUYA INFORMATION TECHNOLOGY CO.,LTD
 * @Company: http://www.tuya.com
 * @Date: 2021-04-24 16:38:51
 * @LastEditTime: 2021-09-21 17:49:51
 */
#include "tkl_platform_types.h"
#include "tkl_binding_table.h"

#if defined (TUYA_RUNTIME_DBG)
#include "tkl_uart.h"
#define tkl_bind_tb_debug(...)    tkl_dbg_printf(__VA_ARGS__)
#else
#define tkl_bind_tb_debug(...)
#endif



STATIC VOID_T __binding_convert(TKL_BINDING_TABLE_T *in_entry, EmberBindingTableEntry *out_entry)
{
    out_entry->type = in_entry->type;
    out_entry->local = in_entry->local_ep;
    out_entry->remote = in_entry->remote_ep;
    out_entry->clusterId = in_entry->cluster;
    out_entry->networkIndex = emberGetCurrentNetwork();
    memcpy(out_entry->identifier, in_entry->address, 8);
}

BOOL_T tkl_zg_add_binding(TKL_BINDING_TABLE_T *entry)
{
    UINT8_T i;
    UINT8_T table_size;
    EmberStatus status;
    EmberBindingTableEntry oldEntry;

    table_size = emberAfGetBindingTableSize();
    for(i = 0; i < table_size; i++) {
        if (emberGetBinding(i, &oldEntry) == EMBER_SUCCESS) {
            if (oldEntry.type == EMBER_UNUSED_BINDING) {
                break;
            }
        }
    }
    if(i == table_size) {
        return FALSE;
    }

    __binding_convert(entry, &oldEntry);
    status = emberSetBinding(i, &oldEntry);
    
    return (status == EMBER_SUCCESS)? TRUE: FALSE;
}

BOOL_T tkl_zg_remove_binding(TKL_BINDING_TABLE_T *entry)
{
    UINT8_T i;
    UINT8_T table_size;
    EmberStatus status = EMBER_SUCCESS;
    EmberBindingTableEntry oldEntry;

    table_size = emberAfGetBindingTableSize();
    for(i = 0; i < table_size; i++) {
        if (emberGetBinding(i, &oldEntry) == EMBER_SUCCESS) {
            if (oldEntry.type == EMBER_UNUSED_BINDING) {
                continue;
            }

            if(oldEntry.local == entry->local_ep &&
               oldEntry.remote == entry->remote_ep &&
               oldEntry.clusterId == entry->cluster &&
               !MEMCOMPARE(oldEntry.identifier,
                           entry->address,
                           (oldEntry.type == EMBER_MULTICAST_BINDING
                            ? 2 // group id
                            : EUI64_SIZE))) {
                
                status = emberDeleteBinding(i);
                if(status != EMBER_SUCCESS) {
                    return FALSE;
                }
            }
        }
    }
    
    return (status == EMBER_SUCCESS)? TRUE: FALSE;
}

BOOL_T tkl_zg_clear_all_binding(VOID_T)
{
    EmberStatus status;

    status = emberClearBindingTable();
    return (status == EMBER_SUCCESS)? TRUE: FALSE;
}

