/*
 * @Author: Deven
 * @Email: liming@tuya.com
 * @LastEditors: Please set LastEditors
 * @FileName: &file name&
 * @Description: 
 * @Copyright: HANGZHOU TUYA INFORMATION TECHNOLOGY CO.,LTD
 * @Company: http://www.tuya.com
 * @Date: 2021-04-24 16:38:51
 * @LastEditTime: 2022-01-26 16:42:04
 */
#include "tkl_platform_types.h"
#include "tkl_memory.h"
#include "tkl_data_transceiver.h"
#include "tkl_network_manager.h"
#include "tkl_rf_data_transceiver.h"

#if defined (TUYA_RUNTIME_DBG)
#include "tkl_uart.h"
#define tkl_data_transceiver_debug(...)    tkl_dbg_printf(__VA_ARGS__)
#else
#define tkl_data_transceiver_debug(...)
#endif

#define INTER_PAN_MIN_APP_DATA_SIZE 26


TKL_ZG_RECV_CB g_zcl_recv_cb;
TKL_ZG_SEND_CB g_zcl_send_cb;

extern bool emAfPluginInterpanProcessMessage(uint8_t messageLength,
                                                          uint8_t *messageContents);
extern EmberStatus emberAfSendInterPan(EmberPanId panId,
                                                const EmberEUI64 destinationLongId,
                                                EmberNodeId destinationShortId,
                                                EmberMulticastId multicastId,
                                                EmberAfClusterId clusterId,
                                                EmberAfProfileId profileId,
                                                uint16_t messageLength,
                                                uint8_t* messageBytes);

// BOOL_T __check_cluster_is_contains(UINT8_T direction, UINT8_T ep_id, UINT16_T cluster)
// {
//     if(cluster != CLUSTER_TUYA_MANAGER_CLUSTER_ID &&
//         cluster != CLUSTER_TUYA_MF_TEST_CLUSTER_ID) {
     
//         if (direction == ZG_ZCL_DATA_CLIENT_TO_SERVER &&
//             !emberAfContainsServer(ep_id, cluster)) {
//             return FALSE;
//         }
//         else if(direction == ZG_ZCL_DATA_SERVER_TO_CLIENT &&
//             !emberAfContainsClient(ep_id, cluster)) {
//             return FALSE;
//         }
//     }

//     return TRUE;
// }


EmberAfStatus emberAfPreAttributeChangeCallback(uint8_t endpoint,
                                                EmberAfClusterId clusterId,
                                                EmberAfAttributeId attributeId,
                                                uint8_t mask,
                                                uint16_t manufacturerCode,
                                                uint8_t type,
                                                uint8_t size,
                                                uint8_t* value)
{
    TKL_ATTR_REC_T attr_rec = {
        .attr_id = attributeId,
        .data_type = type,
        .data_len = size,
        .attr_data = value
    };

    if(g_zcl_recv_cb.pre_write_attr_cb == NULL) {
        return (EmberAfStatus)TUYA_ZCL_STA_SUCCESS;
    }
    
    return (EmberAfStatus)g_zcl_recv_cb.pre_write_attr_cb(endpoint, clusterId, &attr_rec);
}



VOID_T emberAfPostAttributeChangeCallback(uint8_t endpoint,
                                        EmberAfClusterId clusterId,
                                        EmberAfAttributeId attributeId,
                                        uint8_t mask,
                                        uint16_t manufacturerCode,
                                        uint8_t type,
                                        uint8_t size,
                                        uint8_t* value)
{
    TKL_ATTR_REC_T attr_rec = {
        .attr_id = attributeId,
        .data_type = type,
        .data_len = size,
        .attr_data = value
    };

    if(g_zcl_recv_cb.post_write_attr_cb) {
        (VOID_T)g_zcl_recv_cb.post_write_attr_cb(endpoint, clusterId, &attr_rec);
    }
}


/** @brief Pre Command Received
 *
 * This callback is the second in the Application Framework's message processing
 * chain. At this point in the processing of incoming over-the-air messages, the
 * application has determined that the incoming message is a ZCL command. It
 * parses enough of the message to populate an EmberAfClusterCommand struct. The
 * Application Framework defines this struct value in a local scope to the
 * command processing but also makes it available through a global pointer
 * called emberAfCurrentCommand, in app/framework/util/util.c. When command
 * processing is complete, this pointer is cleared.
 *
 * @param cmd   Ver.: always
 */
bool emberAfPreCommandReceivedCallback(EmberAfClusterCommand* cmd)
{
    // processing unregistered private clusters
    
    TKL_ZG_AUX_T aux; 
    TKL_ZCL_FRAME_T frame;
    TKL_HANDLE_MODE_E mode = HANDLE_NATIVE_SDK_MODE;

    if((!cmd->clusterSpecific) ||
        (cmd->apsFrame->clusterId != CLUSTER_TUYA_MANAGER_CLUSTER_ID &&
        cmd->apsFrame->clusterId != CLUSTER_TUYA_MF_TEST_CLUSTER_ID)) {
        return FALSE;
    }
    tkl_data_transceiver_debug("private zcl cluster receive.\r\n");
    if(g_zcl_recv_cb.recv_zcl_cmd_specific_cb == NULL) {
        return FALSE;
    }

    if(cmd->type == EMBER_INCOMING_MULTICAST ||
        cmd->type == EMBER_INCOMING_MULTICAST_LOOPBACK) {
        aux.mode = ZG_MULTICAST_MODE;
        aux.addr.recv.group_addr = cmd->apsFrame->groupId;
    }
    else if(cmd->type == EMBER_INCOMING_BROADCAST ||
          cmd->type == EMBER_INCOMING_BROADCAST_LOOPBACK) {
        aux.mode = ZG_BROADCAST_MODE;
    }
    else {
        aux.mode = ZG_UNICAST_MODE;
    }

    aux.src_ep = cmd->apsFrame->sourceEndpoint;
    aux.dst_ep = cmd->apsFrame->destinationEndpoint;
    aux.profile = cmd->apsFrame->profileId;
    aux.cluster = cmd->apsFrame->clusterId;
    aux.addr.recv.src_addr = cmd->source;

    frame.zcl_hdr.direction = cmd->direction;
    frame.zcl_hdr.manu_spec = cmd->mfgSpecific;
    frame.zcl_hdr.frame_type = cmd->clusterSpecific;
    // frame.zcl_hdr.disable_rsp =
    frame.zcl_hdr.manu_code = cmd->mfgCode;
    frame.zcl_hdr.seq_number = cmd->seqNum;
    frame.zcl_hdr.command_id = cmd->commandId;
    frame.payload_len = (cmd->bufLen - cmd->payloadStartIndex);
    frame.payload = &(cmd->buffer[cmd->payloadStartIndex]);

    (VOID_T)g_zcl_recv_cb.recv_zcl_cmd_specific_cb(&aux, &frame, &mode);
    if(mode == HANDLE_TUYA_SDK_MODE) {
        return TRUE;
    }

    return FALSE;
}


UINT8_T tkl_zcl_seq_num_get(VOID_T)
{
    return emberAfNextSequence();
}

TKL_ZG_RECV_CB *tkl_zg_register_recv_cb_get(VOID_T)
{
    return &g_zcl_recv_cb;
}


OPERATE_RET tkl_zg_register_recv_cb(TKL_ZG_RECV_CB *recv_cb)
{
    if(recv_cb == NULL) {
        return OPRT_INVALID_PARM;
    }
    tkl_system_memcpy(&g_zcl_recv_cb, recv_cb, sizeof(TKL_ZG_RECV_CB));

    return OPRT_OK;
}

OPERATE_RET tkl_zg_register_send_cb(TKL_ZG_SEND_CB *send_cb)
{
    if(send_cb == NULL) {
        return OPRT_INVALID_PARM;
    }
    g_zcl_send_cb.pre_send_cb = send_cb->pre_send_cb;
    g_zcl_send_cb.post_send_cb = send_cb->post_send_cb;
    
    return OPRT_OK;
}

OPERATE_RET tkl_zg_aps_send(TKL_ZG_AUX_T *auxiliary, TKL_ZCL_FRAME_T *zcl_data)
{
    INT_T status;
    UINT8_T frame_ctr = 0;
    UINT16_T aps_opt = EMBER_AF_DEFAULT_APS_OPTIONS;

    if(auxiliary == NULL || zcl_data == NULL) {
        return OPRT_INVALID_PARM;
    }

    frame_ctr = (UINT8_T)(zcl_data->zcl_hdr.frame_type << 0 ) | 
                        (zcl_data->zcl_hdr.manu_spec << 2)    |
                        (zcl_data->zcl_hdr.direction << 3)    |
                        (zcl_data->zcl_hdr.disable_rsp << 4);

    if(auxiliary->mode == ZG_UNICAST_MODE) {
        aps_opt &= (~EMBER_APS_OPTION_RETRY);
    }

    if(g_zcl_send_cb.pre_send_cb != NULL) {
        g_zcl_send_cb.pre_send_cb(zcl_data->zcl_hdr.seq_number);
    }

    emberAfFillExternalBufferApsOptionExt(aps_opt,
                                        zcl_data->zcl_hdr.seq_number,
                                        frame_ctr, 
                                        auxiliary->cluster,
                                        zcl_data->zcl_hdr.command_id,
                                        "b",
                                        zcl_data->payload,
                                        zcl_data->payload_len);

    emberAfSetCommandEndpoints(auxiliary->src_ep, auxiliary->dst_ep);
    
    EmberAfDisableDefaultResponse bakup_zcl_framecontrol = emberAfGetDisableDefaultResponse();
    EmberAfRetryOverride bakup_aps_option = emberAfGetRetryOverride();
    emberAfSetDisableDefaultResponse(EMBER_AF_DISABLE_DEFAULT_RESPONSE_NONE);
    emberAfSetRetryOverride(EMBER_AF_RETRY_OVERRIDE_NONE);
    
    if(auxiliary->mode == ZG_UNICAST_MODE) {
        status = emberAfSendCommandUnicast(EMBER_OUTGOING_DIRECT, auxiliary->addr.send.dst_addr);
    }
    if(auxiliary->mode == ZG_MULTICAST_MODE) {
        status = emberAfSendCommandMulticastWithCallback(auxiliary->addr.send.group_addr, NULL);
    }
    else if(auxiliary->mode == ZG_BROADCAST_MODE) {
        status = emberAfSendCommandBroadcast(auxiliary->addr.send.dst_addr);
    }
    else if(auxiliary->mode == ZG_BINDING_MODE) {
        status = emberAfSendCommandUnicastToBindings();
    }
    else if(auxiliary->mode == ZG_MULTI_BINDING_MODE) {
        status = emberAfSendCommandMulticastToBindings();
    }

    if(g_zcl_send_cb.post_send_cb != NULL) {
        g_zcl_send_cb.post_send_cb(status, zcl_data->zcl_hdr.seq_number);
    }

    emberAfSetDisableDefaultResponse(bakup_zcl_framecontrol);
    emberAfSetRetryOverride(bakup_aps_option);

    return (status == EMBER_SUCCESS)? OPRT_OK: OPRT_OS_ADAPTER_ZG_SEND_FAILED;
}

#if defined(TUYA_ZG_ROUTER)
OPERATE_RET tkl_zg_interpan_send(UINT16_T pan_id, UINT8_T *mac, UINT16_T dst_addr, UINT16_T group_id, UINT16_T cluster, UINT16_T profile, UINT8_T *message, UINT16_T msg_len)
{
    EmberStatus ret = EMBER_SUCCESS;
    ret = emberAfSendInterPan(pan_id, mac, dst_addr, group_id, cluster, profile, msg_len, message);
    if(EMBER_SUCCESS != ret) {
        return OPRT_OS_ADAPTER_ZG_SEND_FAILED;
    }

    return OPRT_OK;
}

TUYA_OPTIMIZE_NONE
TUYA_WEAK_ATTRIBUTE BOOL_T tkl_zg_interpan_recv(CONST UINT8_T *mac, UINT16_T profile, UINT16_T cluster, CONST UINT8_T *message, UINT8_T msg_len)
{
    if(profile == 0xC05E) {
        return FALSE;
    }
    else if(profile == 0x0104 || mac == NULL || 
            message == NULL || msg_len == 0 ) {
        return TRUE;
    }
    return FALSE;
}
bool emberAfPluginInterpanPreMessageReceivedCallback(const EmberAfInterpanHeader *header,
                                                     uint8_t msgLen,
                                                     uint8_t *message)
{
    return tkl_zg_interpan_recv(header->longAddress, header->profileId, header->clusterId, message, msgLen);
}

EmberPacketAction emberPacketHandoffIncoming(EmberZigbeePacketType packetType,
                                            EmberMessageBuffer packetBuffer,
                                            uint8_t index,
                                            void *data)
{
  UINT8_T temp_buff[128] = {0};
    switch (packetType) {
        case EMBER_ZIGBEE_PACKET_TYPE_INTERPAN: {
            UINT8_T packetLength = emberMessageBufferLength(packetBuffer);
            tkl_data_transceiver_debug("packetType %d, packetLength %d\r\n",packetType, packetLength);

            if(packetLength > sizeof(temp_buff)) {
                packetLength = sizeof(temp_buff);
            }
            if(packetLength < INTER_PAN_MIN_APP_DATA_SIZE) {
                break;
            }
            emberCopyFromLinkedBuffers(packetBuffer,
                                        0,
                                        temp_buff,
                                        packetLength);
            emAfPluginInterpanProcessMessage(packetLength, temp_buff);
            break;
        }
        default: {
            break;
        }
    }

    return EMBER_ACCEPT_PACKET;
}

EmberPacketAction emberPacketHandoffOutgoing(EmberZigbeePacketType packetType,
                                                        EmberMessageBuffer packetBuffer,
                                                        uint8_t index,
                                                        void *data)
{
    return EMBER_ACCEPT_PACKET;
}
#else

EmberPacketAction emberPacketHandoffIncoming(EmberZigbeePacketType packetType,
                                             EmberMessageBuffer packetBuffer,
                                             uint8_t index,
                                             void *data)
{
  return EMBER_ACCEPT_PACKET;
}

EmberPacketAction emberPacketHandoffOutgoing(EmberZigbeePacketType packetType,
                                             EmberMessageBuffer packetBuffer,
                                             uint8_t index,
                                             void *data)
{
  return EMBER_ACCEPT_PACKET;
}
#endif
