/*
 * @Author: Deven
 * @Email: liming@tuya.com
 * @LastEditors: Please set LastEditors
 * @FileName: &file name&
 * @Description: 
 * @Copyright: HANGZHOU TUYA INFORMATION TECHNOLOGY CO.,LTD
 * @Company: http://www.tuya.com
 * @Date: 2021-04-22 16:44:56
 * @LastEditTime: 2021-12-16 16:15:46
 */
#include "tkl_platform_types.h"
#include "tkl_memory.h"

#include "tkl_endpoint_register.h"

#define FREE_STATIC     tkl_system_free
#define MALLOC_STATIC   tkl_system_malloc

#if defined (TUYA_RUNTIME_DBG)
#include "tkl_uart.h"
#define tkl_ep_mgr_debug(...)    tkl_dbg_printf(__VA_ARGS__)
#else
#define tkl_ep_mgr_debug(...)
#endif



extern UINT8_T *attributeData; 
extern UINT8_T emberEndpointCount;
extern EmberAfDefinedEndpoint *emAfEndpoints;

UINT16_T total_attribut_size = 0;

typedef struct {
    const EmberAfGenericClusterFunction *group_func;
    const EmberAfGenericClusterFunction *scene_func;
    const EmberAfGenericClusterFunction *identify_func;
} INNER_CLUSTER_FUNC_T;
INNER_CLUSTER_FUNC_T inner_cluster_func;

const EmberAfGenericClusterFunction __emberAfFuncArrayGroupsClusterServer[] = { (EmberAfGenericClusterFunction)emberAfGroupsClusterServerInitCallback};
const EmberAfGenericClusterFunction __emberAfFuncArrayScenesClusterServer[] = { (EmberAfGenericClusterFunction)emberAfScenesClusterServerInitCallback};
const EmberAfGenericClusterFunction __emberAfFuncArrayIdentifyClusterServer[] = { (EmberAfGenericClusterFunction)emberAfIdentifyClusterServerAttributeChangedCallback};
const EmberAfGenericClusterFunction __emberAfFuncArrayOtaBootloadClusterClient[] = { (EmberAfGenericClusterFunction)emberAfOtaBootloadClusterClientInitCallback,(EmberAfGenericClusterFunction)emberAfOtaBootloadClusterClientDefaultResponseCallback};

/** @brief Cluster Init
 *
 * This function is called when a specific cluster is initialized. It gives the
 * application an opportunity to take care of cluster initialization procedures.
 * It is called exactly once for each endpoint where cluster is present.
 *
 * @param endpoint   Ver.: always
 * @param clusterId   Ver.: always
 */
VOID_T emberAfClusterInitCallback(uint8_t endpoint,
                                EmberAfClusterId clusterId)
{
    // init cluster after register endpoint
}

// cluster init
VOID_T tkl_zg_inner_cluster_init_callback(uint8_t ep_id, EmberAfCluster *sl_cluster)
{
}


STATIC UINT16_T __attr_transfer(EmberAfAttributeMetadata *sl_attr, TKL_ATTR_T *ty_attr, UINT8_T sums)
{
    UINT8_T k;
    UINT16_T total_size = 0;

    tkl_ep_mgr_debug("start attribute register....\r\n");
    for(k=0; k<sums; k++) {

        sl_attr[k].attributeId = ty_attr[k].attr_id;
        sl_attr[k].attributeType = ty_attr[k].type;
        sl_attr[k].size = ty_attr[k].size;
        sl_attr[k].mask = ty_attr[k].mask;
        sl_attr[k].defaultValue.ptrToDefaultValue = ty_attr[k].value;
        tkl_ep_mgr_debug("attribute 0x%02x take size %d\r\n",sl_attr[k].attributeId, sl_attr[k].size);
        #if 0
        if(sl_attr[k].size ==1) {
            sl_attr[k].defaultValue.defaultValue = *(UINT8_T *)(ty_attr[k].value);
        }
        else if(sl_attr[k].size == 2) {
            sl_attr[k].defaultValue.defaultValue = *(UINT16_T *)(ty_attr[k].value);
        }
        else {
            sl_attr[k].defaultValue.ptrToDefaultValue = MALLOC_STATIC(attr[k].size);
            if(sl_attr[k].defaultValue.ptrToDefaultValue) {
                tkl_system_memcpy(sl_attr[k].defaultValue.ptrToDefaultValue, ty_attr[k].value, attr[k].size);
            }
        }
        #endif
        if(ty_attr[k].mask & ATTR_MASK_TOKENIZE) {
            // NOTE: attribute token of native SDK is not supported
            sl_attr[k].mask &= (~ATTR_MASK_TOKENIZE);
            sl_attr[k].mask |= ATTR_MASK_TOKEN_FAST;
        }

        total_size += sl_attr[k].size;
    }

    return total_size;
}

STATIC OPERATE_RET __cluster_transfer(EmberAfCluster *sl_cluster, TKL_CLUSTER_T *ty_cluster, UINT8_T sums, EmberAfClusterMask mask, UINT16_T *attr_size)
{
    UINT8_T j;
    UINT16_T total_size = 0;
    
    tkl_ep_mgr_debug("start cluster register....\r\n");
    if(ty_cluster == NULL && sums == 0) {
        *attr_size = 0;
        return OPRT_OK;
    }
    else if(ty_cluster == NULL || sums == 0) {
        return OPRT_INVALID_PARM;
    }

    for(j=0; j<sums; j++) {

        sl_cluster[j].clusterId = ty_cluster[j].cluster_id;
        sl_cluster[j].attributeCount = ty_cluster[j].attr_sums;
        
        if(sl_cluster[j].clusterId == CLUSTER_OTA_BOOTLOAD_CLUSTER_ID) {
            sl_cluster[j].functions = __emberAfFuncArrayOtaBootloadClusterClient;
            sl_cluster[j].mask |= (mask | CLUSTER_MASK_INIT_FUNCTION | CLUSTER_MASK_DEFAULT_RESPONSE_FUNCTION);
        }
        else if(sl_cluster[j].clusterId == CLUSTER_GROUPS_CLUSTER_ID) { // TODO:client / server 调用两次注册的函数是否有问题
            sl_cluster[j].functions = __emberAfFuncArrayGroupsClusterServer;
            sl_cluster[j].mask |= (mask | CLUSTER_MASK_INIT_FUNCTION);
        }
        else if(sl_cluster[j].clusterId == CLUSTER_SCENES_CLUSTER_ID) {
            sl_cluster[j].functions = __emberAfFuncArrayScenesClusterServer;
            sl_cluster[j].mask |= (mask | CLUSTER_MASK_INIT_FUNCTION);
        }
        else if(sl_cluster[j].clusterId == CLUSTER_IDENTIFY_CLUSTER_ID) {
            sl_cluster[j].functions = __emberAfFuncArrayIdentifyClusterServer;
            sl_cluster[j].mask |= (mask | CLUSTER_MASK_ATTRIBUTE_CHANGED_FUNCTION);
        }
        else {
            sl_cluster[j].mask |= mask;
            sl_cluster[j].functions = NULL;
        }

        sl_cluster[j].attributes = MALLOC_STATIC(sl_cluster[j].attributeCount*sizeof(EmberAfAttributeMetadata));
        if(sl_cluster[j].attributes == NULL) {
            return OPRT_MALLOC_FAILED;
        }
        tkl_system_memset((UINT8_T *)sl_cluster[j].attributes, 0, sl_cluster[j].attributeCount*sizeof(EmberAfAttributeMetadata));
        
        sl_cluster[j].clusterSize = __attr_transfer(sl_cluster[j].attributes, 
                                                    ty_cluster[j].attr_list, 
                                                    sl_cluster[j].attributeCount);
        total_size += sl_cluster[j].clusterSize;
        tkl_ep_mgr_debug("cluster 0x%02x has %d attr, mask 0x%02x, total size %d\r\n",sl_cluster[j].clusterId, sl_cluster[j].attributeCount, sl_cluster[j].mask, sl_cluster[j].clusterSize);
    }

    *attr_size = total_size;

    return OPRT_OK;
}

TUYA_OPTIMIZE_NONE
TUYA_WEAK_ATTRIBUTE TKL_DEV_VER_E tkl_zg_endpoint_to_device_version(UINT8_T ep_id)
{
    if(0xF2 == ep_id) {
        return DEV_VER_ZHA;
    }
    else {
        return DEV_VER_ZG30;
    }
}

// when the call receives an error state, it must enter the while(1) 
OPERATE_RET tkl_zg_endpoint_register(CONST TKL_ENDPOINT_T *ep_desc, UINT8_T sums)
{
    UINT8_T i;
    INT_T ret_status;
    UINT8_T cluster_sum = 0;
    UINT16_T one_cluster_attr_size = 0;
    EmberAfCluster *sl_cluster = NULL;
    EmberAfDefinedEndpoint *sl_ep = NULL;

    tkl_ep_mgr_debug("start endpoint register....\r\n");
    if(ep_desc == NULL || sums == 0) {
        return OPRT_INVALID_PARM;
    }
    
    sl_ep = MALLOC_STATIC(sizeof(EmberAfDefinedEndpoint)*sums);
    if(sl_ep == NULL) {
        tkl_ep_mgr_debug("malloc failed1.\r\n");
        return OPRT_MALLOC_FAILED;
    }
    tkl_system_memset((UINT8_T *)sl_ep, 0, sizeof(EmberAfDefinedEndpoint)*sums);

    for(i=0; i<sums; i++) {

        sl_ep[i].endpoint = ep_desc[i].ep_id;
        sl_ep[i].profileId = ep_desc[i].profile;
        sl_ep[i].deviceId = ep_desc[i].dev_id;
        sl_ep[i].deviceVersion = tkl_zg_endpoint_to_device_version(ep_desc[i].ep_id);          //0:ZHA, 1:zigbee3.0, 2:ZLL
        sl_ep[i].networkIndex = 0;
        sl_ep[i].bitmask = EMBER_AF_ENDPOINT_ENABLED;

        sl_ep[i].endpointType = MALLOC_STATIC(sizeof(EmberAfEndpointType));
        if(sl_ep[i].endpointType == NULL) {
            tkl_ep_mgr_debug("malloc failed2.\r\n");
            return OPRT_MALLOC_FAILED;
        }
        tkl_system_memset((UINT8_T *)sl_ep[i].endpointType, 0, sizeof(EmberAfEndpointType));

        cluster_sum = ep_desc[i].client_cluster_sums + ep_desc[i].server_cluster_sums;
        sl_ep[i].endpointType->clusterCount = cluster_sum;
        tkl_ep_mgr_debug("endpoint %d has %d cluster\r\n",sl_ep[i].endpoint, cluster_sum);

        sl_ep[i].endpointType->cluster = MALLOC_STATIC(sizeof(EmberAfCluster)*cluster_sum);
        if(sl_ep[i].endpointType->cluster == NULL) {
            tkl_ep_mgr_debug("malloc failed3.\r\n");
            return OPRT_MALLOC_FAILED;
        }
        tkl_system_memset((UINT8_T *)(sl_ep[i].endpointType->cluster), 0, sizeof(EmberAfCluster)*cluster_sum);

        // server cluster register
        sl_cluster = sl_ep[i].endpointType->cluster;
        ret_status = __cluster_transfer(sl_cluster, 
                                        ep_desc[i].server_cluster_list, 
                                        ep_desc[i].server_cluster_sums, 
                                        CLUSTER_MASK_SERVER,
                                        &(one_cluster_attr_size));
        if(ret_status != 0) {
            tkl_ep_mgr_debug("client cluster convert failed1.\r\n");
            return OPRT_OS_ADAPTER_ZG_EP_REG_FAILED;
        }
        sl_ep[i].endpointType->endpointSize = one_cluster_attr_size;
        tkl_ep_mgr_debug("SERVER CLUSTER 0x%02x occupied attr size: %d\r\n", sl_cluster->clusterId, one_cluster_attr_size);

        // client cluster register
        sl_cluster += ep_desc[i].server_cluster_sums;
        ret_status = __cluster_transfer(sl_cluster, 
                                        ep_desc[i].client_cluster_list, 
                                        ep_desc[i].client_cluster_sums, 
                                        CLUSTER_MASK_CLIENT,
                                        &(one_cluster_attr_size));
        if(ret_status != 0) {
            tkl_ep_mgr_debug("client cluster convert failed2.\r\n");
            return OPRT_OS_ADAPTER_ZG_EP_REG_FAILED;
        }
        sl_ep[i].endpointType->endpointSize += one_cluster_attr_size;
        total_attribut_size += sl_ep[i].endpointType->endpointSize;
        tkl_ep_mgr_debug("CLIENT CLUSTER 0x%02x occupied attr size: %d\r\n", sl_cluster->clusterId, one_cluster_attr_size);
    }
    
    emAfEndpoints = sl_ep;
    emberEndpointCount = sums;

    tkl_ep_mgr_debug("all endpoint attr size: %d\r\n", total_attribut_size);
    attributeData = MALLOC_STATIC(total_attribut_size);
    if(attributeData == NULL) {
        tkl_ep_mgr_debug("malloc failed4.\r\n");
        return OPRT_MALLOC_FAILED;
    }
    tkl_system_memset(attributeData, 0, total_attribut_size);

    return OPRT_OK;
}


BOOL_T tkl_zg_match_cluster(TKL_CLUSTER_TRIPLET_T *triplet)
{
    UINT8_T i;
    BOOL_T return_st = FALSE;
    UINT8_T ep_num = emberAfEndpointCount();

    for (i = 0; i < ep_num; i++) {
        if(triplet->ep_id == emberAfEndpointFromIndex(i)) {
            if(triplet->is_server) {
                return_st = emberAfContainsServer(triplet->ep_id, triplet->cluster_id);
            }
            else {
                return_st = emberAfContainsClient(triplet->ep_id, triplet->cluster_id);
            }
        }
    }

    return return_st;
}

UINT8_T tkl_zg_endpoint_count_get(VOID_T)
{
    return emberAfEndpointCount();
}

BOOL_T tkl_zg_attr_get(TKL_CLUSTER_TRIPLET_T *triplet, UINT16_T attr_id, TKL_ATTR_T *out_attr)
{
    UINT8_T i,j,k;
    UINT16_T attr_index = 0;
    
    if(out_attr == NULL) {
        return FALSE;
    }
    
    for(i=0; i<emberAfEndpointCount(); i++) {

        for(j=0; j<emAfEndpoints[i].endpointType->clusterCount; j++) {

            EmberAfCluster *cluster = emAfEndpoints[i].endpointType->cluster+j;
            for(k=0; k<cluster->attributeCount; k++) {
                
                EmberAfAttributeMetadata *attr = cluster->attributes+k;
                if(triplet->is_server == emberAfClusterIsServer(cluster) &&
                    triplet->ep_id == emAfEndpoints[i].endpoint && 
                    cluster->clusterId == triplet->cluster_id && 
                    attr->attributeId == attr_id) {
                        out_attr->attr_id = attr->attributeId;
                        out_attr->type = (ZG_ATTR_TYPE_E)attr->attributeType;
                        out_attr->size = attr->size;
                        out_attr->mask = attr->mask;
                        out_attr->value = (VOID_T *)(attributeData + attr_index);
                    // tkl_ep_mgr_debug("find arrt size %d, index: %d, data %d, mask 0x%02x\r\n", attr->size, attr_index, (uint8_t)attributeData[attr_index],attr->mask);
                    return TRUE;
                }
                attr_index += attr->size;
            }
        }
    }

    return FALSE;
}

UINT8_T* tkl_zg_inner_attr_location(UINT8_T ep_id, EmberAfClusterId cluster_id, 
                                    UINT8_T is_server, EmberAfAttributeId attr_id)
{
    BOOL_T status;
    TKL_ATTR_T attr;

    TKL_CLUSTER_TRIPLET_T cluster_trp = {
        .ep_id = ep_id,
        .is_server = is_server,
        .cluster_id = cluster_id
    };

    status = tkl_zg_attr_get(&cluster_trp, attr_id, &attr);
    if(!status) {
        return NULL;
    }

    return (UINT8_T *)(attr.value);
}

#if 0
// for test 
VOID_T endpoint_test_func(VOID_T)
{
    UINT8_T i;

    tkl_ep_mgr_debug(" < test register ep > \r\n");
    for (i = 0; i < emberAfEndpointCount(); i++) {
        EmberAfEndpointType *endpointType = emAfEndpoints[i].endpointType;

        tkl_ep_mgr_debug("cluster count %d, endpoint size %d, \r\n",endpointType->clusterCount, endpointType->endpointSize);

        UINT8_T clusterIndex;
        for (clusterIndex = 0; clusterIndex < endpointType->clusterCount; clusterIndex++) {
            EmberAfCluster *cluster = &(endpointType->cluster[clusterIndex]);
            tkl_ep_mgr_debug("cluster 0x%02x, attr count %d, cluster size %d, \r\n", cluster->clusterId, cluster->attributeCount, cluster->clusterSize);
            
            uint16_t attrIndex;
            for (attrIndex = 0; attrIndex < cluster->attributeCount; attrIndex++) {
                EmberAfAttributeMetadata *attr = &(cluster->attributes[attrIndex]);
                tkl_ep_mgr_debug("attr 0x%02x, attr size %d, type %d, mask 0x%x\r\n",attr->attributeId, attr->size, attr->attributeType, attr->mask);
            }
        }
    }
}
#endif


