/*
 * @Author: Deven
 * @Email: liming@tuya.com
 * @LastEditors: Please set LastEditors
 * @FileName: &file name&
 * @Description: 
 * @Copyright: HANGZHOU TUYA INFORMATION TECHNOLOGY CO.,LTD
 * @Company: http://www.tuya.com
 * @Date: 2021-04-24 16:38:51
 * @LastEditTime: 2021-09-21 17:05:53
 */
#include "tkl_platform_types.h"
#include "tkl_endpoint_register.h"
#include "tkl_zcl_identify.h"
#include "tkl_find_bind.h"

#if defined (TUYA_RUNTIME_DBG)
#include "tkl_uart.h"
#define tkl_fb_debug(...)    tkl_dbg_printf(__VA_ARGS__)
#else
#define tkl_fb_debug(...)
#endif

#define TKL_FIND_AND_BIND_TARGET_COMMISSIONING_TIME 180 // seconds


TKL_FB_INITIATOR_COMP_CB g_fb_complete_cb;

/** @brief Complete
 *
 * This callback is fired by the initiator when the Find and Bind process is
 * complete.
 *
 * @param status Status code describing the completion of the find and bind
 * process Ver.: always
 */
void emberAfPluginFindAndBindInitiatorCompleteCallback(EmberStatus status)
{
    TKL_FB_STATUS_E state;

    if(status == EMBER_SUCCESS) {
        state = TKL_FB_SUCCESS;
    }
    else {
        state = TKL_FB_FAILED;
    }
    if(g_fb_complete_cb != NULL) {
        g_fb_complete_cb(state);
    }
}



BOOL_T tkl_zg_find_bind_targer_start(UINT8_T ep_id)
{
    return tkl_zg_identify_start(ep_id, TKL_FIND_AND_BIND_TARGET_COMMISSIONING_TIME);
}

BOOL_T tkl_zg_find_bind_targer_stop(UINT8_T ep_id)
{
    return tkl_zg_identify_start(ep_id, 0);
}

BOOL_T tkl_zg_find_bind_initiator_start(UINT8_T ep_id)
{
    EmberStatus status;
    status = emberAfPluginFindAndBindInitiatorStart(ep_id);

    return (status==EMBER_ZCL_STATUS_SUCCESS) ? TRUE: FALSE;
}

BOOL_T tkl_zg_find_bind_initiator_stop(UINT8_T ep_id)
{
    EmberStatus status;
    status = emberAfPluginFindAndBindInitiatorStop(ep_id);

    return (status==EMBER_ZCL_STATUS_SUCCESS) ? TRUE: FALSE;
}

OPERATE_RET tkl_zg_find_bind_initiator_complete_cb_register(TKL_FB_INITIATOR_COMP_CB complete_cb)
{
    if(complete_cb == NULL) {
        return OPRT_INVALID_PARM;
    }
    g_fb_complete_cb = complete_cb;

    return OPRT_OK;
}

