/*
 * @Author: Deven
 * @Email: liming@tuya.com
 * @LastEditors: Please set LastEditors
 * @FileName: &file name&
 * @Description: 
 * @Copyright: HANGZHOU TUYA INFORMATION TECHNOLOGY CO.,LTD
 * @Company: http://www.tuya.com
 * @Date: 2021-09-07 16:11:38
 * @LastEditTime: 2022-02-09 16:25:08
 */

/**
* @file tkl_sleep.h
* @brief Common process - adapter the sleep manage api
* @version 0.1
* @date 2021-08-18
*
* @copyright Copyright 2020-2021 Tuya Inc. All Rights Reserved.
*
*/
#include "tkl_platform_types.h"
#include "tkl_main_callback.h"


extern VOID_T tkl_rtc_time_loop_handler(VOID_T);
extern VOID_T tkl_ota_inner_init(VOID_T);


#if defined(TUYA_ZG_S_END_DEV)
//wdg next check time
#define WDG_NEXT_CHECK_MIN_TIMEOUT  5000
#define ABNORMAL_WAKEUP_DURATION    (2*60*1000UL)

static UINT32_T last_wakeup_time = 0;
static UINT32_T abnormal_wakeup_time = ABNORMAL_WAKEUP_DURATION;

/** @brief Ok To Sleep
 *
 * This function is called by the Idle/Sleep plugin before sleeping. It is
 * called with interrupts disabled. The application should return true if the
 * device may sleep or false otherwise.
 *
 * @param durationMs The maximum duration in milliseconds that the device will
 * sleep. Ver.: always
 */
bool emberAfPluginIdleSleepOkToSleepCallback(uint32_t durationMs)
{
    // GPIO_PinModeSet(gpioPortA, 5, gpioModeDisabled, 1);
    if(durationMs > WDG_NEXT_CHECK_MIN_TIMEOUT) {
        WDOGn_Feed_Busy_Waitting(DEFAULT_WDOG);
    }
    return true;
}

/** @brief Wake Up
 *
 * This function is called by the Idle/Sleep plugin after sleeping.
 *
 * @param durationMs The duration in milliseconds that the device slept.
 * Ver.: always
 */
void emberAfPluginIdleSleepWakeUpCallback(uint32_t durationMs)
{
    // GPIO_PinModeSet(gpioPortA, 5, gpioModePushPull, 1);
    last_wakeup_time = halCommonGetInt32uMillisecondTick();
}

VOID_T tkl_abnormal_wakeup_time_set(UINT32_T time_ms)
{
    abnormal_wakeup_time = time_ms;
}

VOID_T __abnormal_wakeup_daemon_handler(VOID_T)
{
    UINT32_T interval = 0;
    UINT32_T curr_time = halCommonGetInt32uMillisecondTick();

    if(curr_time >= last_wakeup_time) {
        interval = curr_time - last_wakeup_time;
    }
    else {
        interval = 0xffffffff - last_wakeup_time + curr_time;
    }

    if(interval > abnormal_wakeup_time) {
        last_wakeup_time = curr_time;
        if (tkl_inner_abnormal_wakeup_callback()) {
            NVIC_SystemReset();
        }
    }
}
#else
VOID_T __abnormal_wakeup_daemon_handler(VOID_T)
{
}
#endif

VOID_T tkl_inner_main_init(VOID_T)
{
    (VOID_T)tkl_init_first();
}

VOID_T tkl_inner_before_run_init(VOID_T)
{
    tkl_ota_inner_init();
    (VOID_T)tkl_init_last();
}

VOID_T tkl_inner_main_task_run(VOID_T)
{
    tkl_rtc_time_loop_handler();
    __abnormal_wakeup_daemon_handler();

    (VOID_T)tkl_main_loop();
}


