/*
 * @Author: Deven
 * @Email: liming@tuya.com
 * @LastEditors: Please set LastEditors
 * @FileName: &file name&
 * @Description: 
 * @Copyright: HANGZHOU TUYA INFORMATION TECHNOLOGY CO.,LTD
 * @Company: http://www.tuya.com
 * @Date: 2021-04-24 16:38:51
 * @LastEditTime: 2021-09-02 15:58:33
 */
#include "tkl_platform_types.h"
#include "tkl_poll_manager.h"


#if defined (TUYA_RUNTIME_DBG)
#include "tkl_uart.h"
#define tkl_poll_mgr_debug(...)    tkl_dbg_printf(__VA_ARGS__)
#else
#define tkl_poll_mgr_debug(...)
#endif



typedef struct {
    TKL_ZG_POLL_CMP_CB poll_cmp_cb;
    TKL_ZG_POLL_MGR_CB poll_mgr_cb;
} ZG_POLL_CB_T;

ZG_POLL_CB_T g_poll_cb;

TKL_POLL_STATUS_E __poll_status_convert(EmberStatus status);

// This function is called when a poll completes and explains what happend with
// the poll.  If the number of sequential data polls not ACKed by the parent
// exceeds the threshold, we will try to find a new parent.
void emberPollCompleteHandler(EmberStatus status)
{
    if(g_poll_cb.poll_cmp_cb != NULL) {
        g_poll_cb.poll_cmp_cb(__poll_status_convert(status));
    }
}


TKL_POLL_STATUS_E __poll_status_convert(EmberStatus status)
{
    switch (status) {
        case EMBER_SUCCESS:
        case EMBER_MAC_NO_DATA:
            return TKL_POLL_SUCESS;
        case EMBER_DELIVERY_FAILED:
        case EMBER_PHY_TX_BLOCKED:
        case EMBER_PHY_TX_SCHED_FAIL:
        case EMBER_PHY_TX_CCA_FAIL:
            // This means the air was busy, which we don't count as a failure.
            return TKL_POLL_BUSY_FAIL;
            break;
        case EMBER_MAC_NO_ACK_RECEIVED:
            // The MAC level ACK was never received.
            return TKL_POLL_NO_ACK_FAIL;
            break;
        default:
            return TKL_POLL_IDLE;
    }
}

VOID_T tkl_zg_inner_poll_mamager_callback(VOID_T)
{
    if(g_poll_cb.poll_mgr_cb != NULL) {
        g_poll_cb.poll_mgr_cb();
    }
}


OPERATE_RET tkl_zg_poll_data_send(VOID_T)
{
    EmberStatus status = emberPollForData();

    return (status == EMBER_SUCCESS) ? OPRT_OK: OPRT_OS_ADAPTER_ZG_SEND_FAILED;
}


OPERATE_RET tkl_zg_poll_cb_register(TKL_POLL_CB_T *poll_cb)
{
    if(poll_cb == NULL || 
        poll_cb->poll_mgr_cb == NULL || 
        poll_cb->poll_cmp_cb == NULL) {
        return OPRT_INVALID_PARM;
    }

    g_poll_cb.poll_cmp_cb = poll_cb->poll_cmp_cb;
    g_poll_cb.poll_mgr_cb = poll_cb->poll_mgr_cb;

    return OPRT_OK;
}