/*
 * @Author: Deven
 * @Email: liming@tuya.com
 * @LastEditors: Please set LastEditors
 * @FileName: &file name&
 * @Description: 
 * @Copyright: HANGZHOU TUYA INFORMATION TECHNOLOGY CO.,LTD
 * @Company: http://www.tuya.com
 * @Date: 2021-08-09 16:46:59
 * @LastEditTime: 2021-09-23 20:13:26
 */
#include "tkl_platform_types.h"
#include "tkl_memory.h"
#include "tkl_reporting.h"

#if defined (TUYA_RUNTIME_DBG)
#include "tkl_uart.h"
#define tkl_reporting_debug(...)    tkl_dbg_printf(__VA_ARGS__)
#else
#define tkl_reporting_debug(...)
#endif

extern EmberAfPluginReportingEntry generatedReportingConfigDefaults[];

VOID_T __reporting_table_convert(TKL_REPORT_TABLE_T *entery, UINT8_T sums)
{
    tkl_system_memcpy(&generatedReportingConfigDefaults[0], entery, sums*sizeof(TKL_REPORT_TABLE_T));
}



OPERATE_RET tkl_zg_reporting_init(TKL_REPORT_TABLE_T *entery, UINT8_T sums)
{
    if(entery == NULL || sums == 0) {
        return OPRT_INVALID_PARM;
    }
    if(sums > EMBER_AF_GENERATED_REPORTING_CONFIG_DEFAULTS_TABLE_SIZE) {
        return OPRT_INVALID_PARM;
    }
    
    tkl_reporting_debug("reporting init\r\n");
    __reporting_table_convert(entery, sums);
    
    emberAfPluginReportingInit();
    
    return OPRT_OK;
}

BOOL_T tkl_zg_add_reporting_entry(TKL_REPORT_TABLE_T *entery)
{
    UINT16_T ret;

    if(entery == NULL) {
        return FALSE;
    }

    tkl_reporting_debug("reporting entry add\r\n");
    ret = emAfPluginReportingConditionallyAddReportingEntry((EmberAfPluginReportingEntry *)entery);
    if(ret == 0xFFFF) {
        return FALSE;
    }

    return TRUE;
}

VOID_T tkl_zg_clear_reporting_table(VOID_T)
{
    emberAfClearReportTableCallback();
}

VOID_T tkl_zg_load_default_reporting_table(VOID_T)
{
    emberAfPluginReportingLoadReportingConfigDefaultsExt();
}

