/*
 * @Author: Deven
 * @Email: liming@tuya.com
 * @LastEditors: Please set LastEditors
 * @FileName: &file name&
 * @Description: 
 * @Copyright: HANGZHOU TUYA INFORMATION TECHNOLOGY CO.,LTD
 * @Company: http://www.tuya.com
 * @Date: 2021-04-24 16:38:51
 * @LastEditTime: 2021-11-23 10:23:18
 */
#include "tkl_platform_types.h"
#include "tkl_rf_data_transceiver.h"
#include "rail_types.h"

#if defined (TUYA_RUNTIME_DBG)
#include "tkl_uart.h"
#define tkl_raw_data_debug(...)    tkl_dbg_printf(__VA_ARGS__)
#else
#define tkl_raw_data_debug(...)
#endif

// TODO: packet format shield the difference of the underlying data receiving and receiving formats
extern EmberStatus mfglibStart(void (*mfglibRxCallback)(uint8_t *packet, uint8_t linkQuality, int8_t rssi));

TKL_RF_RECV_CB g_rf_recv_cb;

STATIC VOID_T __rf_recv_cb(uint8_t *packet, uint8_t lqi, int8_t rssi)
{
    // NOTE: Not all SDK raw data is received in the same format, we need to convert it to a unified format.
    // Byte0 +  // data len(include 2Bytes CRC)
    // Bytes... // user data(not include 2Bytes CRC)
    if(g_rf_recv_cb == NULL) {
        return;
    }
    // packet: format convert
    g_rf_recv_cb(packet, lqi, rssi);
}

BOOL_T tkl_rf_channel_set(UINT8_T channel)
{
    EmberStatus status;
    status = mfglibSetChannel(channel);
    return (status == EMBER_SUCCESS ? TRUE : FALSE);
}

BOOL_T tkl_rf_tx_power_set(INT8_T power)
{
    EmberStatus status;
    status = mfglibSetPower(EMBER_TX_POWER_MODE_USE_TOKEN, power);
    return (status == EMBER_SUCCESS ? TRUE : FALSE);
}

BOOL_T tkl_rf_transeiver_start(TKL_RF_RECV_CB recv_cb)
{
    EmberStatus status;
    g_rf_recv_cb = recv_cb;
    status = mfglibStart(__rf_recv_cb);

    return (status == EMBER_SUCCESS ? TRUE : FALSE);
}

BOOL_T tkl_rf_transeiver_end(VOID_T)
{
    EmberStatus status;
    #if defined(TUYA_ZG_S_END_DEV)
    // NOTE: The patch used to solve the problem of not sleeping without completely shutting down the RF interface
    RAIL_Idle(emberGetRailHandle(), 1, false); //RAIL_Idle(emberGetRailHandle(), RAIL_IDLE_ABORT,false);
    #endif
    status = mfglibEnd();
    return (status == EMBER_SUCCESS ? TRUE : FALSE);
}

// BOOL_T tkl_rf_data_send(UINT8_T *packet)
// {
//     EmberStatus status;
//     // packet[0]: data len(data len + 2Bytes CRC)
//     status = mfglibSendPacket(packet, 0);
//     return (status == EMBER_SUCCESS ? TRUE : FALSE);
// }


extern RAIL_Handle_t emPhyRailHandle;
#define connectRailHandle emPhyRailHandle

static RAIL_SchedulerInfo_t txSchedulerInfo = {
  .priority = 100,
  .slipTime = 500000,
  .transactionTime = 0, // filled in later
};
BOOL_T tkl_rf_data_send(UINT8_T *packet)
{
    STATIC UINT8_T buffer[EMBER_PHY_MAX_PACKET_LENGTH];
    RAIL_SetTxFifo(connectRailHandle,
                   buffer,
                   0,
                   EMBER_PHY_MAX_PACKET_LENGTH);
    
    RAIL_WriteTxFifo(connectRailHandle,
                   packet,
                   packet[0],
                   1);

    RAIL_StartTx(connectRailHandle,
                 mfglibGetChannel(),
                 0,
                 &txSchedulerInfo);
                   
   return TRUE;
}



