/*
 * @Author: Deven
 * @Email: liming@tuya.com
 * @LastEditors: Please set LastEditors
 * @FileName: &file name&
 * @Description: 
 * @Copyright: HANGZHOU TUYA INFORMATION TECHNOLOGY CO.,LTD
 * @Company: http://www.tuya.com
 * @Date: 2021-04-19 16:12:17
 * @LastEditTime: 2022-01-07 10:52:29
 */
#include "tkl_platform_types.h"
#include "tkl_security.h"

#if defined (TUYA_RUNTIME_DBG)
#include "tkl_uart.h"
#define tkl_security_debug(...)     tkl_dbg_printf(__VA_ARGS__)
#else
#define tkl_security_debug(...)
#endif

BOOL_T tkl_mbedtls_sha256(const UCHAR_T *input, UINT32_T len, UCHAR_T output[32], BOOL_T is224)
{
    INT32_T ret = -1;
    mbedtls_sha256_context ctx;
    
    // 1. init mbedtls_md_context_t structure
    mbedtls_sha256_init(&ctx);
    
    // 2. start
    ret = mbedtls_sha256_starts_ret(&ctx, is224);
    if (ret != 0) {
        goto exit;
    }
    // 3. update
    ret = mbedtls_sha256_update_ret(&ctx, input, len);
    if (ret != 0) {
        goto exit;
    }
     
    // 4. finish
    ret = mbedtls_sha256_finish_ret(&ctx, output);
    if (ret != 0) {
        goto exit;
    }
    
    exit:
    // 5. free
    mbedtls_sha256_free(&ctx);

    return (BOOL_T)(!ret);
}

