/*
 * @Author: Deven
 * @Email: liming@tuya.com
 * @LastEditors: Please set LastEditors
 * @FileName: &file name&
 * @Description: 
 * @Copyright: HANGZHOU TUYA INFORMATION TECHNOLOGY CO.,LTD
 * @Company: http://www.tuya.com
 * @Date: 2021-04-24 16:38:51
 * @LastEditTime: 2021-09-02 15:59:05
 */
#include "tkl_platform_types.h"
#include "tkl_zcl_group.h"

#if defined (TUYA_RUNTIME_DBG)
#include "tkl_uart.h"
#define tkl_group_debug(...)    tkl_dbg_printf(__VA_ARGS__)
#else
#define tkl_group_debug(...)
#endif


TKL_GROUP_CB_T g_group_cb;

extern EmberAfStatus removeEntryFromGroupTable(uint8_t endpoint, uint16_t groupId);
extern EmberAfStatus addEntryToGroupTable(uint8_t endpoint, uint16_t groupId, uint8_t *groupName);



BOOL_T tkl_zg_find_group(UINT8_T ep_id, UINT16_T group_id)
{
    return emberAfGroupsClusterEndpointInGroupCallback(ep_id, group_id);
}

BOOL_T tkl_zg_add_group(UINT8_T ep_id, UINT16_T group_id)
{
    EmberAfStatus status;

    status = addEntryToGroupTable(ep_id, group_id, NULL);
    if(status != EMBER_ZCL_STATUS_SUCCESS) {
        return FALSE;
    }

    return TRUE;
}

BOOL_T tkl_zg_remove_group(UINT8_T ep_id, UINT16_T group_id)
{
    EmberAfStatus status;

    status = removeEntryFromGroupTable(ep_id, group_id);
    if(status != EMBER_ZCL_STATUS_SUCCESS) {
        return FALSE;
    }

    return TRUE;
}

// EMBER_BROADCAST_ENDPOINT clear all group
VOID_T tkl_zg_clear_group(UINT8_T ep_id)
{
    emberAfGroupsClusterClearGroupTableCallback(ep_id);
}

VOID_T tkl_zg_clear_all_group(VOID_T)
{
    emberAfGroupsClusterClearGroupTableCallback(EMBER_BROADCAST_ENDPOINT);
}

OPERATE_RET tkl_zg_group_cb_register(TKL_GROUP_CB_T *group_cb)
{
    if(group_cb == NULL) {
        return OPRT_INVALID_PARM;
    }
    g_group_cb.add_group_cb = group_cb->add_group_cb;
    g_group_cb.view_group_cb = group_cb->view_group_cb;
    g_group_cb.remove_group_cb = group_cb->remove_group_cb;

    return OPRT_OK;
}

