/*
 * @Author: Deven
 * @Email: liming@tuya.com
 * @LastEditors: Please set LastEditors
 * @FileName: &file name&
 * @Description: 
 * @Copyright: HANGZHOU TUYA INFORMATION TECHNOLOGY CO.,LTD
 * @Company: http://www.tuya.com
 * @Date: 2021-04-24 16:38:51
 * @LastEditTime: 2021-12-16 16:14:59
 */
#include "tkl_platform_types.h"
#include "tkl_endpoint_register.h"
#include "tkl_zcl_identify.h"
#include "tkl_memory.h"

#include "tkl_zigbee_inner.h"

#if defined (TUYA_RUNTIME_DBG)
#include "tkl_uart.h"
#define tkl_identify_debug(...)    tkl_dbg_printf(__VA_ARGS__)
#else
#define tkl_identify_debug(...)
#endif

#define IDENTIFY_FREE   tkl_system_free
#define IDENTIFY_MALLOC tkl_system_malloc


typedef struct {
    BOOL_T doing;
}__IDENTIFY_T;
__IDENTIFY_T* identify_table = NULL;

typedef VOID_T (*IDENTIFY_EVENT_CB)(VOID_T);

IDENTIFY_EVENT_CB identify_timer_tick_event_callback;
EmberEventControl tkl_identify_timer_tick_event_control;

STATIC __IDENTIFY_T* __identity_table_entery(UINT8_T ep_id);

UINT8_T g_is_init;
SDK_COMMAND_CB_T g_identify_cb;


void emberAfIdentifyClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                          EmberAfAttributeId attributeId)
{
    __IDENTIFY_T *identify;

    if(!g_is_init) {
        return;
    }

    if (attributeId == ZCL_IDENTIFY_TIME_ATTRIBUTE_ID) {
        identify = __identity_table_entery(endpoint);
        if(identify != NULL) {
            identify->doing = TRUE;
            emberEventControlSetDelayMS(tkl_identify_timer_tick_event_control, 1);
        }
    }
}


STATIC __IDENTIFY_T* __identity_table_entery(UINT8_T ep_id)
{
    UINT8_T ep_idex = emberAfFindClusterServerEndpointIndex(ep_id, ZCL_IDENTIFY_CLUSTER_ID);
    return (ep_idex == 0xFF ? NULL : &identify_table[ep_idex]);
}

STATIC VOID_T __identify_timer_tick_event_handler(VOID_T)
{
    UINT8_T i;
    UINT8_T ep_id;
    UINT16_T time = 0;
    __IDENTIFY_T *identify;

    emberEventControlSetInactive(tkl_identify_timer_tick_event_control);
    // find identify clusters on each EP
    for(i = 0; i < tkl_zg_endpoint_count_get(); i++) {
        ep_id = emberAfEndpointFromIndex(i);
        identify = __identity_table_entery(ep_id);
        if(identify != NULL && identify->doing) {
            emberAfReadServerAttribute(ep_id,
                                        ZCL_IDENTIFY_CLUSTER_ID,
                                        ZCL_IDENTIFY_TIME_ATTRIBUTE_ID,
                                        (UINT8_T *)&time,
                                        sizeof(UINT16_T));
            if(time != 0) {
                time--;
                emberAfWriteServerAttribute(ep_id,
                                            ZCL_IDENTIFY_CLUSTER_ID,
                                            ZCL_IDENTIFY_TIME_ATTRIBUTE_ID,
                                            (UINT8_T *)&time,
                                            ATTR_INT16U_ATTRIBUTE_TYPE);
                tkl_identify_debug("identify continue loop, ep %d, time %d\r\n", ep_id,time);
                emberEventControlSetDelayMS(tkl_identify_timer_tick_event_control, 1000);
            }
            else {
                identify->doing = FALSE;
                tkl_identify_debug("identify end, ep %d, time %d\r\n", ep_id, time);
            }
        }
    }
}

VOID_T tkl_identify_timer_tick_event_handler(VOID_T)
{
    identify_timer_tick_event_callback();
}

STATIC BOOL_T __identify_time_update(UINT16_T time)
{
    UINT8_T i;
    UINT8_T ep_id;
    BOOL_T status = FALSE;
    __IDENTIFY_T *identify;
    
    for(i = 0; i < tkl_zg_endpoint_count_get(); i++) {
        ep_id = emberAfEndpointFromIndex(i);
        identify = __identity_table_entery(ep_id);
        if(identify != NULL && identify->doing) {
            // write identify time
            emberAfWriteServerAttribute(ep_id,
                                         ZCL_IDENTIFY_CLUSTER_ID,
                                         ZCL_IDENTIFY_TIME_ATTRIBUTE_ID,
                                         (UINT8_T *)&time,
                                         ATTR_INT16U_ATTRIBUTE_TYPE);
            status = TRUE;
            if(time != 0) {
                tkl_identify_debug("identify start loop, ep %d, time %d\r\n", ep_id,time);
                // find & bind target start
                emberEventControlSetDelayMS(tkl_identify_timer_tick_event_control, 1000);
            }
            else {
                // find & bind target stop
                identify->doing = FALSE;
                tkl_identify_debug("identify stop loop, ep %d, time %d\r\n", ep_id,time);
            }
        }
    }
    
    return status;
}


BOOL_T tkl_zg_identify_time_set(UINT8_T ep_id, UINT16_T time)
{
  // Write the identify time.
  EmberAfStatus status = EMBER_ZCL_STATUS_UNSUPPORTED_ATTRIBUTE;

  if (emberAfContainsServer(ep_id, ZCL_IDENTIFY_CLUSTER_ID)) {
    status = emberAfWriteServerAttribute(ep_id,
                                         ZCL_IDENTIFY_CLUSTER_ID,
                                         ZCL_IDENTIFY_TIME_ATTRIBUTE_ID,
                                         (UINT8_T *)&time,
                                         ATTR_INT16U_ATTRIBUTE_TYPE);
  }
  return (status == EMBER_ZCL_STATUS_SUCCESS) ? TRUE:FALSE;
}

BOOL_T tkl_zg_identify_time_get(UINT8_T ep_id, UINT16_T *time)
{
  // Write the identify time.
  EmberAfStatus status = EMBER_ZCL_STATUS_UNSUPPORTED_ATTRIBUTE;

  if (emberAfContainsServer(ep_id, ZCL_IDENTIFY_CLUSTER_ID)) {
      status = emberAfReadServerAttribute(ep_id,
                                         ZCL_IDENTIFY_CLUSTER_ID,
                                         ZCL_IDENTIFY_TIME_ATTRIBUTE_ID,
                                         (UINT8_T *)time,
                                         sizeof(UINT16_T));
  }
  
  return (status == EMBER_ZCL_STATUS_SUCCESS) ? TRUE:FALSE;
}


BOOL_T tkl_zg_identify_start(UINT8_T ep_id, UINT16_T time)
{
    BOOL_T status = FALSE;
    __IDENTIFY_T *identify;

    if(!g_is_init) {
        return status;
    }
    if(ep_id == 0x00) {
        return status;
    }

    identify = __identity_table_entery(ep_id);
    if(identify == NULL) {
        return status;
    }
    identify_timer_tick_event_callback = __identify_timer_tick_event_handler;
    identify->doing = TRUE;
    tkl_identify_debug("identify start, ep %d, time %d\r\n", ep_id, time);
    status = __identify_time_update(time);

    return status;
}

BOOL_T tkl_zg_identify_stop(UINT8_T ep_id)
{
    return tkl_zg_identify_start(ep_id, 0);
}

BOOL_T tkl_zg_inner_identify_start(UINT8_T ep_id, UINT16_T time)
{
    return tkl_zg_identify_start(ep_id, time);
}

// call this API must after endpoint register
OPERATE_RET tkl_zg_identify_init(VOID_T)
{
    if(g_is_init) {
        return OPRT_OK;
    }
    
    UINT8_T ep_sum = tkl_zg_endpoint_count_get();
    identify_table = (__IDENTIFY_T*)IDENTIFY_MALLOC(sizeof(__IDENTIFY_T)*ep_sum);
    if(identify_table == NULL) {
        return OPRT_MALLOC_FAILED;
    }

    if(emberAfContainsClient(TUYA_PRIMARY_ENDPOINT, CLUSTER_IDENTIFY_CLUSTER_ID)) {
        g_identify_cb.client_parse_cb = emberAfIdentifyClusterClientCommandParse;
    }
    if(emberAfContainsServer(TUYA_PRIMARY_ENDPOINT, CLUSTER_IDENTIFY_CLUSTER_ID)) {
        g_identify_cb.server_parse_cb = emberAfIdentifyClusterServerCommandParse;
    }
    g_is_init = TRUE;

    return OPRT_OK;
}
