/*
 * @Author: Deven
 * @Email: liming@tuya.com
 * @LastEditors: Please set LastEditors
 * @FileName: &file name&
 * @Description: 
 * @Copyright: HANGZHOU TUYA INFORMATION TECHNOLOGY CO.,LTD
 * @Company: http://www.tuya.com
 * @Date: 2021-04-19 16:12:17
 * @LastEditTime: 2021-12-10 17:21:14
 */
#include "tkl_platform_types.h"
#include "tkl_zcl_ota.h"

#if defined (TUYA_RUNTIME_DBG)
#include "tkl_uart.h"
#define tkl_zcl_ota_debug(...)     tkl_dbg_printf(__VA_ARGS__)
#else
#define tkl_zcl_ota_debug(...)
#endif


typedef struct {
    UINT16_T manuf_id;      ///< manufacturer id
    UINT16_T image_type;    ///< ota image type
    UINT_T   fw_version;    ///< current firmware version
} __OTA_INFO_T;

__OTA_INFO_T g_ota_info;
TKL_ZG_OTA_CB g_zcl_ota_cb;

void emberAfOtaClientVersionInfoCallback(EmberAfOtaImageId* currentImageInfo,
                                         uint16_t* hardwareVersion)
{
  // This callback is fired when a new query and download is initiated.
  // The application will fill in the currentImageInfo with their manufacturer
  // ID, image type ID, and current software version number to use in that
  // query. The deviceSpecificFileEui64 can be ignored.

  // It may be necessary to dynamically determine this data by talking to
  // another device, as is the case with a host talking to an NCP device.

  // The OTA client plugin will cache the data returned by this callback
  // and use it for the subsequent transaction, which could be a query
  // or a query and download.  Therefore it is possible to instruct the
  // OTA client cluster code to query about multiple images by returning
  // different values.

  MEMSET(currentImageInfo, 0, sizeof(EmberAfOtaImageId));
  currentImageInfo->manufacturerId  = g_ota_info.manuf_id;
  currentImageInfo->imageTypeId     = g_ota_info.image_type;
  currentImageInfo->firmwareVersion = g_ota_info.fw_version;

  if (hardwareVersion != NULL) {
    *hardwareVersion = 0;
  }
}


VOID_T tkl_inner_ota_init(UINT_T app_ver, UINT16_T manuf_id, UINT16_T image_type)
{
    g_ota_info.manuf_id = manuf_id;
    g_ota_info.image_type = image_type;
    g_ota_info.fw_version = app_ver;
}

OPERATE_RET tkl_zg_register_ota_cb(TKL_ZG_OTA_CB *ota_cb)
{
    tkl_zcl_ota_debug("OTA register callback.\r\n");
    
    if(ota_cb == NULL) {
        return OPRT_INVALID_PARM;
    }
    g_zcl_ota_cb.start_notify = ota_cb->start_notify;
    g_zcl_ota_cb.end_notify = ota_cb->end_notify;

    return OPRT_OK; 
}

VOID_T tkl_ota_inner_init(VOID_T)
{
    emberAfOtaStorageDeleteImageCallback(NULL); //clear history data
}

