/*
 * @Author: Deven
 * @Email: liming@tuya.com
 * @LastEditors: Please set LastEditors
 * @FileName: &file name&
 * @Description: 
 * @Copyright: HANGZHOU TUYA INFORMATION TECHNOLOGY CO.,LTD
 * @Company: http://www.tuya.com
 * @Date: 2021-04-24 16:38:51
 * @LastEditTime: 2021-12-14 09:47:03
 */
#include "tkl_platform_types.h"
#include "tkl_zcl_scene.h"

#if defined (TUYA_RUNTIME_DBG)
#include "tkl_uart.h"
#define tkl_scene_debug(...)   tkl_dbg_printf(__VA_ARGS__)
#else
#define tkl_scene_debug(...)
#endif



TKL_SCENE_CB_T g_scene_cb;


BOOL_T tkl_zg_find_scene(UINT8_T ep_id, UINT8_T scene_id, UINT16_T group_id)
{
    EmberAfStatus status;
    EmberAfSceneTableEntry scene_entry;
    
    status = emberAfScenesClusterFindScene(ep_id,
                                            group_id,
                                            scene_id,
                                            &scene_entry);
    if(status != EMBER_ZCL_STATUS_SUCCESS) {
        return FALSE;
    }
    return TRUE;
}

// EMBER_BROADCAST_ENDPOINT remove all scene
VOID_T tkl_zg_clear_scene(UINT8_T ep_id)
{
    emberAfScenesClusterClearSceneTableCallback(ep_id);
}

VOID_T tkl_zg_clear_all_scene(VOID_T)
{
    emberAfScenesClusterClearSceneTableCallback(EMBER_BROADCAST_ENDPOINT);
}

UINT8_T tkl_zg_scene_size_get(VOID_T)
{
    return EMBER_AF_PLUGIN_SCENES_TABLE_SIZE;
}

OPERATE_RET tkl_zg_scene_cb_register(TKL_SCENE_CB_T *scene_cb)
{
    if(scene_cb == NULL) {
        return OPRT_INVALID_PARM;
    }
    g_scene_cb.save_scene_pre_cb = scene_cb->save_scene_pre_cb;
    g_scene_cb.save_scene_cb = scene_cb->save_scene_cb;
    g_scene_cb.view_scene_cb = scene_cb->view_scene_cb;
    g_scene_cb.recall_scene_cb = scene_cb->recall_scene_cb;
    g_scene_cb.remove_scene_cb = scene_cb->remove_scene_cb;
    g_scene_cb.remove_all_scene_cb = scene_cb->remove_all_scene_cb;

    return OPRT_OK;
}

OPERATE_RET tkl_zg_scene_recovery(TKL_MINI_SCENE_T *scene_list, UINT8_T sums)
{
    UINT8_T i;
    EmberAfSceneTableEntry entry;
         
    if(scene_list == NULL || sums == 0) {
        return OPRT_INVALID_PARM;
    }

    if(sums > tkl_zg_scene_size_get()) {
        return OPRT_INVALID_PARM;
    }
    tkl_scene_debug("scene recovery num %d\r\n", sums);
    emberAfPluginScenesServerSetNumSceneEntriesInUse(0);
    for(i=0; i<sums; i++) {
        entry.endpoint = scene_list[i].ep_id;
        entry.groupId = scene_list[i].group_id;
        entry.sceneId = scene_list[i].scene_id;
        entry.transitionTime = scene_list[i].trans_time;
        entry.transitionTime100ms = scene_list[i].trans_time100ms;
        tkl_scene_debug("scene recovery ep %d, sce %d, gp 0x%02x\r\n",entry.endpoint, entry.sceneId, entry.groupId);
        emberAfPluginScenesServerSaveSceneEntry(entry, i);
    }
    emberAfPluginScenesServerSetNumSceneEntriesInUse(i);

    return OPRT_OK;
}