#ifndef RSC_DEV_OTA_H
#define RSC_DEV_OTA_H
#include "rsc_device.h"

#define RSC_OTA_NV_NUM			2.0.0	// new version num
#define RSC_OTA_TYPE				"HTTP"	// OTA Download protocol type
#define _RSC_OTA_NV(name, num)		name##_v##num
#define RSC_OTA_NV(name, num)		_RSC_OTA_NV(name, num)	// OTA new version
#define _STR(x) #x
#define STR(x) _STR(x)


#define BUF_SIZE			4096
#define HEADER_BAK_LEN	32

typedef struct {
	unsigned char ratio;
	unsigned char loop;
	unsigned char nv_num[20];
} rsc_ota_v, *p_rsc_ota_v;

typedef struct {
	uint32_t	status_code;
	uint32_t	header_len;
	uint8_t		*body;
	uint32_t	body_len;
	uint8_t		*header_bak;
	uint32_t	parse_status;
} rsc_http_response_result_t;

void example_rsc(void);
void rsc_ota_down_ratio(uint32_t *dwn, uint32_t *total);
int rsc_http_update_ota(char *host, int port, char *resource);
#endif
