#include "sockets.h"
#include "cJSON.h"
#include "wifi_conf.h"
#include "FreeRTOS.h"
#include "osdep_service.h"
#include "autoconf.h"
#include "lwip_netconf.h"
#include "rsc_device.h"
#include "rsc_dev_ota.h"

static int RSC_OTASVR_PORT		= 0;
static char RSC_OTASVR_ADDR[16]	= {0};
static char rsc_otasvr_rsclct[100]	= {0};
static char rsc_test_pl[1001]		= {0};
static int rsc_dev_tcp_svr			= -1;
static int rsc_dev_tcp_ota			= -1;
static unsigned int rsc_dev_msg_seq= 0;
static _sema rsc_start_sema		= NULL;
static _sema rsc_stop_sema		= NULL;
static _timer rsc_alive_timer		= {0};
extern struct netif xnetif[NET_IF_NUM]; 

static char *security_to_str(rtw_security_t type)
{
	char *str;
	switch(type) {
		case RTW_SECURITY_OPEN:
			str = "OPEN";
			break;
		case RTW_SECURITY_WEP_PSK:
			str = "WEP";
			break;
		case RTW_SECURITY_WPA_TKIP_PSK:
			str = "TKIP";
			break;
		case RTW_SECURITY_WPA2_AES_PSK:
			str = "AES";
			break;
		default:
			str = "UNKNOWN";
	}
	return str;
}

static void rsc_alive_to(void *context)
{
	close(rsc_dev_tcp_svr);
	rsc_dev_tcp_svr = -1;
	rtw_up_sema(&rsc_stop_sema);
}

void rsc_dev_http_ota_report(void *p)
{
	rsc_msg_v v = {0};
	unsigned char ratio;
	static unsigned char ratio_last;
	unsigned int dwn_len, total_len;

	ratio_last = 0;
	while(1) {
		rtw_msleep_os(20);
		rsc_ota_down_ratio(&dwn_len, &total_len);
		if(total_len > 0) {
			if(dwn_len <= total_len) {
				ratio = dwn_len*100/total_len;
				if((ratio - ratio_last >= 30 || ratio == 100) && (rsc_dev_tcp_svr >= 0)) {
					v.msg_t = MSG_OTA_RPT;
					v.ratio = ratio;
					rsc_dev_msg_dump((void *)&v);
					ratio_last = ratio;
				}
			}
			if(dwn_len == total_len) {
				break;
			}
		}
	}
	vTaskDelete(NULL);
}
int errno = 0;
void rsc_dev_http_ota(void *p)
{
	if(xTaskCreate(rsc_dev_http_ota_report, ((const char*)"ota_rpt"), 256, NULL, tskIDLE_PRIORITY + 1, NULL) != pdPASS)
		printf("\n\r%s xTaskCreate(dev_ota_rx) failed", __func__);
	//rsc_http_update_ota(RSC_OTASVR_ADDR, RSC_OTASVR_PORT, rsc_otasvr_rsclct);
	vTaskDelete(NULL);
}

void rsc_dev_msg_dump(void *p)
{
	char *msg_js = NULL;
	cJSON *msg_obj = NULL;
	cJSON_Hooks memoryHook;
	unsigned char *addr;
	p_rsc_msg_v p_msg_v = (p_rsc_msg_v)p;

	memoryHook.malloc_fn = malloc;
	memoryHook.free_fn = free;
	cJSON_InitHooks(&memoryHook);
	
	while(wifi_is_ready_to_transceive(0) != 0) {
		printf("[INFO] wait wifi connect !\r\n");
		rtw_msleep_os(1000);
	}
	if( rsc_dev_tcp_svr < 0) {
		// connect to server
		while(rsc_dev_cnt(CNT_SVR) < 0) {
			rtw_msleep_os(1000);
		}
		rsc_dev_msg_seq = 0;
	}
	
	if((msg_obj = cJSON_CreateObject()) != NULL) {
		unsigned char buf[35] = {0};
		addr = LwIP_GetMAC(&xnetif[0]);
		sprintf(buf, "%02x:%02x:%02x:%02x:%02x:%02x", addr[0], addr[1], addr[2], addr[3], addr[4], addr[5]);
		cJSON_AddItemToObject(msg_obj, "User_ID", cJSON_CreateString(RSC_USER_ID));
		cJSON_AddItemToObject(msg_obj, "Mac_Addr", cJSON_CreateString(buf));
		cJSON_AddItemToObject(msg_obj, "Net_Type", cJSON_CreateString(RSC_NET_TYPE));
		cJSON_AddItemToObject(msg_obj, "IC_Type", cJSON_CreateString(RSC_IC_TYPE));
		cJSON_AddItemToObject(msg_obj, "SW_Ver", cJSON_CreateString(RSC_SW_VER));
		if(p_msg_v->seq_c) {
			cJSON_AddItemToObject(msg_obj, "Seq_Num", cJSON_CreateNumber(p_msg_v->seq_c));
		}else {
			cJSON_AddItemToObject(msg_obj, "Seq_Num", cJSON_CreateNumber(++rsc_dev_msg_seq));
		}
		switch(p_msg_v->msg_t) {
		case MSG_REG:
			cJSON_AddItemToObject(msg_obj, "Msg_Type", cJSON_CreateString("Regist_Dev"));
			cJSON_AddItemToObject(msg_obj, "Boot_Reason", cJSON_CreateString("Software"));
			cJSON_AddItemToObject(msg_obj, "Connect_Reason", cJSON_CreateString("Boot"));
			break;
		case MSG_HB:
			int rssi;
			rtw_wifi_setting_t ap_info;
			if(wifi_get_setting(WLAN0_NAME, &ap_info) < 0) {
				printf("[ERROR] %s:get wifi setting fail !\r\n", __func__);
			}

			cJSON_AddItemToObject(msg_obj, "Msg_Type", cJSON_CreateString("HeartBeat_Dev"));

			rtw_memset(buf, 0, sizeof(buf));
			strcpy(buf, ap_info.ssid);
			cJSON_AddItemToObject(msg_obj, "SSID", cJSON_CreateString(buf));

			rtw_memset(buf, 0, sizeof(buf));
			wifi_get_ap_bssid(buf);
			sprintf(&buf[ETH_ALEN], "%02x:%02x:%02x:%02x:%02x:%02x", buf[0], buf[1], buf[2], buf[3], buf[4], buf[5]);
			cJSON_AddItemToObject(msg_obj, "BSSID", cJSON_CreateString(&buf[ETH_ALEN]));
			cJSON_AddItemToObject(msg_obj, "Security", cJSON_CreateString(security_to_str(ap_info.security_type)));
			cJSON_AddItemToObject(msg_obj, "Channel", cJSON_CreateNumber(ap_info.channel));

			addr = LwIP_GetIP(&xnetif[0]);
			rtw_memset(buf, 0, sizeof(buf));
			sprintf(buf, "%d:%d:%d:%d", addr[0], addr[1], addr[2], addr[3]);
			cJSON_AddItemToObject(msg_obj, "IP_Addr", cJSON_CreateString(buf));

			addr = LwIP_GetGW(&xnetif[0]);;
			rtw_memset(buf, 0, sizeof(buf));
			sprintf(buf, "%d:%d:%d:%d", addr[0], addr[1], addr[2], addr[3]);
			cJSON_AddItemToObject(msg_obj, "GW_Addr", cJSON_CreateString(buf));

			wifi_get_rssi(&rssi);
			cJSON_AddItemToObject(msg_obj, "RSSI", cJSON_CreateNumber(rssi));
			cJSON_AddItemToObject(msg_obj, "Tick", cJSON_CreateNumber(rtw_get_current_time()));

			rtw_set_timer(&rsc_alive_timer, RSC_CLOUDALIVE_TO);
			break;
		case MSG_TEST:
			if(p_msg_v->v > sizeof(rsc_test_pl)-1) {
				p_msg_v->v = sizeof(rsc_test_pl)-1;
				printf("[ERROR] %s:get wifi setting fail !\r\n", __func__);
			}
			rtw_memset(rsc_test_pl, 0, p_msg_v->v +1);
			for(int i=0; i<p_msg_v->v;) {
				rsc_test_pl[i++] = 'a';
			}
			cJSON_AddItemToObject(msg_obj, "Msg_Type", cJSON_CreateString("Test_Dev"));
			cJSON_AddItemToObject(msg_obj, "Dev_Length", cJSON_CreateNumber(p_msg_v->v));
			cJSON_AddItemToObject(msg_obj, "Payload", cJSON_CreateString(rsc_test_pl));
			break;		
		case MSG_GET_HEAP:
			cJSON_AddItemToObject(msg_obj, "Msg_Type", cJSON_CreateString("Get_Dev"));
			cJSON_AddItemToObject(msg_obj, "Get_Type", cJSON_CreateString("Heap"));
			cJSON_AddItemToObject(msg_obj, "Value", cJSON_CreateNumber(rtw_getFreeHeapSize()));
			break;		
		case MSG_OTA_REQ:
			cJSON_AddItemToObject(msg_obj, "Msg_Type", cJSON_CreateString("OTA_Req_Dev"));
			cJSON_AddItemToObject(msg_obj, "OTA_Type", cJSON_CreateString(RSC_OTA_TYPE));
			cJSON_AddItemToObject(msg_obj, "Loop", cJSON_CreateNumber(p_msg_v->loop));		// 1 loop; 0 once
			if(strlen(p_msg_v->nv_num) == 0) {
				cJSON_AddItemToObject(msg_obj, "New_Ver", cJSON_CreateString(STR(RSC_OTA_NV(RSC_FW_NAME, RSC_OTA_NV_NUM))));
			}else {
				rtw_memset(buf, 0, sizeof(buf));
				strcpy(buf, STR(RSC_OTA_NV(RSC_FW_NAME, )));
				strcpy(&buf[strlen(buf)], p_msg_v->nv_num);
				cJSON_AddItemToObject(msg_obj, "New_Ver", cJSON_CreateString(buf));
			}
			break;
		case MSG_OTA_RPT:
			cJSON_AddItemToObject(msg_obj, "Msg_Type", cJSON_CreateString("OTA_Rpt_Dev"));
			cJSON_AddItemToObject(msg_obj, "OTA_Type", cJSON_CreateString(RSC_OTA_TYPE));
			cJSON_AddItemToObject(msg_obj, "Progress", cJSON_CreateNumber(p_msg_v->ratio));
			if(p_msg_v->ratio < 100) {
				cJSON_AddItemToObject(msg_obj, "State", cJSON_CreateString("Ongoing"));
			}else if(p_msg_v->ratio == 100) {
				cJSON_AddItemToObject(msg_obj, "State", cJSON_CreateString("Done"));
			}
			break;
		case MSG_OTA_STP:
			cJSON_AddItemToObject(msg_obj, "Msg_Type", cJSON_CreateString("OTA_Stp_Dev"));
			break;
		default:
			break;	
		}
		
		msg_js = cJSON_Print(msg_obj);
		cJSON_Delete(msg_obj);
	}
	
	if(msg_js) {
		char *end_char = "end";
		char *new_msg = (char *)malloc(strlen(msg_js)+strlen(end_char)+1);
		sprintf(new_msg,"%s%s",msg_js,end_char);
		if(send(rsc_dev_tcp_svr, new_msg, strlen(new_msg), 0) <= 0) {
			printf("[ERROR] %s: TCP client send data error\r\n",__func__);
			close(rsc_dev_tcp_svr);
			rsc_dev_tcp_svr = -1;
		}
		rtw_free(msg_js);
		rtw_free(new_msg);
	}
}

void rsc_cloud_msg_process(char *msg_json)
{
	cJSON_Hooks memoryHook;
	cJSON *msg_obj, *type_obj, *temp_obj;
	rsc_msg_v msg_v = {0};
	
	memoryHook.malloc_fn = malloc;
	memoryHook.free_fn = free;
	cJSON_InitHooks(&memoryHook);
	
	if(((msg_obj = cJSON_Parse(msg_json)) != NULL) && ((type_obj = cJSON_GetObjectItem(msg_obj, "Msg_Type")) != NULL)) {
		if(!strcmp(type_obj->valuestring, "HeartBeat_Cloud")) {
			if(type_obj = cJSON_GetObjectItem(msg_obj, "Seq_Num")) {
				printf("==>Cloud> HB %d\r\n", type_obj->valueint);
				rtw_cancel_timer(&rsc_alive_timer);
			}
		}else if(!strcmp(type_obj->valuestring, "Get_Cloud")) {
			if(type_obj = cJSON_GetObjectItem(msg_obj, "Get_Type")) {
				printf("==>Cloud> Get '%s'\r\n", type_obj->valuestring);
				if(!strcmp(type_obj->valuestring, "Heap")) {
					msg_v.msg_t = MSG_GET_HEAP;
				}else {

				}
				if(temp_obj = cJSON_GetObjectItem(msg_obj, "Seq_Num")) {
					msg_v.seq_c = temp_obj->valueint;
				}
				rsc_dev_msg_dump((void *)&msg_v);
			}
		}else if(!strcmp(type_obj->valuestring, "Test_Cloud")) {
			if(type_obj = cJSON_GetObjectItem(msg_obj, "Cloud_Length")) {
				if(temp_obj = cJSON_GetObjectItem(msg_obj, "Payload")) {
					if(strlen(temp_obj->valuestring) == type_obj->valueint) {
						printf("==>Cloud> Test (%d-", type_obj->valueint);
						if(temp_obj = cJSON_GetObjectItem(msg_obj, "Dev_Length")) {
							printf("%d)", temp_obj->valueint);
							if(type_obj = cJSON_GetObjectItem(msg_obj, "Seq_Num")) {
								msg_v.seq_c = type_obj->valueint;
							}
							msg_v.msg_t = MSG_TEST;
							msg_v.v = temp_obj->valueint;
							rsc_dev_msg_dump((void *)&msg_v);
						}
					}else {
						printf("==>Cloud> Test (%d != %d) !!!", type_obj->valueint, strlen(temp_obj->valuestring));
					}
					printf("\r\n");
				}
			}
		}else if(!strcmp(type_obj->valuestring, "Control_Cloud")) {
			if(type_obj = cJSON_GetObjectItem(msg_obj, "Control_Type")) {
				printf("==>Cloud> Control %s", type_obj->valuestring);
				if(!strcmp(type_obj->valuestring, "GPIO")) {
					if(type_obj = cJSON_GetObjectItem(msg_obj, "Pin")) {
						printf(" %s", type_obj->valuestring);
						if(type_obj = cJSON_GetObjectItem(msg_obj, "Value")) {
							printf(" %d", type_obj->valueint);
						}
					}
				}else if(!strcmp(type_obj->valuestring, "PWM")) {	
					if(type_obj = cJSON_GetObjectItem(msg_obj, "Pin")) {
						printf(" %s", type_obj->valuestring);
						if(type_obj = cJSON_GetObjectItem(msg_obj, "Value")) {
							printf(" %d", type_obj->valueint);
						}
					}
				}
				printf("\r\n");
			}
		}else if(!strcmp(type_obj->valuestring, "OTA_Cmd_Cloud")) {
			if(type_obj = cJSON_GetObjectItem(msg_obj, "Fail_Detail")) {
				printf("==>Cloud> OTA Fail : %s !!!\r\n", type_obj->valuestring);
			}else {			
				printf("==>Cloud> OTA cmd\r\n");
				if(type_obj = cJSON_GetObjectItem(msg_obj, "IP_Addr")) {
					printf("ip: %s\r\n", type_obj->valuestring);
					strcpy(RSC_OTASVR_ADDR, type_obj->valuestring);
				}
				if(type_obj = cJSON_GetObjectItem(msg_obj, "Port")) {
					printf("port: %d\r\n", type_obj->valueint);
					RSC_OTASVR_PORT = type_obj->valueint;
				}
				if(type_obj = cJSON_GetObjectItem(msg_obj, "Bin")) {
					printf("bin: %s\r\n\n", type_obj->valuestring);
					strcpy(rsc_otasvr_rsclct, type_obj->valuestring);
				}

				if(xTaskCreate(rsc_dev_http_ota, ((const char*)"dev_http_ota"), 512, NULL, tskIDLE_PRIORITY + 1, NULL) != pdPASS)
					printf("\n\r%s xTaskCreate(dev_ota_rx) failed", __func__);
			}
		}else if(!strcmp(type_obj->valuestring, "Regist_Cloud")) {
			if(type_obj = cJSON_GetObjectItem(msg_obj, "State")) {
				printf("==>Cloud> Reg %s\r\n", type_obj->valuestring);
				if(!strcmp(type_obj->valuestring, "Success")) {
					rtw_up_sema(&rsc_start_sema);
				}
			}
		}else if(!strcmp(type_obj->valuestring, "Release_Cloud")) {
			if(type_obj = cJSON_GetObjectItem(msg_obj, "Reason")) {
				printf("==>Cloud> Release : %s !!!\r\n", type_obj->valuestring);
			}
			rtw_set_timer(&rsc_alive_timer, 0);
		}else {
			printf("==>Cloud> %s (Unknown Msg type !!!)\r\n", type_obj->valuestring);
		}
	}
	cJSON_Delete(msg_obj);
}

void rsc_dev_rx_svr(void *p)
{
	int ret, maxfd;
	struct timeval  selectTimeOut;

	char *rx_buf = rtw_zmalloc(2048);
	if(rx_buf == NULL) {
		goto Error;
	}
	while(1) {
		fd_set  readfds;
		FD_ZERO(&readfds);
		FD_SET(rsc_dev_tcp_svr, &readfds);
		selectTimeOut.tv_usec = 0L;
		selectTimeOut.tv_sec = (long)1;

		maxfd = (rsc_dev_tcp_svr > rsc_dev_tcp_ota) ? rsc_dev_tcp_svr : rsc_dev_tcp_ota;
		ret = select(maxfd + 1, &readfds, NULL, NULL, &selectTimeOut);
		if (ret < 0) {
			printf("[ERROR]%s: Select ERR: %s !\r\n", __func__, strerror(errno));
			continue;
		}else if (ret == 0) {
			continue;
		}

		if (FD_ISSET(rsc_dev_tcp_svr, &readfds)) {
			char temp;
			char *p1 = rx_buf, *p2 = NULL;
			int len1 = 0, len2  = 0;
Rerx:
			rtw_memset((void *)p1, 0, 2048 - len2);
			ret = recv(rsc_dev_tcp_svr, (void *)p1, 2047-len2, 0); 
			if(ret < 0) {
				printf("[ERROR] %s: rx data fail !\r\n",__func__);
				goto Error;
			}else if(ret > 0) {
				//printf("==> RX:\r\n%s\r\n", p1);
				p1 = rx_buf;
				if(*p1 != NULL && *p1 != '{') {
					p2 = strstr(p1, "{");
					if(p2 == NULL) {
						printf("==>Cloud> %s\r\n", p1);
						continue;
					}else {
						*p2 = '\0';
						printf("==>Cloud> %s\r\n", p1);
						*p2 = '{';
						p1 = p2;
					}
				}
				 while(*p1 != NULL && (p2 = strstr(p1, "}")) != NULL) {	
					temp = *(p2+1);
					*(p2+1) = '\0';
					rsc_cloud_msg_process(p1);
					*(p2+1) = temp;
					p1 = p2+1;
				 }

				 if(*p1 != NULL && p1 != rx_buf) {
					len2 = strlen(p1);
					rtw_memcpy(rx_buf, p1, len2);
					p1 = &rx_buf[len2];
					goto Rerx;
				 }
			}
		}
	}

Error:
	close(rsc_dev_tcp_svr);
	rsc_dev_tcp_svr = -1;
	printf("[ERROR]%s:  delete task !\r\n", __func__);
	vTaskDelete(NULL);
}

int rsc_dev_cnt(int type)
{
	int *socket_fd, socket_ruse=1;
	int socket_target_port;
	char *socket_target_addr;
	
	struct sockaddr_in	svr_addr;
	
	if(type == CNT_SVR) {
		socket_fd = &rsc_dev_tcp_svr;
		socket_target_port = RSC_SVR_PORT;
		socket_target_addr = RSC_SVR_ADDR;
	}else if(type == CNT_OTA) {
		socket_fd = &rsc_dev_tcp_ota;
		socket_target_port = RSC_OTASVR_PORT;
		socket_target_addr = RSC_OTASVR_ADDR;
	}

	if(*socket_fd < 0) {
		//Connecting to server
		if((*socket_fd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0) {
			printf("[ERROR] %s: TCP client create error\r\n",__func__);
			goto Error;
		}else {
			printf("\r\n==>%s: Create socket fd = %d\r\n", __func__, *socket_fd);
			setsockopt(*socket_fd, SOL_SOCKET, SO_REUSEADDR, (char *)&socket_ruse, sizeof(socket_ruse));
		}
		
		rtw_memset(&svr_addr, 0, sizeof(svr_addr));
		svr_addr.sin_family = AF_INET;
		svr_addr.sin_port = htons(socket_target_port);
		svr_addr.sin_addr.s_addr = inet_addr(socket_target_addr);
		if( connect(*socket_fd, (struct sockaddr*)&svr_addr, sizeof(svr_addr)) < 0){
			printf("[ERROR] %s: TCP client connect error\r\n",__func__);
			goto Error;
		}
		if(type == CNT_SVR) {
			printf("==>%s: Connect to server success !\r\n",__func__);
			if(xTaskCreate(rsc_dev_rx_svr, ((const char*)"dev_rx"), 512, NULL, tskIDLE_PRIORITY + 1, NULL) != pdPASS)
				printf("\n\r%s xTaskCreate(dev_rx) failed", __func__);
		}else if(type == CNT_OTA) {
			printf("==>%s: Connect to HTTP server success !\r\n",__func__);
		}
	}
	return RSC_OK;
	
Error:	
	if(*socket_fd >= 0) {
		closesocket(*socket_fd);
		*socket_fd = -1;
	}
	return RSC_CNT_SVR_FAIL;
}


void rsc_task(void *p)
{	
	rsc_msg_v msg_v = {0};

	if(rsc_start_sema == NULL) {
		rtw_init_sema(&rsc_start_sema, 0);
	}
	if(rsc_stop_sema == NULL) {
		rtw_init_sema(&rsc_stop_sema, 0);
	}
	rtw_init_timer(&rsc_alive_timer, NULL, rsc_alive_to, NULL, "rsctimer");
	
RSTART:
	// register dev
	msg_v.msg_t = MSG_REG;
	rsc_dev_msg_dump((void *)&msg_v);
	
	if(rtw_down_sema(&rsc_start_sema)) {
		rtw_msleep_os(100);
	}
	
	// report HeartBeat
	msg_v.msg_t = MSG_HB;
	while(1) {
		rsc_dev_msg_dump((void *)&msg_v);
		//rtw_msleep_os(5000);
		if(1 == rtw_down_timeout_sema(&rsc_stop_sema, RSC_HB_INTERVAL)) {
			printf("\r\n==>>>>> Restart <<<<<==\r\n\n");
			goto RSTART;
		}
	}
}

void example_rsc(void)
{
//	extern uint32_t sys_update_ota_get_curr_fw_idx(void);
//	printf("\r\n==>[%s] current fw idx: %d\r\n", __func__, sys_update_ota_get_curr_fw_idx());

	if(xTaskCreate(rsc_task, ((const char*)"example_rsc"), 1024, NULL, tskIDLE_PRIORITY + 1, NULL) != pdPASS)
		printf("\n\r%s xTaskCreate(example_rsc) failed", __func__);
}

