#ifndef RSC_DEVICE_H
#define RSC_DEVICE_H

#define RSC_USER_ID			"alan_chen"		// user id
#define RSC_SVR_ADDR			"192.168.31.77"	// rsc server ip
#define RSC_SVR_PORT			1234			// rsc server port

#define RSC_SW_VER			"1.0.0"			// current sw version
#define RSC_FW_NAME			firmware_is		// firmware name:Z2-firmware_is; Z-image2_all_ota1
#define RSC_NET_TYPE			"TCP"			// net type to connect to rsc server: TCP,SSL,MQTT
#define RSC_HB_INTERVAL		5000			// device heartbeat interval
#define RSC_CLOUDALIVE_TO		(RSC_HB_INTERVAL*4)// cloud isalive timeout

#if defined(CONFIG_PLATFORM_8710C)
#define RSC_IC_TYPE			"AmebaZ2"		// current IC type
#elif defined(CONFIG_PLATFORM_8721D)
#define RSC_IC_TYPE			"AmebaD"
#elif defined(CONFIG_PLATFORM_8711B)
#define RSC_IC_TYPE			"AmebaZ"
#elif defined(CONFIG_PLATFORM_8195A)
#define RSC_IC_TYPE			"Ameba1"
#elif defined(CONFIG_PLATFORM_8195BHP)
#define RSC_IC_TYPE			"AmebaPro"
#endif

enum {
	MSG_REG	= 0,
	MSG_HB,
	MSG_TEST,	
	MSG_GET_ALL,
	MSG_GET_HEAP,
	MSG_CTL_GPIO,
	MSG_OTA_REQ,
	MSG_OTA_RPT,
	MSG_OTA_STP,
};

enum {
	CNT_SVR	= 0,
	CNT_OTA,
};

enum {
	RSC_OK			= 0,
	RSC_CNT_SVR_FAIL	= -1,
};

typedef struct {
	int msg_t;
	int opt_t;
	unsigned int seq_c;
	unsigned int v;
	unsigned char tgt[20];
	unsigned char ratio;
	unsigned char loop;
	unsigned char nv_num[20];
} rsc_msg_v, *p_rsc_msg_v;

void rsc_dev_msg_dump(void *);
int rsc_dev_cnt(int type);

#endif
