/*
 *  Routines to access hardware
 *
 *  Copyright (c) 2013 Realtek Semiconductor Corp.
 *
 *  This module is a confidential and proprietary property of RealTek and
 *  possession or use of this module requires written permission of RealTek.
 */

#ifndef _RTL8195A_I2C_H_
#define _RTL8195A_I2C_H_

#include "hal_api.h"

//================ Register Bit Field ==================
//2 REG_DW_I2C_IC_CON
#define BIT_IC_CON_IC_SLAVE_DISABLE           	BIT(6)
#define BIT_SHIFT_IC_CON_IC_SLAVE_DISABLE     	6
#define BIT_MASK_IC_CON_IC_SLAVE_DISABLE      	0x1
#define BIT_CTRL_IC_CON_IC_SLAVE_DISABLE(x)   	(((x) & BIT_MASK_IC_CON_IC_SLAVE_DISABLE) << BIT_SHIFT_IC_CON_IC_SLAVE_DISABLE)

#define BIT_IC_CON_IC_RESTART_EN              	BIT(5)
#define BIT_SHIFT_IC_CON_IC_RESTART_EN        	5
#define BIT_MASK_IC_CON_IC_RESTART_EN         	0x1
#define BIT_CTRL_IC_CON_IC_RESTART_EN(x)      	(((x) & BIT_MASK_IC_CON_IC_RESTART_EN) << BIT_SHIFT_IC_CON_IC_RESTART_EN)

#define BIT_IC_CON_IC_10BITADDR_MASTER        	BIT(4)
#define BIT_SHIFT_IC_CON_IC_10BITADDR_MASTER  	4
#define BIT_MASK_IC_CON_IC_10BITADDR_MASTER   	0x1
#define BIT_CTRL_IC_CON_IC_10BITADDR_MASTER(x)	(((x) & BIT_MASK_IC_CON_IC_10BITADDR_MASTER) << BIT_SHIFT_IC_CON_IC_10BITADDR_MASTER)

#define BIT_IC_CON_IC_10BITADDR_SLAVE         	BIT(3)
#define BIT_SHIFT_IC_CON_IC_10BITADDR_SLAVE   	3
#define BIT_MASK_IC_CON_IC_10BITADDR_SLAVE    	0x1
#define BIT_CTRL_IC_CON_IC_10BITADDR_SLAVE(x) 	(((x) & BIT_MASK_IC_CON_IC_10BITADDR_SLAVE) << BIT_SHIFT_IC_CON_IC_10BITADDR_SLAVE)


#define BIT_SHIFT_IC_CON_SPEED 1
#define BIT_MASK_IC_CON_SPEED 0x3
#define BIT_IC_CON_SPEED(x)                   	(((x) & BIT_MASK_IC_CON_SPEED) << BIT_SHIFT_IC_CON_SPEED)
#define BIT_CTRL_IC_CON_SPEED(x)              	(((x) & BIT_MASK_IC_CON_SPEED) << BIT_SHIFT_IC_CON_SPEED)
#define BIT_GET_IC_CON_SPEED(x)               	(((x) >> BIT_SHIFT_IC_CON_SPEED) & BIT_MASK_IC_CON_SPEED)

#define BIT_IC_CON_MASTER_MODE                	BIT(0)
#define BIT_SHIFT_IC_CON_MASTER_MODE          	0
#define BIT_MASK_IC_CON_MASTER_MODE           	0x1
#define BIT_CTRL_IC_CON_MASTER_MODE(x)        	(((x) & BIT_MASK_IC_CON_MASTER_MODE) << BIT_SHIFT_IC_CON_MASTER_MODE)


//2 REG_DW_I2C_IC_TAR
#define BIT_IC_TAR_IC_10BITADDR_MASTER        	BIT(12)
#define BIT_SHIFT_IC_TAR_IC_10BITADDR_MASTER  	12
#define BIT_MASK_IC_TAR_IC_10BITADDR_MASTER   	0x1
#define BIT_CTRL_IC_TAR_IC_10BITADDR_MASTER(x)	(((x) & BIT_MASK_IC_TAR_IC_10BITADDR_MASTER) << BIT_SHIFT_IC_TAR_IC_10BITADDR_MASTER)

#define BIT_IC_TAR_SPECIAL                    	BIT(11)
#define BIT_SHIFT_IC_TAR_SPECIAL              	11
#define BIT_MASK_IC_TAR_SPECIAL               	0x1
#define BIT_CTRL_IC_TAR_SPECIAL(x)            	(((x) & BIT_MASK_IC_TAR_SPECIAL) << BIT_SHIFT_IC_TAR_SPECIAL)

#define BIT_IC_TAR_GC_OR_START                	BIT(10)
#define BIT_SHIFT_IC_TAR_GC_OR_START          	10
#define BIT_MASK_IC_TAR_GC_OR_START           	0x1
#define BIT_CTRL_IC_TAR_GC_OR_START(x)        	(((x) & BIT_MASK_IC_TAR_GC_OR_START) << BIT_SHIFT_IC_TAR_GC_OR_START)


#define BIT_SHIFT_IC_TAR 0
#define BIT_MASK_IC_TAR 0x3ff
#define BIT_IC_TAR(x)                         	(((x) & BIT_MASK_IC_TAR) << BIT_SHIFT_IC_TAR)
#define BIT_CTRL_IC_TAR(x)                    	(((x) & BIT_MASK_IC_TAR) << BIT_SHIFT_IC_TAR)
#define BIT_GET_IC_TAR(x)                     	(((x) >> BIT_SHIFT_IC_TAR) & BIT_MASK_IC_TAR)


//2 REG_DW_I2C_IC_SAR

#define BIT_SHIFT_IC_SAR 0
#define BIT_MASK_IC_SAR 0x3ff
#define BIT_IC_SAR(x)                         	(((x) & BIT_MASK_IC_SAR) << BIT_SHIFT_IC_SAR)
#define BIT_CTRL_IC_SAR(x)                    	(((x) & BIT_MASK_IC_SAR) << BIT_SHIFT_IC_SAR)
#define BIT_GET_IC_SAR(x)                     	(((x) >> BIT_SHIFT_IC_SAR) & BIT_MASK_IC_SAR)


//2 REG_DW_I2C_IC_HS_MADDR

#define BIT_SHIFT_IC_HS_MADDR 0
#define BIT_MASK_IC_HS_MADDR 0x7
#define BIT_IC_HS_MADDR(x)                    	(((x) & BIT_MASK_IC_HS_MADDR) << BIT_SHIFT_IC_HS_MADDR)
#define BIT_CTRL_IC_HS_MADDR(x)               	(((x) & BIT_MASK_IC_HS_MADDR) << BIT_SHIFT_IC_HS_MADDR)
#define BIT_GET_IC_HS_MADDR(x)                	(((x) >> BIT_SHIFT_IC_HS_MADDR) & BIT_MASK_IC_HS_MADDR)


//2 REG_DW_I2C_IC_DATA_CMD
#define BIT_IC_DATA_CMD_RESTART               	BIT(10)
#define BIT_SHIFT_IC_DATA_CMD_RESTART         	10
#define BIT_MASK_IC_DATA_CMD_RESTART          	0x1
#define BIT_CTRL_IC_DATA_CMD_RESTART(x)       	(((x) & BIT_MASK_IC_DATA_CMD_RESTART) << BIT_SHIFT_IC_DATA_CMD_RESTART)

#define BIT_IC_DATA_CMD_STOP                  	BIT(9)
#define BIT_SHIFT_IC_DATA_CMD_STOP            	9
#define BIT_MASK_IC_DATA_CMD_STOP             	0x1
#define BIT_CTRL_IC_DATA_CMD_STOP(x)          	(((x) & BIT_MASK_IC_DATA_CMD_STOP) << BIT_SHIFT_IC_DATA_CMD_STOP)

#define BIT_IC_DATA_CMD_CMD                   	BIT(8)
#define BIT_SHIFT_IC_DATA_CMD_CMD             	8
#define BIT_MASK_IC_DATA_CMD_CMD              	0x1
#define BIT_CTRL_IC_DATA_CMD_CMD(x)           	(((x) & BIT_MASK_IC_DATA_CMD_CMD) << BIT_SHIFT_IC_DATA_CMD_CMD)


#define BIT_SHIFT_IC_DATA_CMD_DAT 0
#define BIT_MASK_IC_DATA_CMD_DAT 0xff
#define BIT_IC_DATA_CMD_DAT(x)                	(((x) & BIT_MASK_IC_DATA_CMD_DAT) << BIT_SHIFT_IC_DATA_CMD_DAT)
#define BIT_CTRL_IC_DATA_CMD_DAT(x)           	(((x) & BIT_MASK_IC_DATA_CMD_DAT) << BIT_SHIFT_IC_DATA_CMD_DAT)
#define BIT_GET_IC_DATA_CMD_DAT(x)            	(((x) >> BIT_SHIFT_IC_DATA_CMD_DAT) & BIT_MASK_IC_DATA_CMD_DAT)


//2 REG_DW_I2C_IC_SS_SCL_HCNT

#define BIT_SHIFT_IC_SS_SCL_HCNT 0
#define BIT_MASK_IC_SS_SCL_HCNT 0xffff
#define BIT_IC_SS_SCL_HCNT(x)                 	(((x) & BIT_MASK_IC_SS_SCL_HCNT) << BIT_SHIFT_IC_SS_SCL_HCNT)
#define BIT_CTRL_IC_SS_SCL_HCNT(x)            	(((x) & BIT_MASK_IC_SS_SCL_HCNT) << BIT_SHIFT_IC_SS_SCL_HCNT)
#define BIT_GET_IC_SS_SCL_HCNT(x)             	(((x) >> BIT_SHIFT_IC_SS_SCL_HCNT) & BIT_MASK_IC_SS_SCL_HCNT)


//2 REG_DW_I2C_IC_SS_SCL_LCNT

#define BIT_SHIFT_IC_SS_SCL_LCNT 0
#define BIT_MASK_IC_SS_SCL_LCNT 0xffff
#define BIT_IC_SS_SCL_LCNT(x)                 	(((x) & BIT_MASK_IC_SS_SCL_LCNT) << BIT_SHIFT_IC_SS_SCL_LCNT)
#define BIT_CTRL_IC_SS_SCL_LCNT(x)            	(((x) & BIT_MASK_IC_SS_SCL_LCNT) << BIT_SHIFT_IC_SS_SCL_LCNT)
#define BIT_GET_IC_SS_SCL_LCNT(x)             	(((x) >> BIT_SHIFT_IC_SS_SCL_LCNT) & BIT_MASK_IC_SS_SCL_LCNT)


//2 REG_DW_I2C_IC_FS_SCL_HCNT

#define BIT_SHIFT_IC_FS_SCL_HCNT 0
#define BIT_MASK_IC_FS_SCL_HCNT 0xffff
#define BIT_IC_FS_SCL_HCNT(x)                 	(((x) & BIT_MASK_IC_FS_SCL_HCNT) << BIT_SHIFT_IC_FS_SCL_HCNT)
#define BIT_CTRL_IC_FS_SCL_HCNT(x)            	(((x) & BIT_MASK_IC_FS_SCL_HCNT) << BIT_SHIFT_IC_FS_SCL_HCNT)
#define BIT_GET_IC_FS_SCL_HCNT(x)             	(((x) >> BIT_SHIFT_IC_FS_SCL_HCNT) & BIT_MASK_IC_FS_SCL_HCNT)


//2 REG_DW_I2C_IC_FS_SCL_LCNT

#define BIT_SHIFT_IC_FS_SCL_LCNT 0
#define BIT_MASK_IC_FS_SCL_LCNT 0xffff
#define BIT_IC_FS_SCL_LCNT(x)                 	(((x) & BIT_MASK_IC_FS_SCL_LCNT) << BIT_SHIFT_IC_FS_SCL_LCNT)
#define BIT_CTRL_IC_FS_SCL_LCNT(x)            	(((x) & BIT_MASK_IC_FS_SCL_LCNT) << BIT_SHIFT_IC_FS_SCL_LCNT)
#define BIT_GET_IC_FS_SCL_LCNT(x)             	(((x) >> BIT_SHIFT_IC_FS_SCL_LCNT) & BIT_MASK_IC_FS_SCL_LCNT)


//2 REG_DW_I2C_IC_HS_SCL_HCNT

#define BIT_SHIFT_IC_HS_SCL_HCNT 0
#define BIT_MASK_IC_HS_SCL_HCNT 0xffff
#define BIT_IC_HS_SCL_HCNT(x)                 	(((x) & BIT_MASK_IC_HS_SCL_HCNT) << BIT_SHIFT_IC_HS_SCL_HCNT)
#define BIT_CTRL_IC_HS_SCL_HCNT(x)            	(((x) & BIT_MASK_IC_HS_SCL_HCNT) << BIT_SHIFT_IC_HS_SCL_HCNT)
#define BIT_GET_IC_HS_SCL_HCNT(x)             	(((x) >> BIT_SHIFT_IC_HS_SCL_HCNT) & BIT_MASK_IC_HS_SCL_HCNT)


//2 REG_DW_I2C_IC_HS_SCL_LCNT

#define BIT_SHIFT_IC_HS_SCL_LCNT 0
#define BIT_MASK_IC_HS_SCL_LCNT 0xffff
#define BIT_IC_HS_SCL_LCNT(x)                 	(((x) & BIT_MASK_IC_HS_SCL_LCNT) << BIT_SHIFT_IC_HS_SCL_LCNT)
#define BIT_CTRL_IC_HS_SCL_LCNT(x)            	(((x) & BIT_MASK_IC_HS_SCL_LCNT) << BIT_SHIFT_IC_HS_SCL_LCNT)
#define BIT_GET_IC_HS_SCL_LCNT(x)             	(((x) >> BIT_SHIFT_IC_HS_SCL_LCNT) & BIT_MASK_IC_HS_SCL_LCNT)


//2 REG_DW_I2C_IC_INTR_STAT
#define BIT_IC_INTR_STAT_R_GEN_CALL           	BIT(11)
#define BIT_SHIFT_IC_INTR_STAT_R_GEN_CALL     	11
#define BIT_MASK_IC_INTR_STAT_R_GEN_CALL      	0x1
#define BIT_CTRL_IC_INTR_STAT_R_GEN_CALL(x)   	(((x) & BIT_MASK_IC_INTR_STAT_R_GEN_CALL) << BIT_SHIFT_IC_INTR_STAT_R_GEN_CALL)

#define BIT_IC_INTR_STAT_R_START_DET          	BIT(10)
#define BIT_SHIFT_IC_INTR_STAT_R_START_DET    	10
#define BIT_MASK_IC_INTR_STAT_R_START_DET     	0x1
#define BIT_CTRL_IC_INTR_STAT_R_START_DET(x)  	(((x) & BIT_MASK_IC_INTR_STAT_R_START_DET) << BIT_SHIFT_IC_INTR_STAT_R_START_DET)

#define BIT_IC_INTR_STAT_R_STOP_DET           	BIT(9)
#define BIT_SHIFT_IC_INTR_STAT_R_STOP_DET     	9
#define BIT_MASK_IC_INTR_STAT_R_STOP_DET      	0x1
#define BIT_CTRL_IC_INTR_STAT_R_STOP_DET(x)   	(((x) & BIT_MASK_IC_INTR_STAT_R_STOP_DET) << BIT_SHIFT_IC_INTR_STAT_R_STOP_DET)

#define BIT_IC_INTR_STAT_R_ACTIVITY           	BIT(8)
#define BIT_SHIFT_IC_INTR_STAT_R_ACTIVITY     	8
#define BIT_MASK_IC_INTR_STAT_R_ACTIVITY      	0x1
#define BIT_CTRL_IC_INTR_STAT_R_ACTIVITY(x)   	(((x) & BIT_MASK_IC_INTR_STAT_R_ACTIVITY) << BIT_SHIFT_IC_INTR_STAT_R_ACTIVITY)

#define BIT_IC_INTR_STAT_R_RX_DONE            	BIT(7)
#define BIT_SHIFT_IC_INTR_STAT_R_RX_DONE      	7
#define BIT_MASK_IC_INTR_STAT_R_RX_DONE       	0x1
#define BIT_CTRL_IC_INTR_STAT_R_RX_DONE(x)    	(((x) & BIT_MASK_IC_INTR_STAT_R_RX_DONE) << BIT_SHIFT_IC_INTR_STAT_R_RX_DONE)

#define BIT_IC_INTR_STAT_R_TX_ABRT            	BIT(6)
#define BIT_SHIFT_IC_INTR_STAT_R_TX_ABRT      	6
#define BIT_MASK_IC_INTR_STAT_R_TX_ABRT       	0x1
#define BIT_CTRL_IC_INTR_STAT_R_TX_ABRT(x)    	(((x) & BIT_MASK_IC_INTR_STAT_R_TX_ABRT) << BIT_SHIFT_IC_INTR_STAT_R_TX_ABRT)

#define BIT_IC_INTR_STAT_R_RD_REQ             	BIT(5)
#define BIT_SHIFT_IC_INTR_STAT_R_RD_REQ       	5
#define BIT_MASK_IC_INTR_STAT_R_RD_REQ        	0x1
#define BIT_CTRL_IC_INTR_STAT_R_RD_REQ(x)     	(((x) & BIT_MASK_IC_INTR_STAT_R_RD_REQ) << BIT_SHIFT_IC_INTR_STAT_R_RD_REQ)

#define BIT_IC_INTR_STAT_R_TX_EMPTY           	BIT(4)
#define BIT_SHIFT_IC_INTR_STAT_R_TX_EMPTY     	4
#define BIT_MASK_IC_INTR_STAT_R_TX_EMPTY      	0x1
#define BIT_CTRL_IC_INTR_STAT_R_TX_EMPTY(x)   	(((x) & BIT_MASK_IC_INTR_STAT_R_TX_EMPTY) << BIT_SHIFT_IC_INTR_STAT_R_TX_EMPTY)

#define BIT_IC_INTR_STAT_R_TX_OVER            	BIT(3)
#define BIT_SHIFT_IC_INTR_STAT_R_TX_OVER      	3
#define BIT_MASK_IC_INTR_STAT_R_TX_OVER       	0x1
#define BIT_CTRL_IC_INTR_STAT_R_TX_OVER(x)    	(((x) & BIT_MASK_IC_INTR_STAT_R_TX_OVER) << BIT_SHIFT_IC_INTR_STAT_R_TX_OVER)

#define BIT_IC_INTR_STAT_R_RX_FULL            	BIT(2)
#define BIT_SHIFT_IC_INTR_STAT_R_RX_FULL      	2
#define BIT_MASK_IC_INTR_STAT_R_RX_FULL       	0x1
#define BIT_CTRL_IC_INTR_STAT_R_RX_FULL(x)    	(((x) & BIT_MASK_IC_INTR_STAT_R_RX_FULL) << BIT_SHIFT_IC_INTR_STAT_R_RX_FULL)

#define BIT_IC_INTR_STAT_R_RX_OVER            	BIT(1)
#define BIT_SHIFT_IC_INTR_STAT_R_RX_OVER      	1
#define BIT_MASK_IC_INTR_STAT_R_RX_OVER       	0x1
#define BIT_CTRL_IC_INTR_STAT_R_RX_OVER(x)    	(((x) & BIT_MASK_IC_INTR_STAT_R_RX_OVER) << BIT_SHIFT_IC_INTR_STAT_R_RX_OVER)

#define BIT_IC_INTR_STAT_R_RX_UNDER           	BIT(0)
#define BIT_SHIFT_IC_INTR_STAT_R_RX_UNDER     	0
#define BIT_MASK_IC_INTR_STAT_R_RX_UNDER      	0x1
#define BIT_CTRL_IC_INTR_STAT_R_RX_UNDER(x)   	(((x) & BIT_MASK_IC_INTR_STAT_R_RX_UNDER) << BIT_SHIFT_IC_INTR_STAT_R_RX_UNDER)


//2 REG_DW_I2C_IC_INTR_MASK
#define BIT_IC_INTR_MASK_M_GEN_CALL           	BIT(11)
#define BIT_SHIFT_IC_INTR_MASK_M_GEN_CALL     	11
#define BIT_MASK_IC_INTR_MASK_M_GEN_CALL      	0x1
#define BIT_CTRL_IC_INTR_MASK_M_GEN_CALL(x)   	(((x) & BIT_MASK_IC_INTR_MASK_M_GEN_CALL) << BIT_SHIFT_IC_INTR_MASK_M_GEN_CALL)

#define BIT_IC_INTR_MASK_M_START_DET          	BIT(10)
#define BIT_SHIFT_IC_INTR_MASK_M_START_DET    	10
#define BIT_MASK_IC_INTR_MASK_M_START_DET     	0x1
#define BIT_CTRL_IC_INTR_MASK_M_START_DET(x)  	(((x) & BIT_MASK_IC_INTR_MASK_M_START_DET) << BIT_SHIFT_IC_INTR_MASK_M_START_DET)

#define BIT_IC_INTR_MASK_M_STOP_DET           	BIT(9)
#define BIT_SHIFT_IC_INTR_MASK_M_STOP_DET     	9
#define BIT_MASK_IC_INTR_MASK_M_STOP_DET      	0x1
#define BIT_CTRL_IC_INTR_MASK_M_STOP_DET(x)   	(((x) & BIT_MASK_IC_INTR_MASK_M_STOP_DET) << BIT_SHIFT_IC_INTR_MASK_M_STOP_DET)

#define BIT_IC_INTR_MASK_M_ACTIVITY           	BIT(8)
#define BIT_SHIFT_IC_INTR_MASK_M_ACTIVITY     	8
#define BIT_MASK_IC_INTR_MASK_M_ACTIVITY      	0x1
#define BIT_CTRL_IC_INTR_MASK_M_ACTIVITY(x)   	(((x) & BIT_MASK_IC_INTR_MASK_M_ACTIVITY) << BIT_SHIFT_IC_INTR_MASK_M_ACTIVITY)

#define BIT_IC_INTR_MASK_M_RX_DONE            	BIT(7)
#define BIT_SHIFT_IC_INTR_MASK_M_RX_DONE      	7
#define BIT_MASK_IC_INTR_MASK_M_RX_DONE       	0x1
#define BIT_CTRL_IC_INTR_MASK_M_RX_DONE(x)    	(((x) & BIT_MASK_IC_INTR_MASK_M_RX_DONE) << BIT_SHIFT_IC_INTR_MASK_M_RX_DONE)

#define BIT_IC_INTR_MASK_M_TX_ABRT            	BIT(6)
#define BIT_SHIFT_IC_INTR_MASK_M_TX_ABRT      	6
#define BIT_MASK_IC_INTR_MASK_M_TX_ABRT       	0x1
#define BIT_CTRL_IC_INTR_MASK_M_TX_ABRT(x)    	(((x) & BIT_MASK_IC_INTR_MASK_M_TX_ABRT) << BIT_SHIFT_IC_INTR_MASK_M_TX_ABRT)

#define BIT_IC_INTR_MASK_M_RD_REQ             	BIT(5)
#define BIT_SHIFT_IC_INTR_MASK_M_RD_REQ       	5
#define BIT_MASK_IC_INTR_MASK_M_RD_REQ        	0x1
#define BIT_CTRL_IC_INTR_MASK_M_RD_REQ(x)     	(((x) & BIT_MASK_IC_INTR_MASK_M_RD_REQ) << BIT_SHIFT_IC_INTR_MASK_M_RD_REQ)

#define BIT_IC_INTR_MASK_M_TX_EMPTY           	BIT(4)
#define BIT_SHIFT_IC_INTR_MASK_M_TX_EMPTY     	4
#define BIT_MASK_IC_INTR_MASK_M_TX_EMPTY      	0x1
#define BIT_CTRL_IC_INTR_MASK_M_TX_EMPTY(x)   	(((x) & BIT_MASK_IC_INTR_MASK_M_TX_EMPTY) << BIT_SHIFT_IC_INTR_MASK_M_TX_EMPTY)

#define BIT_IC_INTR_MASK_M_TX_OVER            	BIT(3)
#define BIT_SHIFT_IC_INTR_MASK_M_TX_OVER      	3
#define BIT_MASK_IC_INTR_MASK_M_TX_OVER       	0x1
#define BIT_CTRL_IC_INTR_MASK_M_TX_OVER(x)    	(((x) & BIT_MASK_IC_INTR_MASK_M_TX_OVER) << BIT_SHIFT_IC_INTR_MASK_M_TX_OVER)

#define BIT_IC_INTR_MASK_M_RX_FULL            	BIT(2)
#define BIT_SHIFT_IC_INTR_MASK_M_RX_FULL      	2
#define BIT_MASK_IC_INTR_MASK_M_RX_FULL       	0x1
#define BIT_CTRL_IC_INTR_MASK_M_RX_FULL(x)    	(((x) & BIT_MASK_IC_INTR_MASK_M_RX_FULL) << BIT_SHIFT_IC_INTR_MASK_M_RX_FULL)

#define BIT_IC_INTR_MASK_M_RX_OVER            	BIT(1)
#define BIT_SHIFT_IC_INTR_MASK_M_RX_OVER      	1
#define BIT_MASK_IC_INTR_MASK_M_RX_OVER       	0x1
#define BIT_CTRL_IC_INTR_MASK_M_RX_OVER(x)    	(((x) & BIT_MASK_IC_INTR_MASK_M_RX_OVER) << BIT_SHIFT_IC_INTR_MASK_M_RX_OVER)

#define BIT_IC_INTR_MASK_M_RX_UNDER           	BIT(0)
#define BIT_SHIFT_IC_INTR_MASK_M_RX_UNDER     	0
#define BIT_MASK_IC_INTR_MASK_M_RX_UNDER      	0x1
#define BIT_CTRL_IC_INTR_MASK_M_RX_UNDER(x)   	(((x) & BIT_MASK_IC_INTR_MASK_M_RX_UNDER) << BIT_SHIFT_IC_INTR_MASK_M_RX_UNDER)


//2 REG_DW_I2C_IC_RAW_INTR_STAT
#define BIT_IC_RAW_INTR_STAT_GEN_CALL         	BIT(11)
#define BIT_SHIFT_IC_RAW_INTR_STAT_GEN_CALL   	11
#define BIT_MASK_IC_RAW_INTR_STAT_GEN_CALL    	0x1
#define BIT_CTRL_IC_RAW_INTR_STAT_GEN_CALL(x) 	(((x) & BIT_MASK_IC_RAW_INTR_STAT_GEN_CALL) << BIT_SHIFT_IC_RAW_INTR_STAT_GEN_CALL)

#define BIT_IC_RAW_INTR_STAT_START_DET        	BIT(10)
#define BIT_SHIFT_IC_RAW_INTR_STAT_START_DET  	10
#define BIT_MASK_IC_RAW_INTR_STAT_START_DET   	0x1
#define BIT_CTRL_IC_RAW_INTR_STAT_START_DET(x)	(((x) & BIT_MASK_IC_RAW_INTR_STAT_START_DET) << BIT_SHIFT_IC_RAW_INTR_STAT_START_DET)

#define BIT_IC_RAW_INTR_STAT_STOP_DET         	BIT(9)
#define BIT_SHIFT_IC_RAW_INTR_STAT_STOP_DET   	9
#define BIT_MASK_IC_RAW_INTR_STAT_STOP_DET    	0x1
#define BIT_CTRL_IC_RAW_INTR_STAT_STOP_DET(x) 	(((x) & BIT_MASK_IC_RAW_INTR_STAT_STOP_DET) << BIT_SHIFT_IC_RAW_INTR_STAT_STOP_DET)

#define BIT_IC_RAW_INTR_STAT_ACTIVITY         	BIT(8)
#define BIT_SHIFT_IC_RAW_INTR_STAT_ACTIVITY   	8
#define BIT_MASK_IC_RAW_INTR_STAT_ACTIVITY    	0x1
#define BIT_CTRL_IC_RAW_INTR_STAT_ACTIVITY(x) 	(((x) & BIT_MASK_IC_RAW_INTR_STAT_ACTIVITY) << BIT_SHIFT_IC_RAW_INTR_STAT_ACTIVITY)

#define BIT_IC_RAW_INTR_STAT_RX_DONE          	BIT(7)
#define BIT_SHIFT_IC_RAW_INTR_STAT_RX_DONE    	7
#define BIT_MASK_IC_RAW_INTR_STAT_RX_DONE     	0x1
#define BIT_CTRL_IC_RAW_INTR_STAT_RX_DONE(x)  	(((x) & BIT_MASK_IC_RAW_INTR_STAT_RX_DONE) << BIT_SHIFT_IC_RAW_INTR_STAT_RX_DONE)

#define BIT_IC_RAW_INTR_STAT_TX_ABRT          	BIT(6)
#define BIT_SHIFT_IC_RAW_INTR_STAT_TX_ABRT    	6
#define BIT_MASK_IC_RAW_INTR_STAT_TX_ABRT     	0x1
#define BIT_CTRL_IC_RAW_INTR_STAT_TX_ABRT(x)  	(((x) & BIT_MASK_IC_RAW_INTR_STAT_TX_ABRT) << BIT_SHIFT_IC_RAW_INTR_STAT_TX_ABRT)

#define BIT_IC_RAW_INTR_STAT_RD_REQ           	BIT(5)
#define BIT_SHIFT_IC_RAW_INTR_STAT_RD_REQ     	5
#define BIT_MASK_IC_RAW_INTR_STAT_RD_REQ      	0x1
#define BIT_CTRL_IC_RAW_INTR_STAT_RD_REQ(x)   	(((x) & BIT_MASK_IC_RAW_INTR_STAT_RD_REQ) << BIT_SHIFT_IC_RAW_INTR_STAT_RD_REQ)

#define BIT_IC_RAW_INTR_STAT_TX_EMPTY         	BIT(4)
#define BIT_SHIFT_IC_RAW_INTR_STAT_TX_EMPTY   	4
#define BIT_MASK_IC_RAW_INTR_STAT_TX_EMPTY    	0x1
#define BIT_CTRL_IC_RAW_INTR_STAT_TX_EMPTY(x) 	(((x) & BIT_MASK_IC_RAW_INTR_STAT_TX_EMPTY) << BIT_SHIFT_IC_RAW_INTR_STAT_TX_EMPTY)

#define BIT_IC_RAW_INTR_STAT_TX_OVER          	BIT(3)
#define BIT_SHIFT_IC_RAW_INTR_STAT_TX_OVER    	3
#define BIT_MASK_IC_RAW_INTR_STAT_TX_OVER     	0x1
#define BIT_CTRL_IC_RAW_INTR_STAT_TX_OVER(x)  	(((x) & BIT_MASK_IC_RAW_INTR_STAT_TX_OVER) << BIT_SHIFT_IC_RAW_INTR_STAT_TX_OVER)

#define BIT_IC_RAW_INTR_STAT_RX_FULL          	BIT(2)
#define BIT_SHIFT_IC_RAW_INTR_STAT_RX_FULL    	2
#define BIT_MASK_IC_RAW_INTR_STAT_RX_FULL     	0x1
#define BIT_CTRL_IC_RAW_INTR_STAT_RX_FULL(x)  	(((x) & BIT_MASK_IC_RAW_INTR_STAT_RX_FULL) << BIT_SHIFT_IC_RAW_INTR_STAT_RX_FULL)

#define BIT_IC_RAW_INTR_STAT_RX_OVER          	BIT(1)
#define BIT_SHIFT_IC_RAW_INTR_STAT_RX_OVER    	1
#define BIT_MASK_IC_RAW_INTR_STAT_RX_OVER     	0x1
#define BIT_CTRL_IC_RAW_INTR_STAT_RX_OVER(x)  	(((x) & BIT_MASK_IC_RAW_INTR_STAT_RX_OVER) << BIT_SHIFT_IC_RAW_INTR_STAT_RX_OVER)

#define BIT_IC_RAW_INTR_STAT_RX_UNDER         	BIT(0)
#define BIT_SHIFT_IC_RAW_INTR_STAT_RX_UNDER   	0
#define BIT_MASK_IC_RAW_INTR_STAT_RX_UNDER    	0x1
#define BIT_CTRL_IC_RAW_INTR_STAT_RX_UNDER(x) 	(((x) & BIT_MASK_IC_RAW_INTR_STAT_RX_UNDER) << BIT_SHIFT_IC_RAW_INTR_STAT_RX_UNDER)


//2 REG_DW_I2C_IC_RX_TL

#define BIT_SHIFT_IC_RX_TL 0
#define BIT_MASK_IC_RX_TL 0xff
#define BIT_IC_RX_TL(x)                       	(((x) & BIT_MASK_IC_RX_TL) << BIT_SHIFT_IC_RX_TL)
#define BIT_CTRL_IC_RX_TL(x)                  	(((x) & BIT_MASK_IC_RX_TL) << BIT_SHIFT_IC_RX_TL)
#define BIT_GET_IC_RX_TL(x)                   	(((x) >> BIT_SHIFT_IC_RX_TL) & BIT_MASK_IC_RX_TL)


//2 REG_DW_I2C_IC_TX_TL

#define BIT_SHIFT_IC_TX_TL 0
#define BIT_MASK_IC_TX_TL 0xff
#define BIT_IC_TX_TL(x)                       	(((x) & BIT_MASK_IC_TX_TL) << BIT_SHIFT_IC_TX_TL)
#define BIT_CTRL_IC_TX_TL(x)                  	(((x) & BIT_MASK_IC_TX_TL) << BIT_SHIFT_IC_TX_TL)
#define BIT_GET_IC_TX_TL(x)                   	(((x) >> BIT_SHIFT_IC_TX_TL) & BIT_MASK_IC_TX_TL)


//2 REG_DW_I2C_IC_CLR_INTR
#define BIT_IC_CLR_INTR                       	BIT(0)
#define BIT_SHIFT_IC_CLR_INTR                 	0
#define BIT_MASK_IC_CLR_INTR                  	0x1
#define BIT_CTRL_IC_CLR_INTR(x)               	(((x) & BIT_MASK_IC_CLR_INTR) << BIT_SHIFT_IC_CLR_INTR)


//2 REG_DW_I2C_IC_CLR_RX_UNDER
#define BIT_IC_CLR_RX_UNDER                   	BIT(0)
#define BIT_SHIFT_IC_CLR_RX_UNDER             	0
#define BIT_MASK_IC_CLR_RX_UNDER              	0x1
#define BIT_CTRL_IC_CLR_RX_UNDER(x)           	(((x) & BIT_MASK_IC_CLR_RX_UNDER) << BIT_SHIFT_IC_CLR_RX_UNDER)


//2 REG_DW_I2C_IC_CLR_RX_OVER
#define BIT_IC_CLR_RX_OVER                    	BIT(0)
#define BIT_SHIFT_IC_CLR_RX_OVER              	0
#define BIT_MASK_IC_CLR_RX_OVER               	0x1
#define BIT_CTRL_IC_CLR_RX_OVER(x)            	(((x) & BIT_MASK_IC_CLR_RX_OVER) << BIT_SHIFT_IC_CLR_RX_OVER)


//2 REG_DW_I2C_IC_CLR_TX_OVER
#define BIT_IC_CLR_TX_OVER                    	BIT(0)
#define BIT_SHIFT_IC_CLR_TX_OVER              	0
#define BIT_MASK_IC_CLR_TX_OVER               	0x1
#define BIT_CTRL_IC_CLR_TX_OVER(x)            	(((x) & BIT_MASK_IC_CLR_TX_OVER) << BIT_SHIFT_IC_CLR_TX_OVER)


//2 REG_DW_I2C_IC_CLR_RD_REQ
#define BIT_IC_CLR_RD_REQ                     	BIT(0)
#define BIT_SHIFT_IC_CLR_RD_REQ               	0
#define BIT_MASK_IC_CLR_RD_REQ                	0x1
#define BIT_CTRL_IC_CLR_RD_REQ(x)             	(((x) & BIT_MASK_IC_CLR_RD_REQ) << BIT_SHIFT_IC_CLR_RD_REQ)


//2 REG_DW_I2C_IC_CLR_TX_ABRT
#define BIT_CLR_RD_REQ                        	BIT(0)
#define BIT_SHIFT_CLR_RD_REQ                  	0
#define BIT_MASK_CLR_RD_REQ                   	0x1
#define BIT_CTRL_CLR_RD_REQ(x)                	(((x) & BIT_MASK_CLR_RD_REQ) << BIT_SHIFT_CLR_RD_REQ)


//2 REG_DW_I2C_IC_CLR_RX_DONE
#define BIT_IC_CLR_RX_DONE                    	BIT(0)
#define BIT_SHIFT_IC_CLR_RX_DONE              	0
#define BIT_MASK_IC_CLR_RX_DONE               	0x1
#define BIT_CTRL_IC_CLR_RX_DONE(x)            	(((x) & BIT_MASK_IC_CLR_RX_DONE) << BIT_SHIFT_IC_CLR_RX_DONE)


//2 REG_DW_I2C_IC_CLR_ACTIVITY
#define BIT_IC_CLR_ACTIVITY                   	BIT(0)
#define BIT_SHIFT_IC_CLR_ACTIVITY             	0
#define BIT_MASK_IC_CLR_ACTIVITY              	0x1
#define BIT_CTRL_IC_CLR_ACTIVITY(x)           	(((x) & BIT_MASK_IC_CLR_ACTIVITY) << BIT_SHIFT_IC_CLR_ACTIVITY)


//2 REG_DW_I2C_IC_CLR_STOP_DET
#define BIT_IC_CLR_STOP_DET                   	BIT(0)
#define BIT_SHIFT_IC_CLR_STOP_DET             	0
#define BIT_MASK_IC_CLR_STOP_DET              	0x1
#define BIT_CTRL_IC_CLR_STOP_DET(x)           	(((x) & BIT_MASK_IC_CLR_STOP_DET) << BIT_SHIFT_IC_CLR_STOP_DET)


//2 REG_DW_I2C_IC_CLR_START_DET
#define BIT_IC_CLR_START_DET                  	BIT(0)
#define BIT_SHIFT_IC_CLR_START_DET            	0
#define BIT_MASK_IC_CLR_START_DET             	0x1
#define BIT_CTRL_IC_CLR_START_DET(x)          	(((x) & BIT_MASK_IC_CLR_START_DET) << BIT_SHIFT_IC_CLR_START_DET)


//2 REG_DW_I2C_IC_CLR_GEN_CALL
#define BIT_IC_CLR_GEN_CALL                   	BIT(0)
#define BIT_SHIFT_IC_CLR_GEN_CALL             	0
#define BIT_MASK_IC_CLR_GEN_CALL              	0x1
#define BIT_CTRL_IC_CLR_GEN_CALL(x)           	(((x) & BIT_MASK_IC_CLR_GEN_CALL) << BIT_SHIFT_IC_CLR_GEN_CALL)


//2 REG_DW_I2C_IC_ENABLE
#define BIT_IC_ENABLE                         	BIT(0)
#define BIT_SHIFT_IC_ENABLE                   	0
#define BIT_MASK_IC_ENABLE                    	0x1
#define BIT_CTRL_IC_ENABLE(x)                 	(((x) & BIT_MASK_IC_ENABLE) << BIT_SHIFT_IC_ENABLE)


//2 REG_DW_I2C_IC_STATUS
#define BIT_IC_STATUS_SLV_ACTIVITY            	BIT(6)
#define BIT_SHIFT_IC_STATUS_SLV_ACTIVITY      	6
#define BIT_MASK_IC_STATUS_SLV_ACTIVITY       	0x1
#define BIT_CTRL_IC_STATUS_SLV_ACTIVITY(x)    	(((x) & BIT_MASK_IC_STATUS_SLV_ACTIVITY) << BIT_SHIFT_IC_STATUS_SLV_ACTIVITY)

#define BIT_IC_STATUS_MST_ACTIVITY            	BIT(5)
#define BIT_SHIFT_IC_STATUS_MST_ACTIVITY      	5
#define BIT_MASK_IC_STATUS_MST_ACTIVITY       	0x1
#define BIT_CTRL_IC_STATUS_MST_ACTIVITY(x)    	(((x) & BIT_MASK_IC_STATUS_MST_ACTIVITY) << BIT_SHIFT_IC_STATUS_MST_ACTIVITY)

#define BIT_IC_STATUS_RFF                     	BIT(4)
#define BIT_SHIFT_IC_STATUS_RFF               	4
#define BIT_MASK_IC_STATUS_RFF                	0x1
#define BIT_CTRL_IC_STATUS_RFF(x)             	(((x) & BIT_MASK_IC_STATUS_RFF) << BIT_SHIFT_IC_STATUS_RFF)

#define BIT_IC_STATUS_RFNE                    	BIT(3)
#define BIT_SHIFT_IC_STATUS_RFNE              	3
#define BIT_MASK_IC_STATUS_RFNE               	0x1
#define BIT_CTRL_IC_STATUS_RFNE(x)            	(((x) & BIT_MASK_IC_STATUS_RFNE) << BIT_SHIFT_IC_STATUS_RFNE)

#define BIT_IC_STATUS_TFE                     	BIT(2)
#define BIT_SHIFT_IC_STATUS_TFE               	2
#define BIT_MASK_IC_STATUS_TFE                	0x1
#define BIT_CTRL_IC_STATUS_TFE(x)             	(((x) & BIT_MASK_IC_STATUS_TFE) << BIT_SHIFT_IC_STATUS_TFE)

#define BIT_IC_STATUS_TFNF                    	BIT(1)
#define BIT_SHIFT_IC_STATUS_TFNF              	1
#define BIT_MASK_IC_STATUS_TFNF               	0x1
#define BIT_CTRL_IC_STATUS_TFNF(x)            	(((x) & BIT_MASK_IC_STATUS_TFNF) << BIT_SHIFT_IC_STATUS_TFNF)

#define BIT_IC_STATUS_ACTIVITY                	BIT(0)
#define BIT_SHIFT_IC_STATUS_ACTIVITY          	0
#define BIT_MASK_IC_STATUS_ACTIVITY           	0x1
#define BIT_CTRL_IC_STATUS_ACTIVITY(x)        	(((x) & BIT_MASK_IC_STATUS_ACTIVITY) << BIT_SHIFT_IC_STATUS_ACTIVITY)


//2 REG_DW_I2C_IC_TXFLR

#define BIT_SHIFT_IC_TXFLR 0
#define BIT_MASK_IC_TXFLR 0x3f
#define BIT_IC_TXFLR(x)                       	(((x) & BIT_MASK_IC_TXFLR) << BIT_SHIFT_IC_TXFLR)
#define BIT_CTRL_IC_TXFLR(x)                  	(((x) & BIT_MASK_IC_TXFLR) << BIT_SHIFT_IC_TXFLR)
#define BIT_GET_IC_TXFLR(x)                   	(((x) >> BIT_SHIFT_IC_TXFLR) & BIT_MASK_IC_TXFLR)


//2 REG_DW_I2C_IC_RXFLR

#define BIT_SHIFT_IC_RXFLR 0
#define BIT_MASK_IC_RXFLR 0x1f
#define BIT_IC_RXFLR(x)                       	(((x) & BIT_MASK_IC_RXFLR) << BIT_SHIFT_IC_RXFLR)
#define BIT_CTRL_IC_RXFLR(x)                  	(((x) & BIT_MASK_IC_RXFLR) << BIT_SHIFT_IC_RXFLR)
#define BIT_GET_IC_RXFLR(x)                   	(((x) >> BIT_SHIFT_IC_RXFLR) & BIT_MASK_IC_RXFLR)


//2 REG_DW_I2C_IC_SDA_HOLD

#define BIT_SHIFT_IC_SDA_HOLD 0
#define BIT_MASK_IC_SDA_HOLD 0xffff
#define BIT_IC_SDA_HOLD(x)                    	(((x) & BIT_MASK_IC_SDA_HOLD) << BIT_SHIFT_IC_SDA_HOLD)
#define BIT_CTRL_IC_SDA_HOLD(x)               	(((x) & BIT_MASK_IC_SDA_HOLD) << BIT_SHIFT_IC_SDA_HOLD)
#define BIT_GET_IC_SDA_HOLD(x)                	(((x) >> BIT_SHIFT_IC_SDA_HOLD) & BIT_MASK_IC_SDA_HOLD)


//2 REG_DW_I2C_IC_TX_ABRT_SOURCE
#define BIT_IC_TX_ABRT_SOURCE_ABRT_SLVRD_INTX 	BIT(15)
#define BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_SLVRD_INTX	15
#define BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_SLVRD_INTX	0x1
#define BIT_CTRL_IC_TX_ABRT_SOURCE_ABRT_SLVRD_INTX(x)	(((x) & BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_SLVRD_INTX) << BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_SLVRD_INTX)

#define BIT_IC_TX_ABRT_SOURCE_ABRT_SLV_ARBLOST	BIT(14)
#define BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_SLV_ARBLOST	14
#define BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_SLV_ARBLOST	0x1
#define BIT_CTRL_IC_TX_ABRT_SOURCE_ABRT_SLV_ARBLOST(x)	(((x) & BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_SLV_ARBLOST) << BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_SLV_ARBLOST)

#define BIT_IC_TX_ABRT_SOURCE_ABRT_SLVFLUSH_TXFIFO	BIT(13)
#define BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_SLVFLUSH_TXFIFO	13
#define BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_SLVFLUSH_TXFIFO	0x1
#define BIT_CTRL_IC_TX_ABRT_SOURCE_ABRT_SLVFLUSH_TXFIFO(x)	(((x) & BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_SLVFLUSH_TXFIFO) << BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_SLVFLUSH_TXFIFO)

#define BIT_IC_TX_ABRT_SOURCE_ARB_LOST        	BIT(12)
#define BIT_SHIFT_IC_TX_ABRT_SOURCE_ARB_LOST  	12
#define BIT_MASK_IC_TX_ABRT_SOURCE_ARB_LOST   	0x1
#define BIT_CTRL_IC_TX_ABRT_SOURCE_ARB_LOST(x)	(((x) & BIT_MASK_IC_TX_ABRT_SOURCE_ARB_LOST) << BIT_SHIFT_IC_TX_ABRT_SOURCE_ARB_LOST)

#define BIT_IC_TX_ABRT_SOURCE_ABRT_MASTER_DIS 	BIT(11)
#define BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_MASTER_DIS	11
#define BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_MASTER_DIS	0x1
#define BIT_CTRL_IC_TX_ABRT_SOURCE_ABRT_MASTER_DIS(x)	(((x) & BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_MASTER_DIS) << BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_MASTER_DIS)

#define BIT_IC_TX_ABRT_SOURCE_ABRT_10B_RD_NORSTRT	BIT(10)
#define BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_10B_RD_NORSTRT	10
#define BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_10B_RD_NORSTRT	0x1
#define BIT_CTRL_IC_TX_ABRT_SOURCE_ABRT_10B_RD_NORSTRT(x)	(((x) & BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_10B_RD_NORSTRT) << BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_10B_RD_NORSTRT)

#define BIT_IC_TX_ABRT_SOURCE_ABRT_SBYTE_NORSTRT	BIT(9)
#define BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_SBYTE_NORSTRT	9
#define BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_SBYTE_NORSTRT	0x1
#define BIT_CTRL_IC_TX_ABRT_SOURCE_ABRT_SBYTE_NORSTRT(x)	(((x) & BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_SBYTE_NORSTRT) << BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_SBYTE_NORSTRT)

#define BIT_IC_TX_ABRT_SOURCE_ABRT_HS_NORSTRT 	BIT(8)
#define BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_HS_NORSTRT	8
#define BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_HS_NORSTRT	0x1
#define BIT_CTRL_IC_TX_ABRT_SOURCE_ABRT_HS_NORSTRT(x)	(((x) & BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_HS_NORSTRT) << BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_HS_NORSTRT)

#define BIT_IC_TX_ABRT_SOURCE_ABRT_SBYTE_ACKDET	BIT(7)
#define BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_SBYTE_ACKDET	7
#define BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_SBYTE_ACKDET	0x1
#define BIT_CTRL_IC_TX_ABRT_SOURCE_ABRT_SBYTE_ACKDET(x)	(((x) & BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_SBYTE_ACKDET) << BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_SBYTE_ACKDET)

#define BIT_IC_TX_ABRT_SOURCE_ABRT_HS_ACKDET  	BIT(6)
#define BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_HS_ACKDET	6
#define BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_HS_ACKDET	0x1
#define BIT_CTRL_IC_TX_ABRT_SOURCE_ABRT_HS_ACKDET(x)	(((x) & BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_HS_ACKDET) << BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_HS_ACKDET)

#define BIT_IC_TX_ABRT_SOURCE_ABRT_GCALL_READ 	BIT(5)
#define BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_GCALL_READ	5
#define BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_GCALL_READ	0x1
#define BIT_CTRL_IC_TX_ABRT_SOURCE_ABRT_GCALL_READ(x)	(((x) & BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_GCALL_READ) << BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_GCALL_READ)

#define BIT_IC_TX_ABRT_SOURCE_ABRT_GCALL_NOACK	BIT(4)
#define BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_GCALL_NOACK	4
#define BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_GCALL_NOACK	0x1
#define BIT_CTRL_IC_TX_ABRT_SOURCE_ABRT_GCALL_NOACK(x)	(((x) & BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_GCALL_NOACK) << BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_GCALL_NOACK)

#define BIT_IC_TX_ABRT_SOURCE_ABRT_TXDATA_NOACK	BIT(3)
#define BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_TXDATA_NOACK	3
#define BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_TXDATA_NOACK	0x1
#define BIT_CTRL_IC_TX_ABRT_SOURCE_ABRT_TXDATA_NOACK(x)	(((x) & BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_TXDATA_NOACK) << BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_TXDATA_NOACK)

#define BIT_IC_TX_ABRT_SOURCE_ABRT_10ADDR2_NOACK	BIT(2)
#define BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_10ADDR2_NOACK	2
#define BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_10ADDR2_NOACK	0x1
#define BIT_CTRL_IC_TX_ABRT_SOURCE_ABRT_10ADDR2_NOACK(x)	(((x) & BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_10ADDR2_NOACK) << BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_10ADDR2_NOACK)

#define BIT_IC_TX_ABRT_SOURCE_ABRT_10ADDR1_NOACK	BIT(1)
#define BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_10ADDR1_NOACK	1
#define BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_10ADDR1_NOACK	0x1
#define BIT_CTRL_IC_TX_ABRT_SOURCE_ABRT_10ADDR1_NOACK(x)	(((x) & BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_10ADDR1_NOACK) << BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_10ADDR1_NOACK)

#define BIT_IC_TX_ABRT_SOURCE_ABRT_7B_ADDR_NOACK	BIT(0)
#define BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_7B_ADDR_NOACK	0
#define BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_7B_ADDR_NOACK	0x1
#define BIT_CTRL_IC_TX_ABRT_SOURCE_ABRT_7B_ADDR_NOACK(x)	(((x) & BIT_MASK_IC_TX_ABRT_SOURCE_ABRT_7B_ADDR_NOACK) << BIT_SHIFT_IC_TX_ABRT_SOURCE_ABRT_7B_ADDR_NOACK)


//2 REG_DW_I2C_IC_SLV_DATA_NACK_ONLY
#define BIT_IC_SLV_DATA_NACK_ONLY             	BIT(0)
#define BIT_SHIFT_IC_SLV_DATA_NACK_ONLY       	0
#define BIT_MASK_IC_SLV_DATA_NACK_ONLY        	0x1
#define BIT_CTRL_IC_SLV_DATA_NACK_ONLY(x)     	(((x) & BIT_MASK_IC_SLV_DATA_NACK_ONLY) << BIT_SHIFT_IC_SLV_DATA_NACK_ONLY)


//2 REG_DW_I2C_IC_DMA_CR
#define BIT_IC_DMA_CR_TDMAE                   	BIT(1)
#define BIT_SHIFT_IC_DMA_CR_TDMAE             	1
#define BIT_MASK_IC_DMA_CR_TDMAE              	0x1
#define BIT_CTRL_IC_DMA_CR_TDMAE(x)           	(((x) & BIT_MASK_IC_DMA_CR_TDMAE) << BIT_SHIFT_IC_DMA_CR_TDMAE)

#define BIT_IC_DMA_CR_RDMAE                   	BIT(0)
#define BIT_SHIFT_IC_DMA_CR_RDMAE             	0
#define BIT_MASK_IC_DMA_CR_RDMAE              	0x1
#define BIT_CTRL_IC_DMA_CR_RDMAE(x)           	(((x) & BIT_MASK_IC_DMA_CR_RDMAE) << BIT_SHIFT_IC_DMA_CR_RDMAE)


//2 REG_DW_I2C_IC_DMA_TDLR

#define BIT_SHIFT_IC_DMA_TDLR_DMATDL 0
#define BIT_MASK_IC_DMA_TDLR_DMATDL 0x1f
#define BIT_IC_DMA_TDLR_DMATDL(x)             	(((x) & BIT_MASK_IC_DMA_TDLR_DMATDL) << BIT_SHIFT_IC_DMA_TDLR_DMATDL)
#define BIT_CTRL_IC_DMA_TDLR_DMATDL(x)        	(((x) & BIT_MASK_IC_DMA_TDLR_DMATDL) << BIT_SHIFT_IC_DMA_TDLR_DMATDL)
#define BIT_GET_IC_DMA_TDLR_DMATDL(x)         	(((x) >> BIT_SHIFT_IC_DMA_TDLR_DMATDL) & BIT_MASK_IC_DMA_TDLR_DMATDL)


//2 REG_DW_I2C_IC_DMA_RDLR

#define BIT_SHIFT_IC_DMA_RDLR_DMARDL 0
#define BIT_MASK_IC_DMA_RDLR_DMARDL 0xf
#define BIT_IC_DMA_RDLR_DMARDL(x)             	(((x) & BIT_MASK_IC_DMA_RDLR_DMARDL) << BIT_SHIFT_IC_DMA_RDLR_DMARDL)
#define BIT_CTRL_IC_DMA_RDLR_DMARDL(x)        	(((x) & BIT_MASK_IC_DMA_RDLR_DMARDL) << BIT_SHIFT_IC_DMA_RDLR_DMARDL)
#define BIT_GET_IC_DMA_RDLR_DMARDL(x)         	(((x) >> BIT_SHIFT_IC_DMA_RDLR_DMARDL) & BIT_MASK_IC_DMA_RDLR_DMARDL)


//2 REG_DW_I2C_IC_SDA_SETUP

#define BIT_SHIFT_IC_SDA_SETUP 0
#define BIT_MASK_IC_SDA_SETUP 0xff
#define BIT_IC_SDA_SETUP(x)                   	(((x) & BIT_MASK_IC_SDA_SETUP) << BIT_SHIFT_IC_SDA_SETUP)
#define BIT_CTRL_IC_SDA_SETUP(x)              	(((x) & BIT_MASK_IC_SDA_SETUP) << BIT_SHIFT_IC_SDA_SETUP)
#define BIT_GET_IC_SDA_SETUP(x)               	(((x) >> BIT_SHIFT_IC_SDA_SETUP) & BIT_MASK_IC_SDA_SETUP)


//2 REG_DW_I2C_IC_ACK_GENERAL_CALL
#define BIT_IC_ACK_GENERAL_CALL               	BIT(0)
#define BIT_SHIFT_IC_ACK_GENERAL_CALL         	0
#define BIT_MASK_IC_ACK_GENERAL_CALL          	0x1
#define BIT_CTRL_IC_ACK_GENERAL_CALL(x)       	(((x) & BIT_MASK_IC_ACK_GENERAL_CALL) << BIT_SHIFT_IC_ACK_GENERAL_CALL)


//2 REG_DW_I2C_IC_ENABLE_STATUS
#define BIT_IC_ENABLE_STATUS_SLV_RX_DATA_LOST 	BIT(2)
#define BIT_SHIFT_IC_ENABLE_STATUS_SLV_RX_DATA_LOST	2
#define BIT_MASK_IC_ENABLE_STATUS_SLV_RX_DATA_LOST	0x1
#define BIT_CTRL_IC_ENABLE_STATUS_SLV_RX_DATA_LOST(x)	(((x) & BIT_MASK_IC_ENABLE_STATUS_SLV_RX_DATA_LOST) << BIT_SHIFT_IC_ENABLE_STATUS_SLV_RX_DATA_LOST)

#define BIT_IC_ENABLE_STATUS_SLV_DISABLED_WHILE_BUSY	BIT(1)
#define BIT_SHIFT_IC_ENABLE_STATUS_SLV_DISABLED_WHILE_BUSY	1
#define BIT_MASK_IC_ENABLE_STATUS_SLV_DISABLED_WHILE_BUSY	0x1
#define BIT_CTRL_IC_ENABLE_STATUS_SLV_DISABLED_WHILE_BUSY(x)	(((x) & BIT_MASK_IC_ENABLE_STATUS_SLV_DISABLED_WHILE_BUSY) << BIT_SHIFT_IC_ENABLE_STATUS_SLV_DISABLED_WHILE_BUSY)

#define BIT_IC_ENABLE_STATUS_IC_EN            	BIT(0)
#define BIT_SHIFT_IC_ENABLE_STATUS_IC_EN      	0
#define BIT_MASK_IC_ENABLE_STATUS_IC_EN       	0x1
#define BIT_CTRL_IC_ENABLE_STATUS_IC_EN(x)    	(((x) & BIT_MASK_IC_ENABLE_STATUS_IC_EN) << BIT_SHIFT_IC_ENABLE_STATUS_IC_EN)


//2 REG_DW_I2C_IC_COMP_PARAM_1

#define BIT_SHIFT_IC_COMP_PARAM_1_TX_BUFFER_DEPTH 16
#define BIT_MASK_IC_COMP_PARAM_1_TX_BUFFER_DEPTH 0xff
#define BIT_IC_COMP_PARAM_1_TX_BUFFER_DEPTH(x)	(((x) & BIT_MASK_IC_COMP_PARAM_1_TX_BUFFER_DEPTH) << BIT_SHIFT_IC_COMP_PARAM_1_TX_BUFFER_DEPTH)
#define BIT_CTRL_IC_COMP_PARAM_1_TX_BUFFER_DEPTH(x)	(((x) & BIT_MASK_IC_COMP_PARAM_1_TX_BUFFER_DEPTH) << BIT_SHIFT_IC_COMP_PARAM_1_TX_BUFFER_DEPTH)
#define BIT_GET_IC_COMP_PARAM_1_TX_BUFFER_DEPTH(x)	(((x) >> BIT_SHIFT_IC_COMP_PARAM_1_TX_BUFFER_DEPTH) & BIT_MASK_IC_COMP_PARAM_1_TX_BUFFER_DEPTH)


#define BIT_SHIFT_IC_COMP_PARAM_1_RX_BUFFER_DEPTH 8
#define BIT_MASK_IC_COMP_PARAM_1_RX_BUFFER_DEPTH 0xff
#define BIT_IC_COMP_PARAM_1_RX_BUFFER_DEPTH(x)	(((x) & BIT_MASK_IC_COMP_PARAM_1_RX_BUFFER_DEPTH) << BIT_SHIFT_IC_COMP_PARAM_1_RX_BUFFER_DEPTH)
#define BIT_CTRL_IC_COMP_PARAM_1_RX_BUFFER_DEPTH(x)	(((x) & BIT_MASK_IC_COMP_PARAM_1_RX_BUFFER_DEPTH) << BIT_SHIFT_IC_COMP_PARAM_1_RX_BUFFER_DEPTH)
#define BIT_GET_IC_COMP_PARAM_1_RX_BUFFER_DEPTH(x)	(((x) >> BIT_SHIFT_IC_COMP_PARAM_1_RX_BUFFER_DEPTH) & BIT_MASK_IC_COMP_PARAM_1_RX_BUFFER_DEPTH)

#define BIT_IC_COMP_PARAM_1_ADD_ENCODED_PARAMS	BIT(7)
#define BIT_SHIFT_IC_COMP_PARAM_1_ADD_ENCODED_PARAMS	7
#define BIT_MASK_IC_COMP_PARAM_1_ADD_ENCODED_PARAMS	0x1
#define BIT_CTRL_IC_COMP_PARAM_1_ADD_ENCODED_PARAMS(x)	(((x) & BIT_MASK_IC_COMP_PARAM_1_ADD_ENCODED_PARAMS) << BIT_SHIFT_IC_COMP_PARAM_1_ADD_ENCODED_PARAMS)

#define BIT_IC_COMP_PARAM_1_HAS_DMA           	BIT(6)
#define BIT_SHIFT_IC_COMP_PARAM_1_HAS_DMA     	6
#define BIT_MASK_IC_COMP_PARAM_1_HAS_DMA      	0x1
#define BIT_CTRL_IC_COMP_PARAM_1_HAS_DMA(x)   	(((x) & BIT_MASK_IC_COMP_PARAM_1_HAS_DMA) << BIT_SHIFT_IC_COMP_PARAM_1_HAS_DMA)

#define BIT_IC_COMP_PARAM_1_INTR_IO           	BIT(5)
#define BIT_SHIFT_IC_COMP_PARAM_1_INTR_IO     	5
#define BIT_MASK_IC_COMP_PARAM_1_INTR_IO      	0x1
#define BIT_CTRL_IC_COMP_PARAM_1_INTR_IO(x)   	(((x) & BIT_MASK_IC_COMP_PARAM_1_INTR_IO) << BIT_SHIFT_IC_COMP_PARAM_1_INTR_IO)

#define BIT_IC_COMP_PARAM_1_HC_COUNT_VALUES   	BIT(4)
#define BIT_SHIFT_IC_COMP_PARAM_1_HC_COUNT_VALUES	4
#define BIT_MASK_IC_COMP_PARAM_1_HC_COUNT_VALUES	0x1
#define BIT_CTRL_IC_COMP_PARAM_1_HC_COUNT_VALUES(x)	(((x) & BIT_MASK_IC_COMP_PARAM_1_HC_COUNT_VALUES) << BIT_SHIFT_IC_COMP_PARAM_1_HC_COUNT_VALUES)


#define BIT_SHIFT_IC_COMP_PARAM_1_MAX_SPEED_MODE 2
#define BIT_MASK_IC_COMP_PARAM_1_MAX_SPEED_MODE 0x3
#define BIT_IC_COMP_PARAM_1_MAX_SPEED_MODE(x) 	(((x) & BIT_MASK_IC_COMP_PARAM_1_MAX_SPEED_MODE) << BIT_SHIFT_IC_COMP_PARAM_1_MAX_SPEED_MODE)
#define BIT_CTRL_IC_COMP_PARAM_1_MAX_SPEED_MODE(x)	(((x) & BIT_MASK_IC_COMP_PARAM_1_MAX_SPEED_MODE) << BIT_SHIFT_IC_COMP_PARAM_1_MAX_SPEED_MODE)
#define BIT_GET_IC_COMP_PARAM_1_MAX_SPEED_MODE(x)	(((x) >> BIT_SHIFT_IC_COMP_PARAM_1_MAX_SPEED_MODE) & BIT_MASK_IC_COMP_PARAM_1_MAX_SPEED_MODE)


#define BIT_SHIFT_IC_COMP_PARAM_1_APB_DATA_WIDTH 0
#define BIT_MASK_IC_COMP_PARAM_1_APB_DATA_WIDTH 0x3
#define BIT_IC_COMP_PARAM_1_APB_DATA_WIDTH(x) 	(((x) & BIT_MASK_IC_COMP_PARAM_1_APB_DATA_WIDTH) << BIT_SHIFT_IC_COMP_PARAM_1_APB_DATA_WIDTH)
#define BIT_CTRL_IC_COMP_PARAM_1_APB_DATA_WIDTH(x)	(((x) & BIT_MASK_IC_COMP_PARAM_1_APB_DATA_WIDTH) << BIT_SHIFT_IC_COMP_PARAM_1_APB_DATA_WIDTH)
#define BIT_GET_IC_COMP_PARAM_1_APB_DATA_WIDTH(x)	(((x) >> BIT_SHIFT_IC_COMP_PARAM_1_APB_DATA_WIDTH) & BIT_MASK_IC_COMP_PARAM_1_APB_DATA_WIDTH)


//2 REG_DW_I2C_IC_COMP_VERSION

#define BIT_SHIFT_IC_COMP_VERSION 0
#define BIT_MASK_IC_COMP_VERSION 0xffffffffL
#define BIT_IC_COMP_VERSION(x)                	(((x) & BIT_MASK_IC_COMP_VERSION) << BIT_SHIFT_IC_COMP_VERSION)
#define BIT_CTRL_IC_COMP_VERSION(x)           	(((x) & BIT_MASK_IC_COMP_VERSION) << BIT_SHIFT_IC_COMP_VERSION)
#define BIT_GET_IC_COMP_VERSION(x)            	(((x) >> BIT_SHIFT_IC_COMP_VERSION) & BIT_MASK_IC_COMP_VERSION)


//2 REG_DW_I2C_IC_COMP_TYPE

#define BIT_SHIFT_IC_COMP_TYPE 0
#define BIT_MASK_IC_COMP_TYPE 0xffffffffL
#define BIT_IC_COMP_TYPE(x)                   	(((x) & BIT_MASK_IC_COMP_TYPE) << BIT_SHIFT_IC_COMP_TYPE)
#define BIT_CTRL_IC_COMP_TYPE(x)              	(((x) & BIT_MASK_IC_COMP_TYPE) << BIT_SHIFT_IC_COMP_TYPE)
#define BIT_GET_IC_COMP_TYPE(x)               	(((x) >> BIT_SHIFT_IC_COMP_TYPE) & BIT_MASK_IC_COMP_TYPE)

//======================== Register Address Definition ========================
#define REG_DW_I2C_IC_CON 0x0000
#define REG_DW_I2C_IC_TAR 0x0004
#define REG_DW_I2C_IC_SAR 0x0008
#define REG_DW_I2C_IC_HS_MADDR 0x000C
#define REG_DW_I2C_IC_DATA_CMD 0x0010
#define REG_DW_I2C_IC_SS_SCL_HCNT 0x0014
#define REG_DW_I2C_IC_SS_SCL_LCNT 0x0018
#define REG_DW_I2C_IC_FS_SCL_HCNT 0x001C
#define REG_DW_I2C_IC_FS_SCL_LCNT 0x0020
#define REG_DW_I2C_IC_HS_SCL_HCNT 0x0024
#define REG_DW_I2C_IC_HS_SCL_LCNT 0x0028
#define REG_DW_I2C_IC_INTR_STAT 0x002C
#define REG_DW_I2C_IC_INTR_MASK 0x0030
#define REG_DW_I2C_IC_RAW_INTR_STAT 0x0034
#define REG_DW_I2C_IC_RX_TL 0x0038
#define REG_DW_I2C_IC_TX_TL 0x003C
#define REG_DW_I2C_IC_CLR_INTR 0x0040
#define REG_DW_I2C_IC_CLR_RX_UNDER 0x0044
#define REG_DW_I2C_IC_CLR_RX_OVER 0x0048
#define REG_DW_I2C_IC_CLR_TX_OVER 0x004C
#define REG_DW_I2C_IC_CLR_RD_REQ 0x0050
#define REG_DW_I2C_IC_CLR_TX_ABRT 0x0054
#define REG_DW_I2C_IC_CLR_RX_DONE 0x0058
#define REG_DW_I2C_IC_CLR_ACTIVITY 0x005C
#define REG_DW_I2C_IC_CLR_STOP_DET 0x0060
#define REG_DW_I2C_IC_CLR_START_DET 0x0064
#define REG_DW_I2C_IC_CLR_GEN_CALL 0x0068
#define REG_DW_I2C_IC_ENABLE 0x006C
#define REG_DW_I2C_IC_STATUS 0x0070
#define REG_DW_I2C_IC_TXFLR 0x0074
#define REG_DW_I2C_IC_RXFLR 0x0078
#define REG_DW_I2C_IC_SDA_HOLD 0x007C
#define REG_DW_I2C_IC_TX_ABRT_SOURCE 0x0080
#define REG_DW_I2C_IC_SLV_DATA_NACK_ONLY 0x0084
#define REG_DW_I2C_IC_DMA_CR 0x0088
#define REG_DW_I2C_IC_DMA_TDLR 0x008C
#define REG_DW_I2C_IC_DMA_RDLR 0x0090
#define REG_DW_I2C_IC_SDA_SETUP 0x0094
#define REG_DW_I2C_IC_ACK_GENERAL_CALL 0x0098
#define REG_DW_I2C_IC_ENABLE_STATUS 0x009C
#define REG_DW_I2C_IC_COMP_PARAM_1 0x00F4
#define REG_DW_I2C_IC_COMP_VERSION 0x00F8
#define REG_DW_I2C_IC_COMP_TYPE 0x00FC

//======================================================
// I2C related enumeration
// I2C Address Mode
typedef enum _I2C_ADDR_MODE_   {
    I2C_ADDR_7BIT   =   0,
    I2C_ADDR_10BIT  =   1,  
}I2C_ADDR_MODE,*PI2C_ADDR_MODE;

// I2C Speed Mode
typedef enum _I2C_SPD_MODE_   {
    I2C_SS_MODE     =   1,
    I2C_FS_MODE     =   2,
    I2C_HS_MODE     =   3,
}I2C_SPD_MODE,*PI2C_SPD_MODE;

//I2C Timing Parameters
#define I2C_SS_MIN_SCL_HTIME    4000    //the unit is ns.
#define I2C_SS_MIN_SCL_LTIME    4700    //the unit is ns.

#define I2C_FS_MIN_SCL_HTIME    600     //the unit is ns.
#define I2C_FS_MIN_SCL_LTIME    1300    //the unit is ns.

#define I2C_HS_MIN_SCL_HTIME_100    60      //the unit is ns, with bus loading = 100pf
#define I2C_HS_MIN_SCL_LTIME_100    120     //the unit is ns., with bus loading = 100pf

#define I2C_HS_MIN_SCL_HTIME_400    160     //the unit is ns, with bus loading = 400pf
#define I2C_HS_MIN_SCL_LTIME_400    320     //the unit is ns., with bus loading = 400pf


//======================================================
//I2C Essential functions and macros
_LONG_CALL_ROM_ VOID HalI2CWrite32(IN u8 I2CIdx, IN u8 I2CReg, IN u32 I2CVal);
_LONG_CALL_ROM_ u32 HalI2CRead32(IN u8 I2CIdx, IN u8 I2CReg);

#define HAL_I2C_WRITE32(I2CIdx, addr, value)    HalI2CWrite32(I2CIdx,addr,value)
#define HAL_I2C_READ32(I2CIdx, addr)            HalI2CRead32(I2CIdx,addr)

// Rtl8195a I2C function prototypes
_LONG_CALL_ HAL_Status HalI2CEnableRtl8195a(IN VOID *Data);
_LONG_CALL_ HAL_Status HalI2CInit8195a(IN VOID *Data);
_LONG_CALL_ HAL_Status HalI2CDeInit8195a(IN VOID *Data);
_LONG_CALL_ROM_ HAL_Status HalI2CSetCLKRtl8195a(IN VOID *Data);
_LONG_CALL_ HAL_Status HalI2CMassSendRtl8195a(IN VOID *Data);
_LONG_CALL_ HAL_Status HalI2CSendRtl8195a(IN VOID *Data);
_LONG_CALL_ u8 HalI2CReceiveRtl8195a(IN VOID *Data);
_LONG_CALL_ROM_ HAL_Status HalI2CIntrCtrl8195a(IN VOID *Data);
_LONG_CALL_ HAL_Status HalI2CClrIntrRtl8195a(IN VOID *Data);
_LONG_CALL_ROM_ HAL_Status HalI2CClrAllIntrRtl8195a(IN VOID *Data);
_LONG_CALL_ HAL_Status HalI2CDMACtrl8195a(IN VOID *Data);
_LONG_CALL_ u32 HalI2CReadRegRtl8195a(IN VOID *Data, IN u8 I2CReg);
_LONG_CALL_ HAL_Status HalI2CWriteRegRtl8195a(IN VOID *Data, IN u8 I2CReg, IN u32 RegVal);

//Rtl8195a I2C V02 function prototype
_LONG_CALL_ HAL_Status HalI2CSendRtl8195aV02(IN  VOID *Data);
#if  defined(CONFIG_CHIP_A_CUT) || defined(CONFIG_CHIP_B_CUT) || defined(CONFIG_CHIP_C_CUT)
_LONG_CALL_ HAL_Status HalI2CSetCLKRtl8195aV02(IN  VOID *Data);
#elif defined(CONFIG_CHIP_E_CUT)
_LONG_CALL_ROM_ HAL_Status HalI2CSetCLKRtl8195aV02(IN  VOID *Data);
#endif
//Rtl8195a I2C V02 function prototype  END

//Rtl8195a I2C V04 function prototype
_LONG_CALL_ HAL_Status HalI2CSendRtl8195a_V04(IN  VOID    *Data);
_LONG_CALL_ HAL_Status HalI2CMassSendRtl8195a_V04(IN  VOID    *Data);
_LONG_CALL_ HAL_Status HalI2CInit8195a_V04(IN  VOID    *Data);
_LONG_CALL_ HAL_Status HalI2CSetCLKRtl8195a_V04(IN  VOID    *Data);
//Rtl8195a I2C V04 function prototype  END

HAL_Status HalI2CInit8195a_Patch(IN VOID *Data);
HAL_Status HalI2CSendRtl8195a_Patch(IN VOID *Data);
HAL_Status HalI2CSetCLKRtl8195a_Patch(IN VOID *Data);
HAL_Status HalI2CMassSendRtl8195a_Patch(IN  VOID    *Data);
HAL_Status HalI2CEnableRtl8195a_Patch(IN  VOID    *Data);
HAL_Status HalI2CSetTarRtl8195a(IN  VOID    *Data);
HAL_Status HalI2CSetSarRtl8195a(IN  VOID    *Data);

#endif
