/*
 *  Routines to access hardware
 *
 *  Copyright (c) 2013 Realtek Semiconductor Corp.
 *
 *  This module is a confidential and proprietary property of RealTek and
 *  possession or use of this module requires written permission of RealTek.
 */

#include "rtl8195a.h"

//#include "autoconf.h" 
//#include "diag.h"
//#include "hal_peri_on.h"
#include "rtl8195a_nfc.h"
#include "osdep_api.h"
//#include "hal_nfc.h"
//#include "rtl8195a_peri_on.h"
//#include "rtl8195a_sys_on.h"
//#include "hal_platform.h"

#ifdef CONFIG_NFC_NORMAL

extern void nfc_tagwrite_callback(PNFC_ADAPTER pNFCAdp, uint32_t page, uint32_t wr_data);
extern void nfc_event_callback(PNFC_ADAPTER pNFCAdp, uint32_t event);
extern void nfc_tagread_callback(PNFC_ADAPTER pNFCAdp, uint32_t page);
extern void nfc_cache_read_callback(PNFC_ADAPTER pNFCAdp, uint32_t start_pg, uint32_t *pbuf);

extern VOID SpicLoadInitParaFromClockRtl8195A(u8 CpuClkMode, u8 BaudRate, PSPIC_INIT_PARA pSpicInitPara); 
extern VOID SpicSectorEraseFlashRtl8195A(u32 Address);
extern VOID SpicWaitBusyDoneRtl8195A(VOID);
extern VOID SpicWaitWipDoneRtl8195A(SPIC_INIT_PARA SpicInitPara); 


VOID WriteA2NMailbox(IN VOID *pNFCAdapte);
VOID A2NWriteInQueue(IN VOID *pNFCAdapte, IN VOID *pBuff);
VOID A2NWriteDeQueue(IN VOID *pNFCAdapte);
VOID N2AReadTag(IN VOID *pNFCAdapte, IN u8 N2ARPage);
u32 HalNFCRead32(IN  u32 Addr);
VOID HalNFCWrite32(IN  u32 Addr, IN u32 Data);
VOID N2AWriteTag(IN VOID *pNFCAdapte, IN u8 N2AWPage);
VOID N2AReadCatch(IN VOID *pNFCAdapte, IN u8 N2ACatchRPage);
VOID NFCReaderPresent(IN VOID *pNFCAdapte, IN u8 State);
VOID N2AMailboxState(IN VOID *pNFCAdapte, IN u8 State, IN u8 Seq);
VOID NFC25MClkReq(IN VOID *pNFCAdapte, IN u8 OP, IN u8 Seq);

//v1.3 150824
u8 NFCFWIMEM[]={
0x01, 0x10, 0x00, 0x65, 0x00, 0x68, 0xA8, 0xB9, 0x00, 0x65, 0x40, 0xF0, 0x20, 0x69, 0x89, 0xB9, 
0x00, 0x65, 0x13, 0xF7, 0x20, 0x6A, 0x80, 0xF0, 0x08, 0x4A, 0x7E, 0xF0, 0x2D, 0x68, 0x7E, 0xF0, 
0x0C, 0x48, 0x00, 0xDA, 0x00, 0x65, 0x00, 0x65, 0x00, 0x65, 0x00, 0x65, 0x13, 0xF7, 0x20, 0x6A, 
0x08, 0x4A, 0x00, 0x9A, 0x00, 0x65, 0x00, 0xF0, 0x20, 0x69, 0xFF, 0xF4, 0x1F, 0x49, 0x2C, 0xE8, 
0x00, 0xDA, 0x00, 0x65, 0x13, 0xF7, 0x20, 0x6A, 0x80, 0xF0, 0x04, 0x4A, 0x00, 0x68, 0x00, 0xDA, 
0x00, 0x65, 0x13, 0xF7, 0x20, 0x6A, 0x80, 0xF0, 0x00, 0x4A, 0x02, 0xF0, 0x20, 0x68, 0xFF, 0x48, 
0x00, 0xDA, 0x00, 0x65, 0x10, 0xF0, 0x20, 0x68, 0x00, 0xF4, 0x01, 0x48, 0x00, 0xE8, 0x00, 0x65, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xDF, 0xF7, 0x04, 0x63, 0x0E, 0xD2, 0x0D, 0xD3, 0x0C, 0xD0, 0x0B, 0xD1, 0x0A, 0xD4, 0x09, 0xD5, 
0x08, 0xD6, 0x07, 0xD7, 0x58, 0x67, 0x06, 0xD2, 0x05, 0x62, 0x8D, 0xB8, 0xAE, 0xB8, 0xC8, 0xB8, 
0xEC, 0xB8, 0x00, 0x18, 0x28, 0x01, 0x00, 0x65, 0x00, 0x6A, 0xAA, 0xB9, 0x06, 0x92, 0x1A, 0x65, 
0x05, 0x92, 0xFA, 0x65, 0x0E, 0x92, 0x0D, 0x93, 0x0C, 0x90, 0x0B, 0x91, 0x0A, 0x94, 0x09, 0x95, 
0x08, 0x96, 0x07, 0x97, 0x20, 0xF0, 0x1C, 0x63, 0x00, 0xBA, 0x00, 0x65, 0x00, 0xF0, 0x20, 0x6A, 
0xFF, 0x4A, 0x60, 0x9A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x13, 0xF7, 0x20, 0x6A, 0x50, 0x4A, 0x00, 0x9A, 0x00, 0x65, 0x10, 0xF0, 0x20, 0x69, 0xFF, 0x49, 
0x2C, 0xE8, 0x00, 0xDA, 0x00, 0x65, 0x34, 0xB8, 0x00, 0xF4, 0x00, 0x68, 0x2D, 0xE8, 0x90, 0xB9, 
0x00, 0x65, 0x00, 0x65, 0x00, 0x65, 0x14, 0xB8, 0x00, 0xF4, 0x00, 0x69, 0x2C, 0xE8, 0xFB, 0x20, 
0x00, 0x65, 0x10, 0xF0, 0x20, 0x68, 0x20, 0xF4, 0x1F, 0x48, 0x00, 0xE8, 0x00, 0x65, 0x10, 0xF0, 
0x30, 0x6A, 0x00, 0xF3, 0x00, 0x4A, 0x10, 0xF0, 0x30, 0x6B, 0xE0, 0xF6, 0x10, 0x4B, 0x00, 0x68, 
0x00, 0xDA, 0x01, 0xDA, 0x02, 0xDA, 0x03, 0xDA, 0x10, 0x4A, 0x63, 0xEA, 0xF9, 0x61, 0x00, 0x65, 
0x10, 0xF0, 0x30, 0x68, 0x20, 0xF3, 0x00, 0x48, 0xB8, 0x65, 0x00, 0x65, 0x10, 0xF0, 0x30, 0x68, 
0x20, 0xF6, 0x08, 0x48, 0xB8, 0x65, 0x00, 0x68, 0xA8, 0xB9, 0x0C, 0xB8, 0x00, 0x65, 0x1F, 0xF7, 
0x01, 0x69, 0x2D, 0xE8, 0xDF, 0xF7, 0x20, 0x69, 0xFF, 0x49, 0x2C, 0xE8, 0x88, 0xB9, 0x00, 0x65, 
0x10, 0xF0, 0x20, 0x68, 0x40, 0xF5, 0x05, 0x48, 0x00, 0xE8, 0x00, 0x65, 0x20, 0xBA, 0x00, 0x65, 
0xF9, 0x63, 0x0D, 0x62, 0x0C, 0xD1, 0x04, 0x01, 0x8A, 0xD9, 0xAB, 0xD9, 0xCC, 0xD9, 0xED, 0xD9, 
0x6A, 0x99, 0x1F, 0xF7, 0x00, 0x6A, 0x6C, 0xEA, 0x43, 0x32, 0x45, 0xD9, 0x6D, 0x99, 0x1F, 0xF7, 
0x00, 0x6A, 0x6C, 0xEA, 0x43, 0x32, 0x44, 0xD9, 0x6A, 0x99, 0x7C, 0x6A, 0x6C, 0xEA, 0x4B, 0x32, 
0x43, 0xD9, 0x64, 0x99, 0x45, 0x99, 0x83, 0x67, 0xA2, 0x67, 0x00, 0x18, 0x3A, 0x01, 0xB9, 0x65, 
0x09, 0x97, 0x08, 0x91, 0x05, 0x63, 0x00, 0xEF, 0xFB, 0x63, 0x09, 0x62, 0x08, 0xD1, 0x04, 0x01, 
0x86, 0xD9, 0xA7, 0xD9, 0x66, 0x99, 0x47, 0x99, 0x6C, 0xEA, 0x43, 0xD9, 0x63, 0x99, 0x80, 0x6A, 
0x6C, 0xEA, 0x02, 0x22, 0x00, 0x18, 0x5B, 0x03, 0x63, 0x99, 0x40, 0x6A, 0x6C, 0xEA, 0x02, 0x22, 
0x00, 0x18, 0x20, 0x04, 0x63, 0x99, 0x20, 0x6A, 0x6C, 0xEA, 0x02, 0x22, 0x00, 0x18, 0x27, 0x04, 
0x63, 0x99, 0x10, 0x6A, 0x6C, 0xEA, 0x02, 0x22, 0x00, 0x18, 0x94, 0x03, 0x63, 0x99, 0x08, 0x6A, 
0x6C, 0xEA, 0x02, 0x22, 0x00, 0x18, 0xA8, 0x04, 0xB9, 0x65, 0x05, 0x97, 0x04, 0x91, 0x03, 0x63, 
0x00, 0xEF, 0x00, 0x65, 0xFA, 0x63, 0x0B, 0x62, 0x0A, 0xD1, 0x04, 0x01, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0xA0, 0xF0, 0x68, 0x9A, 0x63, 0xD9, 0xA0, 0xF0, 0x08, 0x4A, 0x42, 0xAA, 
0x48, 0xC9, 0x20, 0x6A, 0x49, 0xC1, 0x00, 0x6A, 0x48, 0xC1, 0x00, 0x18, 0x6B, 0x01, 0x60, 0x6C, 
0x00, 0x18, 0x01, 0x03, 0x00, 0x18, 0x87, 0x01, 0x00, 0x18, 0x77, 0x01, 0x00, 0x18, 0x9B, 0x01, 
0x00, 0x18, 0x63, 0x01, 0x0A, 0x6C, 0x00, 0x18, 0x84, 0x07, 0xFF, 0x17, 0xFF, 0x63, 0x01, 0xD1, 
0x3D, 0x67, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xA0, 0xF0, 0x50, 0x9A, 0x00, 0x6B, 
0x60, 0xCA, 0xB9, 0x65, 0x01, 0x91, 0x01, 0x63, 0x20, 0xE8, 0x00, 0x65, 0xFF, 0x63, 0x01, 0xD1, 
0x3D, 0x67, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xA0, 0xF0, 0x54, 0x9A, 0x00, 0x6B, 
0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xA0, 0xF0, 0x58, 0x9A, 0x00, 0xF4, 
0x00, 0x6B, 0x60, 0xDA, 0xB9, 0x65, 0x01, 0x91, 0x01, 0x63, 0x20, 0xE8, 0xFF, 0x63, 0x01, 0xD1, 
0x3D, 0x67, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x12, 0xF0, 0x01, 0x6B, 0x40, 0xF6, 
0x6C, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xA0, 0xF0, 0x5C, 0x9A, 0x04, 0x6B, 
0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF0, 0x40, 0x9A, 0x04, 0x6B, 
0x60, 0xDA, 0xB9, 0x65, 0x01, 0x91, 0x01, 0x63, 0x20, 0xE8, 0x00, 0x65, 0xFF, 0x63, 0x01, 0xD1, 
0x3D, 0x67, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF0, 0x44, 0x9A, 0x01, 0x6B, 
0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF0, 0x48, 0x9A, 0x07, 0x6B, 
0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF0, 0x4C, 0x9A, 0xFF, 0x6B, 
0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF0, 0x50, 0x9A, 0x00, 0x6B, 
0x60, 0xDA, 0xB9, 0x65, 0x01, 0x91, 0x01, 0x63, 0x20, 0xE8, 0x00, 0x65, 0xFB, 0x63, 0x09, 0x62, 
0x08, 0xD1, 0x04, 0x01, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x50, 0x9A, 
0x01, 0x6B, 0x6E, 0xEA, 0x04, 0x2A, 0x06, 0x6C, 0x01, 0x6D, 0x00, 0x18, 0xDC, 0x0E, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF0, 0x54, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 
0x60, 0x33, 0xC0, 0xF0, 0x78, 0x9B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xC0, 0xF0, 0x5C, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x62, 0x99, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0xE0, 0xF0, 0x40, 0x9A, 0x6D, 0xEA, 0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0xC0, 0xF0, 0x5C, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0xE0, 0xF0, 0x44, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x62, 0x99, 0x7E, 0x6A, 0x6D, 0xEA, 
0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xE0, 0xF0, 0x44, 0x9A, 0x62, 0x99, 
0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xE0, 0xF0, 0x48, 0x9A, 0x40, 0x9A, 
0x42, 0xD9, 0x62, 0x99, 0x00, 0xF2, 0x01, 0x6A, 0x6D, 0xEA, 0x42, 0xD9, 0x62, 0x99, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xE0, 0xF0, 0x4C, 0x9A, 0x6D, 0xEA, 0x42, 0xD9, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xE0, 0xF0, 0x48, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x62, 0x99, 
0x00, 0xF4, 0x03, 0x6A, 0x4B, 0xEA, 0x6C, 0xEA, 0x42, 0xD9, 0x62, 0x99, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0xE0, 0xF0, 0x50, 0x9A, 0x6C, 0xEA, 0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0xE0, 0xF0, 0x48, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x62, 0x99, 0x00, 0xF4, 
0x02, 0x6A, 0x6D, 0xEA, 0x42, 0xD9, 0x62, 0x99, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xE0, 0xF0, 0x54, 0x9A, 0x6D, 0xEA, 0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xE0, 0xF0, 0x48, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x00, 0x6A, 0x41, 0xD9, 0x27, 0x10, 0x00, 0x6A, 
0x40, 0xD9, 0x03, 0x10, 0x40, 0x99, 0x01, 0x4A, 0x40, 0xD9, 0x40, 0x99, 0x64, 0x5A, 0x58, 0x67, 
0xF9, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xE0, 0xF0, 0x58, 0x9A, 0x40, 0x9A, 
0x42, 0xD9, 0x62, 0x99, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xE0, 0xF0, 0x5C, 0x9A, 
0x6C, 0xEA, 0x42, 0xD9, 0x62, 0x99, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xE0, 0xF0, 
0x5C, 0x9A, 0x6E, 0xEA, 0x08, 0x22, 0x41, 0x99, 0x01, 0x4A, 0x41, 0xD9, 0x41, 0x99, 0x0A, 0x5A, 
0x58, 0x67, 0xD5, 0x2A, 0x01, 0x10, 0x00, 0x65, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xC0, 0xF0, 0x5C, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x62, 0x99, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x00, 0xF1, 0x40, 0x9A, 0x6C, 0xEA, 0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0xC0, 0xF0, 0x5C, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0xC0, 0xF0, 0x54, 0x9A, 0xE4, 0xF1, 0x17, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x00, 0xF1, 0x44, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 
0x00, 0xF1, 0x68, 0x9B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF0, 
0x5C, 0x9A, 0x24, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF1, 
0x4C, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x62, 0x99, 0x02, 0x6A, 0x4B, 0xEA, 0x6C, 0xEA, 0x42, 0xD9, 
0x62, 0x99, 0x0A, 0x6A, 0x6D, 0xEA, 0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x00, 0xF1, 0x4C, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x00, 0xF1, 0x50, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x62, 0x99, 0x40, 0x6A, 0x6D, 0xEA, 0x42, 0xD9, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF1, 0x50, 0x9A, 0x62, 0x99, 0x60, 0xDA, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF1, 0x54, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 
0x62, 0x99, 0x0C, 0x6A, 0x6D, 0xEA, 0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x00, 0xF1, 0x54, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x00, 0xF1, 0x58, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x62, 0x99, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x00, 0xF1, 0x40, 0x9A, 0x6C, 0xEA, 0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x00, 0xF1, 0x58, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x00, 0xF1, 0x5C, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x62, 0x99, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x20, 0xF1, 0x40, 0x9A, 0x6C, 0xEA, 0x42, 0xD9, 0x62, 0x99, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF1, 0x44, 0x9A, 0x6D, 0xEA, 0x42, 0xD9, 0x62, 0x99, 
0x04, 0xF0, 0x01, 0x6A, 0x4B, 0xEA, 0x6C, 0xEA, 0x42, 0xD9, 0x62, 0x99, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x20, 0xF1, 0x48, 0x9A, 0x6D, 0xEA, 0x42, 0xD9, 0x62, 0x99, 0xE0, 0xF3, 
0x11, 0x6A, 0x4B, 0xEA, 0x6C, 0xEA, 0x42, 0xD9, 0x62, 0x99, 0x30, 0x6A, 0x6D, 0xEA, 0x42, 0xD9, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF1, 0x5C, 0x9A, 0x62, 0x99, 0x60, 0xDA, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF1, 0x4C, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 
0x62, 0x99, 0x20, 0x6A, 0x4B, 0xEA, 0x6C, 0xEA, 0x42, 0xD9, 0x62, 0x99, 0x10, 0x6A, 0x6D, 0xEA, 
0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF1, 0x4C, 0x9A, 0x62, 0x99, 
0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xE0, 0xF0, 0x44, 0x9A, 0x40, 0x9A, 
0x42, 0xD9, 0x62, 0x99, 0x80, 0xF7, 0x00, 0x6A, 0x6D, 0xEA, 0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0xE0, 0xF0, 0x44, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x62, 0x99, 0x01, 0xF0, 
0x00, 0x6A, 0x6D, 0xEA, 0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xE0, 0xF0, 
0x44, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x62, 0x99, 0x01, 0xF0, 0x01, 0x6A, 0x4B, 0xEA, 0x6C, 0xEA, 
0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xE0, 0xF0, 0x44, 0x9A, 0x62, 0x99, 
0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF1, 0x50, 0x9A, 0x40, 0x9A, 
0x42, 0xD9, 0x62, 0x99, 0x10, 0x6A, 0x4B, 0xEA, 0x6C, 0xEA, 0x42, 0xD9, 0x62, 0x99, 0x03, 0x6A, 
0x6D, 0xEA, 0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF1, 0x50, 0x9A, 
0x62, 0x99, 0x60, 0xDA, 0x62, 0x99, 0x10, 0x6A, 0x6D, 0xEA, 0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x20, 0xF1, 0x50, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x62, 0x99, 0x11, 0x6A, 
0x4B, 0xEA, 0x6C, 0xEA, 0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF1, 
0x50, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF1, 
0x54, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x62, 0x99, 0xE0, 0xF1, 0x11, 0x6A, 0x4B, 0xEA, 0x6C, 0xEA, 
0x42, 0xD9, 0x62, 0x99, 0x70, 0x6A, 0x6D, 0xEA, 0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x20, 0xF1, 0x54, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x20, 0xF1, 0x58, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x62, 0x99, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x20, 0xF1, 0x5C, 0x9A, 0x6C, 0xEA, 0x42, 0xD9, 0x62, 0x99, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF1, 0x40, 0x9A, 0x6D, 0xEA, 0x42, 0xD9, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF1, 0x58, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF1, 0x44, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x62, 0x99, 
0x10, 0x6A, 0x4B, 0xEA, 0x6C, 0xEA, 0x42, 0xD9, 0x62, 0x99, 0x01, 0x6A, 0x6D, 0xEA, 0x42, 0xD9, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF1, 0x44, 0x9A, 0x62, 0x99, 0x60, 0xDA, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF1, 0x48, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 
0x62, 0x99, 0xE0, 0xF1, 0x01, 0x6A, 0x4B, 0xEA, 0x6C, 0xEA, 0x42, 0xD9, 0x62, 0x99, 0xA0, 0x6A, 
0x6D, 0xEA, 0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF1, 0x48, 0x9A, 
0x62, 0x99, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xE0, 0xF0, 0x44, 0x9A, 
0x40, 0x9A, 0x42, 0xD9, 0x62, 0x99, 0x7F, 0x6A, 0x4B, 0xEA, 0x6C, 0xEA, 0x42, 0xD9, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xE0, 0xF0, 0x44, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xE0, 0xF0, 0x44, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x62, 0x99, 
0x10, 0x6A, 0x6D, 0xEA, 0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xE0, 0xF0, 
0x44, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF1, 
0x4C, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x62, 0x99, 0x07, 0x6A, 0x6D, 0xEA, 0x42, 0xD9, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF1, 0x4C, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x50, 0x9A, 0x01, 0x6B, 0x6E, 0xEA, 0x04, 0x2A, 
0x06, 0x6C, 0x00, 0x6D, 0x00, 0x18, 0xDC, 0x0E, 0xB9, 0x65, 0x05, 0x97, 0x04, 0x91, 0x03, 0x63, 
0x00, 0xEF, 0x00, 0x65, 0xFC, 0x63, 0x07, 0xD1, 0x3D, 0x67, 0x44, 0x67, 0x20, 0xF0, 0x40, 0xC1, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF1, 0x50, 0x9A, 0x00, 0x6B, 0x60, 0xDA, 
0x82, 0x6A, 0x44, 0xD9, 0x64, 0x99, 0xFF, 0x6A, 0x6C, 0xEA, 0x42, 0xD9, 0x64, 0x99, 0x1F, 0xF7, 
0x00, 0x6A, 0x6C, 0xEA, 0x42, 0x32, 0x43, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x40, 0xF1, 0x54, 0x9A, 0x80, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x40, 0xF1, 0x58, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x40, 0xF1, 0x50, 0x9A, 0x63, 0x99, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x40, 0xF1, 0x54, 0x9A, 0x03, 0x6B, 0x60, 0xDA, 0xB9, 0x65, 0x07, 0x91, 0x04, 0x63, 0x20, 0xE8, 
0xFE, 0x63, 0x03, 0xD1, 0x3D, 0x67, 0x00, 0x6A, 0x41, 0xC1, 0x26, 0x10, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x40, 0xF1, 0x5C, 0x9A, 0x40, 0x9A, 0x62, 0x67, 0x01, 0x6A, 0x4C, 0xEB, 
0xFF, 0x6A, 0x6C, 0xEA, 0x0C, 0x22, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF1, 
0x58, 0x9A, 0x40, 0x9A, 0x00, 0xF6, 0x40, 0x32, 0x00, 0xF6, 0x43, 0x32, 0x13, 0x10, 0x00, 0x6A, 
0x40, 0xC1, 0x03, 0x10, 0x40, 0xA1, 0x01, 0x4A, 0x40, 0xC1, 0x40, 0xA1, 0x0A, 0x5A, 0x58, 0x67, 
0xF9, 0x2A, 0x41, 0xA1, 0x01, 0x4A, 0x41, 0xC1, 0x41, 0xA1, 0x64, 0x5A, 0x58, 0x67, 0xD6, 0x2A, 
0x01, 0x6A, 0x4B, 0xEA, 0xB9, 0x65, 0x03, 0x91, 0x02, 0x63, 0x20, 0xE8, 0xFE, 0x63, 0x03, 0xD1, 
0x3D, 0x67, 0x44, 0x67, 0x50, 0xC1, 0x00, 0x6A, 0x41, 0xC9, 0x2C, 0x10, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x40, 0xF1, 0x5C, 0x9A, 0x60, 0x9A, 0x20, 0x6A, 0x6C, 0xEA, 0x14, 0x22, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF1, 0x58, 0x9A, 0x70, 0xA1, 0x60, 0xDA, 
0x00, 0x6A, 0x40, 0xC9, 0x03, 0x10, 0x40, 0xA9, 0x01, 0x4A, 0x40, 0xC9, 0x40, 0x89, 0x00, 0x52, 
0x58, 0x67, 0xF9, 0x22, 0x00, 0x6A, 0x15, 0x10, 0x00, 0x6A, 0x40, 0xC9, 0x03, 0x10, 0x40, 0xA9, 
0x01, 0x4A, 0x40, 0xC9, 0x40, 0xA9, 0xE0, 0xF3, 0x08, 0x5A, 0x58, 0x67, 0xF8, 0x2A, 0x41, 0xA9, 
0x01, 0x4A, 0x41, 0xC9, 0x41, 0xA9, 0x02, 0xF0, 0x00, 0x5A, 0x58, 0x67, 0xCF, 0x2A, 0x01, 0x6A, 
0x4B, 0xEA, 0xB9, 0x65, 0x03, 0x91, 0x02, 0x63, 0x20, 0xE8, 0x00, 0x65, 0xFD, 0x63, 0x05, 0xD1, 
0x3D, 0x67, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF1, 0x40, 0x9A, 0x40, 0x9A, 
0x42, 0xD9, 0x42, 0x99, 0x01, 0x6B, 0x6E, 0xEA, 0x20, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0xA0, 0xF0, 0x5C, 0x9A, 0x04, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x60, 0xF1, 0x44, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x12, 0xF0, 0x01, 0x6B, 0x40, 0xF6, 0x6C, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0xA0, 0xF0, 0x5C, 0x9A, 0x03, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x60, 0xF1, 0x48, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x42, 0x99, 0x01, 0x6B, 0x6E, 0xEA, 
0x33, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF1, 0x4C, 0x9A, 0x40, 0x9A, 
0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF1, 0x50, 0x9A, 0x40, 0x9A, 
0x40, 0xD9, 0x60, 0x99, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF1, 0x54, 0x9A, 
0x6D, 0xEA, 0x40, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF1, 0x50, 0x9A, 
0x60, 0x99, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x44, 0x9A, 
0x2E, 0xF5, 0x10, 0x5A, 0x58, 0x67, 0x08, 0x22, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xC0, 0xF0, 0x40, 0x9A, 0x03, 0x6B, 0x60, 0xDA, 0xB9, 0x65, 0x05, 0x91, 0x03, 0x63, 0x20, 0xE8, 
0xF8, 0x63, 0x0F, 0x62, 0x0E, 0xD1, 0x04, 0x01, 0x00, 0xF3, 0x00, 0x6A, 0x49, 0xD9, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF0, 0x04, 0x4A, 0x40, 0xD9, 0x47, 0x41, 0x1D, 0x4A, 
0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xA0, 0xF0, 0x58, 0x9A, 0x40, 0x9A, 
0x47, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xA0, 0xF0, 0x58, 0x9A, 0x00, 0x6B, 
0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF1, 0x58, 0x9A, 0x40, 0x9A, 
0x48, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF1, 0x5C, 0x9A, 0x40, 0x9A, 
0x46, 0xD9, 0x66, 0x99, 0x80, 0x6A, 0x6D, 0xEA, 0x46, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x60, 0xF1, 0x5C, 0x9A, 0x66, 0x99, 0x60, 0xDA, 0x68, 0x99, 0x01, 0xF0, 0x00, 0x6A, 
0x6C, 0xEA, 0x1B, 0x22, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF1, 0x40, 0x9A, 
0x88, 0x99, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0x20, 0xF1, 0x68, 0x9B, 0x6D, 0xE4, 
0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF1, 0x44, 0x9A, 0x40, 0x9A, 
0x46, 0xD9, 0x66, 0x99, 0x0F, 0x6A, 0x6C, 0xEA, 0x44, 0xD9, 0x68, 0x99, 0x00, 0xF4, 0x00, 0x6A, 
0x6C, 0xEA, 0x80, 0xF0, 0x1F, 0x22, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF1, 
0x44, 0x9A, 0x40, 0x9A, 0x46, 0xD9, 0x66, 0x99, 0x40, 0x6A, 0x6C, 0xEA, 0x80, 0xF0, 0x0D, 0x2A, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF1, 0x48, 0x9A, 0x40, 0x9A, 0x49, 0xD9, 
0x42, 0x99, 0x60, 0xA2, 0x20, 0x6A, 0x4B, 0xEA, 0x6C, 0xEA, 0x46, 0xC1, 0x46, 0xA1, 0x56, 0x32, 
0x46, 0xC1, 0x42, 0x99, 0x02, 0x4A, 0x40, 0xA2, 0x45, 0xC1, 0x46, 0xA1, 0x7B, 0x22, 0x42, 0x99, 
0x02, 0x4A, 0x40, 0xA2, 0x45, 0xC1, 0x42, 0x99, 0x40, 0xA2, 0x62, 0x67, 0x1F, 0x6A, 0x6C, 0xEA, 
0x02, 0x6B, 0x4E, 0xEB, 0x2F, 0x23, 0x03, 0x52, 0x78, 0x67, 0x02, 0x23, 0x20, 0x22, 0x6A, 0x10, 
0x03, 0x6B, 0x4E, 0xEB, 0x31, 0x23, 0x04, 0x6B, 0x6E, 0xEA, 0x64, 0x2A, 0x42, 0x99, 0x02, 0x4A, 
0x40, 0xA2, 0x07, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0x6B, 0xC0, 0xF6, 
0x6C, 0xC2, 0x42, 0x99, 0x02, 0x4A, 0x40, 0xA2, 0x01, 0x6B, 0x6E, 0xEA, 0x50, 0x2A, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x01, 0x6B, 0xC0, 0xF6, 0x6C, 0xC2, 0x4B, 0x10, 0x42, 0x99, 
0x01, 0x4A, 0x40, 0xA2, 0x62, 0x67, 0x45, 0xA1, 0x00, 0x6C, 0xA3, 0x67, 0xC2, 0x67, 0x00, 0x18, 
0xDC, 0x0E, 0x40, 0x10, 0x42, 0x99, 0x01, 0x4A, 0x40, 0xA2, 0x62, 0x67, 0x45, 0xA1, 0x02, 0x6C, 
0xA3, 0x67, 0xC2, 0x67, 0x00, 0x18, 0xDC, 0x0E, 0x46, 0xA1, 0x05, 0x6B, 0x6E, 0xEA, 0x1C, 0x2A, 
0x45, 0xA1, 0x26, 0x5A, 0x58, 0x67, 0x2D, 0x22, 0x00, 0x6A, 0x45, 0xD9, 0x11, 0x10, 0x65, 0xA1, 
0x45, 0x99, 0x49, 0xE3, 0x48, 0x32, 0x60, 0x99, 0x49, 0xE3, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 
0x60, 0x33, 0x80, 0xF1, 0x68, 0x9B, 0x60, 0x9B, 0x60, 0xDA, 0x45, 0x99, 0x01, 0x4A, 0x45, 0xD9, 
0x45, 0x99, 0x04, 0x5A, 0x58, 0x67, 0xEB, 0x2A, 0x46, 0xA1, 0x02, 0x6B, 0x6E, 0xEA, 0x12, 0x2A, 
0x45, 0xA1, 0x48, 0x32, 0x60, 0x99, 0x49, 0xE3, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 
0x80, 0xF1, 0x68, 0x9B, 0x60, 0x9B, 0x60, 0xDA, 0x05, 0x10, 0x00, 0x65, 0x03, 0x10, 0x00, 0x65, 
0x01, 0x10, 0x00, 0x65, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF1, 0x58, 0x9A, 
0x68, 0x99, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xA0, 0xF0, 0x58, 0x9A, 
0x67, 0x99, 0x60, 0xDA, 0xB9, 0x65, 0x0B, 0x97, 0x0A, 0x91, 0x06, 0x63, 0x00, 0xEF, 0x00, 0x65, 
0xFF, 0x63, 0x01, 0xD1, 0x3D, 0x67, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF1, 
0x4C, 0x9A, 0x40, 0x9A, 0xB9, 0x65, 0x01, 0x91, 0x01, 0x63, 0x20, 0xE8, 0xFD, 0x63, 0x05, 0xD1, 
0x3D, 0x67, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF1, 0x50, 0x9A, 0x40, 0x9A, 
0x42, 0xD9, 0x62, 0x99, 0x02, 0x6A, 0x4B, 0xEA, 0x6C, 0xEA, 0x42, 0xD9, 0x00, 0x6A, 0x41, 0xD9, 
0x03, 0x10, 0x41, 0x99, 0x01, 0x4A, 0x41, 0xD9, 0x41, 0x99, 0x05, 0x5A, 0x58, 0x67, 0xF9, 0x2A, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF1, 0x50, 0x9A, 0x62, 0x99, 0x60, 0xDA, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xA0, 0xF0, 0x54, 0x9A, 0x40, 0x9A, 0x40, 0xD9, 
0x00, 0x6A, 0x41, 0xD9, 0x03, 0x10, 0x41, 0x99, 0x01, 0x4A, 0x41, 0xD9, 0x41, 0x99, 0x05, 0x5A, 
0x58, 0x67, 0xF9, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xA0, 0xF0, 0x54, 0x9A, 
0x80, 0x99, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0x80, 0xF1, 0x74, 0x9B, 0x8C, 0xEB, 
0x60, 0xDA, 0x00, 0x6A, 0x41, 0xD9, 0x03, 0x10, 0x41, 0x99, 0x01, 0x4A, 0x41, 0xD9, 0x41, 0x99, 
0x05, 0x5A, 0x58, 0x67, 0xF9, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF1, 
0x58, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x00, 0x6A, 0x41, 0xD9, 0x03, 0x10, 0x41, 0x99, 0x01, 0x4A, 
0x41, 0xD9, 0x41, 0x99, 0x05, 0x5A, 0x58, 0x67, 0xF9, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x80, 0xF1, 0x5C, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x02, 0x6B, 0x64, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x04, 0xF0, 0x00, 0x6B, 0xC0, 0xF6, 0x74, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0xA0, 0xF0, 0x50, 0x9A, 0x00, 0x6B, 0x60, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x54, 0xA2, 0x61, 0x42, 0xFF, 0x6A, 0x4C, 0xEB, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x74, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x80, 0xF1, 0x58, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x00, 0x6A, 0x41, 0xD9, 
0x03, 0x10, 0x41, 0x99, 0x01, 0x4A, 0x41, 0xD9, 0x41, 0x99, 0x32, 0x5A, 0x58, 0x67, 0xF9, 0x2A, 
0x62, 0x99, 0x01, 0x6A, 0x6D, 0xEA, 0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x80, 0xF1, 0x58, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x00, 0x6A, 0x41, 0xD9, 0x03, 0x10, 0x41, 0x99, 
0x01, 0x4A, 0x41, 0xD9, 0x41, 0x99, 0x32, 0x5A, 0x58, 0x67, 0xF9, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x00, 0xF1, 0x4C, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x00, 0x6A, 0x41, 0xD9, 
0x03, 0x10, 0x41, 0x99, 0x01, 0x4A, 0x41, 0xD9, 0x41, 0x99, 0x05, 0x5A, 0x58, 0x67, 0xF9, 0x2A, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF1, 0x4C, 0x9A, 0x82, 0x99, 0x02, 0x6B, 
0x6B, 0xEB, 0x8C, 0xEB, 0x60, 0xDA, 0x00, 0x6A, 0x41, 0xD9, 0x03, 0x10, 0x41, 0x99, 0x01, 0x4A, 
0x41, 0xD9, 0x41, 0x99, 0x05, 0x5A, 0x58, 0x67, 0xF9, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x80, 0xF1, 0x50, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x00, 0x6A, 0x41, 0xD9, 0x03, 0x10, 
0x41, 0x99, 0x01, 0x4A, 0x41, 0xD9, 0x41, 0x99, 0x05, 0x5A, 0x58, 0x67, 0xF9, 0x2A, 0x62, 0x99, 
0x01, 0x6A, 0x6D, 0xEA, 0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF1, 
0x50, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0xB9, 0x65, 0x05, 0x91, 0x03, 0x63, 0x20, 0xE8, 0x00, 0x65, 
0xFD, 0x63, 0x05, 0xD1, 0x3D, 0x67, 0x00, 0x6A, 0x4E, 0xC1, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x41, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xA0, 0xF1, 0x40, 0x9A, 0x40, 0xAA, 0x46, 0xC9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xA0, 0xF1, 0x40, 0x9A, 0x00, 0x6B, 0x60, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xA0, 0xF1, 0x44, 0x9A, 0x40, 0xAA, 0x45, 0xC9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xA0, 0xF1, 0x44, 0x9A, 0x65, 0xA9, 0x60, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x60, 0xF6, 0x0C, 0x4A, 0x50, 0xA2, 0x61, 0x42, 0xFF, 0x6A, 0x4C, 0xEB, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x70, 0xC2, 0x65, 0xA9, 0x08, 0x6A, 0x6C, 0xEA, 
0x43, 0x22, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x12, 0xF0, 0x04, 0x6B, 0x60, 0xF6, 
0x6C, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xA0, 0xF1, 0x48, 0x9A, 0x01, 0x6B, 
0x60, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x52, 0xA2, 
0x61, 0x42, 0xFF, 0x6A, 0x4C, 0xEB, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 
0x0C, 0x4A, 0x72, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x48, 0x9A, 
0x01, 0x6B, 0x6E, 0xEA, 0x08, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF1, 
0x4C, 0x9A, 0x0B, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 
0x48, 0x9A, 0x02, 0x6B, 0x6E, 0xEA, 0x08, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x00, 0xF1, 0x54, 0x9A, 0x00, 0x6B, 0x60, 0xDA, 0x65, 0xA9, 0x01, 0x6A, 0x4C, 0xEB, 0xFF, 0x6A, 
0x6C, 0xEA, 0xE0, 0xF0, 0x0B, 0x22, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 
0x0C, 0x4A, 0x51, 0xA2, 0x61, 0x42, 0xFF, 0x6A, 0x4C, 0xEB, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x71, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xA0, 0xF1, 0x4C, 0x9A, 0x60, 0xAA, 0xFF, 0xF7, 0x1F, 0x6A, 0x4C, 0xEB, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x63, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x43, 0xAA, 0x62, 0x67, 0x1F, 0xF7, 0x00, 0x6A, 0x6C, 0xEA, 
0x27, 0x22, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x43, 0xAA, 
0x42, 0x33, 0xFF, 0xF7, 0x1F, 0x6A, 0x4C, 0xEB, 0xFF, 0x6A, 0x4C, 0xEB, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x69, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x43, 0xAA, 0xFF, 0x6B, 0x6C, 0xEA, 0x10, 0xF0, 0x10, 0x6B, 
0x60, 0x33, 0x60, 0x33, 0x60, 0xF6, 0x0C, 0x4B, 0x43, 0xCB, 0x01, 0x6A, 0x4E, 0xC1, 0x0A, 0x10, 
0x00, 0x6A, 0x4E, 0xC1, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 
0x00, 0x6B, 0x69, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 
0x43, 0xAA, 0x0B, 0x5A, 0x58, 0x67, 0x3F, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xA0, 0xF1, 0x48, 0x9A, 0x01, 0x6B, 0x60, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x80, 0xF1, 0x40, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0x60, 0xF6, 0x0C, 0x4B, 
0x63, 0xAB, 0x83, 0x67, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0xA0, 0xF1, 0x70, 0x9B, 
0x6D, 0xE4, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 
0x00, 0x6B, 0x63, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x01, 0x6B, 0x6B, 0xEB, 
0x80, 0xF6, 0x68, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x04, 0xF0, 0x00, 0x6B, 
0xC0, 0xF6, 0x74, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xA0, 0xF0, 0x50, 0x9A, 
0x01, 0x6B, 0x60, 0xCA, 0x43, 0x10, 0x00, 0x6A, 0x4F, 0xC1, 0x0F, 0x10, 0x4F, 0xA1, 0x48, 0x32, 
0x61, 0x99, 0x49, 0xE3, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0xA0, 0xF1, 0x74, 0x9B, 
0x60, 0x9B, 0x60, 0xDA, 0x4F, 0xA1, 0x01, 0x4A, 0x4F, 0xC1, 0x8F, 0xA1, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x43, 0xAA, 0x62, 0x67, 0x4E, 0xA1, 0x49, 0xE3, 
0x03, 0x4A, 0x00, 0x52, 0x78, 0x67, 0x01, 0x23, 0x03, 0x4A, 0x4B, 0x32, 0x42, 0xEC, 0x58, 0x67, 
0xDD, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x68, 0xA2, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x73, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0xA0, 0xF1, 0x48, 0x9A, 0x01, 0x6B, 0x60, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x12, 0xF0, 0x03, 0x6B, 0x60, 0xF6, 0x6C, 0xDA, 0x65, 0xA9, 0x02, 0x6A, 
0x6C, 0xEA, 0x11, 0x22, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 
0x4C, 0xA2, 0x61, 0x42, 0xFF, 0x6A, 0x4C, 0xEB, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x60, 0xF6, 0x0C, 0x4A, 0x6C, 0xC2, 0x65, 0xA9, 0x04, 0x6A, 0x6C, 0xEA, 0x11, 0x22, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x4D, 0xA2, 0x61, 0x42, 0xFF, 0x6A, 
0x4C, 0xEB, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x6D, 0xC2, 
0x65, 0xA9, 0x00, 0xF2, 0x00, 0x6A, 0x6C, 0xEA, 0x11, 0x22, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x4F, 0xA2, 0x61, 0x42, 0xFF, 0x6A, 0x4C, 0xEB, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x6F, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0xA0, 0xF1, 0x40, 0x9A, 0x66, 0xA9, 0x60, 0xCA, 0xB9, 0x65, 0x05, 0x91, 
0x03, 0x63, 0x20, 0xE8, 0xFF, 0x63, 0x01, 0xD1, 0x3D, 0x67, 0x82, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0xA0, 0xF1, 0x58, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0xA0, 0xF0, 0x5C, 0x9A, 0x03, 0x6B, 0x60, 0xDA, 0xB9, 0x65, 0x01, 0x91, 
0x01, 0x63, 0x20, 0xE8, 0xFF, 0x63, 0x01, 0xD1, 0x3D, 0x67, 0x82, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0xA0, 0xF1, 0x5C, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0xC0, 0xF0, 0x40, 0x9A, 0x03, 0x6B, 0x60, 0xDA, 0xB9, 0x65, 0x01, 0x91, 
0x01, 0x63, 0x20, 0xE8, 0xFF, 0x63, 0x01, 0xD1, 0x3D, 0x67, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0xA0, 0xF0, 0x5C, 0x9A, 0x04, 0x6B, 0x60, 0xDA, 0xB9, 0x65, 0x01, 0x91, 0x01, 0x63, 
0x20, 0xE8, 0x00, 0x65, 0xFF, 0x63, 0x01, 0xD1, 0x3D, 0x67, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0xC0, 0xF0, 0x40, 0x9A, 0x04, 0x6B, 0x60, 0xDA, 0xB9, 0x65, 0x01, 0x91, 0x01, 0x63, 
0x20, 0xE8, 0x00, 0x65, 0xFE, 0x63, 0x03, 0xD1, 0x3D, 0x67, 0x84, 0xD9, 0xA5, 0xD9, 0xC6, 0xD9, 
0x64, 0x99, 0x46, 0x99, 0x49, 0xE3, 0x40, 0xD9, 0x0A, 0x10, 0x44, 0x99, 0x65, 0x99, 0x60, 0xA3, 
0x60, 0xC2, 0x44, 0x99, 0x01, 0x4A, 0x44, 0xD9, 0x45, 0x99, 0x01, 0x4A, 0x45, 0xD9, 0x65, 0x99, 
0x40, 0x99, 0x43, 0xEB, 0x58, 0x67, 0xF1, 0x2A, 0x44, 0x99, 0xB9, 0x65, 0x03, 0x91, 0x02, 0x63, 
0x20, 0xE8, 0x00, 0x65, 0xFE, 0x63, 0x03, 0xD1, 0x3D, 0x67, 0x84, 0xD9, 0xA5, 0xD9, 0x64, 0x99, 
0x45, 0x99, 0x49, 0xE3, 0x40, 0xD9, 0x06, 0x10, 0x44, 0x99, 0x00, 0x6B, 0x60, 0xC2, 0x44, 0x99, 
0x01, 0x4A, 0x44, 0xD9, 0x64, 0x99, 0x40, 0x99, 0x43, 0xEB, 0x58, 0x67, 0xF5, 0x2A, 0x44, 0x99, 
0xB9, 0x65, 0x03, 0x91, 0x02, 0x63, 0x20, 0xE8, 0xFE, 0x63, 0x03, 0xD1, 0x3D, 0x67, 0x84, 0xD9, 
0xA5, 0xD9, 0xC6, 0xD9, 0x00, 0x6A, 0x40, 0xD9, 0x0F, 0x10, 0x64, 0x99, 0x40, 0x99, 0x49, 0xE3, 
0x60, 0xA2, 0x85, 0x99, 0x40, 0x99, 0x49, 0xE4, 0x40, 0xA2, 0x6E, 0xEA, 0x02, 0x22, 0x00, 0x6A, 
0x09, 0x10, 0x40, 0x99, 0x01, 0x4A, 0x40, 0xD9, 0x60, 0x99, 0x46, 0x99, 0x43, 0xEB, 0x58, 0x67, 
0xEC, 0x2A, 0x01, 0x6A, 0xB9, 0x65, 0x03, 0x91, 0x02, 0x63, 0x20, 0xE8, 0xFF, 0x63, 0x01, 0xD1, 
0x3D, 0x67, 0x44, 0x67, 0xA3, 0xD9, 0x48, 0xC1, 0x43, 0x99, 0x60, 0xAA, 0xFF, 0x6A, 0x4C, 0xEB, 
0x48, 0xA1, 0x6E, 0xEA, 0x48, 0xC1, 0x48, 0xA1, 0x50, 0x32, 0x00, 0xF6, 0x40, 0x33, 0x00, 0xF6, 
0x63, 0x33, 0x48, 0x81, 0x6E, 0xEA, 0x00, 0xF6, 0x40, 0x32, 0x00, 0xF6, 0x43, 0x32, 0x48, 0xC1, 
0x43, 0x99, 0x40, 0xAA, 0x42, 0x33, 0xFF, 0xF7, 0x1F, 0x6A, 0x6C, 0xEA, 0x40, 0x33, 0x60, 0x33, 
0x63, 0x33, 0x63, 0x33, 0x48, 0xA1, 0x40, 0x32, 0x40, 0x32, 0x40, 0x32, 0x43, 0x32, 0x43, 0x32, 
0x6E, 0xEA, 0x40, 0x33, 0x60, 0x33, 0x63, 0x33, 0x63, 0x33, 0x48, 0xA1, 0x4C, 0x32, 0x40, 0x32, 
0x40, 0x32, 0x43, 0x32, 0x43, 0x32, 0x6E, 0xEA, 0x40, 0x33, 0x60, 0x33, 0x63, 0x33, 0x63, 0x33, 
0x48, 0xA1, 0x52, 0x34, 0xFF, 0x6A, 0x8C, 0xEA, 0x6E, 0xEA, 0x40, 0x33, 0x60, 0x33, 0x63, 0x33, 
0x63, 0x33, 0xFF, 0xF7, 0x1F, 0x6A, 0x4C, 0xEB, 0x43, 0x99, 0x60, 0xCA, 0x43, 0x99, 0x40, 0xAA, 
0xB9, 0x65, 0x01, 0x91, 0x01, 0x63, 0x20, 0xE8, 0xFC, 0x63, 0x07, 0x62, 0x06, 0xD1, 0x04, 0x01, 
0x84, 0xD9, 0xA5, 0xD9, 0xC6, 0xD9, 0xE7, 0xD9, 0x44, 0x99, 0x01, 0x6B, 0x4E, 0xEB, 0x04, 0x23, 
0x02, 0x6B, 0x6E, 0xEA, 0x05, 0x22, 0x32, 0x10, 0x6C, 0xF3, 0x03, 0x6A, 0x41, 0xC9, 0x04, 0x10, 
0x01, 0x6A, 0x4B, 0xEA, 0x41, 0xC9, 0x00, 0x65, 0x45, 0x99, 0x40, 0x82, 0x40, 0xC1, 0x45, 0x99, 
0x01, 0x4A, 0x45, 0xD9, 0x60, 0xA1, 0x42, 0x41, 0x83, 0x67, 0xA2, 0x67, 0x00, 0x18, 0xDF, 0x05, 
0x46, 0x99, 0xFF, 0x4A, 0x46, 0xD9, 0x46, 0x99, 0xEF, 0x2A, 0x44, 0x99, 0x02, 0x6B, 0x6E, 0xEA, 
0x06, 0x2A, 0x41, 0xA9, 0x4F, 0xEB, 0xFF, 0xF7, 0x1F, 0x6A, 0x6C, 0xEA, 0x41, 0xC9, 0x61, 0xA9, 
0xFF, 0x6A, 0x4C, 0xEB, 0x47, 0x99, 0x60, 0xC2, 0x41, 0xA9, 0x42, 0x33, 0xFF, 0xF7, 0x1F, 0x6A, 
0x4C, 0xEB, 0xFF, 0x6A, 0x4C, 0xEB, 0x48, 0x99, 0x60, 0xC2, 0x00, 0x65, 0xB9, 0x65, 0x03, 0x97, 
0x02, 0x91, 0x02, 0x63, 0x00, 0xEF, 0x00, 0x65, 0xFB, 0x63, 0x09, 0x62, 0x08, 0xD1, 0x06, 0x01, 
0x84, 0xD9, 0x65, 0x67, 0x46, 0x67, 0x74, 0xC1, 0x58, 0xC1, 0x58, 0xA1, 0x01, 0x6B, 0x6E, 0xEA, 
0x0B, 0x2A, 0xA4, 0x99, 0x74, 0xA1, 0x43, 0x41, 0x84, 0x41, 0x04, 0xD4, 0x01, 0x6C, 0xC3, 0x67, 
0xE2, 0x67, 0x00, 0x18, 0x06, 0x06, 0x0A, 0x10, 0xA4, 0x99, 0x74, 0xA1, 0x43, 0x41, 0x84, 0x41, 
0x04, 0xD4, 0x02, 0x6C, 0xC3, 0x67, 0xE2, 0x67, 0x00, 0x18, 0x06, 0x06, 0x43, 0xA1, 0x40, 0xC9, 
0x40, 0xA9, 0x40, 0x32, 0x40, 0xC9, 0x44, 0xA1, 0x62, 0x67, 0x40, 0xA9, 0x6D, 0xEA, 0x40, 0xC9, 
0x40, 0xA9, 0xB9, 0x65, 0x03, 0x97, 0x02, 0x91, 0x02, 0x63, 0x00, 0xEF, 0xFD, 0x63, 0x05, 0xD1, 
0x3D, 0x67, 0xB9, 0x65, 0x05, 0x91, 0x03, 0x63, 0x20, 0xE8, 0x00, 0x65, 0xFF, 0x63, 0x01, 0xD1, 
0x3D, 0x67, 0xB9, 0x65, 0x01, 0x91, 0x01, 0x63, 0x20, 0xE8, 0x00, 0x65, 0xFF, 0x63, 0x01, 0xD1, 
0x3D, 0x67, 0xB9, 0x65, 0x01, 0x91, 0x01, 0x63, 0x20, 0xE8, 0x00, 0x65, 0xFD, 0x63, 0x05, 0xD1, 
0x3D, 0x67, 0x86, 0xD9, 0x46, 0x99, 0x40, 0xD9, 0x40, 0x99, 0x77, 0xF0, 0x24, 0x6B, 0x4D, 0xE3, 
0x40, 0x9B, 0x62, 0xD9, 0x41, 0xD9, 0x41, 0x99, 0xB9, 0x65, 0x05, 0x91, 0x03, 0x63, 0x20, 0xE8, 
0xFD, 0x63, 0x05, 0xD1, 0x3D, 0x67, 0x86, 0xD9, 0xA7, 0xD9, 0x46, 0x99, 0x40, 0xD9, 0x47, 0x99, 
0x41, 0xD9, 0x41, 0x99, 0x60, 0x99, 0x77, 0xF0, 0x24, 0x6A, 0x69, 0xE2, 0x40, 0xDA, 0x42, 0xD9, 
0xB9, 0x65, 0x05, 0x91, 0x03, 0x63, 0x20, 0xE8, 0xFF, 0x63, 0x01, 0xD1, 0x3D, 0x67, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x44, 0x9A, 0x61, 0x42, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x64, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xC0, 0xF1, 0x40, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0x00, 0xF3, 0x64, 0x9B, 
0x60, 0xDA, 0xB9, 0x65, 0x01, 0x91, 0x01, 0x63, 0x20, 0xE8, 0x00, 0x65, 0xFE, 0x63, 0x03, 0xD1, 
0x3D, 0x67, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x02, 0x6B, 
0x64, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x00, 0x6B, 
0x61, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x40, 0x9A, 0x00, 0x6B, 
0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x44, 0x9A, 0x08, 0x6B, 
0x60, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x48, 0x9A, 0xA7, 0xF7, 
0x07, 0x6B, 0x6B, 0xEB, 0x60, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 
0x4C, 0x9A, 0x00, 0xF4, 0x05, 0x6B, 0x60, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x04, 0xF0, 0x00, 0x6B, 0xC0, 0xF6, 0x74, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x00, 0xF0, 0x64, 0xA2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 
0x6C, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF0, 0x04, 0x4A, 0x61, 0xA2, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x6D, 0xC2, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF0, 0x04, 0x4A, 0x62, 0xA2, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x6E, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x00, 0xF0, 0x04, 0x4A, 0x63, 0xA2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xC0, 0xF6, 0x14, 0x4A, 0x6F, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF0, 
0x04, 0x4A, 0x64, 0xA2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 
0x70, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF0, 0x04, 0x4A, 0x65, 0xA2, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x71, 0xC2, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF0, 0x04, 0x4A, 0x66, 0xA2, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x72, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x00, 0xF0, 0x04, 0x4A, 0x67, 0xA2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xC0, 0xF6, 0x14, 0x4A, 0x73, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF0, 
0x04, 0x4A, 0x68, 0xA2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 
0x74, 0xC2, 0xB9, 0x65, 0x03, 0x91, 0x02, 0x63, 0x20, 0xE8, 0x00, 0x65, 0xFE, 0x63, 0x03, 0xD1, 
0x3D, 0x67, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x12, 0xF0, 0x06, 0x6B, 0x60, 0xF6, 
0x6C, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x50, 0x9A, 0x01, 0x6B, 
0x60, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x4C, 0x9A, 0x00, 0xF4, 
0x05, 0x6B, 0x60, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x48, 0x9A, 
0x87, 0xF7, 0x07, 0x6B, 0x6B, 0xEB, 0x60, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x20, 0xF2, 0x4C, 0x9A, 0x00, 0xF4, 0x05, 0x6B, 0x60, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x20, 0xF2, 0x54, 0x9A, 0x08, 0x6B, 0x60, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x00, 0xF3, 0x48, 0x9A, 0x01, 0x6B, 0x6E, 0xEA, 0x08, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x58, 0x9A, 0x1B, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x48, 0x9A, 0x02, 0x6B, 0x6E, 0xEA, 0x10, 0x2A, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x5C, 0x9A, 0x02, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x58, 0x9A, 0x0B, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x40, 0x9A, 0x02, 0x6B, 0x60, 0xCA, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x44, 0x9A, 0x44, 0x6B, 0x60, 0xDA, 0xB9, 0x65, 
0x03, 0x91, 0x02, 0x63, 0x20, 0xE8, 0x00, 0x65, 0xFE, 0x63, 0x03, 0xD1, 0x3D, 0x67, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x12, 0xF0, 0x06, 0x6B, 0x60, 0xF6, 0x6C, 0xDA, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x50, 0x9A, 0x01, 0x6B, 0x60, 0xC2, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x4C, 0x9A, 0x00, 0xF4, 0x05, 0x6B, 0x60, 0xCA, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x48, 0x9A, 0x87, 0xF7, 0x07, 0x6B, 
0x6B, 0xEB, 0x60, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x4C, 0x9A, 
0x00, 0xF4, 0x05, 0x6B, 0x60, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 
0x54, 0x9A, 0x08, 0x6B, 0x60, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 
0x48, 0x9A, 0x01, 0x6B, 0x6E, 0xEA, 0x08, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x20, 0xF2, 0x58, 0x9A, 0x1B, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x00, 0xF3, 0x48, 0x9A, 0x02, 0x6B, 0x6E, 0xEA, 0x10, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x20, 0xF2, 0x5C, 0x9A, 0x02, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x20, 0xF2, 0x58, 0x9A, 0x0B, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x40, 0xF2, 0x40, 0x9A, 0x01, 0x6B, 0x60, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x40, 0xF2, 0x44, 0x9A, 0x00, 0x6B, 0x60, 0xDA, 0xB9, 0x65, 0x03, 0x91, 0x02, 0x63, 
0x20, 0xE8, 0x00, 0x65, 0xFE, 0x63, 0x03, 0xD1, 0x3D, 0x67, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x12, 0xF0, 0x06, 0x6B, 0x60, 0xF6, 0x6C, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x20, 0xF2, 0x50, 0x9A, 0x01, 0x6B, 0x60, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x20, 0xF2, 0x4C, 0x9A, 0x00, 0xF4, 0x05, 0x6B, 0x60, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x48, 0x9A, 0x87, 0xF7, 0x07, 0x6B, 0x6B, 0xEB, 0x60, 0xCA, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x4C, 0x9A, 0x00, 0xF4, 0x05, 0x6B, 
0x60, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x54, 0x9A, 0x08, 0x6B, 
0x60, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x48, 0x9A, 0x01, 0x6B, 
0x6E, 0xEA, 0x08, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x58, 0x9A, 
0x1B, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x48, 0x9A, 
0x02, 0x6B, 0x6E, 0xEA, 0x10, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 
0x5C, 0x9A, 0x02, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 
0x58, 0x9A, 0x0B, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 
0x40, 0x9A, 0x01, 0x6B, 0x60, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 
0x44, 0x9A, 0x00, 0x6B, 0x60, 0xDA, 0xB9, 0x65, 0x03, 0x91, 0x02, 0x63, 0x20, 0xE8, 0x00, 0x65, 
0xF8, 0x63, 0x0F, 0x62, 0x0E, 0xD1, 0x04, 0x01, 0x44, 0x67, 0x20, 0xF0, 0x50, 0xC1, 0x00, 0x6A, 
0x5C, 0xC1, 0x00, 0x6A, 0x43, 0xD9, 0x00, 0x6A, 0x42, 0xD9, 0x00, 0x6A, 0x44, 0xC1, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF0, 0x04, 0x4A, 0x40, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x48, 0x9A, 0x40, 0x9A, 0x46, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x48, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 
0x40, 0xF2, 0x6C, 0x9B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 
0x48, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0x40, 0xF2, 0x70, 0x9B, 0x60, 0xDA, 
0x00, 0x6A, 0x51, 0xC9, 0x03, 0x10, 0x51, 0xA9, 0x01, 0x4A, 0x51, 0xC9, 0x51, 0xA9, 0x0A, 0x5A, 
0x58, 0x67, 0xF9, 0x2A, 0x00, 0x18, 0x73, 0x06, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x40, 0xF2, 0x54, 0x9A, 0xFF, 0x6B, 0x60, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x12, 0xF0, 0x06, 0x6B, 0x60, 0xF6, 0x6C, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x40, 0xF2, 0x58, 0x9A, 0x01, 0x6B, 0x60, 0xCA, 0x01, 0x10, 0x00, 0x65, 0x00, 0x18, 0xF9, 0x08, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x5C, 0x9A, 0x40, 0x9A, 0x45, 0xD9, 
0x45, 0x99, 0x22, 0xF2, 0x14, 0x6B, 0x6E, 0xEA, 0x01, 0x5A, 0x58, 0x67, 0x62, 0x67, 0xFF, 0x6A, 
0x4C, 0xEB, 0x45, 0x99, 0x22, 0xF2, 0x15, 0x6C, 0x8E, 0xEA, 0x01, 0x5A, 0x58, 0x67, 0x82, 0x67, 
0xFF, 0x6A, 0x8C, 0xEA, 0x4D, 0xEB, 0xFF, 0x6A, 0x6C, 0xEA, 0x62, 0x67, 0x45, 0x99, 0x22, 0xF2, 
0x16, 0x6C, 0x8E, 0xEA, 0x01, 0x5A, 0x58, 0x67, 0x6D, 0xEA, 0x2D, 0x22, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x60, 0xF2, 0x40, 0x9A, 0x40, 0x9A, 0x44, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x60, 0xF2, 0x40, 0x9A, 0x64, 0x99, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x60, 0xF2, 0x44, 0x9A, 0x80, 0xF4, 0x00, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF2, 0x48, 0x9A, 0x40, 0x9A, 0x44, 0xD9, 0x64, 0x99, 
0x80, 0x6A, 0x6D, 0xEA, 0x44, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF2, 
0x48, 0x9A, 0x64, 0x99, 0x60, 0xDA, 0x45, 0x99, 0x02, 0xF1, 0x11, 0x6B, 0x6E, 0xEA, 0x12, 0x2A, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF1, 0x04, 0x4A, 0x82, 0x67, 0x00, 0x18, 
0xCB, 0x10, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x5C, 0x9A, 0x24, 0xF2, 
0x02, 0x6B, 0x60, 0xDA, 0x45, 0x99, 0x26, 0xF3, 0x12, 0x6C, 0x8E, 0xEA, 0x39, 0x2A, 0x00, 0x6A, 
0x45, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x4D, 0xA2, 
0x45, 0xD9, 0x45, 0x99, 0x40, 0x32, 0x45, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x60, 0xF6, 0x0C, 0x4A, 0x53, 0xA2, 0x65, 0x99, 0x6D, 0xEA, 0x45, 0xD9, 0x45, 0x99, 0x40, 0x32, 
0x45, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x43, 0xAA, 
0x65, 0x99, 0x6D, 0xEA, 0x45, 0xD9, 0x45, 0x99, 0x40, 0x32, 0x45, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x54, 0xA2, 0x65, 0x99, 0x6D, 0xEA, 0x45, 0xD9, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x5C, 0x9A, 0x65, 0x99, 0x60, 0xDA, 
0x45, 0x99, 0x26, 0xF3, 0x13, 0x6B, 0x6E, 0xEA, 0x0C, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x40, 0xF2, 0x5C, 0x9A, 0x60, 0x99, 0x60, 0x9B, 0x60, 0xDA, 0x40, 0x99, 0x04, 0x4A, 
0x40, 0xD9, 0x45, 0x99, 0x26, 0xF3, 0x14, 0x6C, 0x8E, 0xEA, 0x39, 0x2A, 0x00, 0x6A, 0x45, 0xD9, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x51, 0xA2, 0x45, 0xD9, 
0x45, 0x99, 0x40, 0x32, 0x45, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 
0x0C, 0x4A, 0x52, 0xA2, 0x65, 0x99, 0x6D, 0xEA, 0x45, 0xD9, 0x45, 0x99, 0x40, 0x32, 0x45, 0xD9, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x50, 0xA2, 0x65, 0x99, 
0x6D, 0xEA, 0x45, 0xD9, 0x45, 0x99, 0x40, 0x32, 0x45, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x4C, 0xA2, 0x65, 0x99, 0x6D, 0xEA, 0x45, 0xD9, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x5C, 0x9A, 0x65, 0x99, 0x60, 0xDA, 0x45, 0x99, 
0x26, 0xF3, 0x15, 0x6B, 0x6E, 0xEA, 0x0D, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x40, 0xF2, 0x5C, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0xC0, 0xF6, 0x74, 0x9B, 
0x60, 0xDA, 0x45, 0x99, 0x26, 0xF3, 0x16, 0x6C, 0x8E, 0xEA, 0x0D, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x5C, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 
0xE0, 0xF6, 0x6C, 0x9B, 0x60, 0xDA, 0x45, 0x99, 0x26, 0xF3, 0x17, 0x6B, 0x6E, 0xEA, 0x0D, 0x2A, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x5C, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 
0x60, 0x33, 0x60, 0x33, 0xC0, 0xF6, 0x70, 0x9B, 0x60, 0xDA, 0x45, 0x99, 0x26, 0xF3, 0x18, 0x6C, 
0x8E, 0xEA, 0x07, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x01, 0x6B, 0x00, 0xF3, 
0x68, 0xDA, 0x45, 0x99, 0x26, 0xF3, 0x19, 0x6B, 0x6E, 0xEA, 0x07, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x02, 0x6B, 0x00, 0xF3, 0x68, 0xDA, 0x45, 0x99, 0x46, 0xF3, 0x00, 0x6C, 
0x8E, 0xEA, 0x07, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0x6B, 0x00, 0xF3, 
0x68, 0xDA, 0x45, 0x99, 0x46, 0xF3, 0x01, 0x6B, 0x6E, 0xEA, 0x0D, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x5C, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 
0x00, 0xF3, 0x68, 0x9B, 0x60, 0xDA, 0x45, 0x99, 0x22, 0xF2, 0x14, 0x6C, 0x8E, 0xEA, 0x2E, 0x2A, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x5C, 0x9A, 0xAA, 0xF5, 0x0A, 0x6B, 
0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF2, 0x48, 0x9A, 0x10, 0xF0, 
0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0x60, 0xF2, 0x6C, 0x9B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x60, 0xF2, 0x50, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 
0x60, 0xF2, 0x74, 0x9B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF2, 
0x58, 0x9A, 0x00, 0xF2, 0x00, 0x6B, 0x60, 0xDA, 0x00, 0x18, 0x27, 0x01, 0x45, 0x99, 0x22, 0xF2, 
0x15, 0x6B, 0x6E, 0xEA, 0x37, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 
0x5C, 0x9A, 0x93, 0xF1, 0x19, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x60, 0xF2, 0x5C, 0x9A, 0xAF, 0xF3, 0x1C, 0x6B, 0x6B, 0xEB, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x40, 0x9A, 0x00, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x60, 0xF2, 0x50, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 
0x60, 0xF2, 0x74, 0x9B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF2, 
0x48, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0x80, 0xF2, 0x60, 0x9B, 0x60, 0xDA, 
0x00, 0x18, 0x27, 0x01, 0x45, 0x99, 0x22, 0xF2, 0x16, 0x6C, 0x8E, 0xEA, 0x2F, 0x2A, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x5C, 0x9A, 0x93, 0xF1, 0x19, 0x6B, 0x60, 0xDA, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF2, 0x50, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 
0x60, 0x33, 0x60, 0x33, 0x60, 0xF2, 0x74, 0x9B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x60, 0xF2, 0x48, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0x80, 0xF2, 
0x64, 0x9B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF2, 0x5C, 0x9A, 
0xAF, 0xF3, 0x1C, 0x6B, 0x6B, 0xEB, 0x60, 0xDA, 0x00, 0x18, 0x27, 0x01, 0x45, 0x99, 0x24, 0xF2, 
0x16, 0x6B, 0x6E, 0xEA, 0x07, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x01, 0x6B, 
0xC0, 0xF6, 0x70, 0xDA, 0x45, 0x99, 0x24, 0xF2, 0x15, 0x6C, 0x8E, 0xEA, 0x07, 0x2A, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x02, 0x6B, 0xC0, 0xF6, 0x70, 0xDA, 0x45, 0x99, 0x24, 0xF2, 
0x14, 0x6B, 0x6E, 0xEA, 0x07, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x03, 0x6B, 
0xC0, 0xF6, 0x70, 0xDA, 0x45, 0x99, 0x44, 0xF2, 0x00, 0x6C, 0x8E, 0xEA, 0x07, 0x2A, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x01, 0x6B, 0x00, 0xF3, 0x6C, 0xDA, 0x45, 0x99, 0x44, 0xF2, 
0x01, 0x6B, 0x6E, 0xEA, 0x0D, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 
0x5C, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0x00, 0xF3, 0x6C, 0x9B, 0x60, 0xDA, 
0x45, 0x99, 0x44, 0xF2, 0x02, 0x6C, 0x8E, 0xEA, 0x0E, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x40, 0xF2, 0x5C, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0xC0, 0xF6, 
0x14, 0x4B, 0x64, 0xAB, 0x60, 0xDA, 0x45, 0x99, 0x44, 0xF2, 0x03, 0x6B, 0x6E, 0xEA, 0x07, 0x2A, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x01, 0x6B, 0x00, 0xF3, 0x70, 0xDA, 0x45, 0x99, 
0x44, 0xF2, 0x04, 0x6C, 0x8E, 0xEA, 0x07, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x00, 0x6B, 0x00, 0xF3, 0x70, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 
0x4C, 0x9A, 0x12, 0xF0, 0x03, 0x6B, 0x6E, 0xEA, 0x7F, 0xF5, 0x1F, 0x2A, 0x00, 0x18, 0x07, 0x0A, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x12, 0xF0, 0x06, 0x6B, 0x60, 0xF6, 0x6C, 0xDA, 
0x75, 0x15, 0x00, 0x65, 0xFB, 0x63, 0x09, 0x62, 0x08, 0xD1, 0x04, 0x01, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x80, 0xF2, 0x48, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x62, 0x99, 0x10, 0x6A, 
0x6C, 0xEA, 0x71, 0x22, 0x00, 0x6A, 0x40, 0xC1, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xE0, 0xF6, 0x4C, 0x9A, 0x61, 0x42, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xE0, 0xF6, 
0x6C, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xE0, 0xF6, 0x6C, 0x9A, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF2, 0x4C, 0x9A, 0x63, 0xEA, 0x58, 0x67, 0x5C, 0x22, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0x6B, 0xE0, 0xF6, 0x6C, 0xDA, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x50, 0x9A, 0x01, 0x6B, 0x6E, 0xEA, 0x04, 0x2A, 
0x04, 0x6C, 0x00, 0x6D, 0x00, 0x18, 0xDC, 0x0E, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xC0, 0xF6, 0x14, 0x4A, 0x02, 0x6B, 0x64, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xC0, 0xF6, 0x50, 0x9A, 0x01, 0x6B, 0x6E, 0xEA, 0x09, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x40, 0xF2, 0x5C, 0x9A, 0x22, 0xF2, 0x16, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x50, 0x9A, 0x02, 0x6B, 0x6E, 0xEA, 0x09, 0x2A, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x5C, 0x9A, 0x22, 0xF2, 0x15, 0x6B, 0x60, 0xDA, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x50, 0x9A, 0x03, 0x6B, 0x6E, 0xEA, 
0x13, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x5C, 0x9A, 0x22, 0xF2, 
0x14, 0x6B, 0x60, 0xDA, 0x09, 0x10, 0x01, 0x6A, 0x40, 0xC1, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x00, 0x6B, 0xE0, 0xF6, 0x6C, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xC0, 0xF6, 0x14, 0x4A, 0x44, 0xAA, 0x02, 0x6B, 0x6E, 0xEA, 0xE0, 0xF0, 0x0B, 0x2A, 0x40, 0xA1, 
0x01, 0x6B, 0x6E, 0xEA, 0x10, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 
0x14, 0x4A, 0x41, 0x9A, 0x61, 0x42, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 
0x14, 0x4A, 0x61, 0xDA, 0x08, 0x10, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 
0x14, 0x4A, 0x00, 0x6B, 0x61, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 
0x14, 0x4A, 0x41, 0x9A, 0x11, 0x5A, 0x58, 0x67, 0xE0, 0xF0, 0x12, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x00, 0x6B, 0x61, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x80, 0xF2, 0x50, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x62, 0x99, 0x02, 0x6A, 
0x4B, 0xEA, 0x6C, 0xEA, 0x42, 0xD9, 0x00, 0x6A, 0x41, 0xD9, 0x03, 0x10, 0x41, 0x99, 0x01, 0x4A, 
0x41, 0xD9, 0x41, 0x99, 0x0A, 0x5A, 0x58, 0x67, 0xF9, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x80, 0xF2, 0x50, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x00, 0x6A, 0x41, 0xD9, 0x03, 0x10, 
0x41, 0x99, 0x01, 0x4A, 0x41, 0xD9, 0x41, 0x99, 0x0A, 0x5A, 0x58, 0x67, 0xF9, 0x2A, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x58, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x00, 0x6A, 
0x41, 0xD9, 0x03, 0x10, 0x41, 0x99, 0x01, 0x4A, 0x41, 0xD9, 0x41, 0x99, 0x32, 0x5A, 0x58, 0x67, 
0xF9, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x58, 0x9A, 0x82, 0x99, 
0x01, 0x6B, 0x8D, 0xEB, 0x60, 0xDA, 0x00, 0x6A, 0x41, 0xD9, 0x03, 0x10, 0x41, 0x99, 0x01, 0x4A, 
0x41, 0xD9, 0x41, 0x99, 0x32, 0x5A, 0x58, 0x67, 0xF9, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x80, 0xF2, 0x54, 0x9A, 0x00, 0x6B, 0x60, 0xDA, 0x00, 0x6A, 0x41, 0xD9, 0x03, 0x10, 
0x41, 0x99, 0x01, 0x4A, 0x41, 0xD9, 0x41, 0x99, 0x32, 0x5A, 0x58, 0x67, 0xF9, 0x2A, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF2, 0x54, 0x9A, 0x07, 0x6B, 0x60, 0xDA, 0x00, 0x6A, 
0x41, 0xD9, 0x11, 0x10, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF2, 0x58, 0x9A, 
0x40, 0x9A, 0x42, 0xD9, 0x62, 0x99, 0x01, 0x6A, 0x4C, 0xEB, 0xFF, 0x6A, 0x6C, 0xEA, 0x0E, 0x2A, 
0x41, 0x99, 0x01, 0x4A, 0x41, 0xD9, 0x61, 0x99, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x80, 0xF2, 0x5C, 0x9A, 0x43, 0xEB, 0x58, 0x67, 0xE5, 0x2A, 0x01, 0x10, 0x00, 0x65, 0x00, 0x18, 
0xD3, 0x09, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x58, 0x9A, 0x01, 0x6B, 
0x60, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF2, 0x50, 0x9A, 0x40, 0x9A, 
0x42, 0xD9, 0x62, 0x99, 0x01, 0x6A, 0x6D, 0xEA, 0x42, 0xD9, 0x00, 0x6A, 0x41, 0xD9, 0x03, 0x10, 
0x41, 0x99, 0x01, 0x4A, 0x41, 0xD9, 0x41, 0x99, 0x0A, 0x5A, 0x58, 0x67, 0xF9, 0x2A, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF2, 0x50, 0x9A, 0x62, 0x99, 0x60, 0xDA, 0x00, 0x6A, 
0x41, 0xD9, 0x03, 0x10, 0x41, 0x99, 0x01, 0x4A, 0x41, 0xD9, 0x41, 0x99, 0x0A, 0x5A, 0x58, 0x67, 
0xF9, 0x2A, 0x2E, 0x10, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x4C, 0x9A, 
0x27, 0x22, 0x01, 0x10, 0x00, 0x65, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF2, 
0x48, 0x9A, 0x40, 0x9A, 0x42, 0xD9, 0x62, 0x99, 0x10, 0x6A, 0x6C, 0xEA, 0x18, 0x22, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x4C, 0x9A, 0x61, 0x42, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x6C, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x00, 0xF3, 0x4C, 0x9A, 0x02, 0xF0, 0x01, 0x5A, 0x58, 0x67, 0xDC, 0x2A, 0x01, 0x10, 0x00, 0x65, 
0xB9, 0x65, 0x05, 0x97, 0x04, 0x91, 0x03, 0x63, 0x00, 0xEF, 0x00, 0x65, 0xFC, 0x63, 0x07, 0x62, 
0x06, 0xD1, 0x04, 0x01, 0x00, 0x6A, 0x40, 0xD9, 0x03, 0x10, 0x40, 0x99, 0x01, 0x4A, 0x40, 0xD9, 
0x40, 0x99, 0x32, 0x5A, 0x58, 0x67, 0xF9, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x20, 0xF2, 0x40, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0xA0, 0xF2, 0x60, 0x9B, 
0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x50, 0x9A, 0x01, 0x6B, 
0x6E, 0xEA, 0x16, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 
0x44, 0xAA, 0x02, 0x6B, 0x6E, 0xEA, 0x0C, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xC0, 0xF6, 0x14, 0x4A, 0x01, 0x6B, 0x64, 0xCA, 0x04, 0x6C, 0x00, 0x6D, 0x00, 0x18, 0xDC, 0x0E, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x01, 0x6B, 0x64, 0xCA, 
0xB9, 0x65, 0x03, 0x97, 0x02, 0x91, 0x02, 0x63, 0x00, 0xEF, 0x00, 0x65, 0xFF, 0x63, 0x01, 0xD1, 
0x3D, 0x67, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x02, 0x6B, 
0x64, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x40, 0x9A, 0x00, 0x6B, 
0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x04, 0xF0, 0x00, 0x6B, 0xC0, 0xF6, 
0x74, 0xDA, 0xB9, 0x65, 0x01, 0x91, 0x01, 0x63, 0x20, 0xE8, 0x00, 0x65, 0xFC, 0x63, 0x07, 0x62, 
0x06, 0xD1, 0x04, 0x01, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x54, 0x9A, 
0x1C, 0xF0, 0x00, 0x4A, 0x0E, 0x5A, 0x78, 0x67, 0x20, 0xF1, 0x00, 0x23, 0x48, 0x33, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF1, 0x0C, 0x4A, 0x49, 0xE3, 0x40, 0x9A, 0x00, 0xEA, 
0x00, 0x18, 0x60, 0x0D, 0x44, 0xC1, 0x44, 0xA1, 0x01, 0x6B, 0x6E, 0xEA, 0x00, 0xF1, 0x10, 0x2A, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x04, 0xF0, 0x01, 0x6B, 0xC0, 0xF6, 0x74, 0xDA, 
0x08, 0x11, 0x00, 0x18, 0xA4, 0x0A, 0x44, 0xC1, 0x44, 0xA1, 0x02, 0x2A, 0x00, 0x6A, 0x02, 0x11, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x58, 0x9A, 0x05, 0x6B, 0x60, 0xCA, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x04, 0xF0, 0x01, 0x6B, 0xC0, 0xF6, 0x74, 0xDA, 
0xF0, 0x10, 0x01, 0x6C, 0x00, 0x18, 0xB4, 0x0A, 0x44, 0xC1, 0x44, 0xA1, 0x0A, 0x2A, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x04, 0xF0, 0x00, 0x6B, 0xC0, 0xF6, 0x74, 0xDA, 0x00, 0x6A, 
0xE1, 0x10, 0x44, 0xA1, 0x01, 0x6B, 0x6E, 0xEA, 0x0A, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x04, 0xF0, 0x01, 0x6B, 0xC0, 0xF6, 0x74, 0xDA, 0x00, 0x6A, 0xD3, 0x10, 0x44, 0xA1, 
0x02, 0x6B, 0x6E, 0xEA, 0x0A, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x04, 0xF0, 
0x0C, 0x6B, 0xC0, 0xF6, 0x74, 0xDA, 0x00, 0x6A, 0xC5, 0x10, 0x44, 0xA1, 0x07, 0x6B, 0x6E, 0xEA, 
0x0A, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x04, 0xF0, 0x03, 0x6B, 0xC0, 0xF6, 
0x74, 0xDA, 0x00, 0x6A, 0xB7, 0x10, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x04, 0xF0, 
0x00, 0x6B, 0xC0, 0xF6, 0x74, 0xDA, 0x00, 0x6A, 0xAD, 0x10, 0x02, 0x6C, 0x00, 0x18, 0xA1, 0x0B, 
0x44, 0xC1, 0x44, 0xA1, 0x0A, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x04, 0xF0, 
0x00, 0x6B, 0xC0, 0xF6, 0x74, 0xDA, 0x00, 0x6A, 0x9D, 0x10, 0x44, 0xA1, 0x01, 0x6B, 0x6E, 0xEA, 
0x0A, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x04, 0xF0, 0x03, 0x6B, 0xC0, 0xF6, 
0x74, 0xDA, 0x00, 0x6A, 0x8F, 0x10, 0x44, 0xA1, 0x02, 0x6B, 0x6E, 0xEA, 0x12, 0x2A, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x04, 0xF0, 0x0C, 0x6B, 0xC0, 0xF6, 0x74, 0xDA, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x58, 0x9A, 0x07, 0x6B, 0x60, 0xCA, 0x00, 0x6A, 
0x79, 0x10, 0x44, 0xA1, 0x07, 0x6B, 0x6E, 0xEA, 0x12, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x04, 0xF0, 0x0C, 0x6B, 0xC0, 0xF6, 0x74, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x40, 0xF2, 0x58, 0x9A, 0x07, 0x6B, 0x60, 0xCA, 0x00, 0x6A, 0x63, 0x10, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x04, 0xF0, 0x00, 0x6B, 0xC0, 0xF6, 0x74, 0xDA, 0x00, 0x6A, 
0x59, 0x10, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x4B, 0xA2, 
0x12, 0x22, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x04, 0xF0, 0x00, 0x6B, 0xC0, 0xF6, 
0x74, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x58, 0x9A, 0x05, 0x6B, 
0x60, 0xCA, 0x00, 0x6A, 0x3F, 0x10, 0x00, 0x18, 0x40, 0x0D, 0x44, 0xC1, 0x44, 0xA1, 0x03, 0x6B, 
0x6E, 0xEA, 0x12, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x58, 0x9A, 
0x05, 0x6B, 0x60, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x04, 0xF0, 0x0D, 0x6B, 
0xC0, 0xF6, 0x74, 0xDA, 0x00, 0x6A, 0x26, 0x10, 0x44, 0xA1, 0x12, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x04, 0xF0, 0x00, 0x6B, 0xC0, 0xF6, 0x74, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x58, 0x9A, 0x05, 0x6B, 0x60, 0xCA, 0x00, 0x6A, 0x12, 0x10, 
0x44, 0xA1, 0x02, 0x6B, 0x6E, 0xEA, 0x08, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x04, 0xF0, 0x0C, 0x6B, 0xC0, 0xF6, 0x74, 0xDA, 0x00, 0x6A, 0x04, 0x10, 0x00, 0x6A, 0x02, 0x10, 
0x00, 0x65, 0x00, 0x10, 0xB9, 0x65, 0x03, 0x97, 0x02, 0x91, 0x02, 0x63, 0x00, 0xEF, 0x00, 0x65, 
0xFD, 0x63, 0x05, 0x62, 0x04, 0xD1, 0x04, 0x01, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x80, 0xF6, 0x48, 0xA2, 0x26, 0x6B, 0x6E, 0xEA, 0x02, 0x2A, 0x00, 0x18, 0xD3, 0x06, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x48, 0xA2, 0x52, 0x6B, 0x6E, 0xEA, 0x02, 0x2A, 
0x00, 0x18, 0xD3, 0x06, 0x01, 0x6A, 0xB9, 0x65, 0x01, 0x97, 0x00, 0x91, 0x01, 0x63, 0x00, 0xEF, 
0xFA, 0x63, 0x0B, 0x62, 0x0A, 0xD1, 0x04, 0x01, 0x44, 0x67, 0x20, 0xF0, 0x40, 0xC1, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x41, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x41, 0xA2, 0x40, 0xC1, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x48, 0xA2, 0x93, 0x6B, 0x6E, 0xEA, 0xA0, 0xF1, 0x14, 0x2A, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x41, 0xA2, 0x70, 0x6C, 
0x8E, 0xEA, 0x05, 0x2A, 0x00, 0x6C, 0x00, 0x18, 0xC2, 0x0C, 0x07, 0x6A, 0xA6, 0x11, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x41, 0xA2, 0x20, 0x5A, 0x58, 0x67, 
0x02, 0x22, 0x00, 0x6A, 0x9A, 0x11, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 
0x08, 0x4A, 0x41, 0xA2, 0x68, 0x5A, 0x58, 0x67, 0x02, 0x2A, 0x00, 0x6A, 0x8E, 0x11, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x41, 0xA2, 0x20, 0x6B, 0x6E, 0xEA, 
0x4D, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x78, 0x6B, 0x6B, 0xEB, 0x80, 0xF6, 
0x68, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x6C, 0xA2, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x61, 0xC2, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x6D, 0xA2, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x62, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x6E, 0xA2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x80, 0xF6, 0x08, 0x4A, 0x63, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 
0x14, 0x4A, 0x6F, 0xA2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 
0x64, 0xC2, 0x40, 0xA1, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0x80, 0xF6, 0x08, 0x4B, 
0x83, 0x67, 0xA2, 0x67, 0x00, 0x18, 0x4F, 0x0C, 0x01, 0x6A, 0x37, 0x11, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x48, 0xA2, 0x30, 0x6C, 0x8E, 0xEA, 0x0E, 0x2A, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x41, 0xA2, 0x04, 0x2A, 0x00, 0x18, 
0xAA, 0x0D, 0x02, 0x6A, 0x22, 0x11, 0x00, 0x6A, 0x20, 0x11, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x41, 0xA2, 0x62, 0x67, 0x0F, 0x6A, 0x6C, 0xEA, 0x16, 0x22, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x41, 0xA2, 0x52, 0x33, 
0xFF, 0x6A, 0x6C, 0xEA, 0x62, 0x67, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 
0x0C, 0x4A, 0x43, 0xAA, 0x6E, 0xEA, 0x02, 0x22, 0x00, 0x6A, 0xFF, 0x10, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x41, 0xA2, 0x62, 0x67, 0x0F, 0x6A, 0x4C, 0xEB, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x49, 0xA2, 0x6E, 0xEA, 
0x02, 0x22, 0x00, 0x6A, 0xEA, 0x10, 0x40, 0xA1, 0xE0, 0x4A, 0x53, 0x32, 0x43, 0xC1, 0x00, 0x6A, 
0x42, 0xC1, 0x2C, 0x10, 0x42, 0xA1, 0x0F, 0x2A, 0x42, 0xA1, 0x62, 0x42, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x49, 0xE3, 0x40, 0xA2, 0x88, 0x6B, 0x6E, 0xEA, 
0x1A, 0x22, 0x00, 0x6A, 0xD2, 0x10, 0x42, 0xA1, 0x62, 0x42, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x49, 0xE3, 0x60, 0xA2, 0x42, 0xA1, 0x8F, 0x42, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x49, 0xE4, 0x4C, 0xA2, 0x6E, 0xEA, 
0x02, 0x22, 0x00, 0x6A, 0xBA, 0x10, 0x42, 0xA1, 0x01, 0x4A, 0x42, 0xC1, 0x62, 0xA1, 0x43, 0xA1, 
0x43, 0xEB, 0x58, 0x67, 0xCF, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 
0x08, 0x4A, 0x61, 0xA2, 0x0F, 0x6A, 0x6C, 0xEA, 0x48, 0xC1, 0x48, 0xA1, 0x40, 0x22, 0x48, 0xA1, 
0x08, 0x6B, 0x4B, 0xE3, 0x48, 0xC1, 0x43, 0xA1, 0x14, 0x2A, 0x48, 0xA1, 0x88, 0x6B, 0x83, 0x67, 
0x84, 0xEA, 0x44, 0x67, 0x4A, 0xC1, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 
0x08, 0x4A, 0x42, 0xA2, 0x62, 0x67, 0x48, 0xA1, 0x83, 0x67, 0x84, 0xEA, 0x44, 0x67, 0x49, 0xC1, 
0x20, 0x10, 0x43, 0xA1, 0x6F, 0x42, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 
0x14, 0x4A, 0x49, 0xE3, 0x4C, 0xA2, 0x62, 0x67, 0x48, 0xA1, 0x83, 0x67, 0x84, 0xEA, 0x44, 0x67, 
0x4A, 0xC1, 0x43, 0xA1, 0x62, 0x42, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 
0x08, 0x4A, 0x49, 0xE3, 0x40, 0xA2, 0x62, 0x67, 0x48, 0xA1, 0x83, 0x67, 0x84, 0xEA, 0x44, 0x67, 
0x49, 0xC1, 0x6A, 0xA1, 0x49, 0xA1, 0x6E, 0xEA, 0x02, 0x22, 0x00, 0x6A, 0x66, 0x10, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x6F, 0xA2, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x64, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x6E, 0xA2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x80, 0xF6, 0x08, 0x4A, 0x63, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 
0x14, 0x4A, 0x6D, 0xA2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 
0x62, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x6C, 0xA2, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x61, 0xC2, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x78, 0x6B, 0x6B, 0xEB, 0x80, 0xF6, 0x68, 0xC2, 0x00, 0x6A, 
0x42, 0xC1, 0x12, 0x10, 0x42, 0xA1, 0x83, 0xA1, 0x62, 0xA1, 0x71, 0xE4, 0x10, 0xF0, 0x10, 0x6B, 
0x60, 0x33, 0x60, 0x33, 0x80, 0xF6, 0x08, 0x4B, 0x6D, 0xE4, 0x60, 0xA3, 0x91, 0x67, 0x49, 0xE4, 
0x70, 0xC2, 0x42, 0xA1, 0x01, 0x4A, 0x42, 0xC1, 0x62, 0xA1, 0x43, 0xA1, 0x05, 0x6C, 0x4B, 0xE4, 
0x42, 0xEB, 0x58, 0x67, 0xE7, 0x2A, 0x40, 0xA1, 0x67, 0x41, 0x09, 0x4B, 0x83, 0x67, 0xA2, 0x67, 
0x00, 0x18, 0x4F, 0x0C, 0x01, 0x6A, 0x01, 0x10, 0x00, 0x6A, 0xB9, 0x65, 0x07, 0x97, 0x06, 0x91, 
0x04, 0x63, 0x00, 0xEF, 0xFA, 0x63, 0x0B, 0x62, 0x0A, 0xD1, 0x04, 0x01, 0x44, 0x67, 0x20, 0xF0, 
0x40, 0xC1, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x41, 0xA2, 
0x40, 0xC1, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x48, 0xA2, 0x95, 0x6B, 
0x6E, 0xEA, 0x20, 0xF1, 0x1D, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 
0x08, 0x4A, 0x41, 0xA2, 0x70, 0x6C, 0x8E, 0xEA, 0x05, 0x2A, 0x01, 0x6C, 0x00, 0x18, 0xC2, 0x0C, 
0x07, 0x6A, 0x2F, 0x11, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 
0x41, 0xA2, 0x20, 0x6B, 0x6E, 0xEA, 0x52, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xC0, 0xF6, 0x14, 0x4A, 0x70, 0xA2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 
0x68, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x71, 0xA2, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x61, 0xC2, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x72, 0xA2, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x62, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x73, 0xA2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x80, 0xF6, 0x08, 0x4A, 0x63, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 
0x14, 0x4A, 0x74, 0xA2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 
0x64, 0xC2, 0x40, 0xA1, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0x80, 0xF6, 0x08, 0x4B, 
0x83, 0x67, 0xA2, 0x67, 0x00, 0x18, 0x4F, 0x0C, 0x01, 0x6A, 0xD3, 0x10, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x48, 0xA2, 0x30, 0x6C, 0x8E, 0xEA, 0x0E, 0x2A, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x41, 0xA2, 0x04, 0x2A, 0x00, 0x18, 
0xAA, 0x0D, 0x02, 0x6A, 0xBE, 0x10, 0x00, 0x6A, 0xBC, 0x10, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x41, 0xA2, 0x62, 0x67, 0x01, 0x6A, 0x4C, 0xEB, 0xFF, 0x6A, 
0x6C, 0xEA, 0x16, 0x22, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 
0x41, 0xA2, 0x52, 0x33, 0xFF, 0x6A, 0x6C, 0xEA, 0x62, 0x67, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 0x43, 0xAA, 0x6E, 0xEA, 0x02, 0x22, 0x00, 0x6A, 0x99, 0x10, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x41, 0xA2, 0x62, 0x67, 
0x0F, 0x6A, 0x4C, 0xEB, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x0C, 0x4A, 
0x49, 0xA2, 0x6E, 0xEA, 0x02, 0x22, 0x00, 0x6A, 0x84, 0x10, 0x40, 0xA1, 0xE0, 0x4A, 0x53, 0x32, 
0x42, 0xC1, 0x00, 0x6A, 0x41, 0xC1, 0x1B, 0x10, 0x41, 0xA1, 0x62, 0x42, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x49, 0xE3, 0x60, 0xA2, 0x41, 0xA1, 0x84, 0x42, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x49, 0xE4, 0x4C, 0xA2, 
0x6E, 0xEA, 0x02, 0x22, 0x00, 0x6A, 0x65, 0x10, 0x41, 0xA1, 0x01, 0x4A, 0x41, 0xC1, 0x61, 0xA1, 
0x42, 0xA1, 0x43, 0xEB, 0x58, 0x67, 0xE0, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x80, 0xF6, 0x08, 0x4A, 0x61, 0xA2, 0x0F, 0x6A, 0x6C, 0xEA, 0x45, 0xC1, 0x45, 0xA1, 0x2A, 0x22, 
0x45, 0xA1, 0x08, 0x6B, 0x4B, 0xE3, 0x45, 0xC1, 0x42, 0xA1, 0x64, 0x42, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x49, 0xE3, 0x4C, 0xA2, 0x62, 0x67, 0x45, 0xA1, 
0x83, 0x67, 0x84, 0xEA, 0x44, 0x67, 0x44, 0xC1, 0x42, 0xA1, 0x62, 0x42, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x49, 0xE3, 0x40, 0xA2, 0x62, 0x67, 0x45, 0xA1, 
0x83, 0x67, 0x84, 0xEA, 0x44, 0x67, 0x43, 0xC1, 0x64, 0xA1, 0x43, 0xA1, 0x6E, 0xEA, 0x02, 0x22, 
0x00, 0x6A, 0x27, 0x10, 0x00, 0x6A, 0x41, 0xC1, 0x13, 0x10, 0x41, 0xA1, 0x62, 0xA1, 0x84, 0x43, 
0x61, 0xA1, 0x71, 0xE4, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0xC0, 0xF6, 0x14, 0x4B, 
0x6D, 0xE4, 0x6C, 0xA3, 0x91, 0x67, 0x49, 0xE4, 0x68, 0xC2, 0x41, 0xA1, 0x01, 0x4A, 0x41, 0xC1, 
0x61, 0xA1, 0x42, 0xA1, 0x05, 0x6C, 0x4B, 0xE4, 0x42, 0xEB, 0x58, 0x67, 0xE6, 0x2A, 0x40, 0xA1, 
0x67, 0x41, 0x01, 0x4B, 0x83, 0x67, 0xA2, 0x67, 0x00, 0x18, 0x4F, 0x0C, 0x01, 0x6A, 0x01, 0x10, 
0x00, 0x6A, 0xB9, 0x65, 0x07, 0x97, 0x06, 0x91, 0x04, 0x63, 0x00, 0xEF, 0xFA, 0x63, 0x0B, 0xD1, 
0x3D, 0x67, 0x8C, 0xD9, 0x45, 0x67, 0x20, 0xF0, 0x54, 0xC1, 0x00, 0x6A, 0x46, 0xC9, 0x00, 0x6A, 
0x41, 0xD9, 0x4C, 0x99, 0x40, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x12, 0xF0, 
0x06, 0x6B, 0x60, 0xF6, 0x6C, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 
0x4C, 0x9A, 0x00, 0xF4, 0x05, 0x6B, 0x60, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x20, 0xF2, 0x54, 0x9A, 0x08, 0x6B, 0x60, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x20, 0xF2, 0x50, 0x9A, 0x01, 0x6B, 0x60, 0xC2, 0x20, 0xF0, 0x74, 0xA1, 0x0F, 0x6A, 0x6C, 0xEA, 
0x20, 0x22, 0x20, 0xF0, 0x54, 0xA1, 0x0F, 0x6B, 0x6C, 0xEA, 0x08, 0x6B, 0x4B, 0xE3, 0x46, 0xC9, 
0x46, 0xA9, 0x40, 0x32, 0x46, 0xC9, 0x20, 0xF0, 0x54, 0xA1, 0xE0, 0x4A, 0x53, 0x33, 0xFF, 0xF7, 
0x1F, 0x6A, 0x6C, 0xEA, 0x66, 0xA9, 0x4F, 0xE3, 0xFF, 0xF7, 0x1F, 0x6A, 0x6C, 0xEA, 0x04, 0x4A, 
0x46, 0xC9, 0x66, 0xA9, 0xFF, 0x6A, 0x6C, 0xEA, 0x45, 0xC9, 0x45, 0xA9, 0x01, 0x4A, 0x45, 0xC9, 
0x10, 0x10, 0x20, 0xF0, 0x54, 0xA1, 0xE0, 0x4A, 0x53, 0x33, 0xFF, 0xF7, 0x1F, 0x6A, 0x6C, 0xEA, 
0x66, 0xA9, 0x4F, 0xE3, 0xFF, 0xF7, 0x1F, 0x6A, 0x6C, 0xEA, 0x05, 0x4A, 0x46, 0xC9, 0x46, 0xA9, 
0x45, 0xC9, 0x46, 0xA9, 0x05, 0x6B, 0x6E, 0xEA, 0x09, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x20, 0xF2, 0x54, 0x9A, 0x08, 0x6B, 0x60, 0xC2, 0x08, 0x10, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x54, 0x9A, 0x48, 0x6B, 0x60, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x40, 0x9A, 0x66, 0xA9, 0x60, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x48, 0x9A, 0x01, 0x6B, 0x6E, 0xEA, 0x08, 0x2A, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x58, 0x9A, 0x1B, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x48, 0x9A, 0x02, 0x6B, 0x6E, 0xEA, 0x10, 0x2A, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x5C, 0x9A, 0x02, 0x6B, 0x60, 0xDA, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x58, 0x9A, 0x0B, 0x6B, 0x60, 0xDA, 
0x45, 0xA9, 0x05, 0x5A, 0x58, 0x67, 0x0A, 0x22, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x40, 0xF2, 0x44, 0x9A, 0x60, 0x99, 0x60, 0x9B, 0x60, 0xDA, 0x13, 0x10, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x44, 0x9A, 0x60, 0x99, 0x60, 0x9B, 0x60, 0xDA, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x44, 0x9A, 0x60, 0x99, 0x04, 0x4B, 0x60, 0x9B, 
0x60, 0xDA, 0x00, 0x6A, 0x44, 0xD9, 0x0D, 0x10, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x60, 0xF6, 0x4C, 0x9A, 0x12, 0xF0, 0x04, 0x6B, 0x6E, 0xEA, 0x09, 0x22, 0x44, 0x99, 0x01, 0x4A, 
0x44, 0xD9, 0x44, 0x99, 0xE5, 0xF7, 0x1F, 0x5A, 0x58, 0x67, 0xEE, 0x2A, 0x01, 0x10, 0x00, 0x65, 
0xB9, 0x65, 0x0B, 0x91, 0x06, 0x63, 0x20, 0xE8, 0xFC, 0x63, 0x07, 0x62, 0x06, 0xD1, 0x04, 0x01, 
0x44, 0x67, 0x50, 0xC1, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 
0x41, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x54, 0x9A, 0x04, 0xF0, 
0x01, 0x6B, 0x6E, 0xEA, 0x26, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 
0x08, 0x4A, 0x42, 0xA2, 0x88, 0x6B, 0x6E, 0xEA, 0x02, 0x22, 0x00, 0x6A, 0x3F, 0x10, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x62, 0x67, 0x80, 0xF6, 0x0B, 0x4B, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0xE0, 0xF6, 0x00, 0x4A, 0x83, 0x67, 0xA2, 0x67, 0x03, 0x6E, 0x00, 0x18, 
0xCE, 0x05, 0x01, 0x6B, 0x6E, 0xEA, 0x02, 0x22, 0x00, 0x6A, 0x28, 0x10, 0x00, 0x6C, 0x00, 0x18, 
0xF6, 0x0C, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x54, 0x9A, 0x04, 0xF0, 
0x03, 0x6B, 0x6E, 0xEA, 0x1A, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x62, 0x67, 
0x80, 0xF6, 0x0A, 0x4B, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xE0, 0xF6, 0x04, 0x4A, 
0x83, 0x67, 0xA2, 0x67, 0x04, 0x6E, 0x00, 0x18, 0xCE, 0x05, 0x01, 0x6B, 0x6E, 0xEA, 0x02, 0x22, 
0x00, 0x6A, 0x04, 0x10, 0x01, 0x6C, 0x00, 0x18, 0xF6, 0x0C, 0x00, 0x10, 0xB9, 0x65, 0x03, 0x97, 
0x02, 0x91, 0x02, 0x63, 0x00, 0xEF, 0x00, 0x65, 0xFE, 0x63, 0x03, 0xD1, 0x3D, 0x67, 0x44, 0x67, 
0x50, 0xC1, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x12, 0xF0, 0x06, 0x6B, 0x60, 0xF6, 
0x6C, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x50, 0x9A, 0x01, 0x6B, 
0x60, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x4C, 0x9A, 0x00, 0xF4, 
0x07, 0x6B, 0x60, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x54, 0x9A, 
0x08, 0x6B, 0x60, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x48, 0x9A, 
0x01, 0x6B, 0x6E, 0xEA, 0x08, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 
0x58, 0x9A, 0x1B, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 
0x48, 0x9A, 0x02, 0x6B, 0x6E, 0xEA, 0x10, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x20, 0xF2, 0x5C, 0x9A, 0x02, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x20, 0xF2, 0x58, 0x9A, 0x0B, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x40, 0xF2, 0x40, 0x9A, 0x01, 0x6B, 0x60, 0xCA, 0x50, 0xA1, 0x09, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x44, 0x9A, 0x04, 0x6B, 0x60, 0xDA, 0x08, 0x10, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x44, 0x9A, 0x00, 0x6B, 0x60, 0xDA, 0x00, 0x6A, 
0x40, 0xD9, 0x0D, 0x10, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x4C, 0x9A, 
0x12, 0xF0, 0x04, 0x6B, 0x6E, 0xEA, 0x0E, 0x22, 0x40, 0x99, 0x01, 0x4A, 0x40, 0xD9, 0x60, 0x99, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xA0, 0xF2, 0x44, 0x9A, 0x63, 0xEA, 0x58, 0x67, 
0xE9, 0x22, 0x01, 0x10, 0x00, 0x65, 0xB9, 0x65, 0x03, 0x91, 0x02, 0x63, 0x20, 0xE8, 0x00, 0x65, 
0xFF, 0x63, 0x01, 0xD1, 0x3D, 0x67, 0xB9, 0x65, 0x01, 0x91, 0x01, 0x63, 0x20, 0xE8, 0x00, 0x65, 
0xFD, 0x63, 0x05, 0x62, 0x04, 0xD1, 0x04, 0x01, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x80, 0xF6, 0x48, 0xA2, 0x50, 0x6B, 0x4E, 0xEB, 0x11, 0x23, 0x51, 0x52, 0x78, 0x67, 0x07, 0x23, 
0x1A, 0x6B, 0x4E, 0xEB, 0x23, 0x23, 0x30, 0x6B, 0x6E, 0xEA, 0x18, 0x22, 0x23, 0x10, 0x60, 0x6B, 
0x4E, 0xEB, 0x18, 0x23, 0xA2, 0x6B, 0x6E, 0xEA, 0x0D, 0x22, 0x1C, 0x10, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x41, 0xA2, 0x02, 0x22, 0x00, 0x6A, 0x13, 0x10, 
0x03, 0x6A, 0x11, 0x10, 0x00, 0x18, 0x6C, 0x0D, 0x01, 0x6A, 0x0D, 0x10, 0x00, 0x18, 0xAA, 0x0D, 
0x02, 0x6A, 0x09, 0x10, 0x00, 0x18, 0x0E, 0x07, 0x04, 0x6A, 0x05, 0x10, 0x00, 0x18, 0x49, 0x07, 
0x04, 0x6A, 0x01, 0x10, 0x00, 0x6A, 0xB9, 0x65, 0x01, 0x97, 0x00, 0x91, 0x01, 0x63, 0x00, 0xEF, 
0xFD, 0x63, 0x05, 0x62, 0x04, 0xD1, 0x04, 0x01, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x80, 0xF6, 0x48, 0xA2, 0x52, 0x6B, 0x6E, 0xEA, 0x04, 0x2A, 0x00, 0x18, 0xD3, 0x06, 0x01, 0x6A, 
0x01, 0x10, 0x00, 0x6A, 0xB9, 0x65, 0x01, 0x97, 0x00, 0x91, 0x01, 0x63, 0x00, 0xEF, 0x00, 0x65, 
0xFB, 0x63, 0x09, 0x62, 0x08, 0xD1, 0x04, 0x01, 0x00, 0x6A, 0x42, 0xC1, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x42, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x41, 0xA2, 0x41, 0xC1, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x00, 0xF0, 0x04, 0x4A, 0x4A, 0xA2, 0x40, 0xC1, 0x41, 0xA1, 0x2A, 0x5A, 0x58, 0x67, 
0x01, 0x6B, 0x6E, 0xEA, 0x62, 0x67, 0xFF, 0x6A, 0x4C, 0xEB, 0x41, 0xA1, 0x02, 0x5A, 0x58, 0x67, 
0x82, 0x67, 0xFF, 0x6A, 0x8C, 0xEA, 0x4D, 0xEB, 0xFF, 0x6A, 0x6C, 0xEA, 0x05, 0x22, 0x00, 0x6C, 
0x00, 0x18, 0x03, 0x0E, 0x00, 0x6A, 0x42, 0x10, 0x42, 0xA1, 0x28, 0x22, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x41, 0xA2, 0x48, 0x32, 0x44, 0xC1, 0x00, 0x6A, 
0x43, 0xC1, 0x18, 0x10, 0x64, 0xA1, 0x43, 0xA1, 0x51, 0xE3, 0x43, 0xA1, 0x62, 0x42, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x49, 0xE3, 0x60, 0xA2, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF0, 0x04, 0x4A, 0x49, 0xE4, 0x60, 0xC2, 0x43, 0xA1, 
0x01, 0x4A, 0x43, 0xC1, 0x43, 0xA1, 0x04, 0x5A, 0x58, 0x67, 0xE4, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x50, 0x9A, 0x01, 0x6B, 0x6E, 0xEA, 0x0B, 0x2A, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x41, 0xA2, 0x01, 0x6C, 0xA2, 0x67, 
0x00, 0x18, 0xDC, 0x0E, 0x0A, 0x6C, 0x00, 0x18, 0x03, 0x0E, 0x01, 0x6A, 0xB9, 0x65, 0x05, 0x97, 
0x04, 0x91, 0x03, 0x63, 0x00, 0xEF, 0x00, 0x65, 0xFB, 0x63, 0x09, 0x62, 0x08, 0xD1, 0x04, 0x01, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF0, 0x04, 0x4A, 0x41, 0xD9, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x50, 0x9A, 0x01, 0x6B, 0x60, 0xC2, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x4C, 0x9A, 0x00, 0xF4, 0x07, 0x6B, 0x60, 0xCA, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x54, 0x9A, 0x08, 0x6B, 0x60, 0xC2, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x12, 0xF0, 0x06, 0x6B, 0x60, 0xF6, 0x6C, 0xDA, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x41, 0xA2, 0x2A, 0x5A, 
0x58, 0x67, 0x07, 0x2A, 0x00, 0x6C, 0x00, 0x18, 0x03, 0x0E, 0x00, 0x6A, 0x62, 0x67, 0x43, 0x67, 
0x6F, 0x10, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x41, 0xA2, 
0x48, 0x32, 0x61, 0x99, 0x49, 0xE3, 0x41, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x00, 0xF3, 0x48, 0x9A, 0x01, 0x6B, 0x6E, 0xEA, 0x08, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x20, 0xF2, 0x58, 0x9A, 0x1B, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x00, 0xF3, 0x48, 0x9A, 0x02, 0x6B, 0x6E, 0xEA, 0x10, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x5C, 0x9A, 0x02, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x58, 0x9A, 0x0B, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x40, 0x9A, 0x10, 0x6B, 0x60, 0xCA, 0x00, 0x6A, 0x48, 0xC1, 
0x0F, 0x10, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x44, 0x9A, 0x68, 0xA1, 
0x68, 0x33, 0x81, 0x99, 0x6D, 0xE4, 0x60, 0x9B, 0x60, 0xDA, 0x48, 0xA1, 0x01, 0x4A, 0x48, 0xC1, 
0x48, 0xA1, 0x04, 0x5A, 0x58, 0x67, 0xED, 0x2A, 0x00, 0x6A, 0x40, 0xD9, 0x0D, 0x10, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x4C, 0x9A, 0x12, 0xF0, 0x04, 0x6B, 0x6E, 0xEA, 
0x0E, 0x22, 0x40, 0x99, 0x01, 0x4A, 0x40, 0xD9, 0x60, 0x99, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0xA0, 0xF2, 0x44, 0x9A, 0x63, 0xEA, 0x58, 0x67, 0xE9, 0x22, 0x01, 0x10, 0x00, 0x65, 
0xB9, 0x65, 0x05, 0x97, 0x04, 0x91, 0x03, 0x63, 0x00, 0xEF, 0x00, 0x65, 0xFE, 0x63, 0x03, 0xD1, 
0x3D, 0x67, 0x44, 0x67, 0x50, 0xC1, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 
0x50, 0x9A, 0x01, 0x6B, 0x60, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 
0x4C, 0x9A, 0x00, 0xF4, 0x05, 0x6B, 0x60, 0xCA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x20, 0xF2, 0x54, 0x9A, 0x00, 0x6B, 0x60, 0xC2, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x12, 0xF0, 0x06, 0x6B, 0x60, 0xF6, 0x6C, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x00, 0xF3, 0x48, 0x9A, 0x01, 0x6B, 0x6E, 0xEA, 0x08, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x20, 0xF2, 0x58, 0x9A, 0x1B, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x00, 0xF3, 0x48, 0x9A, 0x02, 0x6B, 0x6E, 0xEA, 0x10, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x5C, 0x9A, 0x02, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x20, 0xF2, 0x58, 0x9A, 0x0B, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x40, 0x9A, 0x00, 0xF4, 0x00, 0x6B, 0x60, 0xCA, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x40, 0xF2, 0x44, 0x9A, 0x70, 0xA1, 0x60, 0xDA, 0x00, 0x6A, 
0x40, 0xD9, 0x0D, 0x10, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x60, 0xF6, 0x4C, 0x9A, 
0x12, 0xF0, 0x04, 0x6B, 0x6E, 0xEA, 0x09, 0x22, 0x40, 0x99, 0x01, 0x4A, 0x40, 0xD9, 0x40, 0x99, 
0xE5, 0xF7, 0x1F, 0x5A, 0x58, 0x67, 0xEE, 0x2A, 0x01, 0x10, 0x00, 0x65, 0xB9, 0x65, 0x03, 0x91, 
0x02, 0x63, 0x20, 0xE8, 0xFE, 0x63, 0x03, 0xD1, 0x3D, 0x67, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x80, 0xF2, 0x50, 0x9A, 0x40, 0x9A, 0x41, 0xD9, 0x61, 0x99, 0x02, 0x6A, 0x4B, 0xEA, 
0x6C, 0xEA, 0x41, 0xD9, 0x00, 0x6A, 0x40, 0xD9, 0x03, 0x10, 0x40, 0x99, 0x01, 0x4A, 0x40, 0xD9, 
0x40, 0x99, 0x0A, 0x5A, 0x58, 0x67, 0xF9, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x80, 0xF2, 0x50, 0x9A, 0x61, 0x99, 0x60, 0xDA, 0x00, 0x6A, 0x40, 0xD9, 0x03, 0x10, 0x40, 0x99, 
0x01, 0x4A, 0x40, 0xD9, 0x40, 0x99, 0x32, 0x5A, 0x58, 0x67, 0xF9, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0xA0, 0xF2, 0x48, 0x9A, 0x40, 0x9A, 0x41, 0xD9, 0x00, 0x6A, 0x40, 0xD9, 
0x03, 0x10, 0x40, 0x99, 0x01, 0x4A, 0x40, 0xD9, 0x40, 0x99, 0x32, 0x5A, 0x58, 0x67, 0xF9, 0x2A, 
0x61, 0x99, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xA0, 0xF2, 0x4C, 0x9A, 0x6D, 0xEA, 
0x41, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xA0, 0xF2, 0x48, 0x9A, 0x61, 0x99, 
0x60, 0xDA, 0x00, 0x6A, 0x40, 0xD9, 0x03, 0x10, 0x40, 0x99, 0x01, 0x4A, 0x40, 0xD9, 0x40, 0x99, 
0x32, 0x5A, 0x58, 0x67, 0xF9, 0x2A, 0x61, 0x99, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xA0, 0xF2, 0x50, 0x9A, 0x6C, 0xEA, 0x41, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xA0, 0xF2, 0x48, 0x9A, 0x61, 0x99, 0x60, 0xDA, 0x00, 0x6A, 0x40, 0xD9, 0x03, 0x10, 0x40, 0x99, 
0x01, 0x4A, 0x40, 0xD9, 0x40, 0x99, 0x32, 0x5A, 0x58, 0x67, 0xF9, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0xA0, 0xF2, 0x54, 0x9A, 0x40, 0x9A, 0x41, 0xD9, 0x61, 0x99, 0x01, 0x6A, 
0x6D, 0xEA, 0x41, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xA0, 0xF2, 0x54, 0x9A, 
0x61, 0x99, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF2, 0x50, 0x9A, 
0x40, 0x9A, 0x41, 0xD9, 0x61, 0x99, 0x01, 0x6A, 0x6D, 0xEA, 0x41, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x80, 0xF2, 0x50, 0x9A, 0x61, 0x99, 0x60, 0xDA, 0xB9, 0x65, 0x03, 0x91, 
0x02, 0x63, 0x20, 0xE8, 0xFE, 0x63, 0x03, 0xD1, 0x3D, 0x67, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x80, 0xF2, 0x50, 0x9A, 0x40, 0x9A, 0x40, 0xD9, 0x60, 0x99, 0x02, 0x6A, 0x4B, 0xEA, 
0x6C, 0xEA, 0x40, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF2, 0x50, 0x9A, 
0x60, 0x99, 0x60, 0xDA, 0xB9, 0x65, 0x03, 0x91, 0x02, 0x63, 0x20, 0xE8, 0xFE, 0x63, 0x03, 0xD1, 
0x3D, 0x67, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF2, 0x50, 0x9A, 0x40, 0x9A, 
0x40, 0xD9, 0x60, 0x99, 0x03, 0x6A, 0x4B, 0xEA, 0x6C, 0xEA, 0x40, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x80, 0xF2, 0x50, 0x9A, 0x60, 0x99, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0xA0, 0xF2, 0x58, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 
0xA0, 0xF2, 0x7C, 0x9B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xA0, 0xF2, 
0x54, 0x9A, 0x40, 0x9A, 0x40, 0xD9, 0x60, 0x99, 0x02, 0x6A, 0x6D, 0xEA, 0x40, 0xD9, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xA0, 0xF2, 0x54, 0x9A, 0x60, 0x99, 0x60, 0xDA, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xA0, 0xF2, 0x58, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 
0x60, 0x33, 0xC0, 0xF2, 0x60, 0x9B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x80, 0xF2, 0x50, 0x9A, 0x40, 0x9A, 0x40, 0xD9, 0x60, 0x99, 0x02, 0x6A, 0x6D, 0xEA, 0x40, 0xD9, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF2, 0x50, 0x9A, 0x60, 0x99, 0x60, 0xDA, 
0xB9, 0x65, 0x03, 0x91, 0x02, 0x63, 0x20, 0xE8, 0xFE, 0x63, 0x03, 0xD1, 0x3D, 0x67, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF2, 0x50, 0x9A, 0x40, 0x9A, 0x40, 0xD9, 0x60, 0x99, 
0x03, 0x6A, 0x4B, 0xEA, 0x6C, 0xEA, 0x40, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x80, 0xF2, 0x50, 0x9A, 0x60, 0x99, 0x60, 0xDA, 0xB9, 0x65, 0x03, 0x91, 0x02, 0x63, 0x20, 0xE8, 
0xFC, 0x63, 0x07, 0xD1, 0x3D, 0x67, 0x64, 0x67, 0x45, 0x67, 0x20, 0xF0, 0x60, 0xC1, 0x20, 0xF0, 
0x44, 0xC1, 0x00, 0x6A, 0x43, 0xD9, 0x00, 0x6A, 0x48, 0xC1, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x60, 0xF2, 0x44, 0x9A, 0x40, 0x9A, 0x40, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x60, 0xF2, 0x44, 0x9A, 0x00, 0x6B, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x00, 0xF0, 0x04, 0x4A, 0x41, 0xD9, 0x48, 0xA1, 0x45, 0xD9, 0x20, 0xF0, 0x40, 0xA1, 
0x04, 0x6B, 0x6E, 0xEA, 0x20, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 
0x54, 0xA2, 0x62, 0x67, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 
0x44, 0xAA, 0x6E, 0xEA, 0x60, 0xF1, 0x0F, 0x22, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xC0, 0xF6, 0x14, 0x4A, 0x64, 0xAA, 0xFF, 0x6A, 0x4C, 0xEB, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x00, 0xF3, 0x74, 0xC2, 0x20, 0xF0, 0x40, 0xA1, 0x07, 0x5A, 0x78, 0x67, 0x40, 0xF1, 
0x07, 0x23, 0x48, 0x33, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF2, 0x04, 0x4A, 
0x49, 0xE3, 0x40, 0x9A, 0x00, 0xEA, 0x20, 0xF0, 0x44, 0xA1, 0x45, 0xD9, 0x45, 0x99, 0x40, 0x32, 
0x40, 0x32, 0x00, 0xF5, 0x00, 0x4A, 0x45, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xC0, 0xF2, 0x44, 0x9A, 0x65, 0x99, 0x60, 0xDA, 0x00, 0x6A, 0x44, 0xD9, 0x12, 0x10, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF2, 0x44, 0x9A, 0x20, 0xF0, 0x84, 0xA1, 0x64, 0x99, 
0x6D, 0xE4, 0x68, 0x33, 0x81, 0x99, 0x6D, 0xE4, 0x60, 0x9B, 0x60, 0xDA, 0x44, 0x99, 0x01, 0x4A, 
0x44, 0xD9, 0x44, 0x99, 0x04, 0x5A, 0x58, 0x67, 0xEA, 0x2A, 0x12, 0x11, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x41, 0xA2, 0x45, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x40, 0x9A, 0x61, 0x42, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 
0x40, 0x32, 0x00, 0xF3, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 
0x40, 0x9A, 0x80, 0x6B, 0x6E, 0xEA, 0x07, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x00, 0x6B, 0x00, 0xF3, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF2, 
0x44, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0x00, 0xF3, 0x60, 0x9B, 0x60, 0x34, 
0x65, 0x99, 0x60, 0x33, 0x60, 0x33, 0x6D, 0xE4, 0x41, 0x4B, 0x60, 0xDA, 0x00, 0x6A, 0x45, 0xD9, 
0x00, 0x6A, 0x44, 0xD9, 0x14, 0x10, 0x45, 0x99, 0x40, 0x32, 0x45, 0xD9, 0x05, 0x6B, 0x44, 0x99, 
0x4F, 0xE3, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x80, 0xF6, 0x08, 0x4A, 0x49, 0xE3, 
0x40, 0xA2, 0x65, 0x99, 0x49, 0xE3, 0x45, 0xD9, 0x44, 0x99, 0x01, 0x4A, 0x44, 0xD9, 0x44, 0x99, 
0x04, 0x5A, 0x58, 0x67, 0xE8, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF2, 
0x44, 0x9A, 0x65, 0x99, 0x60, 0xDA, 0xB4, 0x10, 0x20, 0xF0, 0x44, 0xA1, 0x45, 0xD9, 0x45, 0x99, 
0x40, 0x32, 0x40, 0x32, 0x45, 0xD9, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF2, 
0x44, 0x9A, 0x85, 0x99, 0x00, 0xF2, 0x02, 0x6B, 0x8D, 0xEB, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0xC0, 0xF2, 0x44, 0x9A, 0x20, 0xF0, 0x64, 0xA1, 0x68, 0x33, 0x81, 0x99, 
0x6D, 0xE4, 0x60, 0x9B, 0x60, 0xDA, 0x94, 0x10, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x00, 0xF3, 0x40, 0x9A, 0x61, 0x42, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 
0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x40, 0x9A, 0x80, 0x6B, 
0x6E, 0xEA, 0x07, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0x6B, 0x00, 0xF3, 
0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF6, 0x14, 0x4A, 0x44, 0xAA, 
0x01, 0x6B, 0x6E, 0xEA, 0x16, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF2, 
0x44, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0x00, 0xF3, 0x60, 0x9B, 0x60, 0x34, 
0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0xC0, 0xF2, 0x68, 0x9B, 0x6D, 0xE4, 0x60, 0xDA, 
0x57, 0x10, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF2, 0x44, 0x9A, 0x10, 0xF0, 
0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0x00, 0xF3, 0x60, 0x9B, 0x60, 0x33, 0x24, 0x4B, 0x60, 0xDA, 
0x47, 0x10, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x40, 0x9A, 0x61, 0x42, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x60, 0xDA, 0x10, 0xF0, 0x10, 0x6A, 
0x40, 0x32, 0x40, 0x32, 0x00, 0xF3, 0x40, 0x9A, 0x80, 0x6B, 0x6E, 0xEA, 0x07, 0x2A, 0x10, 0xF0, 
0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0x00, 0x6B, 0x00, 0xF3, 0x60, 0xDA, 0x20, 0xF0, 0x44, 0xA1, 
0x01, 0x6B, 0x6E, 0xEA, 0x16, 0x2A, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF2, 
0x44, 0x9A, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0x00, 0xF3, 0x60, 0x9B, 0x60, 0x34, 
0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0xC0, 0xF2, 0x6C, 0x9B, 0x6D, 0xE4, 0x60, 0xDA, 
0x0F, 0x10, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF2, 0x44, 0x9A, 0x10, 0xF0, 
0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0x00, 0xF3, 0x60, 0x9B, 0x60, 0x33, 0x26, 0x4B, 0x60, 0xDA, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF2, 0x50, 0x9A, 0x40, 0x9A, 0x45, 0xD9, 
0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xC0, 0xF2, 0x50, 0x9A, 0x85, 0x99, 0x01, 0x6B, 
0x8D, 0xEB, 0x60, 0xDA, 0x01, 0x10, 0x00, 0x65, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0x60, 0xF2, 0x44, 0x9A, 0x60, 0x99, 0x60, 0xDA, 0xB9, 0x65, 0x07, 0x91, 0x04, 0x63, 0x20, 0xE8, 
0xFD, 0x63, 0x05, 0xD1, 0x3D, 0x67, 0x86, 0xD9, 0xA7, 0xD9, 0x00, 0x6A, 0x41, 0xD9, 0x41, 0x99, 
0x42, 0xD9, 0x46, 0x99, 0x43, 0xD9, 0x34, 0x10, 0x41, 0xA1, 0x30, 0x5A, 0x58, 0x67, 0x08, 0x2A, 
0x41, 0xA1, 0x3A, 0x5A, 0x58, 0x67, 0x04, 0x22, 0x41, 0xA1, 0xD0, 0x4A, 0x40, 0xC1, 0x1A, 0x10, 
0x41, 0xA1, 0x61, 0x5A, 0x58, 0x67, 0x08, 0x2A, 0x41, 0xA1, 0x67, 0x5A, 0x58, 0x67, 0x04, 0x22, 
0x41, 0xA1, 0xA9, 0x4A, 0x40, 0xC1, 0x0E, 0x10, 0x41, 0xA1, 0x41, 0x5A, 0x58, 0x67, 0x08, 0x2A, 
0x41, 0xA1, 0x47, 0x5A, 0x58, 0x67, 0x04, 0x22, 0x41, 0xA1, 0xC9, 0x4A, 0x40, 0xC1, 0x02, 0x10, 
0x00, 0x6A, 0x1F, 0x10, 0x41, 0x99, 0x50, 0x33, 0x40, 0xA1, 0x49, 0xE3, 0x42, 0xD9, 0x62, 0x99, 
0x41, 0x99, 0x43, 0xEB, 0x58, 0x67, 0x02, 0x22, 0x00, 0x6A, 0x13, 0x10, 0x42, 0x99, 0x41, 0xD9, 
0x43, 0x99, 0x40, 0xA2, 0x41, 0xC1, 0x00, 0x6A, 0x61, 0xA1, 0x01, 0x23, 0x01, 0x6A, 0xFF, 0x6B, 
0x6C, 0xEA, 0x63, 0x99, 0x01, 0x4B, 0x63, 0xD9, 0xBF, 0x2A, 0x47, 0x99, 0x61, 0x99, 0x60, 0xDA, 
0x01, 0x6A, 0xB9, 0x65, 0x05, 0x91, 0x03, 0x63, 0x20, 0xE8, 0x00, 0x65, 0xF3, 0x63, 0x19, 0x62, 
0x18, 0xD1, 0x04, 0x01, 0x96, 0xD9, 0xB7, 0xD9, 0xD8, 0xD9, 0x56, 0x99, 0x4B, 0xD9, 0xB5, 0x11, 
0x57, 0x99, 0x40, 0x82, 0x25, 0x6B, 0x6E, 0xEA, 0x10, 0x22, 0x56, 0x99, 0x08, 0x22, 0x57, 0x99, 
0x60, 0x82, 0x4B, 0x99, 0x60, 0xC2, 0x4B, 0x99, 0x01, 0x4A, 0x4B, 0xD9, 0xA3, 0x11, 0x57, 0x99, 
0x40, 0x82, 0x82, 0x67, 0x00, 0x18, 0x3B, 0x03, 0x9D, 0x11, 0x57, 0x99, 0x01, 0x4A, 0x57, 0xD9, 
0x57, 0x99, 0x40, 0x82, 0x73, 0x6B, 0x6E, 0xEA, 0x1D, 0x2A, 0x58, 0x99, 0x40, 0x9A, 0x4C, 0xD9, 
0x58, 0x99, 0x04, 0x4A, 0x58, 0xD9, 0x12, 0x10, 0x56, 0x99, 0x08, 0x22, 0x4C, 0x99, 0x60, 0x82, 
0x4B, 0x99, 0x60, 0xC2, 0x4B, 0x99, 0x01, 0x4A, 0x4B, 0xD9, 0x05, 0x10, 0x4C, 0x99, 0x40, 0x82, 
0x82, 0x67, 0x00, 0x18, 0x3B, 0x03, 0x4C, 0x99, 0x01, 0x4A, 0x4C, 0xD9, 0x4C, 0x99, 0x40, 0x82, 
0xEB, 0x2A, 0x78, 0x11, 0x47, 0x41, 0x2D, 0x4A, 0x4A, 0xD9, 0x00, 0x6A, 0x49, 0xD9, 0x04, 0x6A, 
0x48, 0xD9, 0x57, 0x99, 0x40, 0x82, 0x23, 0x6B, 0x6E, 0xEA, 0x05, 0x2A, 0x01, 0x6A, 0x49, 0xD9, 
0x57, 0x99, 0x01, 0x4A, 0x57, 0xD9, 0x57, 0x99, 0x40, 0x82, 0x68, 0x6B, 0x6E, 0xEA, 0x05, 0x2A, 
0x0C, 0x6A, 0x48, 0xD9, 0x57, 0x99, 0x01, 0x4A, 0x57, 0xD9, 0x57, 0x99, 0x40, 0x82, 0x68, 0x6B, 
0x6E, 0xEA, 0x05, 0x2A, 0x04, 0x6A, 0x48, 0xD9, 0x57, 0x99, 0x01, 0x4A, 0x57, 0xD9, 0x57, 0x99, 
0x60, 0x82, 0x20, 0x6A, 0x6D, 0xEA, 0x00, 0xF6, 0x40, 0x32, 0x00, 0xF6, 0x43, 0x32, 0x78, 0x6B, 
0x6E, 0xEA, 0x4F, 0x2A, 0x58, 0x99, 0x47, 0xD9, 0x47, 0x99, 0x40, 0x9A, 0x46, 0xD9, 0x47, 0x99, 
0x04, 0x4A, 0x47, 0xD9, 0x57, 0x99, 0x60, 0x82, 0xFF, 0x6A, 0x6C, 0xEA, 0x62, 0x67, 0x20, 0x6A, 
0x6C, 0xEA, 0x45, 0xD9, 0x47, 0x99, 0x58, 0xD9, 0x49, 0x99, 0x36, 0x22, 0x4A, 0x99, 0x30, 0x6B, 
0x60, 0xC2, 0x4A, 0x99, 0x01, 0x4A, 0x4A, 0xD9, 0x45, 0x99, 0x00, 0xF6, 0x40, 0x33, 0x00, 0xF6, 
0x63, 0x33, 0x58, 0x6A, 0x6D, 0xEA, 0x00, 0xF6, 0x40, 0x33, 0x00, 0xF6, 0x63, 0x33, 0x4A, 0x99, 
0x60, 0xC2, 0x4A, 0x99, 0x01, 0x4A, 0x4A, 0xD9, 0x1F, 0x10, 0x66, 0x99, 0x48, 0x99, 0x67, 0xEA, 
0x0F, 0x6A, 0x4C, 0xEB, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 0xE0, 0xF2, 0x00, 0x4A, 
0x49, 0xE3, 0x60, 0x82, 0x45, 0x99, 0x00, 0xF6, 0x40, 0x32, 0x00, 0xF6, 0x43, 0x32, 0x6D, 0xEA, 
0x00, 0xF6, 0x40, 0x33, 0x00, 0xF6, 0x63, 0x33, 0x4A, 0x99, 0x60, 0xC2, 0x4A, 0x99, 0x01, 0x4A, 
0x4A, 0xD9, 0x48, 0x99, 0xFC, 0x4A, 0x48, 0xD9, 0x48, 0x99, 0x00, 0x52, 0x58, 0x67, 0xDD, 0x22, 
0xDE, 0x10, 0x57, 0x99, 0x40, 0x82, 0x64, 0x6B, 0x6E, 0xEA, 0x62, 0x2A, 0x58, 0x99, 0x40, 0x9A, 
0x44, 0xD9, 0x58, 0x99, 0x04, 0x4A, 0x58, 0xD9, 0x44, 0x99, 0x00, 0x52, 0x58, 0x67, 0x09, 0x22, 
0x4A, 0x99, 0x2D, 0x6B, 0x60, 0xC2, 0x4A, 0x99, 0x01, 0x4A, 0x4A, 0xD9, 0x44, 0x99, 0x4B, 0xEA, 
0x44, 0xD9, 0x4A, 0x99, 0x4C, 0xD9, 0x64, 0x99, 0x10, 0xF0, 0x10, 0x6A, 0x40, 0x32, 0x40, 0x32, 
0xE0, 0xF2, 0x54, 0x9A, 0x58, 0xEB, 0x10, 0xEA, 0x4B, 0x34, 0xC0, 0xF7, 0x63, 0x32, 0x4B, 0xE4, 
0x44, 0x32, 0x48, 0x34, 0x89, 0xE2, 0x4B, 0xE3, 0xFF, 0x6B, 0x6C, 0xEA, 0x67, 0x42, 0x29, 0x4B, 
0xFF, 0x6A, 0x6C, 0xEA, 0x00, 0xF6, 0x40, 0x33, 0x00, 0xF6, 0x63, 0x33, 0x4A, 0x99, 0x60, 0xC2, 
0x4A, 0x99, 0x01, 0x4A, 0x4A, 0xD9, 0x44, 0x99, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 
0xE0, 0xF2, 0x74, 0x9B, 0x78, 0xEA, 0x10, 0xEB, 0x6B, 0x33, 0xC0, 0xF7, 0x43, 0x32, 0x4B, 0xE3, 
0x44, 0xD9, 0x44, 0x99, 0xD0, 0x2A, 0x4A, 0x99, 0x43, 0xD9, 0x11, 0x10, 0x43, 0x99, 0x40, 0x82, 
0x44, 0xD9, 0x4C, 0x99, 0x60, 0x82, 0x43, 0x99, 0x60, 0xC2, 0x44, 0x99, 0x00, 0xF6, 0x40, 0x33, 
0x00, 0xF6, 0x63, 0x33, 0x4C, 0x99, 0x60, 0xC2, 0x4C, 0x99, 0x01, 0x4A, 0x4C, 0xD9, 0x43, 0x99, 
0xFF, 0x4A, 0x43, 0xD9, 0x63, 0x99, 0x4C, 0x99, 0x63, 0xEA, 0x58, 0x67, 0xE7, 0x2A, 0x77, 0x10, 
0x57, 0x99, 0x40, 0x82, 0x40, 0x6B, 0x6E, 0xEA, 0x2C, 0x2A, 0x58, 0x99, 0x41, 0xD9, 0x41, 0x99, 
0x40, 0x9A, 0x52, 0xD9, 0x41, 0x99, 0x04, 0x4A, 0x41, 0xD9, 0x41, 0x99, 0x58, 0xD9, 0x47, 0x41, 
0x41, 0x4A, 0x42, 0xD9, 0x13, 0x10, 0x42, 0x99, 0x40, 0xA2, 0x8A, 0x99, 0x10, 0xF0, 0x10, 0x6B, 
0x60, 0x33, 0x60, 0x33, 0xC0, 0xF2, 0x14, 0x4B, 0xA3, 0x67, 0xC2, 0x67, 0x00, 0x18, 0xD6, 0x10, 
0x6A, 0x99, 0x49, 0xE3, 0x4A, 0xD9, 0x42, 0x99, 0x01, 0x4A, 0x42, 0xD9, 0x47, 0x41, 0x41, 0x4A, 
0x64, 0x42, 0x42, 0x99, 0x63, 0xEA, 0x58, 0x67, 0xE6, 0x2A, 0x4A, 0x99, 0xFF, 0x4A, 0x4A, 0xD9, 
0x46, 0x10, 0x57, 0x99, 0x40, 0x82, 0x21, 0x6B, 0x6E, 0xEA, 0x26, 0x2A, 0x58, 0x99, 0x40, 0x9A, 
0x4C, 0xD9, 0x58, 0x99, 0x04, 0x4A, 0x58, 0xD9, 0x4C, 0x99, 0x06, 0x4A, 0x40, 0xD9, 0x13, 0x10, 
0x4C, 0x99, 0x40, 0x82, 0x8A, 0x99, 0x10, 0xF0, 0x10, 0x6B, 0x60, 0x33, 0x60, 0x33, 0xC0, 0xF2, 
0x18, 0x4B, 0xA3, 0x67, 0xC2, 0x67, 0x00, 0x18, 0xD6, 0x10, 0x6A, 0x99, 0x49, 0xE3, 0x4A, 0xD9, 
0x4C, 0x99, 0x01, 0x4A, 0x4C, 0xD9, 0x6C, 0x99, 0x40, 0x99, 0x43, 0xEB, 0x58, 0x67, 0xE8, 0x2A, 
0x4A, 0x99, 0xFF, 0x4A, 0x4A, 0xD9, 0x1B, 0x10, 0x57, 0x99, 0x40, 0x82, 0x63, 0x6B, 0x6E, 0xEA, 
0x0F, 0x2A, 0x58, 0x99, 0x40, 0x9A, 0x00, 0xF6, 0x40, 0x33, 0x00, 0xF6, 0x63, 0x33, 0x4A, 0x99, 
0x60, 0xC2, 0x4A, 0x99, 0x01, 0x4A, 0x4A, 0xD9, 0x58, 0x99, 0x04, 0x4A, 0x58, 0xD9, 0x07, 0x10, 
0x57, 0x99, 0x60, 0x82, 0x4A, 0x99, 0x60, 0xC2, 0x4A, 0x99, 0x01, 0x4A, 0x4A, 0xD9, 0x47, 0x41, 
0x2D, 0x4A, 0x4C, 0xD9, 0x12, 0x10, 0x56, 0x99, 0x08, 0x22, 0x4C, 0x99, 0x60, 0x82, 0x4B, 0x99, 
0x60, 0xC2, 0x4B, 0x99, 0x01, 0x4A, 0x4B, 0xD9, 0x05, 0x10, 0x4C, 0x99, 0x40, 0x82, 0x82, 0x67, 
0x00, 0x18, 0x3B, 0x03, 0x4C, 0x99, 0x01, 0x4A, 0x4C, 0xD9, 0x6C, 0x99, 0x4A, 0x99, 0x43, 0xEB, 
0x58, 0x67, 0xE9, 0x2A, 0x57, 0x99, 0x01, 0x4A, 0x57, 0xD9, 0x57, 0x99, 0x40, 0x82, 0x5F, 0xF6, 
0x07, 0x2A, 0x56, 0x99, 0x03, 0x22, 0x4B, 0x99, 0x00, 0x6B, 0x60, 0xC2, 0x6B, 0x99, 0x56, 0x99, 
0x4B, 0xE3, 0xB9, 0x65, 0x15, 0x97, 0x14, 0x91, 0x0B, 0x63, 0x00, 0xEF, 0xFD, 0x63, 0x05, 0x62, 
0x04, 0xD1, 0x04, 0x01, 0xA3, 0xD9, 0xC4, 0xD9, 0xE5, 0xD9, 0x82, 0xD9, 0x62, 0x99, 0x47, 0x41, 
0x01, 0x4A, 0x04, 0x4A, 0x00, 0x6C, 0xA3, 0x67, 0xC2, 0x67, 0x00, 0x18, 0xE3, 0x0F, 0xB9, 0x65, 
0x01, 0x97, 0x00, 0x91, 0x01, 0x63, 0x00, 0xEF, 0xFD, 0x63, 0x05, 0x62, 0x04, 0xD1, 0x04, 0x01, 
0x82, 0xD9, 0xC4, 0xD9, 0xE5, 0xD9, 0xA3, 0xD9, 0x63, 0x99, 0x47, 0x41, 0x05, 0x4A, 0x04, 0x4A, 
0x82, 0x99, 0xA3, 0x67, 0xC2, 0x67, 0x00, 0x18, 0xE3, 0x0F, 0xB9, 0x65, 0x01, 0x97, 0x00, 0x91, 
0x01, 0x63, 0x00, 0xEF, 
};


u8 NFCFWDMEM[]={
0x13, 0x24, 0x08, 0x15, 
0x58, 0x53, 0x9B, 0x18, 0x22, 0xB6, 0x28, 0x80, 0x3C, 0x48, 0x00, 0x00, 0xE1, 0x11, 0x12, 0x00, 
0x01, 0x03, 0xA0, 0x10, 0x44, 0x03, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x20, 0x00, 0x00, 0x20, 0x21, 0x00, 0x00, 0x21, 0x22, 0x00, 0x00, 0x00, 
0x23, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x26, 0x00, 0x00, 0x00, 
0x27, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x56, 0x15, 0x08, 0x24, 0x01, 0x03, 0x00, 0x00, 
0x18, 0x00, 0x00, 0x93, 0x14, 0x00, 0x00, 0x9F, 0x84, 0x00, 0x00, 0x9F, 0x08, 0x10, 0x00, 0x90, 
0x1C, 0x10, 0x00, 0x90, 0x60, 0x20, 0x00, 0x90, 0x48, 0x20, 0x00, 0x90, 0x04, 0x20, 0x00, 0x90, 
0x00, 0x20, 0x00, 0x90, 0x54, 0x00, 0x00, 0x94, 0xFF, 0xFF, 0x0F, 0x00, 0x1C, 0x04, 0x00, 0x94, 
0x00, 0x00, 0x01, 0x00, 0x50, 0x00, 0x00, 0x94, 0x74, 0x00, 0x00, 0x94, 0x00, 0x00, 0x04, 0x20, 
0xFF, 0xFF, 0xF7, 0xBF, 0x00, 0x00, 0x08, 0x40, 0x70, 0x01, 0x00, 0x94, 0xA0, 0x20, 0x20, 0x00, 
0xFF, 0xFF, 0xFE, 0xFF, 0x58, 0x00, 0x00, 0x94, 0xFF, 0xAF, 0x0E, 0x00, 0x5C, 0x00, 0x00, 0x94, 
0x60, 0x00, 0x00, 0x94, 0x0C, 0x00, 0x00, 0x94, 0x08, 0x08, 0x00, 0x94, 0x6C, 0x00, 0x00, 0x94, 
0xFF, 0xFF, 0x03, 0xFC, 0x00, 0x00, 0x34, 0x00, 0x00, 0x00, 0x00, 0x20, 0x28, 0x07, 0x00, 0x94, 
0x04, 0x04, 0x00, 0x94, 0x70, 0x00, 0x00, 0x94, 0x20, 0x07, 0x00, 0x94, 0xFF, 0xFF, 0xFF, 0xE0, 
0x00, 0x00, 0x00, 0x0A, 0x24, 0x07, 0x00, 0x94, 0x38, 0x07, 0x00, 0x94, 0x28, 0x00, 0x00, 0x94, 
0x04, 0x00, 0x00, 0x90, 0x0C, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x90, 0x14, 0x00, 0x00, 0x90, 
0x10, 0x10, 0x00, 0x90, 0x0C, 0x10, 0x00, 0x90, 0x24, 0x10, 0x00, 0x90, 0x20, 0x10, 0x00, 0x90, 
0x54, 0x00, 0x00, 0x9F, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x9F, 0x0C, 0x00, 0x00, 0x9F, 
0xFC, 0x00, 0x00, 0x9F, 0x64, 0x00, 0x00, 0x9F, 0x60, 0x00, 0x00, 0x9F, 0x7C, 0x00, 0x00, 0x90, 
0x2C, 0x00, 0x00, 0x94, 0xFF, 0xFF, 0xFF, 0xFE, 0x20, 0x01, 0x00, 0x94, 0x24, 0x01, 0x00, 0x94, 
0x22, 0x00, 0x00, 0x93, 0x20, 0x00, 0x00, 0x93, 0x10, 0x00, 0x00, 0x93, 0x0A, 0x00, 0x00, 0x93, 
0x00, 0x00, 0x00, 0x30, 0x0C, 0x00, 0x00, 0x93, 0x00, 0x10, 0x00, 0x90, 0x14, 0x10, 0x00, 0x90, 
0xC4, 0x01, 0x64, 0xB8, 0x68, 0x65, 0x6C, 0x6C, 0x6F, 0x0A, 0x00, 0x00, 0x73, 0x28, 0x00, 0x80, 
0xA3, 0x28, 0x00, 0x80, 0x7D, 0x2A, 0x00, 0x80, 0x2B, 0x29, 0x00, 0x80, 0x7D, 0x2A, 0x00, 0x80, 
0x7D, 0x2A, 0x00, 0x80, 0x7D, 0x2A, 0x00, 0x80, 0x7D, 0x2A, 0x00, 0x80, 0x7D, 0x2A, 0x00, 0x80, 
0x7D, 0x2A, 0x00, 0x80, 0x7D, 0x2A, 0x00, 0x80, 0x7D, 0x2A, 0x00, 0x80, 0xD3, 0x29, 0x00, 0x80, 
0x51, 0x28, 0x00, 0x80, 0x27, 0x3C, 0x00, 0x80, 0x7D, 0x3C, 0x00, 0x80, 0x39, 0x3D, 0x00, 0x80, 
0xA1, 0x3E, 0x00, 0x80, 0x79, 0x3D, 0x00, 0x80, 0xA1, 0x3E, 0x00, 0x80, 0x13, 0x3E, 0x00, 0x80, 
0x14, 0x00, 0x00, 0x9F, 0x12, 0x00, 0x00, 0x93, 0x14, 0x00, 0x00, 0x93, 0x16, 0x00, 0x00, 0x93, 
0x10, 0x00, 0x00, 0x93, 0x26, 0x00, 0x00, 0x93, 0x5C, 0x00, 0x00, 0x94, 0x0C, 0x00, 0x00, 0x94, 
0x08, 0x00, 0x00, 0x93, 0x0C, 0x00, 0x00, 0x93, 0x20, 0x00, 0x00, 0x9F, 0x00, 0x00, 0x34, 0x12, 
0x01, 0x00, 0x34, 0x12, 0x22, 0x00, 0x00, 0x93, 0x18, 0x00, 0x00, 0x93, 0xFC, 0x00, 0x00, 0x9F, 
0x80, 0x00, 0x00, 0x9F, 0x84, 0x00, 0x00, 0x9F, 0x0C, 0x00, 0x00, 0x9F, 0x03, 0x01, 0xD0, 0x00, 
0x50, 0x00, 0x00, 0x9F, 0xF2, 0x00, 0x00, 0xA0, 0x08, 0x00, 0x00, 0x9F, 0x10, 0x00, 0x00, 0x9F, 
0x02, 0x01, 0x70, 0x00, 0x01, 0x01, 0x70, 0x00, 0x24, 0x01, 0x00, 0x94, 0x00, 0x00, 0x20, 0x00, 
0x2C, 0x00, 0x00, 0x94, 0x28, 0x00, 0x00, 0x94, 0x68, 0x01, 0x00, 0x94, 0x00, 0x00, 0x01, 0x00, 
0x00, 0x00, 0x00, 0x01, 0xFE, 0xFF, 0x02, 0x00, 0x6C, 0x00, 0x00, 0x94, 0x00, 0x00, 0x02, 0x00, 
0xFF, 0xFF, 0xFD, 0xFF, 0x20, 0x01, 0x00, 0x94, 0x70, 0x00, 0x00, 0x94, 0x00, 0xD0, 0x80, 0x3D, 
0x00, 0x90, 0x80, 0x3D, 0x58, 0x00, 0x00, 0x9F, 0x24, 0x00, 0x01, 0x00, 0x26, 0x00, 0x01, 0x00, 
0x68, 0x00, 0x00, 0x9F, 0x25, 0x64, 0x2E, 0x00, 0x25, 0x68, 0x68, 0x58, 0x3A, 0x00, 0x00, 0x00, 
0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 
0x00, 0x00, 0x00, 0x00, 0x67, 0x66, 0x66, 0x66, 
};


//NFC_ADAPTER NFCAdapter;
IRQ_FUN LpPeriIrqFunTable[32];
u32 LpPeriIrqDataTable[32];

VOID
WriteA2NMailbox(
    IN VOID *pNFCAdapte
)
{
    PNFC_ADAPTER pNFCAdp = (PNFC_ADAPTER) pNFCAdapte;
    u8 i = 0;
    u32 RegTemp;

    if (!(pNFCAdp->A2NMAILQ[pNFCAdp->A2NWQRIdx].Response)) {
        pNFCAdp->A2NMAILQ[pNFCAdp->A2NWQRIdx].Content[0] = 
            (pNFCAdp->A2NMAILQ[pNFCAdp->A2NWQRIdx].Content[0]|(pNFCAdp->A2NSeq << 8));
        pNFCAdp->A2NSeq++;
    }    
    
    for(i = 0; i < pNFCAdp->A2NMAILQ[pNFCAdp->A2NWQRIdx].Length; i++) {
        HalDelayUs(30);
        HAL_WRITE32(NFC_INTERFACE_BASE, 0x10, pNFCAdp->A2NMAILQ[pNFCAdp->A2NWQRIdx].Content[i]);
    }
    
    HalDelayUs(30);
    RegTemp = HAL_READ32(NFC_INTERFACE_BASE,0x24)|BIT1;
    HAL_WRITE32(NFC_INTERFACE_BASE, 0x24, RegTemp);
    
    RegTemp = (HAL_READ32(NFC_INTERFACE_BASE,0x24)&(~BIT1));
    HAL_WRITE32(NFC_INTERFACE_BASE, 0x24, RegTemp);
}

VOID
A2NWriteInQueue(
    IN VOID *pNFCAdapte,
    IN VOID *pBuff
)
{
    PNFC_ADAPTER pNFCAdp = (PNFC_ADAPTER) pNFCAdapte;
    PA2N_MAILBOX_Q pA2NWData = (PA2N_MAILBOX_Q) pBuff;
    u8 Idx;

    //Q full handle
    if ((pNFCAdp->A2NWQWIdx == (pNFCAdp->A2NWQRIdx - 1))||
        ((pNFCAdp->A2NWQRIdx == 0)&&(pNFCAdp->A2NWQWIdx == N2A_Q_LENGTH - 1))){

        DBG_8195A("A2N write Mailbox Queue full !!\n");
    }
    
    for (Idx = 0; Idx < pA2NWData->Length; Idx++) {
        pNFCAdp->A2NMAILQ[pNFCAdp->A2NWQWIdx].Content[Idx] = pA2NWData->Content[Idx];
    }
    
    pNFCAdp->A2NMAILQ[pNFCAdp->A2NWQWIdx].Length = pA2NWData->Length;
    pNFCAdp->A2NMAILQ[pNFCAdp->A2NWQWIdx].Response = pA2NWData->Response;
    pNFCAdp->A2NWQWIdx++;

    if (pNFCAdp->A2NWQWIdx == N2A_Q_LENGTH){
        pNFCAdp->A2NWQWIdx = 0;
    }

    //check qu and enable task
    if (pNFCAdp->A2NWQWIdx != pNFCAdp->A2NWQRIdx){
        pNFCAdp->A2NWMailBox = TRUE;
        RtlUpSema(&(pNFCAdp->VeriSema));
    }

    
    #if 0
    {
        u8 i = 0;
        u8 j = 0;
        DBG_8195A("A2N idx = 0x%x \n", pNFCAdp->A2NWMailBox);
        DBG_8195A("A2N write R idx = 0x%x \n", pNFCAdp->A2NWQRIdx);
        DBG_8195A("A2N write W idx = 0x%x \n", pNFCAdp->A2NWQWIdx);

        for(i = 0;i<pNFCAdp->A2NWQWIdx;i++) {
            
            DBG_8195A("A2N write queue %d, length = 0x%x \n", i, pNFCAdp->A2NMAILQ[i].Length);
            DBG_8195A("A2N write queue %d, response = 0x%x \n", i, pNFCAdp->A2NMAILQ[i].Response);
            for(j = 0;j < 5; j++) {
                DBG_8195A("A2N write queue %d, data = 0x%x \n", i, pNFCAdp->A2NMAILQ[i].Content[j]);
            }
        }
    }
    #endif
}

VOID
A2NWriteDeQueue(
    IN VOID *pNFCAdapte
)
{
    PNFC_ADAPTER pNFCAdp = (PNFC_ADAPTER) pNFCAdapte;
    u32 TimeIdx = 0;
    
    while(((HAL_READ32(NFC_INTERFACE_BASE, 0x14)>>1) & 0xf)!= 0){
        DBG_8195A("A2N Mailbox W MISC 0x%08x\n", ((HAL_READ32(NFC_INTERFACE_BASE, 0x14)>>1) & 0xf));
        HalDelayUs(30);
        TimeIdx++;
        if (TimeIdx > 10000){
            
            DBG_8195A("A2N Mailbox write timeout\n");
            
            //check qu and enable task
            if (pNFCAdp->A2NWQWIdx != pNFCAdp->A2NWQRIdx){
                pNFCAdp->A2NWMailBox = TRUE;
                RtlUpSema(&(pNFCAdp->VeriSema));
            }
            return;
        }    
    };

    WriteA2NMailbox(pNFCAdapte);
    
    pNFCAdp->A2NWQRIdx++;
    if (pNFCAdp->A2NWQRIdx == N2A_Q_LENGTH) {
        pNFCAdp->A2NWQRIdx = 0;
    }

    //check qu and enable task
    if (pNFCAdp->A2NWQWIdx != pNFCAdp->A2NWQRIdx){
        pNFCAdp->A2NWMailBox = TRUE;
        RtlUpSema(&(pNFCAdp->VeriSema));
    }
    else {
        pNFCAdp->A2NWMailBox = FALSE;
    }
}


//cmd 0
VOID
N2AReadTag(
    IN VOID *pNFCAdapte,
    IN u8   N2ARPage
)
{
    PNFC_ADAPTER pNFCAdp = (PNFC_ADAPTER)pNFCAdapte;

    nfc_tagread_callback (pNFCAdp, N2ARPage);
}

VOID
A2NWriteCatch(
    IN VOID *pNFCAdapte,
    IN u8   N2AWPage,
    IN u8   Length,
    IN u32  *WData
)
{
    PNFC_ADAPTER pNFCAdp = (PNFC_ADAPTER)pNFCAdapte;
    u8 Idx;
    A2N_MAILBOX_Q DataTemp;

    DataTemp.Length = Length+1;
    DataTemp.Response = 0;
    DataTemp.Content[0] = (CATCH_WRITE|(DataTemp.Length<<5)|(N2AWPage<<16));
    for (Idx = 0; Idx < Length; Idx++) {
        DataTemp.Content[Idx+1] = WData[Idx];
    }
    A2NWriteInQueue(pNFCAdp, &DataTemp);
}


VOID
A2NReadCatch(
    IN VOID *pNFCAdapte,
    IN u8   A2NRPage
)
{
    A2N_MAILBOX_Q DataTemp;
    
    DataTemp.Length = 1;
    DataTemp.Response = 0;
    DataTemp.Content[0] = (CATCH_READ|(DataTemp.Length<<5)|(A2NRPage<<16));

    A2NWriteInQueue((PNFC_ADAPTER)pNFCAdapte, &DataTemp);
}


//cmd 1
VOID
N2AWriteTag(
    IN VOID *pNFCAdapte,
    IN u8   N2AWPage
)
{
    PNFC_ADAPTER pNFCAdp = (PNFC_ADAPTER)pNFCAdapte;
    u32 wr_data;

    wr_data = HAL_READ32(NFC_INTERFACE_BASE, 0x18);
    nfc_tagwrite_callback(pNFCAdp, N2AWPage, wr_data);
}


//cmd 3
VOID
N2AReadCatch(
    IN VOID *pNFCAdapte,
    IN u8   N2ACatchRPage
)
{
    PNFC_ADAPTER pNFCAdp = (PNFC_ADAPTER)pNFCAdapte;
    u32 TagBuf[4];

    TagBuf[0] = HAL_READ32(NFC_INTERFACE_BASE, 0x18);
    TagBuf[1] = HAL_READ32(NFC_INTERFACE_BASE, 0x18);
    TagBuf[2] = HAL_READ32(NFC_INTERFACE_BASE, 0x18);
    TagBuf[3] = HAL_READ32(NFC_INTERFACE_BASE, 0x18);
    
    nfc_cache_read_callback(pNFCAdp, N2ACatchRPage, TagBuf);
}

//cmd 4
VOID
NFCReaderPresent(
    IN VOID *pNFCAdapte,
    IN u8 State
)
{
    PNFC_ADAPTER pNFCAdp = (PNFC_ADAPTER)pNFCAdapte;

    if (State) {
        DBG_8195A("NFC Reader Present\n");

        //call app
        nfc_event_callback(pNFCAdp, NFC_HAL_READER_PRESENT);
    }
}


//cmd 5 
VOID
N2AMailboxState(
    IN VOID *pNFCAdapte,
    IN u8 State,
    IN u8 Seq
)
{
    A2N_MAILBOX_Q MailData;
    PNFC_ADAPTER pNFCAdp = (PNFC_ADAPTER)pNFCAdapte;

    pNFCAdp->N2ABoxOpen = State;
    DBG_8195A("N2A Mailbox State = %d\n", pNFCAdp->N2ABoxOpen);
    
    if (State) {
        MailData.Length = 1;
        MailData.Response = 1;
        MailData.Content[0] = (CONFIRM_N2A_BOX_STATE)|(0x1<<5)|((Seq|BIT7)<<8)|(ON<<16);
        //WriteA2NMailbox(1, &MailData, 1);
        A2NWriteInQueue(pNFCAdp, &MailData);
    }
}


//cmd 6
VOID
NFC25MClkReq(
    IN VOID *pNFCAdapte,
    IN u8 OP,
    IN u8 Seq
)
{
    PNFC_ADAPTER pNFCAdp = (PNFC_ADAPTER)pNFCAdapte;
    A2N_MAILBOX_Q MailData;
    u32 RegTemp = HAL_READ32(SYSTEM_CTRL_BASE, REG_SYS_SYSPLL_CTRL1);
    if (OP) {
        RegTemp = ((RegTemp & 0xFFFFC7FF)|(BIT_SYS_SYSPLL_CKSDR_EN|BIT_SYS_SYSPLL_CKSDR_DIV(2)));
    }
    else {
        RegTemp = RegTemp & 0xFFFFC7FF;
    }
    HAL_WRITE32(SYSTEM_CTRL_BASE, REG_SYS_SYSPLL_CTRL1, RegTemp);

    //write mailbox
    MailData.Length = 1;
    MailData.Response = 1;
    MailData.Content[0] = (EXT_CLK_RSP)|(0x1<<5)|((Seq|BIT7)<<8)|(ON<<16);
    //WriteA2NMailbox(pNFCAdp, &MailData);
    A2NWriteInQueue(pNFCAdp, &MailData);
}

VOID
NFCRoutine(
    IN VOID *pNFCAdapte
)
{
    u32 N2ARData, N2AMISC;
    u8  N2ARB2;
    u8  Seq;
    PNFC_ADAPTER pNFCAdp = (PNFC_ADAPTER)pNFCAdapte;
    
    //N2A MEM DATA
    if (pNFCAdp->NFCIsr & (BIT0|BIT6)) {
        pNFCAdp->NFCIsr &= ~(BIT6|BIT0);
        
        N2AMISC = ((HAL_READ32(NFC_INTERFACE_BASE, 0x1c)>>1)&0xf);
        //DBG_8195A("NFC 0x1C = 0x%x \n", N2AMISC);
        while (N2AMISC != 0){

            N2ARData = HAL_READ32(NFC_INTERFACE_BASE, 0x18);
            N2ARB2 = ((u8)(N2ARData>>16));
            Seq = (u8)(N2ARData>>8);
            //DBG_8195A("NFC 0x18 = 0x%x \n", N2ARData);
            
            switch(N2ARData & 0x1F) {
                case TAG_READ:
                    //get data
                    N2AReadTag(pNFCAdapte, N2ARB2);
                    //call app
                    
                    break;
                case TAG_WRITE:
                    //get data
                    N2AWriteTag(pNFCAdapte, N2ARB2);
                    //call app
                    
                    break;
                case CATCH_READ_DATA:
                    //get data
                    N2AReadCatch(pNFCAdapte, N2ARB2);
                    //call app
                    
                    break;
                case NFC_R_PRESENT:
                    NFCReaderPresent(pNFCAdapte, N2ARB2);
                    break;
                case N2A_MAILBOX_STATE:
                    N2AMailboxState(pNFCAdapte, N2ARB2, Seq);
                    break;
                case EXT_CLK_REQ:
                    NFC25MClkReq(pNFCAdapte, N2ARB2, Seq);
                    break;
                default:
                    break;
            }
            
            N2AMISC = ((HAL_READ32(NFC_INTERFACE_BASE, 0x1c)>>1)&0xf);
        }
    }
    
    if(pNFCAdp->A2NWMailBox){
        A2NWriteDeQueue(pNFCAdp);
    }
    //enable int
    //A2NWRITE32(0x68, 0xff00);
}


VOID
NFCTaskHandle(
    IN VOID *pNFCAdapte
)
{
    PNFC_ADAPTER pNFCAdp = (PNFC_ADAPTER)pNFCAdapte;
    
    #if !TASK_SCHEDULER_DISABLED//#if !TASK_SCHEDULER_DISABLED(>>)
    for (;;)//start of for(;;)
    {   
        //4 waiting for start command
        RtlDownSema(&(pNFCAdp->VeriSema));

        if (pNFCAdp->TaskStop) {
            break;  // task stopping, break the for loop
        }
        NFCRoutine(pNFCAdapte);
        
    }//end of for(;;)

    pNFCAdp->TaskStop = 0;
#if ( INCLUDE_vTaskDelete == 1 )
    vTaskDelete(NULL);
#endif
    #endif
}

VOID
LPIrqHandle(
    IN VOID *pNFCAdapte
)
{
    u32 LpIrqStatus, CheckIndex, ExactIrqStatus, TableIndex;
    
    //DBG_8195A("Enter ISR\n");
    
    LpIrqStatus = HAL_READ32(VENDOR_REG_BASE, LP_PERI_EXT_IRQ_STATUS);

    //Save exact IRQ status
    ExactIrqStatus = LpIrqStatus &
                     HAL_READ32(VENDOR_REG_BASE, LP_PERI_EXT_IRQ_EN);

    //Check exact IRQ function
    for(CheckIndex = 0;CheckIndex<32;CheckIndex++) {
        if (ExactIrqStatus & BIT_(CheckIndex)) {
            TableIndex = CheckIndex;
            LpPeriIrqFunTable[TableIndex]((VOID *)(LpPeriIrqDataTable[TableIndex]));
        }
    }

    //Clear sub-rout IRQ
    HAL_WRITE32(VENDOR_REG_BASE, LP_PERI_EXT_IRQ_STATUS, LpIrqStatus);

}

VOID
NFCIrqHandle(
    IN VOID *pNFCAdapte
)
{
    PNFC_ADAPTER pNFCAdp = (PNFC_ADAPTER)pNFCAdapte;
    u32 ISR = HalNFCRead32(0x68);
    pNFCAdp->NFCIsr = (((u8)((ISR&0xbf00)>>8))&((u8)ISR));
    //DBG_8195A("A2N 0x68 = 0x%x\n", ISR);

    //stop int
    //ISR = ISR&0xff;
    
    HalNFCWrite32(0x68, ISR);
    
    //DBG_8195A("After clean ISR A2N 0x68 = 0x%x\n", A2NREAD32(0x68));   
    RtlUpSema(&(pNFCAdp->VeriSema));
}

VOID HalNFCDmemInit(
    IN u32 *pTagData,
    IN u32 TagLen
)
{
    if (pTagData == NULL) {
        return;
    }

    u32 pgidx, dmemidx;
    for (pgidx = 0, dmemidx = 4; pgidx<TagLen; pgidx++) {
        NFCFWDMEM[dmemidx++] = (u8)((pTagData[pgidx] & 0x000000FF) >>  0);
        NFCFWDMEM[dmemidx++] = (u8)((pTagData[pgidx] & 0x0000FF00) >>  8);
        NFCFWDMEM[dmemidx++] = (u8)((pTagData[pgidx] & 0x00FF0000) >> 16);
        NFCFWDMEM[dmemidx++] = (u8)((pTagData[pgidx] & 0xFF000000) >> 24);
    }
}

VOID
HalNFCInit(
    PNFC_ADAPTER pNFCAdp
)
{
    u32 Rtemp = 0;

    _memset(pNFCAdp, 0, sizeof(NFC_ADAPTER));
   
    //Enable NFC clk 0x244[17:16] = 3
    Rtemp = HAL_READ32(SYSTEM_CTRL_BASE, REG_PESOC_COM_CLK_CTRL1)|0x00030000;
    HAL_WRITE32(SYSTEM_CTRL_BASE, REG_PESOC_COM_CLK_CTRL1, Rtemp);

    //Enable A33 interface
    Rtemp = (HAL_READ32(SYSTEM_CTRL_BASE, REG_SYS_DSLP_TIM_CTRL) | 0x80000000);
    HAL_WRITE32(SYSTEM_CTRL_BASE, REG_SYS_DSLP_TIM_CTRL, Rtemp);

    //Enabel NFC and release IOS33_Ameba
    Rtemp = ((HAL_READ32(SYSTEM_CTRL_BASE, REG_SYS_DSLP_TIM_CTRL) & 0xffff0000) | 0x00009401);
    HAL_WRITE32(SYSTEM_CTRL_BASE, REG_SYS_DSLP_TIM_CTRL, Rtemp);

    //polling ISO33_NFC 0x134 [0] = 0
    while ( (HAL_READ32(SYSTEM_CTRL_BASE, REG_SYS_PERI_MONITOR)&BIT0) != 0 ){};

    //DBG_8195A("NFC Initialization Finish\n");

    //CLK 25M
    {
    u32 RegTemp = HAL_READ32(SYSTEM_CTRL_BASE, REG_SYS_SYSPLL_CTRL1);

    RegTemp = ((RegTemp & 0xFFFFC7FF)|(BIT_SYS_SYSPLL_CKSDR_EN|BIT_SYS_SYSPLL_CKSDR_DIV(2)));
    //RegTemp = ((RegTemp & 0xFFFFC7FF)|BIT13|BIT12);
    HAL_WRITE32(SYSTEM_CTRL_BASE, REG_SYS_SYSPLL_CTRL1, RegTemp);
    HAL_WRITE32(SYSTEM_CTRL_BASE, 0x244, HAL_READ32(SYSTEM_CTRL_BASE, 0x244)|BIT18);
    }

    
    //Init INT
    {
        IRQ_HANDLE          NfcHandle;
        NfcHandle.Data       = (u32) (pNFCAdp);
        NfcHandle.IrqNum     = LP_EXTENSION_IRQ;//NFC_IRQ;
        NfcHandle.IrqFun     = (IRQ_FUN) LPIrqHandle;
        NfcHandle.Priority   = 13;
         
        InterruptRegister(&NfcHandle);
        InterruptEn(&NfcHandle);

        LpPeriIrqFunTable[1]  = (IRQ_FUN)((u32)NFCIrqHandle | 0x1);

        LpPeriIrqDataTable[1] = (u32)(pNFCAdp);
        //level trigger
        HAL_WRITE32(VENDOR_REG_BASE, LP_PERI_EXT_IRQ_MODE,0);
        //enable imr
        HAL_WRITE32(VENDOR_REG_BASE, LP_PERI_EXT_IRQ_EN, 
                    (HAL_READ32(VENDOR_REG_BASE, LP_PERI_EXT_IRQ_EN) | BIT1));
        HalNFCWrite32(0x68, 0xBF00);
        //enable mailbox
        HalNFCWrite32(0xfc, 0x2243);
        
    }

    #if !TASK_SCHEDULER_DISABLED
    {
        s32 NFCTmpSts;
        //create task
        RtlInitSema(&(pNFCAdp->VeriSema),0);
        NFCTmpSts = xTaskCreate( NFCTaskHandle, (const char *)"NFC_TASK", 
                            ((1024*4)/sizeof(portBASE_TYPE)), (void *)pNFCAdp, 1, &(pNFCAdp->NFCTask));
        if (pdTRUE != NFCTmpSts ) {
            DBG_NFC_ERR("HalNFCInit: Create Task Err(%d)!!\n", NFCTmpSts);
        }
    }
    #endif
    
}

VOID
HalNFCDeinit(
    PNFC_ADAPTER pNFCAdp
)
{
    u32 i;
    u32 Rtemp = 0;
    
    pNFCAdp->TaskStop = 1;
    RtlUpSema(&(pNFCAdp->VeriSema));
    // wait sometime for the task be stooped
    for(i=0;i<1000;i++) {
        if (pNFCAdp->TaskStop == 0) {
            break;
        }
        else {
            RtlMsleepOS(100);
        }
    }
    //4 free the task semaphore
    RtlFreeSema(&(pNFCAdp->VeriSema));
    _memset(pNFCAdp, 0, sizeof(NFC_ADAPTER));

    //4 Disable NFC clk
    Rtemp = HAL_READ32(SYSTEM_CTRL_BASE, REG_PESOC_COM_CLK_CTRL1)&0xFFFCFFFF;
    HAL_WRITE32(SYSTEM_CTRL_BASE, REG_PESOC_COM_CLK_CTRL1, Rtemp);

    //4 Enable A33 interface
    Rtemp = (HAL_READ32(SYSTEM_CTRL_BASE, REG_SYS_DSLP_TIM_CTRL) | 0x80000000);
    HAL_WRITE32(SYSTEM_CTRL_BASE, REG_SYS_DSLP_TIM_CTRL, Rtemp);

    Rtemp = ((HAL_READ32(SYSTEM_CTRL_BASE, REG_SYS_DSLP_TIM_CTRL) & 0xffff0000) | 0x00009404);
    HAL_WRITE32(SYSTEM_CTRL_BASE, REG_SYS_DSLP_TIM_CTRL, Rtemp);
}


u32
HalNFCRead32(
    IN  u32 Addr
)
{    
    u32 Rtemp = 0;
    u32 Idxtemp = 0;
    
    //full addr
    HAL_WRITE32(NFC_INTERFACE_BASE, 0x0, (0x1f000000+Addr));
    //R_cmd
    HAL_WRITE32(NFC_INTERFACE_BASE, 0x4, 0x2f);

    while(1) {
        if( (HAL_READ32(NFC_INTERFACE_BASE, 0x4)&BIT7) == 0 ){
            Idxtemp++;
            if((Idxtemp)%10000 == 0) {
                DBG_8195A("Idxtemp: 0x%x\n", Idxtemp);
            }
            if (Idxtemp > 0x0fffff) {
                DBG_8195A("A2N_OCP_MISC_R_IN_WHILE: 0x%x\r\n", HAL_READ32(NFC_INTERFACE_BASE, 0x4));
                DBG_8195A("Read FAIL!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!1\r\n");
                return 0;
            }            
        }
        else {
            //DBG_8195A("A2N_OCP_MISC_R_IN_WHILE: 0x%x\n", HAL_READ32(NFC_INTERFACE_BASE, 0x4));
            HAL_WRITE32(NFC_INTERFACE_BASE, 0x4, BIT7);
            Rtemp = HAL_READ32(NFC_INTERFACE_BASE, 0xc);
            break;
        }        
    }

    return Rtemp;
}

VOID
HalNFCWrite32(
    IN  u32 Addr,
    IN  u32 Data
)
{
    u32 Idxtemp = 0;
    
    //full addr
    HAL_WRITE32(NFC_INTERFACE_BASE, 0x0, 0x1f000000+Addr);
    //full data
    HAL_WRITE32(NFC_INTERFACE_BASE, 0x8, Data);
    //W_cmd
    HAL_WRITE32(NFC_INTERFACE_BASE, 0x4, 0x1f);

    //polling 0x4[7]=1
    while(1) {
        if( (HAL_READ32(NFC_INTERFACE_BASE, 0x4)&BIT7) == 0 ){
	        Idxtemp++;
            if((Idxtemp)%10000 == 0) {
                DBG_8195A("Idxtemp: 0x%x\n", Idxtemp);
            }
            if (Idxtemp > 0x0fffff) {
                DBG_8195A("A2N_OCP_MISC_R_IN_WHILE: 0x%x\r\n", HAL_READ32(NFC_INTERFACE_BASE, 0x4));
        	    DBG_8195A("write FAIL!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!1\r\n");
                return;
            }
        }
        else {
            //DBG_8195A("A2N_OCP_MISC_W_IN_WHILE: 0x%x\n", HAL_READ32(NFC_INTERFACE_BASE, 0x4));
            HAL_WRITE32(NFC_INTERFACE_BASE, 0x4, BIT7);
            break;
        }
    }
}

VOID
HalNFCFwFullMEM(
    IN  VOID *Data,
    IN  u32  NFCFwLength
)
{
    u32 *NFCFW;
    NFCFW = (u32*) Data;
    u32 Idx, NFCFwTemp, RTemp;
    u8 Temp = (NFCFwLength%4);
    u32 IdxTemp = ((NFCFwLength-Temp)/4);
    u8 MEMTemp = 0;
//    u8 MEMCnt = 0;

    u32 FWChkSum = 0;

    HalNFCWrite32(0x4C, 0x0);
    
    //write fw to MEM
    for (Idx = 0; Idx < IdxTemp; Idx++ ) {

        NFCFwTemp = *(NFCFW+Idx);
        HAL_WRITE32(NFC_INTERFACE_BASE, 0x10, NFCFwTemp);

        //cal chksum
        FWChkSum ^= NFCFwTemp;
        MEMTemp++;
        HalDelayUs(1);
        
        if (MEMTemp == 8) {
            
            MEMTemp = 0;
            
            //check mem empty
            while(1){
                
                RTemp = HAL_READ32(NFC_INTERFACE_BASE, 0x14);
//                MEMCnt = (((u8)(RTemp & 0x1e)) >> 1);
                
                if ( RTemp & BIT6) {
                    break;
                }
                else {
                }
            }
        }
    }
    
    HalDelayUs(200);

    while(1){
        RTemp = HAL_READ32(NFC_INTERFACE_BASE, 0x14);
        if ( RTemp & BIT6) {
            break;
        }
        else {
        }
    }

    //write chksum
    HAL_WRITE32(NFC_INTERFACE_BASE, 0x10, FWChkSum);

    while(1){
        RTemp = HAL_READ32(NFC_INTERFACE_BASE, 0x14);
        if ( RTemp & BIT6) {
            break;
        }
        else {
        }
    }
}    


VOID
HalNFCFwDownload(
    VOID
)
{
    u32 Rtemp = 0;
    
    //switch free run clock from 500K to 80M
    HalNFCWrite32(0x88, 0xf06cf06c);

    //2 Download NFC FW
    //3 Download IMEM
    //setting fw download
    HalNFCWrite32(0x48, 0x1);

    //reset NFC CPU
    HalNFCWrite32(0x20, 0x1234FFFF);
        
    //switch IMEM
    HAL_WRITE32(NFC_INTERFACE_BASE, 0x14, 0);

    //write fw to MEM
    HalNFCFwFullMEM(NFCFWIMEM,sizeof(NFCFWIMEM));
    HalDelayUs(100);
    
    Rtemp = HalNFCRead32(0x48);
    if(Rtemp & BIT1) {
        //DBG_8195A("NFC FW Download IMEM SUCCESS \n");
    }
    else {
        DBG_8195A("NFC FW Download IMEM FAIL !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! \n");
        return;
    }

    //3 Download DMEM
    //setting fw download
    HalNFCWrite32(0x48, 0x1);
      
    //switch DMEM
    HAL_WRITE32(NFC_INTERFACE_BASE, 0x14, 1);

    //write fw to MEM
    HalNFCFwFullMEM(NFCFWDMEM,sizeof(NFCFWDMEM));
    
    HalDelayUs(100);
    Rtemp = HalNFCRead32(0x48);
    if(Rtemp & BIT1) {
        //DBG_8195A("NFC FW Download DMEM SUCCESS \n");
    }
    else {
        DBG_8195A("NFC FW Download DMEM FAIL !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! \n");
        return;
    }
    
    //Reset CPU
    HalNFCWrite32(0x48, 0x80);
    
    DBG_8195A("NFC REBOOT SUCCESS \n");
}


u32
HalNFCDbgRead32(

    IN  u32 Addr
)
{
    u32 Rtemp = 0;
    u32 Idxtemp = 0;
    
    //full addr
    HAL_WRITE32(NFC_INTERFACE_BASE, 0x0, Addr);
    //R_cmd
    HAL_WRITE32(NFC_INTERFACE_BASE, 0x4, 0x2f);

    while(1) {
        if( (HAL_READ32(NFC_INTERFACE_BASE, 0x4)&BIT7) == 0 ){
            Idxtemp++;
            if((Idxtemp)%10000 == 0) {
                DBG_8195A("Idxtemp: 0x%x\n", Idxtemp);
            }
            if (Idxtemp > 0x0fffff) {
                DBG_8195A("A2N_OCP_MISC_R_IN_WHILE: 0x%x\r\n", HAL_READ32(NFC_INTERFACE_BASE, 0x4));
                DBG_8195A("Read FAIL!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!1\r\n");
                return 0;
            }            
        }
        else {
            //DBG_8195A("A2N_OCP_MISC_R_IN_WHILE: 0x%x\n", HAL_READ32(NFC_INTERFACE_BASE, 0x4));
            HAL_WRITE32(NFC_INTERFACE_BASE, 0x4, BIT7);
            Rtemp = HAL_READ32(NFC_INTERFACE_BASE, 0xc);
            break;
        }        
    }

    return Rtemp;
}


VOID
HalNFCDbgWrite32(

    IN  u32 Addr,
    IN  u32 Data
)
{
    u32 Idxtemp = 0;
    
    //full addr
    HAL_WRITE32(NFC_INTERFACE_BASE, 0x0, Addr);
    //full data
    HAL_WRITE32(NFC_INTERFACE_BASE, 0x8, Data);
    //W_cmd
    HAL_WRITE32(NFC_INTERFACE_BASE, 0x4, 0x1f);

    while(1) {
        if( (HAL_READ32(NFC_INTERFACE_BASE, 0x4)&BIT7) == 0 ){
	        Idxtemp++;
            if((Idxtemp)%10000 == 0) {
                DBG_8195A("Idxtemp: 0x%x\n", Idxtemp);
            }
            if (Idxtemp > 0x0fffff) {
                DBG_8195A("A2N_OCP_MISC_R_IN_WHILE: 0x%x\r\n", HAL_READ32(NFC_INTERFACE_BASE, 0x4));
        	    DBG_8195A("write FAIL!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!1\r\n");
                return;
            }
        }
        else {
            //DBG_8195A("A2N_OCP_MISC_W_IN_WHILE: 0x%x\n", HAL_READ32(NFC_INTERFACE_BASE, 0x4));
            HAL_WRITE32(NFC_INTERFACE_BASE, 0x4, BIT7);
            break;
        }
    }
}

#endif  //CONFIG_NFC_EN
