#ifndef __INC_RTL8710B_SYS_ON_BIT_H
#define __INC_RTL8710B_SYS_ON_BIT_H

/* REG_SYS_PWR_ISO_CTRL 0x0000 */
#define BIT_SYS_PWR_SOC_EN 				BIT(2)
#define BIT_SYS_PWR_RET_MEM_EN 			BIT(1)
#define BIT_SYS_PWR_PEON_EN 				BIT(0)

/* REG_SYS_ISO_CTRL 0x0002 */
#define BIT_SYS_ISO_SYSPLL 					BIT(23)
#define BIT_SYS_ISO_32K 					BIT(21)
#define BIT_SYS_ISO_MEM2 					BIT(20)
#define BIT_SYS_ISO_MEM1 					BIT(19)
#define BIT_SYS_ISO_SOC 					BIT(18)
#define BIT_SYS_ISO_RET_MEM 				BIT(17)
#define BIT_SYS_ISO_PEON 					BIT(16)

/* REG_SYS_FUNC_EN 0x0008 */
#define BIT_SYS_AMACRO_EN 					BIT(31)
#define BIT_SYS_PWRON_TRAP_SHTDN_N 		BIT(30)
#define BIT_SYS_FEN_SIC_MST 				BIT(25)
#define BIT_SYS_FEN_SIC 					BIT(24)
#define BIT_SOC_SYSPEON_EN 				BIT(4)
#define BIT_SYS_FEN_EELDR 					BIT(0)

/* REG_SYS_REGU_CTRL0 0x0040 */
#define BIT_SHIFT_SYS_REGU_LDO25M_ADJ	20
#define BIT_MASK_SYS_REGU_LDO25M_ADJ		0xf
#define BIT_SYS_REGU_ANACK_4M_SEL		BIT(18)
#define BIT_SYS_REGU_PC_EF_EN				BIT(17)
#define BIT_SYS_REGU_LDOH12_SLP_EN		BIT(16)
#define BIT_SHIFT_SYS_REGU_LDOH12_ADJ	12
#define BIT_MASK_SYS_REGU_LDOH12_ADJ		0xf
#define BIT_SHIFT_SYS_REGU_LDO25E_ADJ	8
#define BIT_MASK_SYS_REGU_LDO25E_ADJ		0xf
#define BIT_SYS_REGU_DSLEPM_EN			BIT(7)
#define BIT_SYS_REGU_PC_33V_EN			BIT(3)
#define BIT_SYS_REGU_PC_EF25_EN			BIT(2)
#define BIT_SYS_REGU_LDO25M_EN			BIT(1)
#define BIT_SYS_REGU_LDO25E_EN			BIT(0)

/* REG_SYS_SWR_CTRL0 0x0048 */
#define BIT_SHIFT_SYS_SWR12_COMP_R2 		30
#define BIT_MASK_SYS_SWR12_COMP_R2 		0x3
#define BIT_SHIFT_SYS_SWR12_COMP_R1 		28
#define BIT_MASK_SYS_SWR12_COMP_R1 		0x3
#define BIT_SHIFT_SYS_SWR12_COMP_C3 		26
#define BIT_MASK_SYS_SWR12_COMP_C3 		0x3
#define BIT_SHIFT_SYS_SWR12_COMP_C2 		24
#define BIT_MASK_SYS_SWR12_COMP_C2 		0x3
#define BIT_SHIFT_SYS_SWR12_COMP_C1 		22
#define BIT_MASK_SYS_SWR12_COMP_C1 		0x3
#define BIT_SYS_SWR12_COMP_TYPE_L 		BIT(21)
#define BIT_SYS_SWR12_FPWM_MD 			BIT(20)
#define BIT_SHIFT_SYS_SPSLDO_VOL 			17
#define BIT_MASK_SYS_SPSLDO_VOL 			0x7
#define BIT_SHIFT_SYS_SWR12_IN 			14
#define BIT_MASK_SYS_SWR12_IN 			0x7
#define BIT_SHIFT_SYS_SWR12_STD 			12
#define BIT_MASK_SYS_SWR12_STD 			0x3
#define BIT_SHIFT_SYS_SWR12_VOL 			8
#define BIT_MASK_SYS_SWR12_VOL 			0xf
#define BIT_SYS_SWR_EN 						BIT(1)
#define BIT_SYS_SWR_LDO_EN 				BIT(0)

/* REG_SYS_SWR_CTRL1 0x004C */
#define BIT_SYS_SW12_PFM_SEL 				BIT(25)
#define BIT_SYS_SW12_AUTO_ZCD_L 			BIT(24)
#define BIT_SYS_SW12_AUTO_MODE 			BIT(23)
#define BIT_SYS_SW12_LDOF_L 				BIT(22)
#define BIT_SYS_SW12_OCPS_L 				BIT(21)

#define BIT_SHIFT_SYS_SW12_TBOX 				17
#define BIT_MASK_SYS_SW12_TBOX 				0x3
#define BIT_SHIFT_SYS_SW12_NONOVRLAP_DLY	15
#define BIT_MASK_SYS_SW12_NONOVRLAP_DLY 	0x3
#define BIT_SYS_SW12_CLAMP_DUTY 				BIT(14)
#define BIT_SYS_SWR12_BYPASS_SSR 				BIT(13)
#define BIT_SYS_SWR12_ZCDOUT_EN 				BIT(12)
#define BIT_SYS_SWR12_POW_ZCD 				BIT(11)
#define BIT_SYS_SW12_AREN 						BIT(10)
#define BIT_SHIFT_SYS_SWR12_OCP_CUR 			7
#define BIT_MASK_SYS_SWR12_OCP_CUR 			0x7
#define BIT_SYS_SWR12_OCP_EN 					BIT(6)
#define BIT_SHIFT_SYS_SWR12_SAWTOOTH_CF_L 	4
#define BIT_MASK_SYS_SWR12_SAWTOOTH_CF_L 	0x3
#define BIT_SHIFT_SYS_SWR12_SAWTOOTH_CFC_L 	2
#define BIT_MASK_SYS_SWR12_SAWTOOTH_CFC_L 	0x3
#define BIT_SHIFT_SYS_SWR12_COMP_R3 			0
#define BIT_MASK_SYS_SWR12_COMP_R3 			0x3

/* REG_SYS_PINMUX_CTRL 0x00A4 */
#define BIT_SWD_PU_EN						BIT(12)	/*!< SWD pinmux use REG_SYS_PINMUX_CTRL enable */
#define BIT_SWD_S1_PU						BIT(11)	/*!< SWD S1 PU */
#define BIT_SWD_S0_PU						BIT(10)	/*!< SWD S0 PU */
#define BIT_SDIO_S1_PU						BIT(9)	/*!< SDIO S1 PU: GPIOA_6 ~ GPIOA_11 */
#define BIT_SDIO_S0_PU						BIT(8)	/*!< SDIO S0 PU: GPIOA_18 ~ GPIOA_23 */
#define BIT_FLASH_PU							BIT(2)	/*!< default : 0, without Pull-up resistance, set 0x4000_00A4[2]=1 before power save to fix QFN32 ACUT power leakage */
#define BIT_GPIOA3_PU						BIT(1)	/*!< GPIOA3 default PU to fix QFN32 ACUT power leakage, for SPS mode, should set 0 */
#define BIT_SIC_PIN_EN						BIT(0)	/*!< 1: Enable SIC PINMUX function; 0: disable */

/* REG_SYS_DEBUG_REG 0x00BC */
#define BIT_SHIFT_SYS_DBG_VALUE 			0
#define BIT_MASK_SYS_DBG_VALUE 			0xffffffffL

/* REG_SYS_EEPROM_CTRL0 0x00E0 */
#define BIT_MASK_EFUSE_UNLOCK 			(0xff << 24)
#define BIT_SYS_EFUSE_LDALL 				BIT(16)
#define BIT_MASK_SYS_EEPROM_MD 			(0x3 << 6)
#define BIT_SYS_AUTOLOAD_SUS 				BIT(5)
#define BIT_SYS_EEPROM_SEL 				BIT(4)

/* REG_SYS_EEPROM_CTRL1 0x00E4 */
#define BIT_MASK_SYS_EEPROM_VPD 			0xffffffffL

/* REG_SYS_EFUSE_CTRL 0x00E8 */
#define BIT_SYS_EF_RWFLAG 					(0x00000001 << 31)
#define BIT_MASK_SYS_EF_PGPD 				(0x00000007 << 28)
#define BIT_MASK_SYS_EF_RDT 				(0x0000000f << 20)
#define BIT_MASK_SYS_EF_PGTS 				(0x0000000f << 20)
#define BIT_SYS_EF_ALDEN 					(0x00000001 << 18)
#define BIT_MASK_SYS_EF_ADDR 				(0x000003ff << 8)
#define BIT_MASK_SYS_EF_DATA 				(0x000000ff)

/* REG_SYS_EFUSE_TEST 0x00EC */
#define BIT_SYS_EF_CRES_SEL 				(0x00000001 << 26)
#define BIT_MASK_SYS_EF_SCAN_START 		(0x000001ff << 16)
#define BIT_MASK_SYS_EF_SCAN_END 			(0x0000000f << 12)
#define BIT_SYS_EF_FORCE_PGMEN 			(0x00000001 << 11)
#define BIT_SYS_EF_TRPT 					(0x00000001 << 7)
#define BIT_MASK_SYS_EF_SCAN_TTHD 		(0x0000007f)

/* REG_SYS_PERI_MONITOR 0x0134 */
#define BIT_RTC_DIV_XTAL					0x07FF0000//1221 [26:16]
#define BIT_RTC_PEN							((u32)(0x00000001 << 12))
#define BIT_RTC_DIV_XTAL_EN				((u32)(0x00000001 << 11))
#define BIT_RTC_CK_SEL						((u32)(0x00000001 << 10))
#define BIT_RTC_CK_EN						((u32)(0x00000001 << 9))
#define BIT_RTC_EN							((u32)(0x00000001 << 8))

//================= SYSON Register Address Definition =====================//
#define REG_SYS_PWR_ISO_CTRL				0x0000 /*!< 0x00: REG_SYS_PWR_CTRL, 0x02: REG_SYS_ISO_CTRL */
#define REG_SYS_FUNC_EN					0x0008
#define REG_SYS_CLK_CTRL0					0x0010
#define REG_SYS_CLK_CTRL1					0x0014
#define REG_SYS_EFUSE_SYSCFG0				0x0020 /*!< BYTE0x00~0x03 */
#define REG_SYS_EFUSE_SYSCFG1				0x0024 /*!< BYTE0x04~0x07 */
#define REG_SYS_EFUSE_SYSCFG2				0x0028 /*!< BYTE0x08~0x0B */
#define REG_SYS_EFUSE_SYSCFG3				0x002C /*!< BYTE0x0C~0x0F */
#define REG_SYS_EFUSE_SYSCFG4				0x0030 /*!< BYTE0x10~0x13 */
#define REG_SYS_EFUSE_SYSCFG5				0x0034 /*!< BYTE0x14~0x17 */
#define REG_SYS_EFUSE_SYSCFG6				0x0038 /*!< BYTE0x18~0x1B */
#define REG_SYS_EFUSE_SYSCFG7				0x003C
#define REG_SYS_REGU_CTRL0					0x0040
#define REG_SYS_SWR_CTRL0					0x0048
#define REG_SYS_SWR_CTRL1					0x004C
#define REG_SYS_XTAL_CTRL0					0x0060
#define REG_SYS_XTAL_CTRL1					0x0064
#define REG_SYS_XTAL_CTRL2					0x0068
#define REG_SYS_SYSPLL_CTRL0				0x0070
#define REG_SYS_SYSPLL_CTRL1				0x0074
#define REG_SYS_SYSPLL_CTRL2				0x0078
#define REG_SYS_SYSPLL_CTRL3				0x007C
#define REG_SYS_ANA_TIM_CTRL				0x0090
#define REG_SYS_DSLP_TIM_CTRL				0x0094
#define REG_SYS_DSLP_TIM_CAL_CTRL			0x0098
#define REG_SYS_PINMUX_CTRL				0x00A4
#define REG_SYS_GPIO_DSTBY_WAKE_CTRL0	0x00A8
#define REG_SYS_GPIO_DSTBY_WAKE_CTRL1	0x00AC
#define REG_SYS_DEBUG_REG					0x00BC
#define REG_SYS_EEPROM_CTRL0				0x00E0
#define REG_SYS_EEPROM_CTRL1				0x00E4
#define REG_SYS_EFUSE_CTRL					0x00E8
#define REG_SYS_EFUSE_TEST					0x00EC

#define REG_OSC32K_CTRL					0x00F0 /* AmebaZ move to 0xf0 */
#define REG_OSC32K_RCAL					0x00F4 /* AmebaZ Add */

#define REG_SYS_DSTBY_INFO0				0x00F8
#define REG_SYS_DSTBY_INFO1				0x00FC
#define REG_SYS_SLP_WAKE_EVENT_MSK0		0x0100
#define REG_SYS_SLP_WAKE_EVENT_MSK1		0x0104
#define REG_SYS_SLP_WAKE_EVENT_STATUS0	0x0108
#define REG_SYS_SLP_WAKE_EVENT_STATUS1	0x010C
#define REG_SYS_SNF_WAKE_EVENT_MSK0		0x0110
#define REG_SYS_SNF_WAKE_EVENT_STATUS	0x0114
#define REG_SYS_PWRMGT_CTRL				0x0118
#define REG_SYS_PWRMGT_OPTION			0x0120
#define REG_SYS_PWRMGT_OPTION_EXT		0x0124
#define REG_SYS_DSLP_WEVENT				0x0130
#define REG_SYS_PERI_MONITOR				0x0134
#define REG_SYS_NORESET_FF					0x0138
#define REG_SYS_SYSTEM_CFG0				0x01F0
#define REG_SYS_SYSTEM_CFG1				0x01F4
#define REG_SYS_SYSTEM_CFG2				0x01F8

#endif //__INC_RTL8710B_SYS_ON_BIT_H
