/**
  ******************************************************************************
  * @file    rtl8710b_pinmapcfg.c
  * @author
  * @version V1.0.0
  * @date    2016-05-17
  * @brief   This file provides firmware functions to manage the following 
  *          functionalities of pin control:
  *           - pinmux
  *           - active pad pull up & pull down
  *           - sleep pad pull up & pull down
  ******************************************************************************
  * @attention
  *
  * This module is a confidential and proprietary property of RealTek and
  * possession or use of this module requires written permission of RealTek.
  *
  * Copyright(c) 2015, Realtek Semiconductor Corporation. All rights reserved.
  ****************************************************************************** 
  */

#include "ameba_soc.h"

const PMAP_TypeDef pmap_func[]=
{
//  	Pin Name		Func Select				Func PU/PD			Slp PU/PD			DrvStrenth
	{_PA_14,		PINMUX_FUNCTION_SWD,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //SWD_CLK
	{_PA_15,		PINMUX_FUNCTION_SWD,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //SWD_DATA
	{_PA_13,		PINMUX_FUNCTION_PWM,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //PWM4
	{_PA_0,		PINMUX_FUNCTION_PWM,	GPIO_PuPd_NOPULL,	GPIO_PuPd_DOWN,PAD_DRV_STRENGTH_0}, //PWM2
	{_PA_16,		PINMUX_FUNCTION_PWM,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //PWM1
	{_PA_17,		PINMUX_FUNCTION_PWM,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //PWM2
	{_PA_25,		PINMUX_FUNCTION_UART,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //UART1_RXD
	{_PA_26,		PINMUX_FUNCTION_UART,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //UART1_TXD
	{_PA_28,		PINMUX_FUNCTION_I2C,	GPIO_PuPd_UP,		GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //I2C1_SCL
	{_PA_27,		PINMUX_FUNCTION_I2C,	GPIO_PuPd_UP,		GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //I2C1_SDA
	{_PA_12,		PINMUX_FUNCTION_PWM,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //PWM3
	{_PA_4,		PINMUX_FUNCTION_UART,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //UART0_TXD
	{_PA_1,		PINMUX_FUNCTION_UART,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //UART0_RXD
	{_PA_3,		PINMUX_FUNCTION_UART,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //UART0_RTS
	{_PA_2,		PINMUX_FUNCTION_UART,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //UART0_CTS
	{_PA_6,		PINMUX_FUNCTION_SPIF,	GPIO_PuPd_UP,		GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //SPIC_CS
	{_PA_7,		PINMUX_FUNCTION_SPIF,	GPIO_PuPd_UP,		GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //SPIC_DATA1
	{_PA_8,		PINMUX_FUNCTION_SPIF,	GPIO_PuPd_UP,		GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //SPIC_DATA2
	{_PA_9,		PINMUX_FUNCTION_SPIF,	GPIO_PuPd_UP,		GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //SPIC_DATA0
	{_PA_10,		PINMUX_FUNCTION_SPIF,	GPIO_PuPd_UP,		GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //SPIC_CLK
	{_PA_11,		PINMUX_FUNCTION_SPIF,	GPIO_PuPd_UP,		GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //SPIC_DATA3
	{_PA_5,		PINMUX_FUNCTION_PWM,	GPIO_PuPd_UP,		GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //PWM4
	{_PA_18,		PINMUX_FUNCTION_SDIOD,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //SD_D2
	{_PA_19,		PINMUX_FUNCTION_SDIOD,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //SD_D3
	{_PA_20,		PINMUX_FUNCTION_SDIOD,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //SD_CMD
	{_PA_21,		PINMUX_FUNCTION_SDIOD,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //SD_CLK
	{_PA_22,		PINMUX_FUNCTION_SDIOD,	GPIO_PuPd_UP,		GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //SD_D0
	{_PA_23,		PINMUX_FUNCTION_SDIOD,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //SD_D1
	{_PB_0,		PINMUX_FUNCTION_SPIM,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //SPI1_CS
	{_PB_1,		PINMUX_FUNCTION_SPIM,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //SPI1_CLK
	{_PB_2,		PINMUX_FUNCTION_SPIM,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //SPI1_MISO
	{_PB_3,		PINMUX_FUNCTION_SPIM,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //SPI1_MOSI
	{_PB_4,		PINMUX_FUNCTION_I2S,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //I2S_MCK
	{_PB_5,		PINMUX_FUNCTION_I2S,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //I2S_SD_TX
	{_PA_24,		PINMUX_FUNCTION_I2S,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //I2S_SD_RX
	{_PA_31,		PINMUX_FUNCTION_I2S,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //I2S_CLK
	{_PB_6,		PINMUX_FUNCTION_I2S,	GPIO_PuPd_NOPULL,	GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //I2S_WS
	{_PA_30,		PINMUX_FUNCTION_UART,	GPIO_PuPd_UP,		GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //UART2_log_TXD
	{_PA_29,		PINMUX_FUNCTION_UART,	GPIO_PuPd_UP,		GPIO_PuPd_UP,	PAD_DRV_STRENGTH_0}, //UART2_log_RXD
	{_PNC,		PINMUX_FUNCTION_GPIO,	GPIO_PuPd_NOPULL,	GPIO_PuPd_NOPULL,	PAD_DRV_STRENGTH_0}, //table end
};

/******************* (C) COPYRIGHT 2016 Realtek Semiconductor *****END OF FILE****/
