/***********************************************************
*  File: tuya_uart.h
*  Author: nzy
*  Date: 20171107
***********************************************************/
#ifndef __TUYA_UART_H
    #define __TUYA_UART_H

    #include "tuya_cloud_types.h"
    #include "tuya_hal_uart.h"

#ifdef __cplusplus
	extern "C" {
#endif

#ifdef  __TUYA_UART_GLOBALS
    #define __TUYA_UART_EXT
#else
    #define __TUYA_UART_EXT extern
#endif

/***********************************************************
*************************micro define***********************
***********************************************************/
#define TY_AUTH_UART TY_UART0

/***********************************************************
*************************variable define********************
***********************************************************/

/***********************************************************
*************************function define********************
***********************************************************/
/***********************************************************
*  Function: ty_uart_init 
*  Input: port badu bits parity stop
*  Output: none
*  Return: OPERATE_RET
***********************************************************/
__TUYA_UART_EXT \
OPERATE_RET ty_uart_init(TY_UART_PORT_E port,TY_UART_CFG_S *cfg, UINT_T bufsz, BOOL_T RUnBlock);

/***********************************************************
*  Function: ty_uart_free 
*  Input:free uart
*  Output: none
*  Return: OPERATE_RET
***********************************************************/
OPERATE_RET ty_uart_free(IN CONST TY_UART_PORT_E port);

/***********************************************************
*  Function: ty_uart_send_data 
*  Input: port data len
*  Output: none
*  Return: none
***********************************************************/
__TUYA_UART_EXT \
VOID ty_uart_send_data(IN CONST TY_UART_PORT_E port,IN CONST BYTE_T *data,IN CONST UINT_T len);

/***********************************************************
*  Function: ty_uart_send_data 
*  Input: len->data buf len
*  Output: buf->read data buf
*  Return: actual read data size
***********************************************************/
__TUYA_UART_EXT \
UINT_T ty_uart_read_data(IN CONST TY_UART_PORT_E port,OUT BYTE_T *buf,IN CONST UINT_T len);

#ifdef __cplusplus
}
#endif
#endif

