/**
 * @file tuya_main.c
 * @brief 提供tuya sdk 入口
 * 
 * @copyright Copyright (c) {2018-2020} 涂鸦科技 www.tuya.com
 * 
 */
#include "tuya_os_adapter.h"
#include "tuya_iot_wifi_api.h"
#include "mf_test.h"
#include "uni_log.h"
#include "tuya_uart.h"
#include "tuya_gpio.h"
#include "gw_intf.h"
#include "wf_basic_intf.h"
#if TY_SECURITY_CHIP
#include "Z32HUA_encrypt.h"
#endif

/***********************************************************
*************************micro define***********************
***********************************************************/
#define TEST_SSID "tuya_mdev_test1"
#define WF_SSID_LEN 32
typedef VOID_T (*APP_PROD_CB)(BOOL_T flag, CHAR_T rssi);

/***********************************************************
*************************variable define********************
***********************************************************/
extern VOID_T app_init(VOID_T);
STATIC APP_PROD_CB app_prod_test = NULL;
STATIC GW_WF_CFG_MTHD_SEL gwcm_mode = GWCM_OLD;
STATIC CHAR_T prod_ssid_name[WF_SSID_LEN + 1] = TEST_SSID;

/***********************************************************
*************************function define********************
***********************************************************/
extern VOID_T pre_device_init(VOID_T);
extern OPERATE_RET device_init(VOID_T);
extern BOOL_T gpio_test(VOID_T);
extern VOID_T mf_user_callback(VOID_T);
extern VOID tuya_cnt_rst_judge(VOID);
extern OPERATE_RET user_product_test_cb(USHORT_T cmd,UCHAR_T *data, UINT_T len, OUT UCHAR_T **ret_data,OUT USHORT_T *ret_len);

extern void sys_jtag_off(void);
extern TY_GPIO_PORT_E swith_ctl_port;
STATIC VOID_T __gw_ug_inform_cb(INOUT BOOL_T *handled, IN CONST FW_UG_S *fw);
STATIC OPERATE_RET __gw_upgrage_process_cb(IN CONST FW_UG_S *fw, IN CONST UINT_T total_len,IN CONST UINT_T offset,\
                                           IN CONST BYTE_T *data,IN CONST UINT_T len,OUT UINT_T *remain_len, IN PVOID_T pri_data);
STATIC VOID_T __gw_upgrade_notify_cb(IN CONST FW_UG_S *fw, IN CONST INT_T download_result, IN PVOID_T pri_data);
STATIC OPERATE_RET __mf_gw_upgrade_notify_cb(VOID_T);
STATIC VOID __mf_gw_ug_inform_cb(UINT_T file_size, UINT_T file_crc);

STATIC VOID_T __tuya_mf_uart_init(UINT_T baud,UINT_T bufsz)
{
    TY_UART_CFG_S cfg = {0};
    cfg.baudrate = baud;
    cfg.data_bits = TY_UART_DATA_BIT8;
    cfg.flowctl = TY_UART_FLOW_CONTROL_NONE;
    cfg.intrx = TY_UART_INT_RX_ENABLE;
    cfg.parity = TY_UART_PARITY_NONE;
    cfg.stop_bits = TY_UART_STOP_BIT1;

    ty_uart_init(TY_UART1,&cfg,bufsz,TRUE);
}

STATIC VOID_T __tuya_mf_uart_free(VOID_T)
{
    ty_uart_free(TY_UART1);
}

STATIC VOID_T __tuya_mf_send(IN CONST BYTE_T *data,IN CONST UINT_T len)
{
    ty_uart_send_data(TY_UART1,data,len);
}

STATIC UINT_T __tuya_mf_recv(OUT BYTE_T *buf,IN CONST UINT_T len)
{
    return ty_uart_read_data(TY_UART1,buf,len);
}
STATIC BOOL_T scan_test_ssid(VOID)
{
    OPERATE_RET op_ret = OPRT_OK;
    GW_WORK_STAT_MAG_S read_gw_wsm;
    op_ret = wd_gw_wsm_read(&read_gw_wsm);
	if(gwcm_mode == GWCM_OLD_PROD ) {
        if(read_gw_wsm.nc_tp >= GWNS_TY_SMARTCFG) {
            return false;
        }
	} else if (gwcm_mode == GWCM_SPCL_MODE || gwcm_mode == GWCM_LOW_POWER){
        if(read_gw_wsm.nc_tp != GWNS_LOWPOWER) {
            return false;
        }
    }
    
    wf_wk_mode_set(WWM_STATION);
    AP_IF_S *ap = NULL;
    BOOL_T flag = TRUE;
    PR_NOTICE("current product ssid name:%s", prod_ssid_name);
	op_ret = wf_assign_ap_scan(prod_ssid_name, &ap);//lql
    wf_station_disconnect();
    if(OPRT_OK != op_ret) {
        PR_DEBUG("wf_assign_ap_scan failed(%d)",op_ret);
        return FALSE;
    }
    //check if has authorized
    op_ret = wd_gw_base_if_read(&(get_gw_cntl()->gw_base));
    if(OPRT_OK != op_ret) {
        PR_DEBUG("read flash err");
        flag = FALSE;
    }
    // gateway base info verify
    #if TY_SECURITY_CHIP
    if(!get_gw_cntl()->gw_base.has_auth) {
    #else
    if(0 == get_gw_cntl()->gw_base.auth_key[0] || \
       0 == get_gw_cntl()->gw_base.uuid[0]) {
    #endif
        PR_DEBUG("please write uuid and auth_key first");
        flag = FALSE;
    }

    if(app_prod_test) {
        app_prod_test(flag, ap->rssi);
    }
    return TRUE;
}

void app_cfg_set(IN CONST GW_WF_CFG_MTHD_SEL mthd, APP_PROD_CB callback)
{
    app_prod_test = callback;
    gwcm_mode = mthd;
}

// mf gateway upgrade start
STATIC OPERATE_RET __mf_gw_ug_inform_cb(UINT_T file_size, UINT_T file_crc)
{
    OPERATE_RET op_ret = tuya_hal_ota_start_inform(file_size);
    if(op_ret != OPRT_OK) {
        PR_ERR("tuya_hal_ota_start_inform err:%d",op_ret);
        return op_ret;
    }

    return OPRT_OK;
}
// gateway upgrade start
STATIC VOID_T __gw_ug_inform_cb(INOUT BOOL_T *handled, IN CONST FW_UG_S *fw)
{
    PR_DEBUG("Rev Pre_GW Upgrade Info");
    PR_DEBUG("fw->tp:%d", fw->tp);
    PR_DEBUG("fw->fw_url:%s", fw->fw_url);
    PR_DEBUG("fw->fw_hmac:%s", fw->fw_hmac);
    PR_DEBUG("fw->sw_ver:%s", fw->sw_ver);
    PR_DEBUG("fw->file_size:%d", fw->file_size);

    if(fw->tp != DEV_NM_ATH_SNGL) {
        *handled = FALSE;
        return;
    }
    
    *handled = TRUE;

    OPERATE_RET op_ret = tuya_hal_ota_start_inform(fw->file_size);
    if(op_ret != OPRT_OK) {
        PR_ERR("tuya_hal_ota_start_inform err:%d",op_ret);
        return;
    }

    op_ret = tuya_iot_upgrade_gw(fw,__gw_upgrage_process_cb,__gw_upgrade_notify_cb,NULL);
    if(OPRT_OK != op_ret) {
        PR_ERR("tuya_iot_upgrade_gw err:%d",op_ret);
        return;
    }

    return;
}

// gateway/mf upgrade process
STATIC OPERATE_RET __gw_upgrage_process_cb(IN CONST FW_UG_S *fw, IN CONST UINT_T total_len, \
                                           IN CONST UINT_T offset, IN CONST BYTE_T *data, \
                                           IN CONST UINT_T len, OUT UINT_T *remain_len, IN PVOID_T pri_data)
{
    return tuya_hal_ota_data_process(total_len, offset, data, len, remain_len, pri_data);
}
// mf gateway upgrade result notify
STATIC OPERATE_RET __mf_gw_upgrade_notify_cb(VOID_T)
{
    OPERATE_RET op_ret = tuya_hal_ota_end_inform(FALSE);
    if(op_ret != OPRT_OK) {
        return op_ret;
    }

    PR_NOTICE("the gateway upgrade success");
    return OPRT_OK;
}

// gateway upgrade result notify
STATIC VOID_T __gw_upgrade_notify_cb(IN CONST FW_UG_S *fw, IN CONST INT_T download_result, IN PVOID_T pri_data)
{
    if(OPRT_OK == download_result) { // update success
        // verify
        OPERATE_RET op_ret = tuya_hal_ota_end_inform(TRUE);
        if(op_ret != OPRT_OK) {
            PR_ERR("tuya_hal_ota_end_inform %d",op_ret);
        }
    }else {
        PR_ERR("the gateway upgrade failed");
    }

    return;
}
#define SYS_DEBUG_MEM_FFS (0)
#if SYS_DEBUG_MEM_FFS

#ifdef CONFIG_PLATFORM_8711B
#include "rtl8710b.h"
#endif
#ifdef CONFIG_PLATFORM_8711B
    #define OutputPrint DiagPrintf
#endif
extern int totalHeapSize ;
extern int totalUsedHeapSize ;
extern int taskUsedHeapSize ;
extern int nowMallocSize ;
extern int nowFreeSize ;
extern sdkUsedSize ;
extern int printFlag;
#endif
/**
 * @brief Tuya SDK entrance
 */
void user_main(void)
{
    OPERATE_RET op_ret = OPRT_OK;
    TY_INIT_PARAMS_S init_param = {0};
    init_param.init_db = FALSE;
    strcpy(init_param.sys_env, "RTL8710BN_2M");
#if SYS_DEBUG_MEM_FFS
    
    printFlag = 0;
    char *pMem = Malloc(512);
    vTaskList(pMem);
    OutputPrint(pMem);
    Free(pMem);
    
    OutputPrint("[%s][%d],freeHeapSize:%d,totalHeapSize:%d,totalUseHeapSize:%d,TaskUsedSize:%d,sdkUsedSize:%d",
        __FILE__,__LINE__,tuya_hal_system_getheapsize(), totalHeapSize,totalUsedHeapSize,taskUsedHeapSize,sdkUsedSize);
#endif
    op_ret = tuya_iot_init_params(NULL, &init_param);
    if(OPRT_OK != op_ret) {
        PR_ERR("tuya_iot_init err:%d",op_ret);
        return;
    }
    sys_jtag_off();//lql

#if TY_SECURITY_CHIP
    SEChip_I2C_Init(); //加密芯片 I2C 接口初始化
//    SE_EncyptDemoTest(); //加密芯片demo
#endif

    pre_device_init();
    tuya_cnt_rst_judge();
    tuya_iot_kv_flash_init(NULL);
	if(pre_app_cb) {
        pre_app_cb();
    }
    extern void wait_wifi_semaphore(void);
    wait_wifi_semaphore();

#if 1
    // to add prodect test code
    mf_reg_gw_ug_cb(__mf_gw_ug_inform_cb, __gw_upgrage_process_cb, __mf_gw_upgrade_notify_cb);
    MF_IMPORT_INTF_S intf = {
        .uart_init = __tuya_mf_uart_init,
        .uart_free = __tuya_mf_uart_free,
        .uart_send = __tuya_mf_send,
        .uart_recv = __tuya_mf_recv,
        .gpio_test = gpio_test,
        .mf_user_product_test = user_product_test_cb,
        .user_callback = mf_user_callback,
    };
    op_ret = mf_init(&intf,APP_BIN_NAME,USER_SW_VER,TRUE);
    if(OPRT_OK != op_ret) {
        PR_ERR("mf_init err:%d",op_ret);
        return;
    }
    
    intf.uart_free();
#endif

    // register gw upgrade inform callback
    iot_register_pre_gw_ug_cb(__gw_ug_inform_cb);

// for debug
#if 0
    WF_GW_PROD_INFO_S wf_prod_info = {
        "tuyad6db61930456075e","eAr5qH46Dw9HcpISLk5GpD4z1q3nvrfp",NULL,NULL
    };
    op_ret = tuya_iot_set_wf_gw_prod_info(&wf_prod_info);
    if(OPRT_OK != op_ret) {
        PR_ERR("tuya_iot_set_wf_gw_prod_info err:%d",op_ret);
        return;
    }
#endif

#if 0
    DEBUG_GW_PROD_INFO_S debug_prod_info = {
        TRUE, NULL, NULL
    };
    op_ret = tuya_iot_set_wf_gw_debug_info(&debug_prod_info);
    if(OPRT_OK != op_ret) {
        PR_ERR("tuya_iot_set_wf_gw_prod_info err:%d",op_ret);
        return;
    }
#endif

    app_init();
    PR_DEBUG("gwcm_mode %d",gwcm_mode);
    if(gwcm_mode != GWCM_OLD) {
        PR_DEBUG("low_power select");
        if(true == scan_test_ssid()) {
            PR_DEBUG("prodtest");
            return;
        }
        PR_DEBUG("no tuya_mdev_test1!");
        op_ret = device_init();
        if(OPRT_OK != op_ret) {
            PR_ERR("device_init error:%d",op_ret);
            return;
        }
    }else {
        PR_DEBUG("device_init in");
        op_ret = device_init();
        if(OPRT_OK != op_ret) {
            PR_ERR("device_init err:%d",op_ret);
            return;
        }
    }
}
// mf gateway upgrade start
VOID __mf_gw_ug_inform_cb(UINT_T file_size, UINT_T file_crc)
{
    ug_proc = Malloc(SIZEOF(UG_PROC_S));
    if(NULL == ug_proc) {
        PR_ERR("malloc err");
        return;
    }
    
}
