/**
 * @file tuya_hal_watchdog.h
 * @brief 看门狗接口
 * 
 * @copyright Copyright (c) {2018-2020} 涂鸦科技 www.tuya.com
 * 
 */
#ifndef __TUYA_HAL_WATCHDOG_H__
#define __TUYA_HAL_WATCHDOG_H__


#include <stdint.h>


#ifdef __cplusplus
    extern "C" {
#endif

/**
 * @brief 用于初始化并运行watchdog
 * 
 * @param[in] timeval watch dog检测时间间隔：如果timeval大于看门狗的
 * 最大可设置时间，则使用平台可设置时间的最大值，并且返回该最大值
 * @return int [out] 实际设置的看门狗时间
 */
unsigned int tuya_hal_watchdog_init_start(const unsigned int timeval);

/**
 * @brief 用于刷新watch dog
 * 
 */
void tuya_hal_watchdog_refresh(void);

/**
 * @brief 用于停止watch dog
 * 
 */
void tuya_hal_watchdog_stop(void);

#ifdef __cplusplus
}
#endif

#endif // __TUYA_HAL_WATCHDOG_H__