/**
 * @file tuya_hal_semaphore.h
 * @brief semaphore相关接口封装
 * 
 * @copyright Copyright(C),2018-2020, 涂鸦科技 www.tuya.com
 * 
 */

#ifndef _TUYA_HAL_SEMAPHORE_H
#define _TUYA_HAL_SEMAPHORE_H

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif


/* tuya sdk definition of semaphore */
typedef void* SEM_HANDLE;

/**
 * @brief tuya_hal_semaphore_create_init用于创建并初始化semaphore
 * 
 * @param[out] *pHandle semaphore句柄
 * @param[in] semCnt 
 * @param[in] sem_max 
 * @return int 0=成功，非0=失败
 */
int tuya_hal_semaphore_create_init(SEM_HANDLE *pHandle, const unsigned int semCnt, const unsigned int sem_max);

/**
 * @brief tuya_hal_semaphore_wait用于wait semaphore
 * 
 * @param[in] semHandle semaphore句柄
 * @return int 0=成功，非0=失败
 */
int tuya_hal_semaphore_wait(const SEM_HANDLE semHandle);

/**
 * @brief tuya_hal_semaphore_post用于post semaphore
 * 
 * @param[in] semHandle semaphore句柄
 * @return int 0=成功，非0=失败
 */
int tuya_hal_semaphore_post(const SEM_HANDLE semHandle);

/**
 * @brief tuya_hal_semaphore_release用于release semaphore
 * 
 * @param[in] semHandle 
 * @return int 0=成功，非0=失败
 */
int tuya_hal_semaphore_release(const SEM_HANDLE semHandle);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif

