/**
 * @file tuya_hal_thread.h
 * @brief 线程操作接口
 * 
 * @copyright Copyright(C),2018-2020, 涂鸦科技 www.tuya.com
 * 
 */

#ifndef __TUYA_HAL_THREAD_H__
#define __TUYA_HAL_THREAD_H__


#include <stdbool.h>
#include <stdint.h>


#ifdef __cplusplus
extern "C" {
#endif


/**
 * @brief handle of thread
 * 
 */
typedef void* THREAD_HANDLE;

/**
 * @brief thread function type
 * 
 */
typedef void (*THREAD_FUNC_T)(void*);

/**
 * @brief create and start a tuya sdk thread
 * 
 * @param[out] thread       the thread handle
 * @param[in] name          the thread name
 * @param[in] stack_size    stack size of thread
 * @param[in] priority      priority of thread
 * @param[in] func          the main thread process function
 * @param[in] arg           the args of the func, can be null
 * @retval 0          success
 * @retval Other            fail
 */
int tuya_hal_thread_create(THREAD_HANDLE* thread,
                           const char* name,
                           const unsigned int stack_size,
                           const unsigned int priority,
                           const THREAD_FUNC_T func,
                           const void* arg);

/**
 * @brief terminal thread and release thread resources
 * 
 * @param[in] thread    the input thread handle
 * @retval 0      success
 * @retval Other        fail
 */
int tuya_hal_thread_release(THREAD_HANDLE thread);

/**
 * @brief check thread is self thread
 * 
 * @param[in] thread    the thread handle
 * @param[out] is_self  output is self thread
 * @retval 0      success
 * @retval Other        fail
 */
int tuya_hal_thread_is_self(THREAD_HANDLE thread, bool* is_self);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif // __TUYA_HAL_THREAD_H__

